/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.testing;

import com.google.api.client.util.Maps;
import com.google.common.base.Function;
import com.google.gct.testing.CloudConfigurationImpl;
import com.google.gct.testing.CloudTestingUtils;
import com.google.gct.testing.TwoPanelTreeDimensionSelectionEvent;
import com.google.gct.testing.TwoPanelTreeSelectionListener;
import com.google.gct.testing.TwoPanelTreeTypeGroupSelectionEvent;
import com.google.gct.testing.TwoPanelTreeTypeSelectionEvent;
import com.google.gct.testing.android.CloudConfiguration;
import com.google.gct.testing.dimension.CloudConfigurationDimension;
import com.google.gct.testing.dimension.CloudTestingType;
import com.google.gct.testing.dimension.CloudTestingTypeGroup;
import com.google.gct.testing.dimension.DeviceDimension;
import com.intellij.openapi.ui.Splitter;
import com.intellij.ui.CheckboxTree;
import com.intellij.ui.CheckboxTreeBase;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBList;
import com.intellij.util.containers.HashMap;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;

public class TwoPanelTree
extends MouseAdapter
implements ListSelectionListener,
KeyListener {
    private final DefaultListModel listModel;
    private final JPanel myPanel;
    private final JPanel leftPanel;
    private final JScrollPane rightScrollPane;
    private final Splitter mySplitter;
    private final JPanel mySplitterPanel;
    private final JPanel topPanel;
    private final JPanel bottomPanel;
    private Map<CloudConfigurationDimension, CheckboxTree> treeMap;
    private final Map<CheckboxTree, Boolean> userToggledTrees = Maps.newHashMap();
    private boolean isAutoToggled = false;
    private JBList list;
    private CloudConfigurationImpl configuration;
    List<TwoPanelTreeSelectionListener> listeners = new LinkedList<TwoPanelTreeSelectionListener>();
    private JLabel mySelectAllButton;
    private JLabel mySelectNoneButton;

    public TwoPanelTree(CloudConfigurationImpl configuration) {
        this.configuration = configuration;
        this.myPanel = new JPanel(new BorderLayout());
        this.myPanel.setPreferredSize(new Dimension(540, 250));
        this.mySplitterPanel = new JPanel(new BorderLayout());
        this.mySplitterPanel.setBorder(BorderFactory.createLineBorder(UIUtil.getBorderColor()));
        this.mySplitter = new Splitter(false);
        this.mySplitter.getDivider().setBorder(BorderFactory.createLineBorder(UIUtil.getBorderColor()));
        this.mySplitter.setProportion(0.3f);
        this.leftPanel = new JPanel(new BorderLayout());
        this.rightScrollPane = new JScrollPane();
        this.rightScrollPane.setBorder(BorderFactory.createEmptyBorder());
        FlowLayout flowLayout = new FlowLayout(2);
        flowLayout.setHgap(15);
        flowLayout.setVgap(10);
        this.topPanel = new JPanel(flowLayout);
        this.bottomPanel = new JPanel(new FlowLayout(0));
        this.listModel = new DefaultListModel();
        this.init();
    }

    public void init() {
        this.myPanel.add((Component)this.topPanel, "North");
        if (this.configuration.getKind() != CloudConfiguration.Kind.SINGLE_DEVICE) {
            this.populateTopPanel();
            this.bottomPanel.setBackground(UIUtil.getListBackground());
            this.bottomPanel.setPreferredSize(new Dimension(540, 35));
            this.myPanel.add((Component)this.bottomPanel, "South");
            this.populateBottomPanel();
        }
        this.mySplitter.setFirstComponent((JComponent)this.leftPanel);
        this.mySplitter.setSecondComponent((JComponent)this.rightScrollPane);
        this.mySplitterPanel.add((Component)this.mySplitter, "Center");
        this.myPanel.add((Component)this.mySplitterPanel, "Center");
        this.treeMap = new HashMap();
        this.list = new JBList();
        for (CloudConfigurationDimension dimension : this.configuration.getDimensions()) {
            this.addDimension(dimension);
        }
        this.leftPanel.add((Component)this.list, "Center");
        this.list.setModel((ListModel)this.listModel);
        this.list.getSelectionModel().setSelectionMode(0);
        this.list.setCellRenderer((ListCellRenderer)new EnhancedCellRenderer());
        this.list.addListSelectionListener((ListSelectionListener)this);
        this.list.setSelectedIndex(0);
    }

    private void populateBottomPanel() {
        this.bottomPanel.setBorder(BorderFactory.createLineBorder(UIUtil.getBorderColor(), 1));
        this.updateConfigurationCountPane();
    }

    private void updateConfigurationCountPane() {
        int numberOfConfigurations = this.configuration.getDeviceConfigurationCount();
        String pricingText = numberOfConfigurations > 0 ? " and " + CloudTestingUtils.preparePricingAnchor("Firebase Test Lab pricing") + " will apply." : ".";
        JEditorPane countPane = new JEditorPane("text/html", "<html>Tests will run on <b>" + numberOfConfigurations + " configurations</b>" + pricingText + "</html>");
        CloudTestingUtils.linkifyEditorPane(countPane, this.bottomPanel.getBackground());
        if (numberOfConfigurations < 1) {
            countPane.setForeground((Color)JBColor.RED);
        } else {
            countPane.setForeground(UIUtil.getActiveTextColor());
        }
        this.bottomPanel.removeAll();
        this.bottomPanel.add(countPane);
        this.bottomPanel.revalidate();
        this.bottomPanel.repaint();
    }

    private void populateTopPanel() {
        this.mySelectAllButton = this.makeTextButton("Select all", new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (TwoPanelTree.this.getSelectedDimension().isEditable()) {
                    TwoPanelTree.this.getSelectedDimension().enableAll();
                    TwoPanelTree.this.updateCurrentCheckboxTree((Function<CheckedTreeNode, Void>)((Function)new Function<CheckedTreeNode, Void>(){

                        public Void apply(CheckedTreeNode treeNode) {
                            treeNode.setChecked(true);
                            return null;
                        }
                    }));
                }
            }
        });
        this.topPanel.add(this.mySelectAllButton);
        this.mySelectNoneButton = this.makeTextButton("Select none", new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (TwoPanelTree.this.getSelectedDimension().isEditable()) {
                    TwoPanelTree.this.getSelectedDimension().disableAll();
                    TwoPanelTree.this.updateCurrentCheckboxTree((Function<CheckedTreeNode, Void>)((Function)new Function<CheckedTreeNode, Void>(){

                        public Void apply(CheckedTreeNode treeNode) {
                            treeNode.setChecked(false);
                            return null;
                        }
                    }));
                }
            }
        });
        this.topPanel.add(this.mySelectNoneButton);
    }

    private void updateCurrentCheckboxTree(Function<CheckedTreeNode, Void> updateFunction) {
        CloudConfigurationDimension selectedDimension = this.getSelectedDimension();
        CheckboxTree currentCheckboxTree = this.treeMap.get(selectedDimension);
        CheckedTreeNode rootNode = (CheckedTreeNode)currentCheckboxTree.getModel().getRoot();
        this.updateNode(rootNode, updateFunction);
        this.updateUI(currentCheckboxTree);
        selectedDimension.dimensionChanged();
        this.updateConfigurationCountPane();
        this.list.updateUI();
    }

    private void updateNode(CheckedTreeNode node, Function<CheckedTreeNode, Void> updateFunction) {
        for (int childIndex = 0; childIndex < node.getChildCount(); ++childIndex) {
            CheckedTreeNode child = (CheckedTreeNode)node.getChildAt(childIndex);
            updateFunction.apply((Object)child);
            this.updateNode(child, updateFunction);
        }
    }

    private void updateUI(CheckboxTree checkboxTree) {
        checkboxTree.updateUI();
        BasicTreeUI ui = (BasicTreeUI)checkboxTree.getUI();
    }

    private JLabel makeTextButton(String text, MouseAdapter mouseAdapter) {
        JLabel label = new JLabel(text);
        label.setForeground((Color)JBColor.BLUE);
        label.setFont(new Font("Sans", 0, 11));
        label.setCursor(new Cursor(12));
        label.addMouseListener(mouseAdapter);
        return label;
    }

    public void addDimension(CloudConfigurationDimension dimension) {
        this.listModel.addElement(dimension);
        CheckedTreeNode rootNode = new CheckedTreeNode((Object)dimension);
        CheckboxTreeBase.CheckPolicy radioButtonsCheckPolicy = new CheckboxTreeBase.CheckPolicy(false, false, false, false);
        final CheckboxTree tree = this.configuration.getKind() == CloudConfiguration.Kind.SINGLE_DEVICE ? new CheckboxTree(new CheckboxTree.CheckboxTreeCellRenderer(){}, rootNode, radioButtonsCheckPolicy) : new CheckboxTree();
        DefaultTreeModel treeModel = new DefaultTreeModel((TreeNode)rootNode);
        tree.setModel((TreeModel)treeModel);
        tree.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
                if (!TwoPanelTree.this.isAutoToggled) {
                    TwoPanelTree.this.userToggledTrees.put(tree, true);
                }
            }

            @Override
            public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
                if (!TwoPanelTree.this.isAutoToggled) {
                    TwoPanelTree.this.userToggledTrees.put(tree, true);
                }
            }
        });
        tree.setRootVisible(false);
        this.updateUI(tree);
        tree.getSelectionModel().setSelectionMode(1);
        List<? extends CloudTestingTypeGroup> supportedGroups = dimension.getSupportedGroups();
        for (CloudTestingTypeGroup cloudTestingTypeGroup : supportedGroups) {
            if (this.configuration.getKind() == CloudConfiguration.Kind.SINGLE_DEVICE && dimension instanceof DeviceDimension && cloudTestingTypeGroup.getName().equals("PHYSICAL")) continue;
            List<CloudTestingType> types = cloudTestingTypeGroup.getTypes();
            if (types.size() == 1 && !dimension.shouldBeAlwaysGrouped()) {
                this.addChildNode(rootNode, types.get(0), dimension);
                continue;
            }
            CheckedTreeNode groupNode = new CheckedTreeNode((Object)cloudTestingTypeGroup);
            rootNode.add((MutableTreeNode)groupNode);
            groupNode.setEnabled(dimension.isEditable() && this.configuration.getKind() != CloudConfiguration.Kind.SINGLE_DEVICE);
            for (CloudTestingType type : types) {
                this.addChildNode(groupNode, type, dimension);
            }
        }
        this.treeMap.put(dimension, tree);
        tree.setCellRenderer((TreeCellRenderer)(this.configuration.getKind() == CloudConfiguration.Kind.SINGLE_DEVICE ? new RadioButtonRenderer() : new CheckBoxRenderer()));
        treeModel.reload();
        tree.addMouseListener((MouseListener)this);
        tree.addKeyListener((KeyListener)this);
    }

    public JPanel getPanel() {
        return this.myPanel;
    }

    private void addChildNode(CheckedTreeNode parentNode, CloudTestingType type, CloudConfigurationDimension dimension) {
        CheckedTreeNode newNode = new CheckedTreeNode((Object)type);
        parentNode.add((MutableTreeNode)newNode);
        newNode.setChecked(dimension.getEnabledTypes().contains((Object)type));
        newNode.setEnabled(dimension.isEditable());
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        CloudConfigurationDimension selectedDimension = this.getSelectedDimension();
        CheckboxTree currentTree = this.treeMap.get(selectedDimension);
        this.rightScrollPane.setViewportView((Component)currentTree);
        this.rightScrollPane.updateUI();
        this.prepareForViewing(currentTree);
        if (this.configuration.getKind() != CloudConfiguration.Kind.SINGLE_DEVICE) {
            this.mySelectAllButton.setVisible(selectedDimension.isEditable());
            this.mySelectNoneButton.setVisible(selectedDimension.isEditable());
        }
        for (TwoPanelTreeSelectionListener listener : this.listeners) {
            listener.dimensionSelectionChanged(new TwoPanelTreeDimensionSelectionEvent(selectedDimension));
        }
    }

    private void prepareForViewing(CheckboxTree tree) {
        TreeNode root = (TreeNode)tree.getModel().getRoot();
        if (!this.isAnyLeafChecked(tree)) {
            for (int i = 0; i < root.getChildCount(); ++i) {
                CheckedTreeNode firstLevelChild = (CheckedTreeNode)root.getChildAt(i);
                if (firstLevelChild.getChildCount() <= 0) continue;
                tree.expandPath(new TreePath(firstLevelChild.getPath()));
                return;
            }
        } else {
            boolean hasEncounteredCheckedLeaf = false;
            block1: for (int i = 0; i < root.getChildCount(); ++i) {
                CheckedTreeNode firstLevelChild = (CheckedTreeNode)root.getChildAt(i);
                if (firstLevelChild.isLeaf()) {
                    if (!firstLevelChild.isChecked() || hasEncounteredCheckedLeaf) continue;
                    hasEncounteredCheckedLeaf = true;
                    tree.scrollPathToVisible(new TreePath(firstLevelChild.getPath()));
                    continue;
                }
                for (int j = 0; j < firstLevelChild.getChildCount(); ++j) {
                    CheckedTreeNode secondLevelChild = (CheckedTreeNode)firstLevelChild.getChildAt(j);
                    if (!secondLevelChild.isChecked()) continue;
                    tree.expandPath(new TreePath(firstLevelChild.getPath()));
                    if (hasEncounteredCheckedLeaf) continue block1;
                    hasEncounteredCheckedLeaf = true;
                    tree.scrollPathToVisible(new TreePath(secondLevelChild.getPath()));
                    continue block1;
                }
            }
        }
    }

    private CloudConfigurationDimension getSelectedDimension() {
        return (CloudConfigurationDimension)this.list.getModel().getElementAt(this.list.getSelectedIndex());
    }

    public void addSelectionListener(TwoPanelTreeSelectionListener treeSelectionListener) {
        this.listeners.add(treeSelectionListener);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        CheckboxTree currentTree = this.treeMap.get(this.getSelectedDimension());
        if (currentTree == null || currentTree.getSelectionPath() == null) {
            return;
        }
        CheckedTreeNode selectedNode = (CheckedTreeNode)currentTree.getSelectionPath().getLastPathComponent();
        if (!selectedNode.isEnabled() && selectedNode.getUserObject() instanceof CloudTestingTypeGroup && this.userToggledTrees.get(currentTree) != Boolean.TRUE) {
            this.isAutoToggled = true;
            TreePath selectedPath = new TreePath(selectedNode.getPath());
            if (currentTree.isExpanded(selectedPath)) {
                currentTree.collapsePath(selectedPath);
            } else {
                currentTree.expandPath(selectedPath);
            }
            this.isAutoToggled = false;
        }
        this.userToggledTrees.put(currentTree, false);
        this.updateState();
    }

    @Override
    public void keyTyped(KeyEvent e) {
        this.updateState();
    }

    @Override
    public void keyPressed(KeyEvent e) {
        this.updateState();
    }

    @Override
    public void keyReleased(KeyEvent e) {
        this.updateState();
    }

    private void updateState() {
        CheckboxTree currentTree = this.treeMap.get(this.getSelectedDimension());
        if (currentTree == null || currentTree.getSelectionPath() == null) {
            return;
        }
        if (this.configuration.getKind() == CloudConfiguration.Kind.SINGLE_DEVICE) {
            this.updateRadioButtonTreeState(currentTree);
        } else {
            this.updateCheckBoxTreeState(currentTree);
        }
        this.updateConfigurationCountPane();
        this.list.updateUI();
    }

    private void updateCheckBoxTreeState(CheckboxTree currentTree) {
        CloudConfigurationDimension currentDimension = this.getSelectedDimension();
        CheckedTreeNode selectedNode = (CheckedTreeNode)currentTree.getSelectionPath().getLastPathComponent();
        Object userObject = selectedNode.getUserObject();
        if (userObject instanceof CloudTestingType) {
            CloudTestingType clickedType = (CloudTestingType)userObject;
            if (selectedNode.isEnabled()) {
                currentDimension.setEnabled(clickedType, selectedNode.isChecked());
                currentDimension.dimensionChanged();
            }
            for (TwoPanelTreeSelectionListener listener : this.listeners) {
                listener.typeSelectionChanged(new TwoPanelTreeTypeSelectionEvent(currentDimension, clickedType));
            }
        } else {
            CloudTestingTypeGroup clickedGroup = (CloudTestingTypeGroup)userObject;
            if (selectedNode.isEnabled()) {
                for (int childIndex = 0; childIndex < selectedNode.getChildCount(); ++childIndex) {
                    CheckedTreeNode child = (CheckedTreeNode)selectedNode.getChildAt(childIndex);
                    currentDimension.setEnabled((CloudTestingType)child.getUserObject(), child.isChecked());
                }
                currentDimension.dimensionChanged();
            }
            for (TwoPanelTreeSelectionListener listener : this.listeners) {
                listener.groupSelectionChanged(new TwoPanelTreeTypeGroupSelectionEvent(currentDimension, clickedGroup));
            }
        }
    }

    private void updateRadioButtonTreeState(CheckboxTree currentTree) {
        CloudConfigurationDimension currentDimension = this.getSelectedDimension();
        CheckedTreeNode selectedNode = (CheckedTreeNode)currentTree.getSelectionPath().getLastPathComponent();
        Object userObject = selectedNode.getUserObject();
        if (userObject instanceof CloudTestingType) {
            CloudTestingType clickedType = (CloudTestingType)userObject;
            if (selectedNode.isEnabled() && (selectedNode.isChecked() || !this.isAnyLeafChecked(currentTree))) {
                this.uncheckAll(currentTree);
                selectedNode.setChecked(true);
                currentDimension.disableAll();
                currentDimension.enable(clickedType);
                currentDimension.dimensionChanged();
            }
            for (TwoPanelTreeSelectionListener listener : this.listeners) {
                listener.typeSelectionChanged(new TwoPanelTreeTypeSelectionEvent(currentDimension, clickedType));
            }
        } else {
            CloudTestingTypeGroup clickedGroup = (CloudTestingTypeGroup)userObject;
            for (TwoPanelTreeSelectionListener listener : this.listeners) {
                listener.groupSelectionChanged(new TwoPanelTreeTypeGroupSelectionEvent(currentDimension, clickedGroup));
            }
        }
    }

    private void uncheckAll(CheckboxTree currentTree) {
        TreeNode root = (TreeNode)currentTree.getModel().getRoot();
        for (int i = 0; i < root.getChildCount(); ++i) {
            CheckedTreeNode firstLevelChild = (CheckedTreeNode)root.getChildAt(i);
            firstLevelChild.setChecked(false);
            if (firstLevelChild.isLeaf()) continue;
            for (int j = 0; j < firstLevelChild.getChildCount(); ++j) {
                ((CheckedTreeNode)firstLevelChild.getChildAt(j)).setChecked(false);
            }
        }
    }

    private boolean isAnyLeafChecked(CheckboxTree currentTree) {
        TreeNode root = (TreeNode)currentTree.getModel().getRoot();
        for (int i = 0; i < root.getChildCount(); ++i) {
            CheckedTreeNode firstLevelChild = (CheckedTreeNode)root.getChildAt(i);
            if (firstLevelChild.isLeaf()) {
                if (!firstLevelChild.isChecked()) continue;
                return true;
            }
            for (int j = 0; j < firstLevelChild.getChildCount(); ++j) {
                if (!((CheckedTreeNode)firstLevelChild.getChildAt(j)).isChecked()) continue;
                return true;
            }
        }
        return false;
    }

    private class EnhancedCellRenderer
    implements ListCellRenderer {
        protected DefaultListCellRenderer defaultRenderer = new DefaultListCellRenderer();

        private EnhancedCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel renderer = (JLabel)this.defaultRenderer.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            CloudConfigurationDimension dimension = (CloudConfigurationDimension)value;
            renderer.setIcon(dimension.getIcon());
            int totalCount = 0;
            for (CloudTestingType cloudTestingType : dimension.getSupportedDomain()) {
                if (TwoPanelTree.this.configuration.getKind() == CloudConfiguration.Kind.SINGLE_DEVICE && cloudTestingType instanceof DeviceDimension.Device && !((DeviceDimension.Device)cloudTestingType).isVirtual()) continue;
                ++totalCount;
            }
            renderer.setText(dimension.getDisplayName() + " (" + dimension.getEnabledTypes().size() + "/" + totalCount + ")");
            if (dimension.getEnabledTypes().isEmpty()) {
                renderer.setForeground((Color)JBColor.RED);
                renderer.setFont(renderer.getFont().deriveFont(1));
            }
            return renderer;
        }
    }

    private class RadioButtonRenderer
    extends JPanel
    implements TreeCellRenderer {
        private final ColoredTreeCellRenderer myTextRenderer;
        public final JRadioButton myRadioButton;
        private final boolean myUsePartialStatusForParentNodes;

        public RadioButtonRenderer() {
            this(true);
        }

        public RadioButtonRenderer(boolean opaque) {
            this(opaque, true);
        }

        public RadioButtonRenderer(boolean opaque, boolean usePartialStatusForParentNodes) {
            super(new BorderLayout());
            this.myUsePartialStatusForParentNodes = usePartialStatusForParentNodes;
            this.myRadioButton = new JRadioButton();
            this.myTextRenderer = new ColoredTreeCellRenderer(){

                public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                    if (tree == null) {
                        1.$$$reportNull$$$0(0);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/google/gct/testing/TwoPanelTree$RadioButtonRenderer$1", "customizeCellRenderer"));
                }
            };
            this.myTextRenderer.setOpaque(opaque);
            this.add((Component)this.myRadioButton, "West");
            this.add((Component)this.myTextRenderer, "Center");
        }

        public void updateTreeState(JTree tree, CheckedTreeNode node, CloudTestingType cloudTestingType) {
            if (!node.isEnabled()) {
                CloudConfigurationDimension dimension = (CloudConfigurationDimension)((CheckedTreeNode)tree.getModel().getRoot()).getUserObject();
                boolean isChecked = dimension.getEnabledTypes().contains((Object)cloudTestingType);
                node.setChecked(isChecked);
            }
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (tree instanceof CheckboxTree && !TwoPanelTree.this.isAnyLeafChecked((CheckboxTree)tree) && TwoPanelTree.this.list.getSelectedIndex() != -1 && !TwoPanelTree.this.getSelectedDimension().getEnabledTypes().isEmpty()) {
                return this;
            }
            this.invalidate();
            if (value instanceof CheckedTreeNode) {
                CheckedTreeNode node = (CheckedTreeNode)value;
                CheckboxTreeBase.NodeState state = this.getNodeStatus(node);
                this.myRadioButton.setVisible(true);
                this.myRadioButton.setMargin(new Insets(-5, -3, -5, -5));
                this.myRadioButton.setSelected(state != CheckboxTreeBase.NodeState.CLEAR);
                this.myRadioButton.setEnabled(node.isEnabled() && state != CheckboxTreeBase.NodeState.PARTIAL);
                this.myRadioButton.setOpaque(false);
                this.myRadioButton.setBackground(null);
                this.setBackground(null);
            } else {
                this.myRadioButton.setVisible(false);
            }
            this.myTextRenderer.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            if (UIUtil.isUnderGTKLookAndFeel()) {
                Color background = selected ? UIUtil.getTreeSelectionBackground() : UIUtil.getTreeTextBackground();
                UIUtil.changeBackGround((Component)this, (Color)background);
            } else if (UIUtil.isUnderNimbusLookAndFeel()) {
                UIUtil.changeBackGround((Component)this, (Color)UIUtil.TRANSPARENT_COLOR);
            }
            if (!leaf) {
                this.myRadioButton.setEnabled(false);
            }
            if (!this.myRadioButton.isEnabled() && UIUtil.isUnderDarcula()) {
                this.myRadioButton.setBackground(CloudTestingUtils.makeDarker(Color.LIGHT_GRAY, 7));
            }
            this.revalidate();
            if (value instanceof DefaultMutableTreeNode) {
                Object userObject = ((DefaultMutableTreeNode)value).getUserObject();
                if (userObject instanceof CloudTestingType) {
                    CloudTestingType googleCloudTestingType = (CloudTestingType)userObject;
                    this.myTextRenderer.append(googleCloudTestingType.getConfigurationDialogDisplayName(), this.myRadioButton.isSelected() ? SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES : SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    this.updateTreeState(tree, (CheckedTreeNode)value, googleCloudTestingType);
                } else if (userObject instanceof CloudTestingTypeGroup) {
                    CloudTestingTypeGroup group = (CloudTestingTypeGroup)userObject;
                    this.myTextRenderer.append(group.getName(), this.myRadioButton.isSelected() ? SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES : SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    CloudTestingType type = (CloudTestingType)((CheckedTreeNode)((DefaultMutableTreeNode)value).getChildAt(0)).getUserObject();
                    this.updateTreeState(tree, (CheckedTreeNode)value, type);
                }
            }
            return this;
        }

        private CheckboxTreeBase.NodeState getNodeStatus(CheckedTreeNode node) {
            boolean checked = node.isChecked();
            if (node.getChildCount() == 0 || !this.myUsePartialStatusForParentNodes) {
                return checked ? CheckboxTreeBase.NodeState.FULL : CheckboxTreeBase.NodeState.CLEAR;
            }
            CheckboxTreeBase.NodeState result = null;
            for (int i = 0; i < node.getChildCount(); ++i) {
                CheckboxTreeBase.NodeState childStatus;
                TreeNode child = node.getChildAt(i);
                CheckboxTreeBase.NodeState nodeState = child instanceof CheckedTreeNode ? this.getNodeStatus((CheckedTreeNode)child) : (childStatus = checked ? CheckboxTreeBase.NodeState.FULL : CheckboxTreeBase.NodeState.CLEAR);
                if (childStatus == CheckboxTreeBase.NodeState.PARTIAL) {
                    return CheckboxTreeBase.NodeState.PARTIAL;
                }
                if (result == null) {
                    result = childStatus;
                    continue;
                }
                if (result == childStatus) continue;
                return CheckboxTreeBase.NodeState.PARTIAL;
            }
            return result == null ? CheckboxTreeBase.NodeState.CLEAR : result;
        }
    }

    private class CheckBoxRenderer
    extends CheckboxTree.CheckboxTreeCellRenderer {
        private CheckBoxRenderer() {
        }

        public void customizeRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (value instanceof DefaultMutableTreeNode) {
                Object userObject = ((DefaultMutableTreeNode)value).getUserObject();
                if (userObject instanceof CloudTestingType) {
                    CloudTestingType cloudTestingType = (CloudTestingType)userObject;
                    this.getTextRenderer().append(cloudTestingType.getConfigurationDialogDisplayName(), ((CheckedTreeNode)value).isChecked() ? SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES : SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    this.updateTreeState(tree, (CheckedTreeNode)value, cloudTestingType);
                } else if (userObject instanceof CloudTestingTypeGroup) {
                    CloudTestingTypeGroup group = (CloudTestingTypeGroup)userObject;
                    this.getTextRenderer().append(group.getName(), this.hasCheckedChildren((CheckedTreeNode)value) ? SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES : SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    CloudTestingType type = (CloudTestingType)((CheckedTreeNode)((DefaultMutableTreeNode)value).getChildAt(0)).getUserObject();
                    this.updateTreeState(tree, (CheckedTreeNode)value, type);
                }
            }
        }

        private boolean hasCheckedChildren(CheckedTreeNode node) {
            for (int i = 0; i < node.getChildCount(); ++i) {
                if (!((CheckedTreeNode)node.getChildAt(i)).isChecked()) continue;
                return true;
            }
            return false;
        }

        private void updateTreeState(JTree tree, CheckedTreeNode node, CloudTestingType cloudTestingType) {
            if (!node.isEnabled()) {
                CloudConfigurationDimension dimension = (CloudConfigurationDimension)((CheckedTreeNode)tree.getModel().getRoot()).getUserObject();
                boolean isChecked = dimension.getEnabledTypes().contains((Object)cloudTestingType);
                node.setChecked(isChecked);
            }
        }
    }
}

