/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.testing.android;

import com.android.ddmlib.IDevice;
import com.android.tools.idea.ddms.DeviceNameRendererEx;
import com.google.gct.testing.CloudConfigurationHelper;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleTextAttributes;
import org.jetbrains.annotations.NotNull;

public class CloudDeviceNameRenderer
implements DeviceNameRendererEx {
    public boolean isApplicable(@NotNull IDevice device) {
        if (device == null) {
            CloudDeviceNameRenderer.$$$reportNull$$$0(0);
        }
        return CloudConfigurationHelper.getCloudDeviceConfiguration(device) != null;
    }

    public void render(@NotNull IDevice device, @NotNull ColoredTextContainer component) {
        if (device == null) {
            CloudDeviceNameRenderer.$$$reportNull$$$0(1);
        }
        if (component == null) {
            CloudDeviceNameRenderer.$$$reportNull$$$0(2);
        }
        component.setIcon(CloudConfigurationHelper.getCloudDeviceIcon());
        String cloudDeviceConfiguration = CloudConfigurationHelper.getCloudDeviceConfiguration(device);
        if (device.getState() == IDevice.DeviceState.OFFLINE) {
            component.append("Launching " + cloudDeviceConfiguration, SimpleTextAttributes.GRAYED_BOLD_ATTRIBUTES);
        } else {
            component.append(cloudDeviceConfiguration, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        }
    }

    @NotNull
    public String getName(@NotNull IDevice device) {
        String deviceName;
        if (device == null) {
            CloudDeviceNameRenderer.$$$reportNull$$$0(3);
        }
        if ((deviceName = CloudConfigurationHelper.getCloudDeviceConfiguration(device)) == null) {
            throw new IllegalArgumentException("This device name renderer is not applicable to the given device: " + device);
        }
        String string = deviceName;
        if (string == null) {
            CloudDeviceNameRenderer.$$$reportNull$$$0(4);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/google/gct/testing/android/CloudDeviceNameRenderer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/google/gct/testing/android/CloudDeviceNameRenderer";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isApplicable";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "render";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getName";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

