/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.testing.android;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.gct.testing.CloudConfigurationHelper;
import com.google.gct.testing.android.CloudConfiguration;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.JBUI;
import java.awt.Dimension;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ComboBoxModel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import org.jdesktop.swingx.combobox.ListComboBoxModel;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CloudProjectSelector
extends ComboBox<String> {
    private static final String LOADING_CLOUD_PROJECTS_STRING = "Loading cloud projects...";
    private static final List<String> LOADING_CLOUD_PROJECTS_LIST = ImmutableList.of((Object)"Loading cloud projects...");
    private static volatile List<String> myCloudProjects;
    private final CloudConfiguration.Kind myConfigurationKind;
    private int myCurrentConfigurationId;
    private Module myCurrentModule;
    private static Map<CloudConfiguration.Kind, String> myLastChosenProjectIdPerKind;
    private static Map<Integer, Map<Pair<CloudConfiguration.Kind, Module>, String>> myProjectByConfigurationIdAndModuleCache;

    public CloudProjectSelector(@NotNull CloudConfiguration.Kind configurationKind) {
        if (configurationKind == null) {
            CloudProjectSelector.$$$reportNull$$$0(0);
        }
        this.myCurrentConfigurationId = -1;
        this.myConfigurationKind = configurationKind;
        this.setRenderer((ListCellRenderer)((Object)new CloudProjectRenderer()));
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object selectedItem = CloudProjectSelector.this.getSelectedItem();
                if (selectedItem != null && !CloudProjectSelector.LOADING_CLOUD_PROJECTS_STRING.equals(selectedItem)) {
                    CloudProjectSelector.this.rememberChosenProjectId((String)selectedItem);
                }
            }
        });
        if (myCloudProjects == null || myCloudProjects.isEmpty()) {
            this.setDefaultPreferredSize();
        }
        if (myCloudProjects != null) {
            this.setModel((ComboBoxModel)new ListComboBoxModel(myCloudProjects));
        }
    }

    public void refreshCloudProjects() {
        this.setModel((ComboBoxModel)new ListComboBoxModel(LOADING_CLOUD_PROJECTS_LIST));
        this.setEnabled(false);
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            myCloudProjects = CloudConfigurationHelper.getCloudProjects();
            SwingUtilities.invokeLater(() -> {
                if (!myCloudProjects.isEmpty()) {
                    this.setPreferredSize(null);
                } else {
                    this.setDefaultPreferredSize();
                }
                this.setModel((ComboBoxModel)new ListComboBoxModel(myCloudProjects));
                this.restoreChosenProjectId();
                this.setEnabled(true);
                for (ItemListener itemListener : this.getItemListeners()) {
                    itemListener.itemStateChanged(new ItemEvent((ItemSelectable)((Object)this), 701, (Object)this, 1));
                }
            });
        });
    }

    private void setDefaultPreferredSize() {
        this.setPreferredSize(new Dimension(JBUI.scale((int)200), this.getMinimumSize().height));
    }

    @NotNull
    public String getProjectId() {
        Object selectedItem = this.getSelectedItem();
        if (LOADING_CLOUD_PROJECTS_STRING.equals(selectedItem)) {
            selectedItem = this.getStoredChosenProjectId();
        }
        String string = selectedItem == null ? "" : (String)selectedItem;
        if (string == null) {
            CloudProjectSelector.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void updateCloudProjectId(@NotNull String cloudProjectId) {
        if (cloudProjectId == null) {
            CloudProjectSelector.$$$reportNull$$$0(2);
        }
        this.setSelectedItem(cloudProjectId);
        if (!cloudProjectId.equals(this.getSelectedItem()) && this.getItemCount() > 0) {
            this.setSelectedIndex(0);
        }
        this.rememberChosenProjectId(cloudProjectId);
    }

    public void setFacet(@Nullable AndroidFacet facet) {
        if (facet == null) {
            return;
        }
        this.myCurrentModule = facet.getModule();
        if (myCloudProjects == null) {
            this.refreshCloudProjects();
        } else {
            this.restoreChosenProjectId();
        }
    }

    public void setRunConfigurationId(int configurationId) {
        this.myCurrentConfigurationId = configurationId;
    }

    private void rememberChosenProjectId(@NotNull String cloudProjectId) {
        if (cloudProjectId == null) {
            CloudProjectSelector.$$$reportNull$$$0(3);
        }
        myLastChosenProjectIdPerKind.put(this.myConfigurationKind, cloudProjectId);
        if (this.myCurrentConfigurationId == -1 || this.myCurrentModule == null) {
            return;
        }
        HashMap projectByModuleCache = myProjectByConfigurationIdAndModuleCache.get(this.myCurrentConfigurationId);
        if (projectByModuleCache == null) {
            projectByModuleCache = Maps.newHashMapWithExpectedSize((int)5);
            myProjectByConfigurationIdAndModuleCache.put(this.myCurrentConfigurationId, projectByModuleCache);
        }
        projectByModuleCache.put(Pair.create((Object)((Object)this.myConfigurationKind), (Object)this.myCurrentModule), cloudProjectId);
    }

    private void restoreChosenProjectId() {
        String storedChosenProjectId = this.getStoredChosenProjectId();
        if (storedChosenProjectId != null) {
            this.setSelectedItem(storedChosenProjectId);
        }
    }

    @Nullable
    private String getStoredChosenProjectId() {
        if (this.myCurrentConfigurationId == -1 || this.myCurrentModule == null) {
            return myLastChosenProjectIdPerKind.get((Object)this.myConfigurationKind);
        }
        Map<Pair<CloudConfiguration.Kind, Module>, String> projectByModuleCache = myProjectByConfigurationIdAndModuleCache.get(this.myCurrentConfigurationId);
        if (projectByModuleCache != null) {
            return projectByModuleCache.get(Pair.create((Object)((Object)this.myConfigurationKind), (Object)this.myCurrentModule));
        }
        return null;
    }

    static {
        myLastChosenProjectIdPerKind = Maps.newHashMapWithExpectedSize((int)5);
        myProjectByConfigurationIdAndModuleCache = Maps.newHashMapWithExpectedSize((int)5);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationKind";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/google/gct/testing/android/CloudProjectSelector";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cloudProjectId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/google/gct/testing/android/CloudProjectSelector";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "updateCloudProjectId";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "rememberChosenProjectId";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class CloudProjectRenderer
    extends ColoredListCellRenderer {
        private CloudProjectRenderer() {
        }

        protected void customizeCellRenderer(JList list, Object value, int index, boolean selected, boolean hasFocus) {
            if (value == null) {
                this.append("[none]", SimpleTextAttributes.ERROR_ATTRIBUTES);
            } else {
                this.append(String.valueOf(value));
            }
        }
    }
}

