/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.testing.android;

import com.android.tools.idea.run.ValidationError;
import com.google.common.collect.Lists;
import com.google.gct.testing.CloudConfigurationHelper;
import com.google.gct.testing.android.CloudConfiguration;
import com.google.gct.testing.launcher.CloudAuthenticator;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

public final class CloudTargetUtil {
    private CloudTargetUtil() {
    }

    @NotNull
    public static List<ValidationError> validate(@NotNull AndroidFacet facet, @NotNull CloudConfiguration.Kind kind, @NotNull String cloudProjectId, int cloudConfigurationId) {
        if (facet == null) {
            CloudTargetUtil.$$$reportNull$$$0(0);
        }
        if (kind == null) {
            CloudTargetUtil.$$$reportNull$$$0(1);
        }
        if (cloudProjectId == null) {
            CloudTargetUtil.$$$reportNull$$$0(2);
        }
        ArrayList errors = Lists.newArrayList();
        if (!CloudAuthenticator.isUserLoggedIn()) {
            errors.add(ValidationError.fatal((String)"Not signed in with Google."));
            ArrayList arrayList = errors;
            if (arrayList == null) {
                CloudTargetUtil.$$$reportNull$$$0(3);
            }
            return arrayList;
        }
        if (cloudProjectId.isEmpty()) {
            errors.add(ValidationError.fatal((String)"Cloud project not specified."));
        }
        CloudConfiguration selectedConfig = null;
        for (CloudConfiguration cloudConfiguration : CloudConfigurationHelper.getCloudConfigurations(facet, kind)) {
            if (cloudConfiguration.getId() != cloudConfigurationId) continue;
            selectedConfig = cloudConfiguration;
        }
        if (selectedConfig == null) {
            errors.add(ValidationError.fatal((String)"Matrix configuration not specified."));
            ArrayList arrayList = errors;
            if (arrayList == null) {
                CloudTargetUtil.$$$reportNull$$$0(4);
            }
            return arrayList;
        }
        if (selectedConfig.getDeviceConfigurationCount() < 1) {
            errors.add(ValidationError.fatal((String)"Selected matrix configuration is empty."));
        }
        ArrayList arrayList = errors;
        if (arrayList == null) {
            CloudTargetUtil.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cloudProjectId";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/google/gct/testing/android/CloudTargetUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/google/gct/testing/android/CloudTargetUtil";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "validate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "validate";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

