/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.testing.config;

import com.google.gct.testing.config.GsutilConfigurable;
import com.google.gct.testing.config.GsutilSettings;
import com.intellij.execution.ExecutableValidator;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.CharsetToolkit;
import org.jetbrains.annotations.NotNull;

public class GsutilExecutableValidator
extends ExecutableValidator {
    private final Project project;
    private final GsutilConfigurable gsutilConfigurable;

    public GsutilExecutableValidator(@NotNull Project project, @NotNull GsutilConfigurable gsutilConfigurable) {
        if (project == null) {
            GsutilExecutableValidator.$$$reportNull$$$0(0);
        }
        if (gsutilConfigurable == null) {
            GsutilExecutableValidator.$$$reportNull$$$0(1);
        }
        super(project, "Can't start GSUtil! ", "Looks like the path to gsutil executable is not valid.");
        this.project = project;
        this.gsutilConfigurable = gsutilConfigurable;
    }

    protected String getCurrentExecutable() {
        return GsutilSettings.getGsutilExecutable(this.project);
    }

    @NotNull
    protected String getConfigurableDisplayName() {
        String string = this.gsutilConfigurable.getDisplayName();
        if (string == null) {
            GsutilExecutableValidator.$$$reportNull$$$0(2);
        }
        return string;
    }

    public boolean isExecutableValid(@NotNull String executable) {
        if (executable == null) {
            GsutilExecutableValidator.$$$reportNull$$$0(3);
        }
        try {
            GeneralCommandLine commandLine = new GeneralCommandLine();
            commandLine.setExePath(executable);
            CapturingProcessHandler handler = new CapturingProcessHandler(commandLine.createProcess(), CharsetToolkit.getDefaultSystemCharset());
            ProcessOutput result = handler.runProcess(60000);
            return !result.isTimeout() && result.getExitCode() == 0;
        }
        catch (Throwable ignored) {
            return false;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gsutilConfigurable";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/google/gct/testing/config/GsutilExecutableValidator";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/google/gct/testing/config/GsutilExecutableValidator";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurableDisplayName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isExecutableValid";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

