/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.testing.dimension;

import com.google.api.client.util.Lists;
import com.google.api.services.testing.model.AndroidDeviceCatalog;
import com.google.api.services.testing.model.Locale;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.gct.testing.CloudConfigurationImpl;
import com.google.gct.testing.dimension.CloudConfigurationDimension;
import com.google.gct.testing.dimension.CloudTestingType;
import com.google.gct.testing.launcher.CloudAuthenticator;
import com.intellij.openapi.vfs.VirtualFile;
import icons.AndroidIcons;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.ResourceFolderManager;

public class LanguageDimension
extends CloudConfigurationDimension {
    public static final String DISPLAY_NAME = "Locale";
    private static ImmutableList<Language> FULL_DOMAIN;
    private static Language defaultLanguage;
    private final List<Language> supportedLanguages;

    public LanguageDimension(CloudConfigurationImpl googleCloudTestingConfiguration, AndroidFacet facet) {
        super(googleCloudTestingConfiguration);
        final List<String> locales = this.getLocales(facet);
        this.supportedLanguages = Lists.newArrayList((Iterable)Iterables.filter(LanguageDimension.getFullDomain(), (Predicate)new Predicate<Language>(){

            public boolean apply(Language input) {
                return locales.contains(input.getId());
            }
        }));
        Collections.sort(this.supportedLanguages, new Comparator<Language>(){

            @Override
            public int compare(Language lang1, Language lang2) {
                return lang1.getResultsViewerDisplayName().compareTo(lang2.getResultsViewerDisplayName());
            }
        });
        this.addLocalDefaultLocale();
    }

    private void addLocalDefaultLocale() {
        Language userLanguage = LanguageDimension.getLanguage(System.getProperty("user.language"));
        if (userLanguage == null && this.supportedLanguages.isEmpty()) {
            userLanguage = LanguageDimension.getLanguage("en");
        }
        if (userLanguage != null) {
            Language localDefaultLanguage = new Language(userLanguage, true);
            this.supportedLanguages.remove(localDefaultLanguage);
            this.supportedLanguages.add(0, localDefaultLanguage);
        }
    }

    @VisibleForTesting
    public LanguageDimension(CloudConfigurationImpl googleCloudTestingConfiguration, final List<String> locales) {
        super(googleCloudTestingConfiguration);
        this.supportedLanguages = Lists.newArrayList((Iterable)Iterables.filter(LanguageDimension.getFullDomain(), (Predicate)new Predicate<Language>(){

            public boolean apply(Language input) {
                return locales.contains(input.getId());
            }
        }));
        this.addLocalDefaultLocale();
    }

    private List<String> getLocales(AndroidFacet facet) {
        LinkedList<String> locales = new LinkedList<String>();
        Pattern pattern = Pattern.compile("\\Avalues-([a-z]+)(-r[a-zA-Z0-9]+)?(-[a-zA-Z0-9]+)?\\z");
        for (VirtualFile resourceDirectory : ResourceFolderManager.getInstance((AndroidFacet)facet).getFolders()) {
            for (VirtualFile subfolder : resourceDirectory.getChildren()) {
                String group3;
                String subfolderName = subfolder.getName();
                Matcher matcher = pattern.matcher(subfolderName);
                if (!matcher.find()) continue;
                StringBuffer sb = new StringBuffer();
                sb.append(matcher.group(1));
                String group2 = matcher.group(2);
                if (group2 != null) {
                    this.appendLocaleGroup(sb, group2, 2);
                }
                if ((group3 = matcher.group(3)) != null) {
                    this.appendLocaleGroup(sb, group3, 1);
                }
                locales.add(sb.toString());
            }
        }
        return locales;
    }

    private void appendLocaleGroup(StringBuffer sb, String groupText, int startIndex) {
        sb.append("_" + groupText.substring(startIndex));
    }

    @Override
    public List<? extends CloudTestingType> getAppSupportedDomain() {
        return this.supportedLanguages;
    }

    public static List<Language> getFullDomain() {
        if (LanguageDimension.isFullDomainMissing() || LanguageDimension.shouldPollDiscoveryTestApi(DISPLAY_NAME)) {
            ImmutableList.Builder fullDomainBuilder = new ImmutableList.Builder();
            AndroidDeviceCatalog androidDeviceCatalog = CloudAuthenticator.getInstance().getAndroidDeviceCatalog();
            if (androidDeviceCatalog != null) {
                for (Locale locale : androidDeviceCatalog.getRuntimeConfiguration().getLocales()) {
                    Language language = new Language(locale.getId(), locale.getName(), locale.getRegion(), false);
                    fullDomainBuilder.add((Object)language);
                    List tags = locale.getTags();
                    if (tags == null || !tags.contains("default")) continue;
                    defaultLanguage = language;
                }
            }
            if (LanguageDimension.isFullDomainMissing() || !fullDomainBuilder.build().isEmpty()) {
                FULL_DOMAIN = fullDomainBuilder.build();
            }
            LanguageDimension.resetDiscoveryTestApiUpdateTimestamp(DISPLAY_NAME);
        }
        return FULL_DOMAIN;
    }

    private static boolean isFullDomainMissing() {
        return FULL_DOMAIN == null || FULL_DOMAIN.isEmpty();
    }

    private static Language getDefaultLanguage() {
        if (defaultLanguage == null) {
            LanguageDimension.getFullDomain();
        }
        return defaultLanguage;
    }

    public void enableDefault() {
        if (LanguageDimension.getDefaultLanguage() == null) {
            return;
        }
        List<? extends CloudTestingType> appSupportedDomain = this.getAppSupportedDomain();
        if (appSupportedDomain.contains(defaultLanguage)) {
            this.enable(defaultLanguage);
        } else if (!appSupportedDomain.isEmpty()) {
            this.enable(appSupportedDomain.get(0));
        }
    }

    public static Language getLanguage(final String locale) {
        try {
            return (Language)Iterables.find(LanguageDimension.getFullDomain(), (Predicate)new Predicate<Language>(){

                public boolean apply(Language input) {
                    return input.getId().equals(locale);
                }
            });
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    @Override
    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    @Override
    public String getId() {
        return "LOCALE";
    }

    @Override
    public Icon getIcon() {
        return AndroidIcons.Configs.Language;
    }

    public static class Language
    extends CloudTestingType {
        private final String id;
        private final String name;
        private final String region;
        private final boolean isLocalDefault;

        public Language(Language language, boolean isLocalDefault) {
            this(language.id, language.name, language.region, isLocalDefault);
        }

        public Language(String id, String name, String region, boolean isLocalDefault) {
            this.id = id;
            this.name = name;
            this.region = region;
            this.details = ImmutableMap.of();
            this.isLocalDefault = isLocalDefault;
        }

        @Override
        public String getGroupName() {
            int endIndex = this.name.indexOf(40);
            return endIndex != -1 ? this.name.substring(0, endIndex).trim() : this.name;
        }

        @Override
        public String getConfigurationDialogDisplayName() {
            return this.getResultsViewerDisplayName() + (this.isLocalDefault ? " - default" : "");
        }

        @Override
        public String getResultsViewerDisplayName() {
            return this.name + (this.region == null ? "" : " (" + this.region + ")");
        }

        @Override
        public String getId() {
            return this.id;
        }
    }
}

