/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.testing.results;

import com.google.gct.testing.results.GoogleCloudTestingInfrastructureFailureState;
import com.google.gct.testing.results.GoogleCloudTestingScheduledState;
import com.google.gct.testing.results.GoogleCloudTestingSuiteInProgressState;
import com.google.gct.testing.results.GoogleCloudTestingTimeoutState;
import com.google.gct.testing.results.GoogleCloudTestingTriggeringErrorState;
import com.google.gct.testing.results.GoogleCloudTestsPresentationUtil;
import com.intellij.execution.Location;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.CompositePrintable;
import com.intellij.execution.testframework.Filter;
import com.intellij.execution.testframework.Printable;
import com.intellij.execution.testframework.Printer;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.sm.SMStacktraceParser;
import com.intellij.execution.testframework.sm.TestsLocationProviderUtil;
import com.intellij.execution.testframework.sm.runner.SMTestLocator;
import com.intellij.execution.testframework.sm.runner.states.AbstractState;
import com.intellij.execution.testframework.sm.runner.states.NotRunState;
import com.intellij.execution.testframework.sm.runner.states.SuiteFinishedState;
import com.intellij.execution.testframework.sm.runner.states.TerminatedState;
import com.intellij.execution.testframework.sm.runner.states.TestComparisionFailedState;
import com.intellij.execution.testframework.sm.runner.states.TestErrorState;
import com.intellij.execution.testframework.sm.runner.states.TestFailedState;
import com.intellij.execution.testframework.sm.runner.states.TestIgnoredState;
import com.intellij.execution.testframework.sm.runner.states.TestInProgressState;
import com.intellij.execution.testframework.sm.runner.states.TestPassedState;
import com.intellij.execution.testframework.sm.runner.states.TestStateInfo;
import com.intellij.execution.testframework.stacktrace.DiffHyperlink;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.ide.util.EditSourceUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.config.AbstractProperty;
import com.intellij.util.containers.ContainerUtilRt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoogleCloudTestProxy
extends AbstractTestProxy {
    private static final Logger LOG = Logger.getInstance((String)GoogleCloudTestProxy.class.getName());
    private List<GoogleCloudTestProxy> myChildren;
    private GoogleCloudTestProxy myParent;
    private AbstractState myState = NotRunState.getInstance();
    private final String myName;
    private Long myDuration = null;
    @Nullable
    private final String myLocationUrl;
    private boolean myDurationIsCached = false;
    private boolean myHasCriticalErrors = false;
    private boolean myHasErrorsCached = false;
    private boolean myHasPassedTests = false;
    private boolean myHasPassedTestsCached = false;
    @Nullable
    private String myStacktrace;
    private final boolean myIsSuite;
    private boolean myIsEmptyIsCached = false;
    private boolean myIsEmpty = true;
    SMTestLocator myLocator = null;
    private final boolean myPreservePresentableName;
    private Printer myPreferredPrinter = null;

    public GoogleCloudTestProxy(String testName, boolean isSuite, @Nullable String locationUrl) {
        this(testName, isSuite, locationUrl, false);
    }

    public GoogleCloudTestProxy(String testName, boolean isSuite, @Nullable String locationUrl, boolean preservePresentableName) {
        this.myName = testName;
        this.myIsSuite = isSuite;
        this.myLocationUrl = locationUrl;
        this.myPreservePresentableName = preservePresentableName;
    }

    public void setLocator(@NotNull SMTestLocator locator) {
        if (locator == null) {
            GoogleCloudTestProxy.$$$reportNull$$$0(0);
        }
        this.myLocator = locator;
    }

    public void setPreferredPrinter(@NotNull Printer preferredPrinter) {
        if (preferredPrinter == null) {
            GoogleCloudTestProxy.$$$reportNull$$$0(1);
        }
        this.myPreferredPrinter = preferredPrinter;
    }

    public boolean isInProgress() {
        return this.myState.isInProgress();
    }

    public boolean isDefect() {
        return this.myState.isDefect();
    }

    public boolean isError() {
        return this.myState instanceof TestErrorState;
    }

    public boolean isFailure() {
        return this.myState instanceof TestFailedState;
    }

    public boolean shouldRun() {
        return true;
    }

    public int getMagnitude() {
        return this.getMagnitudeInfo().getValue();
    }

    public boolean isActiveScheduled() {
        return this.myState instanceof GoogleCloudTestingScheduledState && ((GoogleCloudTestingScheduledState)this.myState).isActive();
    }

    public TestStateInfo.Magnitude getMagnitudeInfo() {
        return this.myState.getMagnitude();
    }

    public boolean hasErrors() {
        if (this.myHasErrorsCached) {
            return this.myHasCriticalErrors;
        }
        boolean canCacheErrors = !this.myState.isInProgress();
        boolean hasErrors = this.calcHasErrors();
        if (canCacheErrors) {
            this.myHasCriticalErrors = hasErrors;
            this.myHasErrorsCached = true;
        }
        return hasErrors;
    }

    private boolean calcHasErrors() {
        if (this.myHasCriticalErrors) {
            return true;
        }
        for (GoogleCloudTestProxy googleCloudTestProxy : this.getChildren()) {
            if (!googleCloudTestProxy.hasErrors()) continue;
            return true;
        }
        return false;
    }

    public boolean isFinal() {
        return this.myState.isFinal();
    }

    private void setStacktraceIfNotSet(@Nullable String stacktrace) {
        if (this.myStacktrace == null) {
            this.myStacktrace = stacktrace;
        }
    }

    public boolean isLeaf() {
        return this.myChildren == null || this.myChildren.isEmpty();
    }

    public boolean isInterrupted() {
        return this.myState.wasTerminated();
    }

    public boolean hasPassedTests() {
        boolean canCache;
        if (this.myHasPassedTestsCached) {
            return this.myHasPassedTests;
        }
        boolean hasPassedTests = this.calcPassedTests();
        boolean bl = canCache = !this.myState.isInProgress();
        if (canCache) {
            this.myHasPassedTests = hasPassedTests;
            this.myHasPassedTestsCached = true;
        }
        return hasPassedTests;
    }

    boolean hasScheduledOrPendingConfigurations() {
        for (GoogleCloudTestProxy googleCloudTestProxy : this.getChildren()) {
            if (googleCloudTestProxy.getMagnitudeInfo() != TestStateInfo.Magnitude.SCHEDULED_INDEX && googleCloudTestProxy.getMagnitudeInfo() != TestStateInfo.Magnitude.RUNNING_INDEX) continue;
            return true;
        }
        return false;
    }

    private boolean calcPassedTests() {
        if (this.isPassed()) {
            return true;
        }
        for (GoogleCloudTestProxy googleCloudTestProxy : this.getChildren()) {
            if (!googleCloudTestProxy.hasPassedTests()) continue;
            return true;
        }
        return false;
    }

    public boolean isIgnored() {
        if (this.hasPassedTests()) {
            return false;
        }
        return this.myState.getMagnitude() == TestStateInfo.Magnitude.IGNORED_INDEX;
    }

    public boolean isPassed() {
        return this.myState.getMagnitude() == TestStateInfo.Magnitude.SKIPPED_INDEX || this.myState.getMagnitude() == TestStateInfo.Magnitude.COMPLETE_INDEX || this.myState.getMagnitude() == TestStateInfo.Magnitude.PASSED_INDEX;
    }

    public void addChild(GoogleCloudTestProxy child) {
        if (this.myChildren == null) {
            this.myChildren = new ArrayList<GoogleCloudTestProxy>();
        }
        this.myChildren.add(child);
        if (this.getParent() != null && this.getParent().getParent() != null) {
            this.addLast((Printable)child);
            GoogleCloudTestProxy configurationNode = this.getParent();
            configurationNode.addLast((Printable)child);
            configurationNode.getParent().addLast((Printable)child);
        }
        child.setParent(this);
        child.setPrinter(this.myPrinter);
        if (this.myPreferredPrinter != null && child.myPreferredPrinter == null) {
            child.setPreferredPrinter(this.myPreferredPrinter);
        }
    }

    @Nullable
    private Printer getRightPrinter(@Nullable Printer printer) {
        if (this.myPreferredPrinter != null && printer != null) {
            return this.myPreferredPrinter;
        }
        return printer;
    }

    public void setPrinter(Printer printer) {
        super.setPrinter(this.getRightPrinter(printer));
    }

    public String getName() {
        return this.myName;
    }

    public boolean isConfig() {
        return false;
    }

    @Nullable
    public Location getLocation(Project project, GlobalSearchScope searchScope) {
        List locations;
        if (this.myLocationUrl == null || this.myLocator == null) {
            return null;
        }
        String protocolId = VirtualFileManager.extractProtocol((String)this.myLocationUrl);
        String path = TestsLocationProviderUtil.extractPath((String)this.myLocationUrl);
        if (protocolId != null && path != null && !(locations = this.myLocator.getLocation(protocolId, path, project, searchScope)).isEmpty()) {
            return (Location)locations.iterator().next();
        }
        return null;
    }

    @Nullable
    public Navigatable getDescriptor(Location location, TestConsoleProperties testConsoleProperties) {
        Navigatable result;
        if (location == null) {
            return null;
        }
        String stacktrace = this.myStacktrace;
        if (stacktrace != null && testConsoleProperties instanceof SMStacktraceParser && this.isLeaf() && (result = ((SMStacktraceParser)testConsoleProperties).getErrorNavigatable(location.getProject(), stacktrace)) != null) {
            return result;
        }
        return EditSourceUtil.getDescriptor((PsiElement)location.getPsiElement());
    }

    public boolean isSuite() {
        return this.myIsSuite;
    }

    public GoogleCloudTestProxy getParent() {
        return this.myParent;
    }

    public List<? extends GoogleCloudTestProxy> getChildren() {
        return this.myChildren != null ? this.myChildren : Collections.emptyList();
    }

    public List<GoogleCloudTestProxy> getAllTests() {
        ArrayList<GoogleCloudTestProxy> allTests = new ArrayList<GoogleCloudTestProxy>();
        allTests.add(this);
        for (GoogleCloudTestProxy googleCloudTestProxy : this.getChildren()) {
            allTests.addAll(googleCloudTestProxy.getAllTests());
        }
        return allTests;
    }

    public void setStarted() {
        this.myState = !this.myIsSuite ? TestInProgressState.TEST : new GoogleCloudTestingSuiteInProgressState(this);
    }

    public void setScheduled() {
        this.myState = !this.myIsSuite ? TestInProgressState.TEST : new GoogleCloudTestingScheduledState(this);
    }

    public void setScheduledActive() {
        if (!(this.myState instanceof GoogleCloudTestingScheduledState)) {
            this.myState = new GoogleCloudTestingScheduledState(this);
        }
        ((GoogleCloudTestingScheduledState)this.myState).makeActive();
    }

    @Nullable
    public Long getDuration() {
        if (this.myDurationIsCached || !this.isSuite()) {
            return this.myDuration;
        }
        this.myDuration = this.calcSuiteDuration();
        this.myDurationIsCached = true;
        return this.myDuration;
    }

    private boolean isSubjectToHide(TestConsoleProperties consoleProperties) {
        return TestConsoleProperties.HIDE_PASSED_TESTS.value((AbstractProperty.AbstractPropertyContainer)consoleProperties) && this.getParent() != null && !this.isDefect();
    }

    @Nullable
    public String getDurationString(TestConsoleProperties consoleProperties) {
        switch (this.getMagnitudeInfo()) {
            case PASSED_INDEX: 
            case RUNNING_INDEX: {
                return !this.isSubjectToHide(consoleProperties) ? this.getDurationString() : null;
            }
            case COMPLETE_INDEX: 
            case FAILED_INDEX: 
            case ERROR_INDEX: 
            case IGNORED_INDEX: 
            case SKIPPED_INDEX: 
            case TERMINATED_INDEX: {
                return this.getDurationString();
            }
        }
        return null;
    }

    private String getDurationString() {
        Long duration = this.getDuration();
        return duration != null ? StringUtil.formatDuration((long)duration) : null;
    }

    public boolean shouldSkipRootNodeForExport() {
        return true;
    }

    public void setDuration(long duration) {
        this.invalidateCachedDurationForContainerSuites();
        this.myDurationIsCached = true;
        this.myDuration = duration >= 0L ? Long.valueOf(duration) : null;
    }

    public void setFinished() {
        if (this.myState.isFinal()) {
            return;
        }
        this.myState = !this.isSuite() ? TestPassedState.INSTANCE : this.determineSuiteStateOnFinished();
        this.fireOnNewPrintable((Printable)this.myState);
    }

    public void setTestFailed(@NotNull String localizedMessage, @Nullable String stackTrace, boolean testError) {
        if (localizedMessage == null) {
            GoogleCloudTestProxy.$$$reportNull$$$0(2);
        }
        this.setStacktraceIfNotSet(stackTrace);
        localizedMessage = this.getParent().getParent().getName() + "\n\t" + localizedMessage;
        if (this.myState instanceof TestFailedState) {
            ((TestFailedState)this.myState).addError(localizedMessage, stackTrace, this.myPrinter);
        } else {
            this.myState = testError ? new TestErrorState(localizedMessage, stackTrace) : new TestFailedState(localizedMessage, stackTrace);
            this.fireOnNewPrintable((Printable)this.myState);
        }
    }

    public void setTestComparisonFailed(@NotNull String localizedMessage, @Nullable String stackTrace, @NotNull String actualText, @NotNull String expectedText) {
        if (localizedMessage == null) {
            GoogleCloudTestProxy.$$$reportNull$$$0(3);
        }
        if (actualText == null) {
            GoogleCloudTestProxy.$$$reportNull$$$0(4);
        }
        if (expectedText == null) {
            GoogleCloudTestProxy.$$$reportNull$$$0(5);
        }
        this.setStacktraceIfNotSet(stackTrace);
        this.myState = new TestComparisionFailedState(localizedMessage, stackTrace, actualText, expectedText);
        this.fireOnNewPrintable((Printable)this.myState);
    }

    public void setTestIgnored(@Nullable String ignoreComment, @Nullable String stackTrace) {
        this.setStacktraceIfNotSet(stackTrace);
        this.myState = new TestIgnoredState(ignoreComment, stackTrace);
        this.fireOnNewPrintable((Printable)this.myState);
    }

    public void setParent(@Nullable GoogleCloudTestProxy parent) {
        this.myParent = parent;
    }

    public List<? extends GoogleCloudTestProxy> collectChildren(@Nullable Filter<GoogleCloudTestProxy> filter) {
        return GoogleCloudTestProxy.filterChildren(filter, this.collectChildren());
    }

    public List<? extends GoogleCloudTestProxy> collectChildren() {
        List<? extends GoogleCloudTestProxy> allChildren = this.getChildren();
        ArrayList result = ContainerUtilRt.newArrayList();
        result.addAll(allChildren);
        for (GoogleCloudTestProxy googleCloudTestProxy : allChildren) {
            result.addAll(googleCloudTestProxy.collectChildren());
        }
        return result;
    }

    public List<? extends GoogleCloudTestProxy> getChildren(@Nullable Filter<? super GoogleCloudTestProxy> filter) {
        List<? extends GoogleCloudTestProxy> allChildren = this.getChildren();
        return GoogleCloudTestProxy.filterChildren(filter, allChildren);
    }

    private static List<? extends GoogleCloudTestProxy> filterChildren(@Nullable Filter<? super GoogleCloudTestProxy> filter, List<? extends GoogleCloudTestProxy> allChildren) {
        if (filter == Filter.NO_FILTER || filter == null) {
            return allChildren;
        }
        ArrayList<GoogleCloudTestProxy> selectedChildren = new ArrayList<GoogleCloudTestProxy>();
        for (GoogleCloudTestProxy googleCloudTestProxy : allChildren) {
            if (!filter.shouldAccept((AbstractTestProxy)googleCloudTestProxy)) continue;
            selectedChildren.add(googleCloudTestProxy);
        }
        if (selectedChildren.isEmpty()) {
            return Collections.emptyList();
        }
        return selectedChildren;
    }

    public boolean wasLaunched() {
        return this.myState.wasLaunched();
    }

    public void printOn(Printer printer) {
        final Printer rightPrinter = this.getRightPrinter(printer);
        super.printOn(rightPrinter);
        final AbstractState oldState = this.myState;
        CompositePrintable.invokeInAlarm((Runnable)new Runnable(){

            @Override
            public void run() {
                oldState.printOn(rightPrinter);
            }
        });
    }

    public void addStdOutput(String output, Key outputType, boolean shouldFireEvent) {
        GoogleCloudTestProxy parent = this.getParent();
        if (parent != null) {
            if (parent instanceof GoogleCloudRootTestProxy) {
                String configurationPrefix = this.getName() + "\n\t";
                parent.fireOnNewPrintable(this.printableFromString(configurationPrefix, outputType));
                parent.addStdOutput(configurationPrefix + output, outputType, false);
            } else {
                parent.addStdOutput(output, outputType, false);
            }
        }
        Printable outputPrintable = this.printableFromString(output, outputType);
        if (shouldFireEvent) {
            this.addLast(outputPrintable);
        } else {
            this.myNestedPrintables.add(outputPrintable);
        }
    }

    private Printable printableFromString(final String text, final Key outputType) {
        return new Printable(){

            public void printOn(Printer printer) {
                printer.print(text, ConsoleViewContentType.getConsoleViewType((Key)outputType));
            }
        };
    }

    public void addStdErr(final String output, boolean shouldFireEvent) {
        Printable printable = new Printable(){

            public void printOn(Printer printer) {
                printer.print(output, ConsoleViewContentType.ERROR_OUTPUT);
            }
        };
        if (shouldFireEvent) {
            this.addLast(printable);
        } else {
            this.myNestedPrintables.add(printable);
        }
        GoogleCloudTestProxy parent = this.getParent();
        if (parent != null) {
            parent.addStdErr(output, false);
        }
    }

    @Deprecated
    public void addError(String output, @Nullable String stackTrace) {
        this.addError(output, stackTrace, true);
    }

    public void addError(final String output, final @Nullable String stackTrace, boolean isCritical) {
        this.myHasCriticalErrors = isCritical;
        this.setStacktraceIfNotSet(stackTrace);
        this.addLast(new Printable(){

            public void printOn(Printer printer) {
                String errorText = TestFailedState.buildErrorPresentationText((String)output, (String)stackTrace);
                LOG.assertTrue(errorText != null);
                TestFailedState.printError((Printer)printer, Arrays.asList(errorText));
            }
        });
    }

    public void addSystemOutput(final String output) {
        this.addLast(new Printable(){

            public void printOn(Printer printer) {
                printer.print(output, ConsoleViewContentType.SYSTEM_OUTPUT);
            }
        });
    }

    @NotNull
    public String getPresentableName() {
        if (this.myPreservePresentableName) {
            String string = GoogleCloudTestsPresentationUtil.getPresentableNameTrimmedOnly(this);
            if (string == null) {
                GoogleCloudTestProxy.$$$reportNull$$$0(6);
            }
            return string;
        }
        String string = GoogleCloudTestsPresentationUtil.getPresentableName(this);
        if (string == null) {
            GoogleCloudTestProxy.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Nullable
    public DiffHyperlink getDiffViewerProvider() {
        if (this.myState instanceof TestComparisionFailedState) {
            return ((TestComparisionFailedState)this.myState).getHyperlink();
        }
        if (this.myChildren != null) {
            for (GoogleCloudTestProxy child : this.myChildren) {
                DiffHyperlink provider;
                if (!child.isDefect() || (provider = child.getDiffViewerProvider()) == null) continue;
                return provider;
            }
        }
        return null;
    }

    public String toString() {
        return this.getPresentableName();
    }

    public void setTerminated() {
        if (this.myState.isFinal()) {
            return;
        }
        this.myState = TerminatedState.INSTANCE;
        for (GoogleCloudTestProxy googleCloudTestProxy : this.getChildren()) {
            googleCloudTestProxy.setTerminated();
        }
        this.fireOnNewPrintable((Printable)this.myState);
    }

    public void setTimeout() {
        if (this.myState.isFinal()) {
            return;
        }
        this.myState = new GoogleCloudTestingTimeoutState(this);
        for (GoogleCloudTestProxy googleCloudTestProxy : this.getChildren()) {
            googleCloudTestProxy.setTimeout();
        }
        this.fireOnNewPrintable((Printable)this.myState);
    }

    public void setInfrastructureFailed() {
        if (this.myState.isFinal()) {
            return;
        }
        this.myState = new GoogleCloudTestingInfrastructureFailureState(this);
        for (GoogleCloudTestProxy googleCloudTestProxy : this.getChildren()) {
            googleCloudTestProxy.setInfrastructureFailed();
        }
        this.fireOnNewPrintable((Printable)this.myState);
    }

    public void setTriggeringError() {
        if (this.myState.isFinal()) {
            return;
        }
        this.myState = new GoogleCloudTestingTriggeringErrorState(this);
        for (GoogleCloudTestProxy googleCloudTestProxy : this.getChildren()) {
            googleCloudTestProxy.setTriggeringError();
        }
        this.fireOnNewPrintable((Printable)this.myState);
    }

    public boolean wasTerminated() {
        return this.myState.wasTerminated();
    }

    @Nullable
    public String getLocationUrl() {
        return this.myLocationUrl;
    }

    private boolean containsErrorTests() {
        List<? extends GoogleCloudTestProxy> children = this.getChildren();
        for (GoogleCloudTestProxy googleCloudTestProxy : children) {
            if (googleCloudTestProxy.getMagnitudeInfo() != TestStateInfo.Magnitude.ERROR_INDEX) continue;
            return true;
        }
        return false;
    }

    private boolean containsFailedTests() {
        List<? extends GoogleCloudTestProxy> children = this.getChildren();
        for (GoogleCloudTestProxy googleCloudTestProxy : children) {
            if (googleCloudTestProxy.getMagnitudeInfo() != TestStateInfo.Magnitude.FAILED_INDEX) continue;
            return true;
        }
        return false;
    }

    private boolean containsPassedTests() {
        List<? extends GoogleCloudTestProxy> children = this.getChildren();
        for (GoogleCloudTestProxy googleCloudTestProxy : children) {
            if (googleCloudTestProxy.getMagnitudeInfo() != TestStateInfo.Magnitude.PASSED_INDEX) continue;
            return true;
        }
        return false;
    }

    protected AbstractState determineSuiteStateOnFinished() {
        Object state = this.isLeaf() ? SuiteFinishedState.EMPTY_LEAF_SUITE : (this.isEmptySuite() && !this.isDefect() && !this.containsTriggeringErrorChildren() ? SuiteFinishedState.EMPTY_SUITE : (this.isDefect() ? (this.containsTerminatedChildren() ? TerminatedState.INSTANCE : (this.containsTimeoutChildren() ? new GoogleCloudTestingTimeoutState(this) : (this.containsInfrastructureFailureChildren() ? new GoogleCloudTestingInfrastructureFailureState(this) : (this.containsErrorTests() ? SuiteFinishedState.ERROR_SUITE : (this.containsFailedTests() ? SuiteFinishedState.FAILED_SUITE : SuiteFinishedState.WITH_IGNORED_TESTS_SUITE))))) : (this.containsPassedTests() || !this.containsTriggeringErrorChildren() ? SuiteFinishedState.PASSED_SUITE : new GoogleCloudTestingTriggeringErrorState(this))));
        return state;
    }

    private boolean containsTerminatedChildren() {
        for (GoogleCloudTestProxy googleCloudTestProxy : this.getChildren()) {
            if (googleCloudTestProxy.getMagnitudeInfo() != TestStateInfo.Magnitude.TERMINATED_INDEX) continue;
            return true;
        }
        return false;
    }

    private boolean containsTimeoutChildren() {
        for (GoogleCloudTestProxy googleCloudTestProxy : this.getChildren()) {
            if (googleCloudTestProxy.getMagnitudeInfo() != TestStateInfo.Magnitude.TIMEOUT_INDEX) continue;
            return true;
        }
        return false;
    }

    private boolean containsInfrastructureFailureChildren() {
        for (GoogleCloudTestProxy googleCloudTestProxy : this.getChildren()) {
            if (googleCloudTestProxy.getMagnitudeInfo() != TestStateInfo.Magnitude.INFRASTRUCTURE_FAILURE_INDEX) continue;
            return true;
        }
        return false;
    }

    private boolean containsTriggeringErrorChildren() {
        for (GoogleCloudTestProxy googleCloudTestProxy : this.getChildren()) {
            if (googleCloudTestProxy.getMagnitudeInfo() != TestStateInfo.Magnitude.TRIGGERING_ERROR_INDEX) continue;
            return true;
        }
        return false;
    }

    public boolean isEmptySuite() {
        if (this.myIsEmptyIsCached) {
            return this.myIsEmpty;
        }
        if (!this.isSuite()) {
            this.myIsEmpty = true;
            this.myIsEmptyIsCached = true;
            return this.myIsEmpty;
        }
        this.myIsEmpty = true;
        List<? extends GoogleCloudTestProxy> allTestCases = this.getChildren();
        for (GoogleCloudTestProxy googleCloudTestProxy : allTestCases) {
            if (googleCloudTestProxy.isSuite()) {
                if (!googleCloudTestProxy.isEmptySuite()) {
                    this.myIsEmpty = false;
                    this.myIsEmptyIsCached = true;
                    break;
                }
                this.myIsEmpty = true;
                this.myIsEmptyIsCached = this.myState.isFinal();
                continue;
            }
            this.myIsEmpty = false;
            this.myIsEmptyIsCached = true;
            break;
        }
        return this.myIsEmpty;
    }

    @Nullable
    private Long calcSuiteDuration() {
        long partialDuration = 0L;
        boolean durationOfChildrenIsUnknown = true;
        for (GoogleCloudTestProxy googleCloudTestProxy : this.getChildren()) {
            Long duration = googleCloudTestProxy.getDuration();
            if (duration == null) continue;
            durationOfChildrenIsUnknown = false;
            partialDuration += duration.longValue();
        }
        return durationOfChildrenIsUnknown ? null : Long.valueOf(partialDuration);
    }

    private void invalidateCachedDurationForContainerSuites() {
        this.myDuration = null;
        this.myDurationIsCached = false;
        GoogleCloudTestProxy containerSuite = this.getParent();
        if (containerSuite != null) {
            containerSuite.invalidateCachedDurationForContainerSuites();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "locator";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "preferredPrinter";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localizedMessage";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actualText";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedText";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/google/gct/testing/results/GoogleCloudTestProxy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/google/gct/testing/results/GoogleCloudTestProxy";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setLocator";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setPreferredPrinter";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setTestFailed";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setTestComparisonFailed";
                break;
            }
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class GoogleCloudRootTestProxy
    extends GoogleCloudTestProxy {
        private String testRunId;
        private boolean myTestsReporterAttached;

        public GoogleCloudRootTestProxy() {
            super("[root]", true, null);
        }

        public String getTestRunId() {
            return this.testRunId;
        }

        public void setTestRunId(String testRunId) {
            this.testRunId = testRunId;
        }

        public void setTestsReporterAttached() {
            this.myTestsReporterAttached = true;
        }

        public boolean isTestsReporterAttached() {
            return this.myTestsReporterAttached;
        }

        @Override
        protected AbstractState determineSuiteStateOnFinished() {
            if (this.isLeaf() && !this.isTestsReporterAttached()) {
                return SuiteFinishedState.TESTS_REPORTER_NOT_ATTACHED;
            }
            return super.determineSuiteStateOnFinished();
        }
    }
}

