/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.testing.results;

import com.google.gct.testing.CloudMatrixExecutionCancellator;
import com.google.gct.testing.results.GoogleCloudTestEventsProcessor;
import com.google.gct.testing.results.GoogleCloudTestingConsoleView;
import com.google.gct.testing.results.GoogleCloudTestingResultsForm;
import com.google.gct.testing.results.GoogleCloudTestingToSMTRunnerEventsConvertor;
import com.google.gct.testing.results.GoogleCloudTestingUIActionsHandler;
import com.google.gct.testing.results.OutputToGoogleCloudTestEventsConverter;
import com.intellij.execution.Location;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.sm.FileUrlProvider;
import com.intellij.execution.testframework.sm.runner.SMTestLocator;
import com.intellij.execution.testframework.sm.runner.TestProxyFilterProvider;
import com.intellij.execution.testframework.sm.runner.TestProxyPrinterProvider;
import com.intellij.execution.testframework.sm.runner.ui.AttachToProcessListener;
import com.intellij.execution.testframework.ui.BaseTestsOutputConsoleView;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.testIntegration.TestLocationProvider;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoogleCloudTestResultsConnectionUtil {
    private static final String TEST_RUNNER_DEBUG_MODE_PROPERTY = "idea.smrunner.debug";

    private GoogleCloudTestResultsConnectionUtil() {
    }

    public static BaseTestsOutputConsoleView createAndAttachConsole(@NotNull String testFrameworkName, @NotNull ProcessHandler processHandler, @NotNull TestConsoleProperties consoleProperties, ExecutionEnvironment environment, @NotNull CloudMatrixExecutionCancellator matrixExecutionCancellator) {
        if (testFrameworkName == null) {
            GoogleCloudTestResultsConnectionUtil.$$$reportNull$$$0(0);
        }
        if (processHandler == null) {
            GoogleCloudTestResultsConnectionUtil.$$$reportNull$$$0(1);
        }
        if (consoleProperties == null) {
            GoogleCloudTestResultsConnectionUtil.$$$reportNull$$$0(2);
        }
        if (matrixExecutionCancellator == null) {
            GoogleCloudTestResultsConnectionUtil.$$$reportNull$$$0(3);
        }
        BaseTestsOutputConsoleView console = GoogleCloudTestResultsConnectionUtil.createConsole(testFrameworkName, consoleProperties, environment, matrixExecutionCancellator);
        console.attachToProcess(processHandler);
        return console;
    }

    public static BaseTestsOutputConsoleView createConsoleWithCustomLocator(@NotNull String testFrameworkName, @NotNull TestConsoleProperties consoleProperties, ExecutionEnvironment environment, @Nullable TestLocationProvider locator, @NotNull CloudMatrixExecutionCancellator matrixExecutionCancellator) {
        if (testFrameworkName == null) {
            GoogleCloudTestResultsConnectionUtil.$$$reportNull$$$0(4);
        }
        if (consoleProperties == null) {
            GoogleCloudTestResultsConnectionUtil.$$$reportNull$$$0(5);
        }
        if (matrixExecutionCancellator == null) {
            GoogleCloudTestResultsConnectionUtil.$$$reportNull$$$0(6);
        }
        return GoogleCloudTestResultsConnectionUtil.createConsoleWithCustomLocator(testFrameworkName, consoleProperties, environment, new CompositeTestLocationProvider(locator), false, null, matrixExecutionCancellator);
    }

    public static GoogleCloudTestingConsoleView createConsoleWithCustomLocator(@NotNull String testFrameworkName, @NotNull TestConsoleProperties consoleProperties, ExecutionEnvironment environment, @Nullable SMTestLocator locator, boolean idBasedTreeConstruction, @Nullable TestProxyFilterProvider filterProvider, @NotNull CloudMatrixExecutionCancellator matrixExecutionCancellator) {
        if (testFrameworkName == null) {
            GoogleCloudTestResultsConnectionUtil.$$$reportNull$$$0(7);
        }
        if (consoleProperties == null) {
            GoogleCloudTestResultsConnectionUtil.$$$reportNull$$$0(8);
        }
        if (matrixExecutionCancellator == null) {
            GoogleCloudTestResultsConnectionUtil.$$$reportNull$$$0(9);
        }
        String splitterPropertyName = GoogleCloudTestResultsConnectionUtil.getSplitterPropertyName(testFrameworkName);
        GoogleCloudTestingConsoleView consoleView = new GoogleCloudTestingConsoleView(consoleProperties, environment, splitterPropertyName);
        GoogleCloudTestResultsConnectionUtil.initConsoleView(consoleView, testFrameworkName, locator, idBasedTreeConstruction, filterProvider, matrixExecutionCancellator);
        return consoleView;
    }

    @NotNull
    public static String getSplitterPropertyName(@NotNull String testFrameworkName) {
        if (testFrameworkName == null) {
            GoogleCloudTestResultsConnectionUtil.$$$reportNull$$$0(10);
        }
        String string = testFrameworkName + ".Splitter.Proportion";
        if (string == null) {
            GoogleCloudTestResultsConnectionUtil.$$$reportNull$$$0(11);
        }
        return string;
    }

    public static void initConsoleView(final @NotNull GoogleCloudTestingConsoleView consoleView, final @NotNull String testFrameworkName, final @Nullable SMTestLocator locator, final boolean idBasedTreeConstruction, final @Nullable TestProxyFilterProvider filterProvider, final @NotNull CloudMatrixExecutionCancellator matrixExecutionCancellator) {
        if (consoleView == null) {
            GoogleCloudTestResultsConnectionUtil.$$$reportNull$$$0(12);
        }
        if (testFrameworkName == null) {
            GoogleCloudTestResultsConnectionUtil.$$$reportNull$$$0(13);
        }
        if (matrixExecutionCancellator == null) {
            GoogleCloudTestResultsConnectionUtil.$$$reportNull$$$0(14);
        }
        consoleView.addAttachToProcessListener(new AttachToProcessListener(){

            public void onAttachToProcess(@NotNull ProcessHandler processHandler) {
                if (processHandler == null) {
                    1.$$$reportNull$$$0(0);
                }
                TestProxyPrinterProvider printerProvider = null;
                if (filterProvider != null) {
                    printerProvider = new TestProxyPrinterProvider((BaseTestsOutputConsoleView)consoleView, filterProvider);
                }
                GoogleCloudTestingResultsForm resultsForm = consoleView.getResultsViewer();
                GoogleCloudTestResultsConnectionUtil.attachEventsProcessors(consoleView.getProperties(), resultsForm, processHandler, testFrameworkName, locator, idBasedTreeConstruction, printerProvider, matrixExecutionCancellator);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processHandler", "com/google/gct/testing/results/GoogleCloudTestResultsConnectionUtil$1", "onAttachToProcess"));
            }
        });
        consoleView.setHelpId("reference.runToolWindow.testResultsTab");
        consoleView.initUI();
    }

    public static BaseTestsOutputConsoleView createConsole(@NotNull String testFrameworkName, @NotNull TestConsoleProperties consoleProperties, ExecutionEnvironment environment, @NotNull CloudMatrixExecutionCancellator matrixExecutionCancellator) {
        if (testFrameworkName == null) {
            GoogleCloudTestResultsConnectionUtil.$$$reportNull$$$0(15);
        }
        if (consoleProperties == null) {
            GoogleCloudTestResultsConnectionUtil.$$$reportNull$$$0(16);
        }
        if (matrixExecutionCancellator == null) {
            GoogleCloudTestResultsConnectionUtil.$$$reportNull$$$0(17);
        }
        return GoogleCloudTestResultsConnectionUtil.createConsoleWithCustomLocator(testFrameworkName, consoleProperties, environment, null, matrixExecutionCancellator);
    }

    public static boolean isInDebugMode() {
        return Boolean.valueOf(System.getProperty(TEST_RUNNER_DEBUG_MODE_PROPERTY));
    }

    private static void attachEventsProcessors(@NotNull TestConsoleProperties consoleProperties, GoogleCloudTestingResultsForm resultsViewer, ProcessHandler processHandler, @NotNull String testFrameworkName, @Nullable SMTestLocator locator, boolean idBasedTreeConstruction, @Nullable TestProxyPrinterProvider printerProvider, final @NotNull CloudMatrixExecutionCancellator matrixExecutionCancellator) {
        if (consoleProperties == null) {
            GoogleCloudTestResultsConnectionUtil.$$$reportNull$$$0(18);
        }
        if (testFrameworkName == null) {
            GoogleCloudTestResultsConnectionUtil.$$$reportNull$$$0(19);
        }
        if (matrixExecutionCancellator == null) {
            GoogleCloudTestResultsConnectionUtil.$$$reportNull$$$0(20);
        }
        final OutputToGoogleCloudTestEventsConverter outputConsumer = new OutputToGoogleCloudTestEventsConverter(testFrameworkName, consoleProperties);
        if (idBasedTreeConstruction) {
            throw new RuntimeException("ID-based converter is not supported!");
        }
        final GoogleCloudTestingToSMTRunnerEventsConvertor eventsProcessor = new GoogleCloudTestingToSMTRunnerEventsConvertor(resultsViewer.getTestsRootNode(), testFrameworkName);
        if (locator != null) {
            ((GoogleCloudTestEventsProcessor)eventsProcessor).setLocator(locator);
        }
        if (printerProvider != null) {
            ((GoogleCloudTestEventsProcessor)eventsProcessor).setPrinterProvider(printerProvider);
        }
        GoogleCloudTestingUIActionsHandler uiActionsHandler = new GoogleCloudTestingUIActionsHandler(consoleProperties);
        outputConsumer.setProcessor(eventsProcessor);
        ((GoogleCloudTestEventsProcessor)eventsProcessor).addEventsListener(resultsViewer);
        resultsViewer.addEventsListener(uiActionsHandler);
        processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void processTerminated(ProcessEvent event) {
                matrixExecutionCancellator.cancel();
                outputConsumer.flushBufferBeforeTerminating();
                eventsProcessor.onFinishTesting();
                Disposer.dispose((Disposable)eventsProcessor);
                Disposer.dispose((Disposable)outputConsumer);
            }

            public void startNotified(ProcessEvent event) {
                eventsProcessor.onStartTesting();
            }

            public void onTextAvailable(ProcessEvent event, Key outputType) {
                outputConsumer.process(event.getText(), outputType);
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testFrameworkName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleProperties";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 14: 
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matrixExecutionCancellator";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/google/gct/testing/results/GoogleCloudTestResultsConnectionUtil";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleView";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/google/gct/testing/results/GoogleCloudTestResultsConnectionUtil";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getSplitterPropertyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createAndAttachConsole";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createConsoleWithCustomLocator";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getSplitterPropertyName";
                break;
            }
            case 11: {
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "initConsoleView";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createConsole";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "attachEventsProcessors";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class CompositeTestLocationProvider
    implements SMTestLocator {
        private final TestLocationProvider myPrimaryLocator;
        private final TestLocationProvider[] myLocators;

        public CompositeTestLocationProvider(@Nullable TestLocationProvider primaryLocator) {
            this.myPrimaryLocator = primaryLocator;
            this.myLocators = (TestLocationProvider[])Extensions.getExtensions((ExtensionPointName)TestLocationProvider.EP_NAME);
        }

        @NotNull
        public List<Location> getLocation(@NotNull String protocol, @NotNull String path, @NotNull Project project, @NotNull GlobalSearchScope scope) {
            List locations;
            if (protocol == null) {
                CompositeTestLocationProvider.$$$reportNull$$$0(0);
            }
            if (path == null) {
                CompositeTestLocationProvider.$$$reportNull$$$0(1);
            }
            if (project == null) {
                CompositeTestLocationProvider.$$$reportNull$$$0(2);
            }
            if (scope == null) {
                CompositeTestLocationProvider.$$$reportNull$$$0(3);
            }
            boolean isDumbMode = DumbService.isDumb((Project)project);
            if (!(this.myPrimaryLocator == null || isDumbMode && !(this.myPrimaryLocator instanceof DumbAware) || (locations = this.myPrimaryLocator.getLocation(protocol, path, project)).isEmpty())) {
                List list = locations;
                if (list == null) {
                    CompositeTestLocationProvider.$$$reportNull$$$0(4);
                }
                return list;
            }
            if ("file".equals(protocol) && !(locations = FileUrlProvider.INSTANCE.getLocation(protocol, path, project, scope)).isEmpty()) {
                List list = locations;
                if (list == null) {
                    CompositeTestLocationProvider.$$$reportNull$$$0(5);
                }
                return list;
            }
            for (TestLocationProvider provider : this.myLocators) {
                List locations2;
                if (isDumbMode && !(provider instanceof DumbAware) || (locations2 = provider.getLocation(protocol, path, project)).isEmpty()) continue;
                List list = locations2;
                if (list == null) {
                    CompositeTestLocationProvider.$$$reportNull$$$0(6);
                }
                return list;
            }
            List<Location> list = Collections.emptyList();
            if (list == null) {
                CompositeTestLocationProvider.$$$reportNull$$$0(7);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "protocol";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scope";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/google/gct/testing/results/GoogleCloudTestResultsConnectionUtil$CompositeTestLocationProvider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/google/gct/testing/results/GoogleCloudTestResultsConnectionUtil$CompositeTestLocationProvider";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLocation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getLocation";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

