/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.testing.results;

import com.google.gct.testing.results.GoogleCloudTestNodeDescriptor;
import com.google.gct.testing.results.GoogleCloudTestProxy;
import com.google.gct.testing.results.GoogleCloudTestingRootTestProxyFormatter;
import com.google.gct.testing.results.GoogleCloudTestsPresentationUtil;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.TestTreeView;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.config.AbstractProperty;
import com.intellij.util.ui.JBUI;
import java.awt.Dimension;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class GoogleCloudTestTreeRenderer
extends ColoredTreeCellRenderer {
    @NonNls
    private static final String SPACE_STRING = " ";
    private final TestConsoleProperties myConsoleProperties;
    private GoogleCloudTestingRootTestProxyFormatter myAdditionalRootFormatter;
    private int myDurationWidth = -1;
    private int myRow;

    public GoogleCloudTestTreeRenderer(TestConsoleProperties consoleProperties) {
        this.myConsoleProperties = consoleProperties;
    }

    public void customizeCellRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        this.myRow = row;
        this.myDurationWidth = -1;
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
        Object userObj = node.getUserObject();
        if (userObj instanceof GoogleCloudTestNodeDescriptor) {
            String durationString;
            GoogleCloudTestNodeDescriptor desc = (GoogleCloudTestNodeDescriptor)((Object)userObj);
            GoogleCloudTestProxy testProxy = (GoogleCloudTestProxy)desc.getElement();
            if (testProxy instanceof GoogleCloudTestProxy.GoogleCloudRootTestProxy) {
                GoogleCloudTestProxy.GoogleCloudRootTestProxy rootTestProxy = (GoogleCloudTestProxy.GoogleCloudRootTestProxy)testProxy;
                if (rootTestProxy.isLeaf()) {
                    GoogleCloudTestsPresentationUtil.formatRootNodeWithoutChildren(rootTestProxy, this);
                } else {
                    GoogleCloudTestsPresentationUtil.formatRootNodeWithChildren(rootTestProxy, this);
                }
                if (this.myAdditionalRootFormatter != null) {
                    this.myAdditionalRootFormatter.format(rootTestProxy, this);
                }
            } else {
                GoogleCloudTestsPresentationUtil.formatTestProxy(testProxy, this);
            }
            if (TestConsoleProperties.SHOW_INLINE_STATISTICS.value((AbstractProperty.AbstractPropertyContainer)this.myConsoleProperties) && (durationString = testProxy.getDurationString(this.myConsoleProperties)) != null) {
                durationString = "  " + durationString;
                this.myDurationWidth = this.getFontMetrics(this.getFont()).stringWidth(durationString);
                if (((TestTreeView)this.myTree).isExpandableHandlerVisibleForCurrentRow(this.myRow)) {
                    this.append(durationString);
                }
            }
            return;
        }
        String text = node.toString();
        this.append(text != null ? text : SPACE_STRING, SimpleTextAttributes.GRAYED_ATTRIBUTES);
    }

    @NotNull
    public Dimension getPreferredSize() {
        Dimension preferredSize = super.getPreferredSize();
        Dimension dimension = this.myDurationWidth < 0 || ((TestTreeView)this.myTree).isExpandableHandlerVisibleForCurrentRow(this.myRow) ? preferredSize : JBUI.size((int)(preferredSize.width + this.myDurationWidth), (int)preferredSize.height);
        if (dimension == null) {
            GoogleCloudTestTreeRenderer.$$$reportNull$$$0(0);
        }
        return dimension;
    }

    public TestConsoleProperties getConsoleProperties() {
        return this.myConsoleProperties;
    }

    public void setAdditionalRootFormatter(@NotNull GoogleCloudTestingRootTestProxyFormatter formatter) {
        if (formatter == null) {
            GoogleCloudTestTreeRenderer.$$$reportNull$$$0(1);
        }
        this.myAdditionalRootFormatter = formatter;
    }

    public void removeAdditionalRootFormatter() {
        this.myAdditionalRootFormatter = null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/google/gct/testing/results/GoogleCloudTestTreeRenderer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formatter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferredSize";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/google/gct/testing/results/GoogleCloudTestTreeRenderer";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setAdditionalRootFormatter";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

