/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.testing.results;

import com.google.gct.testing.results.GoogleCloudTestEventsListener;
import com.google.gct.testing.results.GoogleCloudTestProxy;
import com.google.gct.testing.results.GoogleCloudTestResultsViewer;
import com.google.gct.testing.results.GoogleCloudTestRunnerToolbarPanel;
import com.google.gct.testing.results.GoogleCloudTestTreeBuilder;
import com.google.gct.testing.results.GoogleCloudTestTreeStructure;
import com.google.gct.testing.results.GoogleCloudTestTreeView;
import com.google.gct.testing.results.GoogleCloudTestingPropagateSelectionHandler;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.Filter;
import com.intellij.execution.testframework.LvcsHelper;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.TestFrameworkRunningModel;
import com.intellij.execution.testframework.TestTreeView;
import com.intellij.execution.testframework.TestsUIUtil;
import com.intellij.execution.testframework.ToolbarPanel;
import com.intellij.execution.testframework.sm.SMRunnerUtil;
import com.intellij.execution.testframework.sm.runner.ui.TestsPresentationUtil;
import com.intellij.execution.testframework.ui.AbstractTestTreeBuilder;
import com.intellij.execution.testframework.ui.TestResultsPanel;
import com.intellij.execution.testframework.ui.TestsProgressAnimator;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.util.ColorProgressBar;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.JBColor;
import com.intellij.util.config.AbstractProperty;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.DateFormatUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoogleCloudTestingResultsForm
extends TestResultsPanel
implements TestFrameworkRunningModel,
GoogleCloudTestResultsViewer,
GoogleCloudTestEventsListener {
    @NonNls
    private static final String DEFAULT_SM_RUNNER_SPLITTER_PROPERTY = "SMTestRunner.Splitter.Proportion";
    public static final Color DARK_YELLOW = JBColor.YELLOW.darker();
    private GoogleCloudTestTreeView myTreeView;
    private TestsProgressAnimator myTestAnimator;
    private final GoogleCloudTestProxy.GoogleCloudRootTestProxy myTestsRootNode;
    private GoogleCloudTestTreeBuilder myTreeBuilder;
    private final TestConsoleProperties myConsoleProperties;
    private final List<GoogleCloudTestResultsViewer.EventsListener> myEventListeners;
    private GoogleCloudTestingPropagateSelectionHandler myShowStatisticForProxyHandler;
    private final Project myProject;
    private int myTotalTestCount;
    private int myStartedTestCount;
    private int myFinishedTestCount;
    private int myFailedTestCount;
    private int myIgnoredTestCount;
    private long myStartTime;
    private long myEndTime;
    private String myCurrentCustomProgressCategory;
    private final Set<String> myMentionedCategories;
    private boolean myTestsRunning;

    public GoogleCloudTestingResultsForm(RunProfile runProfile, @NotNull JComponent console, TestConsoleProperties consoleProperties) {
        if (console == null) {
            GoogleCloudTestingResultsForm.$$$reportNull$$$0(0);
        }
        this(runProfile, console, AnAction.EMPTY_ARRAY, consoleProperties, null);
    }

    public GoogleCloudTestingResultsForm(RunProfile runProfile, @NotNull JComponent console, AnAction[] consoleActions, TestConsoleProperties consoleProperties, String splitterPropertyName) {
        if (console == null) {
            GoogleCloudTestingResultsForm.$$$reportNull$$$0(1);
        }
        super(console, consoleActions, consoleProperties, splitterPropertyName != null ? splitterPropertyName : DEFAULT_SM_RUNNER_SPLITTER_PROPERTY, 0.5f);
        this.myEventListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myTotalTestCount = 0;
        this.myStartedTestCount = 0;
        this.myFinishedTestCount = 0;
        this.myFailedTestCount = 0;
        this.myIgnoredTestCount = 0;
        this.myMentionedCategories = new LinkedHashSet<String>();
        this.myTestsRunning = true;
        this.myConsoleProperties = consoleProperties;
        this.myProject = ((RunConfiguration)runProfile).getProject();
        this.myTestsRootNode = new GoogleCloudTestProxy.GoogleCloudRootTestProxy();
    }

    public void initUI() {
        super.initUI();
        KeyStroke shiftEnterKey = KeyStroke.getKeyStroke(10, 1);
        InputMap inputMap = this.myTreeView.getInputMap(1);
        inputMap.put(shiftEnterKey, "show-statistics-for-test-proxy");
        this.myTreeView.getActionMap().put(inputMap.get(shiftEnterKey), new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ignored) {
                GoogleCloudTestingResultsForm.this.showStatisticsForSelectedProxy();
            }
        });
    }

    protected ToolbarPanel createToolbarPanel() {
        return new GoogleCloudTestRunnerToolbarPanel(this.myConsoleProperties, this, (JComponent)((Object)this));
    }

    protected JComponent createTestTreeView() {
        this.myTreeView = new GoogleCloudTestTreeView();
        this.myTreeView.setLargeModel(true);
        this.myTreeView.attachToModel(this);
        this.myTreeView.setTestResultsViewer(this);
        GoogleCloudTestTreeStructure structure = new GoogleCloudTestTreeStructure(this.myProject, (Object)this.myTestsRootNode);
        this.myTreeBuilder = new GoogleCloudTestTreeBuilder((JTree)((Object)this.myTreeView), structure);
        this.myTreeBuilder.setTestsComparator(this);
        Disposer.register((Disposable)this, (Disposable)this.myTreeBuilder);
        this.myTestAnimator = new MyAnimator(this.myTreeBuilder);
        return this.myTreeView;
    }

    public void addTestsTreeSelectionListener(TreeSelectionListener listener) {
        this.myTreeView.getSelectionModel().addTreeSelectionListener(listener);
    }

    @Override
    public void setShowStatisticForProxyHandler(GoogleCloudTestingPropagateSelectionHandler handler) {
        this.myShowStatisticForProxyHandler = handler;
    }

    @Override
    public void onTestingStarted(@NotNull GoogleCloudTestProxy.GoogleCloudRootTestProxy testsRoot, boolean printTestingStartedTime) {
        if (testsRoot == null) {
            GoogleCloudTestingResultsForm.$$$reportNull$$$0(2);
        }
        this.myTestAnimator.setCurrentTestCase((AbstractTestProxy)this.myTestsRootNode);
        this.myStatusLine.setStatusColor(ColorProgressBar.GREEN);
        this.selectAndNotify(this.myTestsRootNode);
        this.myStartTime = System.currentTimeMillis();
        if (printTestingStartedTime) {
            this.myTestsRootNode.addSystemOutput("Testing started at " + DateFormatUtil.formatTime((long)this.myStartTime) + " ...\n");
        }
        this.updateStatusLabel(false);
        this.fireOnTestingStarted();
    }

    @Override
    public void onTestingFinished(@NotNull GoogleCloudTestProxy.GoogleCloudRootTestProxy testsRoot) {
        if (testsRoot == null) {
            GoogleCloudTestingResultsForm.$$$reportNull$$$0(3);
        }
        this.myEndTime = System.currentTimeMillis();
        if (this.myTotalTestCount == 0) {
            this.myTotalTestCount = this.myStartedTestCount;
            this.myStatusLine.setFraction(1.0);
        }
        this.updateStatusLabel(true);
        this.updateIconProgress();
        this.myTestAnimator.stopMovie();
        this.myTreeBuilder.updateFromRoot();
        LvcsHelper.addLabel((TestFrameworkRunningModel)this);
        this.selectAndNotify(this.myTestsRootNode, new Runnable(){

            @Override
            public void run() {
                GoogleCloudTestingResultsForm.this.myTestsRunning = false;
            }
        });
        this.fireOnTestingFinished();
    }

    @Override
    public void onTestsCountInSuite(int count) {
        this.updateCountersAndProgressOnTestCount(count, false);
    }

    @Override
    public void onTestStarted(@NotNull GoogleCloudTestProxy testProxy) {
        if (testProxy == null) {
            GoogleCloudTestingResultsForm.$$$reportNull$$$0(4);
        }
        this.updateOnTestStarted(false);
        this._addTestOrSuite(testProxy);
        this.fireOnTestNodeAdded(testProxy);
    }

    @Override
    public void onTestFailed(@NotNull GoogleCloudTestProxy test) {
        if (test == null) {
            GoogleCloudTestingResultsForm.$$$reportNull$$$0(5);
        }
        this.updateOnTestFailed(false);
        this.updateIconProgress();
    }

    @Override
    public void onTestIgnored(@NotNull GoogleCloudTestProxy test) {
        if (test == null) {
            GoogleCloudTestingResultsForm.$$$reportNull$$$0(6);
        }
        this.updateOnTestIgnored();
    }

    @Override
    public void onSuiteStarted(@NotNull GoogleCloudTestProxy newSuite) {
        if (newSuite == null) {
            GoogleCloudTestingResultsForm.$$$reportNull$$$0(7);
        }
        this._addTestOrSuite(newSuite);
    }

    @Override
    public void onCustomProgressTestsCategory(@Nullable String categoryName, int testCount) {
        this.myCurrentCustomProgressCategory = categoryName;
        this.updateCountersAndProgressOnTestCount(testCount, true);
    }

    @Override
    public void onCustomProgressTestStarted() {
        this.updateOnTestStarted(true);
    }

    @Override
    public void onCustomProgressTestFailed() {
        this.updateOnTestFailed(true);
    }

    @Override
    public void onTestFinished(@NotNull GoogleCloudTestProxy test) {
        if (test == null) {
            GoogleCloudTestingResultsForm.$$$reportNull$$$0(8);
        }
        this.updateOnTestFinished(false);
        this.updateIconProgress();
    }

    @Override
    public void onSuiteFinished(@NotNull GoogleCloudTestProxy suite) {
        if (suite == null) {
            GoogleCloudTestingResultsForm.$$$reportNull$$$0(9);
        }
    }

    @Override
    public GoogleCloudTestProxy.GoogleCloudRootTestProxy getTestsRootNode() {
        return this.myTestsRootNode;
    }

    public TestConsoleProperties getProperties() {
        return this.myConsoleProperties;
    }

    public void setFilter(Filter filter) {
        GoogleCloudTestTreeStructure treeStructure = this.myTreeBuilder.getGoogleCloudTestTreeStructure();
        treeStructure.setFilter(filter);
        this.myTreeBuilder.queueUpdate();
    }

    public boolean isRunning() {
        return this.myTestsRunning;
    }

    public TestTreeView getTreeView() {
        return this.myTreeView;
    }

    public GoogleCloudTestTreeBuilder getTreeBuilder() {
        return this.myTreeBuilder;
    }

    public boolean hasTestSuites() {
        return !this.getRoot().getChildren().isEmpty();
    }

    @NotNull
    public AbstractTestProxy getRoot() {
        GoogleCloudTestProxy.GoogleCloudRootTestProxy googleCloudRootTestProxy = this.myTestsRootNode;
        if (googleCloudRootTestProxy == null) {
            GoogleCloudTestingResultsForm.$$$reportNull$$$0(10);
        }
        return googleCloudRootTestProxy;
    }

    @Override
    public void selectAndNotify(AbstractTestProxy testProxy) {
        this.selectAndNotify(testProxy, null);
    }

    private void selectAndNotify(@Nullable AbstractTestProxy testProxy, @Nullable Runnable onDone) {
        this.selectWithoutNotify(testProxy, onDone);
        this.showStatisticsForSelectedProxy(testProxy, false);
    }

    @Override
    public void addEventsListener(final GoogleCloudTestResultsViewer.EventsListener listener) {
        this.myEventListeners.add(listener);
        this.addTestsTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                GoogleCloudTestProxy selectedProxy = (GoogleCloudTestProxy)GoogleCloudTestingResultsForm.this.getTreeView().getSelectedTest();
                listener.onSelected(selectedProxy, GoogleCloudTestingResultsForm.this, GoogleCloudTestingResultsForm.this);
            }
        });
    }

    public void dispose() {
        super.dispose();
        this.myShowStatisticForProxyHandler = null;
        this.myEventListeners.clear();
    }

    @Override
    public void showStatisticsForSelectedProxy() {
        TestConsoleProperties.SHOW_STATISTICS.set((AbstractProperty.AbstractPropertyContainer)this.myProperties, (Object)true);
        AbstractTestProxy selectedProxy = this.myTreeView.getSelectedTest();
        this.showStatisticsForSelectedProxy(selectedProxy, true);
    }

    private void showStatisticsForSelectedProxy(AbstractTestProxy selectedProxy, boolean requestFocus) {
        if (selectedProxy instanceof GoogleCloudTestProxy && this.myShowStatisticForProxyHandler != null) {
            this.myShowStatisticForProxyHandler.handlePropagateSelectionRequest((GoogleCloudTestProxy)selectedProxy, this, requestFocus);
        }
    }

    protected int getTotalTestCount() {
        return this.myTotalTestCount;
    }

    protected int getStartedTestCount() {
        return this.myStartedTestCount;
    }

    protected int getFinishedTestCount() {
        return this.myFinishedTestCount;
    }

    protected int getFailedTestCount() {
        return this.myFailedTestCount;
    }

    protected int getIgnoredTestCount() {
        return this.myIgnoredTestCount;
    }

    protected Color getTestsStatusColor() {
        return this.myStatusLine.getStatusColor();
    }

    public Set<String> getMentionedCategories() {
        return this.myMentionedCategories;
    }

    protected long getStartTime() {
        return this.myStartTime;
    }

    protected long getEndTime() {
        return this.myEndTime;
    }

    private void _addTestOrSuite(@NotNull GoogleCloudTestProxy newTestOrSuite) {
        if (newTestOrSuite == null) {
            GoogleCloudTestingResultsForm.$$$reportNull$$$0(11);
        }
        GoogleCloudTestProxy parentSuite = newTestOrSuite.getParent();
        assert (parentSuite != null);
        this.myTreeBuilder.updateTestsSubtree(parentSuite);
        this.myTreeBuilder.repaintWithParents(newTestOrSuite);
        this.myTestAnimator.setCurrentTestCase((AbstractTestProxy)newTestOrSuite);
    }

    private void fireOnTestNodeAdded(GoogleCloudTestProxy test) {
        for (GoogleCloudTestResultsViewer.EventsListener eventListener : this.myEventListeners) {
            eventListener.onTestNodeAdded(this, test);
        }
    }

    private void fireOnTestingFinished() {
        for (GoogleCloudTestResultsViewer.EventsListener eventListener : this.myEventListeners) {
            eventListener.onTestingFinished(this);
        }
    }

    private void fireOnTestingStarted() {
        for (GoogleCloudTestResultsViewer.EventsListener eventListener : this.myEventListeners) {
            eventListener.onTestingStarted(this);
        }
    }

    private void selectWithoutNotify(final AbstractTestProxy testProxy, final @Nullable Runnable onDone) {
        if (testProxy == null) {
            return;
        }
        SMRunnerUtil.runInEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (GoogleCloudTestingResultsForm.this.myTreeBuilder.isDisposed()) {
                    return;
                }
                GoogleCloudTestingResultsForm.this.myTreeBuilder.select(testProxy, onDone);
            }
        }, (ModalityState)ModalityState.NON_MODAL);
    }

    private void updateStatusLabel(boolean testingFinished) {
        boolean launchedAndFinished;
        if (this.myFailedTestCount > 0) {
            this.myStatusLine.setStatusColor(ColorProgressBar.RED);
        } else if (this.myIgnoredTestCount > 0) {
            this.myStatusLine.setStatusColor(DARK_YELLOW);
        }
        if (testingFinished && this.myTotalTestCount == 0) {
            this.myStatusLine.setStatusColor((Color)(this.myTestsRootNode.wasLaunched() || !this.myTestsRootNode.isTestsReporterAttached() ? JBColor.LIGHT_GRAY : ColorProgressBar.RED));
        }
        boolean bl = launchedAndFinished = this.myTestsRootNode.wasLaunched() && !this.myTestsRootNode.isInProgress();
        if (!TestsPresentationUtil.hasNonDefaultCategories(this.myMentionedCategories)) {
            if (this.myTestsRootNode.getDuration() == null || this.myEndTime == 0L) {
                this.myStatusLine.setText("");
            } else {
                this.myStatusLine.setText("Total time \u2013 " + StringUtil.formatDuration((long)this.myTestsRootNode.getDuration()));
            }
        } else {
            this.myStatusLine.setText(TestsPresentationUtil.getProgressStatus_Text((long)this.myStartTime, (long)this.myEndTime, (int)this.myTotalTestCount, (int)this.myFinishedTestCount, (int)this.myFailedTestCount, this.myMentionedCategories, (boolean)launchedAndFinished));
        }
    }

    public void performUpdate() {
        this.myTreeBuilder.performUpdate();
    }

    private void updateIconProgress() {
        int doneTestCount;
        int totalTestCount;
        if (this.myTotalTestCount == 0) {
            totalTestCount = 2;
            doneTestCount = 1;
        } else {
            totalTestCount = this.myTotalTestCount;
            doneTestCount = this.myFinishedTestCount + this.myFailedTestCount + this.myIgnoredTestCount;
        }
        TestsUIUtil.showIconProgress((Project)this.myProject, (int)doneTestCount, (int)totalTestCount, (int)this.myFailedTestCount, (boolean)true);
    }

    public GoogleCloudTestingPropagateSelectionHandler createSelectMeListener() {
        return new GoogleCloudTestingPropagateSelectionHandler(){

            @Override
            public void handlePropagateSelectionRequest(final @Nullable GoogleCloudTestProxy selectedTestProxy, @NotNull Object sender, final boolean requestFocus) {
                if (sender == null) {
                    5.$$$reportNull$$$0(0);
                }
                SMRunnerUtil.addToInvokeLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        GoogleCloudTestingResultsForm.this.selectWithoutNotify(selectedTestProxy, null);
                        if (requestFocus) {
                            IdeFocusManager.getInstance((Project)GoogleCloudTestingResultsForm.this.myProject).requestFocus((Component)((Object)GoogleCloudTestingResultsForm.this.myTreeView), true);
                        }
                    }
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sender", "com/google/gct/testing/results/GoogleCloudTestingResultsForm$5", "handlePropagateSelectionRequest"));
            }
        };
    }

    private void updateCountersAndProgressOnTestCount(int count, boolean isCustomMessage) {
        if (!this.isModeConsistent(isCustomMessage)) {
            return;
        }
        this.myTotalTestCount += count;
        this.updateStatusLabel(false);
    }

    private void updateOnTestStarted(boolean isCustomMessage) {
        if (!this.isModeConsistent(isCustomMessage)) {
            return;
        }
        this.myMentionedCategories.add(this.myCurrentCustomProgressCategory != null ? this.myCurrentCustomProgressCategory : "Tests");
        ++this.myStartedTestCount;
        if (this.myStartedTestCount > this.myTotalTestCount && this.myTotalTestCount != 0) {
            this.myTotalTestCount = this.myStartedTestCount;
        }
        this.updateStatusLabel(false);
    }

    private void updateProgressOnTestDone() {
        int doneTestCount = this.myFinishedTestCount + this.myFailedTestCount + this.myIgnoredTestCount;
        if (this.myTotalTestCount != 0) {
            this.myStatusLine.setFraction((double)doneTestCount / (double)this.myTotalTestCount);
        } else {
            this.myStatusLine.setFraction(doneTestCount > 0 ? 0.5 : 0.0);
        }
    }

    private void updateOnTestFailed(boolean isCustomMessage) {
        if (!this.isModeConsistent(isCustomMessage)) {
            return;
        }
        ++this.myFailedTestCount;
        this.updateProgressOnTestDone();
        this.updateStatusLabel(false);
    }

    private void updateOnTestFinished(boolean isCustomMessage) {
        if (!this.isModeConsistent(isCustomMessage)) {
            return;
        }
        ++this.myFinishedTestCount;
        this.updateProgressOnTestDone();
    }

    private void updateOnTestIgnored() {
        ++this.myIgnoredTestCount;
        this.updateProgressOnTestDone();
        this.updateStatusLabel(false);
    }

    private boolean isModeConsistent(boolean isCustomMessage) {
        return isCustomMessage != (this.myCurrentCustomProgressCategory == null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "console";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testsRoot";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testProxy";
                break;
            }
            case 5: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "test";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSuite";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suite";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/google/gct/testing/results/GoogleCloudTestingResultsForm";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newTestOrSuite";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/google/gct/testing/results/GoogleCloudTestingResultsForm";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "onTestingStarted";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "onTestingFinished";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "onTestStarted";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "onTestFailed";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "onTestIgnored";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "onSuiteStarted";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "onTestFinished";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "onSuiteFinished";
                break;
            }
            case 10: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "_addTestOrSuite";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyAnimator
    extends TestsProgressAnimator {
        public MyAnimator(AbstractTestTreeBuilder builder) {
            super(builder);
        }
    }
}

