/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.testing.results;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.gct.testing.CloudTestingUtils;
import com.google.gct.testing.results.GoogleCloudTestEventsListener;
import com.google.gct.testing.results.GoogleCloudTestEventsProcessor;
import com.google.gct.testing.results.GoogleCloudTestProxy;
import com.google.gct.testing.results.GoogleCloudTestResultsConnectionUtil;
import com.google.gct.testing.results.events.GoogleCloudTestFailedEvent;
import com.google.gct.testing.results.events.GoogleCloudTestFinishedEvent;
import com.google.gct.testing.results.events.GoogleCloudTestIgnoredEvent;
import com.google.gct.testing.results.events.GoogleCloudTestOutputEvent;
import com.google.gct.testing.results.events.GoogleCloudTestStartedEvent;
import com.google.gct.testing.results.events.SetActiveCloudMatrixEvent;
import com.google.gct.testing.results.events.SetTestRunIdEvent;
import com.google.gct.testing.results.events.TestConfigurationFinishedEvent;
import com.google.gct.testing.results.events.TestConfigurationProgressEvent;
import com.google.gct.testing.results.events.TestConfigurationScheduledEvent;
import com.google.gct.testing.results.events.TestConfigurationStartedEvent;
import com.google.gct.testing.results.events.TestConfigurationStoppedEvent;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.sm.SMTestsRunnerBundle;
import com.intellij.execution.testframework.sm.runner.SMTestLocator;
import com.intellij.execution.testframework.sm.runner.TestProxyPrinterProvider;
import com.intellij.execution.testframework.sm.runner.events.TestSuiteFinishedEvent;
import com.intellij.execution.testframework.sm.runner.events.TestSuiteStartedEvent;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoogleCloudTestingToSMTRunnerEventsConvertor
extends GoogleCloudTestEventsProcessor {
    private static final Logger LOG = Logger.getInstance((String)GoogleCloudTestingToSMTRunnerEventsConvertor.class.getName());
    private final Map<String, GoogleCloudTestProxy> myRunningTestsFullNameToProxy;
    private final Set<AbstractTestProxy> myFailedTestsSet;
    private final List<GoogleCloudTestEventsListener> myEventsListeners;
    private final GoogleCloudTestProxy.GoogleCloudRootTestProxy myTestsRootNode;
    private final String myTestFrameworkName;
    private boolean myIsTestingFinished;
    private SMTestLocator myLocator;
    private GoogleCloudTestProxy lastUpdatedTest;

    public GoogleCloudTestingToSMTRunnerEventsConvertor(@NotNull GoogleCloudTestProxy.GoogleCloudRootTestProxy testsRootNode, @NotNull String testFrameworkName) {
        if (testsRootNode == null) {
            GoogleCloudTestingToSMTRunnerEventsConvertor.$$$reportNull$$$0(0);
        }
        if (testFrameworkName == null) {
            GoogleCloudTestingToSMTRunnerEventsConvertor.$$$reportNull$$$0(1);
        }
        this.myRunningTestsFullNameToProxy = new HashMap<String, GoogleCloudTestProxy>();
        this.myFailedTestsSet = new HashSet<AbstractTestProxy>();
        this.myEventsListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myLocator = null;
        this.lastUpdatedTest = null;
        this.myTestsRootNode = testsRootNode;
        this.myTestFrameworkName = testFrameworkName;
    }

    @Override
    public void setLocator(@NotNull SMTestLocator customLocator) {
        if (customLocator == null) {
            GoogleCloudTestingToSMTRunnerEventsConvertor.$$$reportNull$$$0(2);
        }
        this.myLocator = customLocator;
    }

    @Override
    public void addEventsListener(@NotNull GoogleCloudTestEventsListener listener) {
        if (listener == null) {
            GoogleCloudTestingToSMTRunnerEventsConvertor.$$$reportNull$$$0(3);
        }
        this.myEventsListeners.add(listener);
    }

    @Override
    public void onStartTesting() {
        this.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                GoogleCloudTestingToSMTRunnerEventsConvertor.this.myTestsRootNode.setScheduled();
                GoogleCloudTestingToSMTRunnerEventsConvertor.this.lastUpdatedTest = null;
                GoogleCloudTestingToSMTRunnerEventsConvertor.this.fireOnTestingStarted(true);
            }
        });
    }

    @Override
    public void onTestsReporterAttached() {
        this.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                GoogleCloudTestingToSMTRunnerEventsConvertor.this.myTestsRootNode.setTestsReporterAttached();
            }
        });
    }

    @Override
    public void onFinishTesting() {
        this.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                if (GoogleCloudTestingToSMTRunnerEventsConvertor.this.myIsTestingFinished) {
                    return;
                }
                GoogleCloudTestingToSMTRunnerEventsConvertor.this.myIsTestingFinished = true;
                GoogleCloudTestingToSMTRunnerEventsConvertor.this.myRunningTestsFullNameToProxy.clear();
                GoogleCloudTestingToSMTRunnerEventsConvertor.this.lastUpdatedTest = null;
                if (GoogleCloudTestingToSMTRunnerEventsConvertor.this.myTestsRootNode.hasScheduledOrPendingConfigurations()) {
                    GoogleCloudTestingToSMTRunnerEventsConvertor.this.myTestsRootNode.setTerminated();
                } else {
                    GoogleCloudTestingToSMTRunnerEventsConvertor.this.myTestsRootNode.setFinished();
                }
                GoogleCloudTestingToSMTRunnerEventsConvertor.this.onUncapturedOutput(this.prepareFinishString(), ProcessOutputTypes.STDOUT);
                GoogleCloudTestingToSMTRunnerEventsConvertor.this.onUncapturedOutput("\nPricing information: https://firebase.google.com/pricing \n", ProcessOutputTypes.STDOUT);
                GoogleCloudTestingToSMTRunnerEventsConvertor.this.fireOnTestingFinished();
            }

            private String prepareFinishString() {
                return CloudTestingUtils.shouldShowProgressTimestamps() ? "Finish\t" + System.currentTimeMillis() + "\n" : "Finish\n";
            }
        });
    }

    @Override
    public void setPrinterProvider(@NotNull TestProxyPrinterProvider printerProvider) {
        if (printerProvider == null) {
            GoogleCloudTestingToSMTRunnerEventsConvertor.$$$reportNull$$$0(4);
        }
    }

    @Override
    public void onTestStarted(final @NotNull GoogleCloudTestStartedEvent testStartedEvent) {
        if (testStartedEvent == null) {
            GoogleCloudTestingToSMTRunnerEventsConvertor.$$$reportNull$$$0(5);
        }
        this.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                String configuration = testStartedEvent.getConfiguration();
                String className = testStartedEvent.getClassName();
                String testName = testStartedEvent.getName();
                String locationUrl = testStartedEvent.getLocationUrl();
                String fullName = GoogleCloudTestingToSMTRunnerEventsConvertor.this.getFullTestName(configuration, className, testName);
                if (GoogleCloudTestingToSMTRunnerEventsConvertor.this.myRunningTestsFullNameToProxy.containsKey(fullName)) {
                    GoogleCloudTestingToSMTRunnerEventsConvertor.this.logProblem("Test [" + fullName + "] has been already started");
                    if (GoogleCloudTestResultsConnectionUtil.isInDebugMode()) {
                        return;
                    }
                }
                GoogleCloudTestProxy parentSuite = GoogleCloudTestingToSMTRunnerEventsConvertor.this.findOrCreateChildNode(GoogleCloudTestingToSMTRunnerEventsConvertor.this.myTestsRootNode, configuration, true);
                parentSuite = GoogleCloudTestingToSMTRunnerEventsConvertor.this.findOrCreateChildNode(parentSuite, className, true);
                GoogleCloudTestProxy testProxy = new GoogleCloudTestProxy(testName, false, locationUrl);
                if (GoogleCloudTestingToSMTRunnerEventsConvertor.this.myLocator != null) {
                    testProxy.setLocator(GoogleCloudTestingToSMTRunnerEventsConvertor.this.myLocator);
                }
                GoogleCloudTestingToSMTRunnerEventsConvertor.this.lastUpdatedTest = testProxy;
                parentSuite.addChild(testProxy);
                GoogleCloudTestingToSMTRunnerEventsConvertor.this.myRunningTestsFullNameToProxy.put(fullName, testProxy);
                testProxy.setStarted();
                GoogleCloudTestingToSMTRunnerEventsConvertor.this.fireOnTestStarted(testProxy);
            }
        });
    }

    private String getFullTestName(String configuration, String className, String testName) {
        return configuration + ":" + className + ":" + testName;
    }

    private GoogleCloudTestProxy findOrCreateChildNode(GoogleCloudTestProxy parent, String nodeName, boolean shouldStartIfNotFound) {
        GoogleCloudTestProxy testProxy = (GoogleCloudTestProxy)((Object)Iterables.find(parent.getChildren(), this.getNodeNamed(nodeName), null));
        if (testProxy == null) {
            testProxy = new GoogleCloudTestProxy(nodeName, true, null);
            parent.addChild(testProxy);
            if (shouldStartIfNotFound) {
                testProxy.setStarted();
                this.fireOnTestStarted(testProxy);
            }
        }
        return testProxy;
    }

    private Predicate<GoogleCloudTestProxy> getNodeNamed(final String nodeName) {
        return new Predicate<GoogleCloudTestProxy>(){

            public boolean apply(GoogleCloudTestProxy testProxy) {
                return testProxy.getName().equals(nodeName);
            }
        };
    }

    @Override
    public void onSuiteStarted(@NotNull TestSuiteStartedEvent suiteStartedEvent) {
        if (suiteStartedEvent == null) {
            GoogleCloudTestingToSMTRunnerEventsConvertor.$$$reportNull$$$0(6);
        }
        this.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                throw new RuntimeException("Unsupported event 'onSuiteStarted'");
            }
        });
    }

    @Override
    public void onSetTestRunId(@NotNull SetTestRunIdEvent setTestRunIdEvent) {
        if (setTestRunIdEvent == null) {
            GoogleCloudTestingToSMTRunnerEventsConvertor.$$$reportNull$$$0(7);
        }
        this.myTestsRootNode.setTestRunId(setTestRunIdEvent.getTestRunId());
    }

    @Override
    public void onSetActiveCloudMatrix(@NotNull SetActiveCloudMatrixEvent setActiveCloudMatrixEvent) {
        if (setActiveCloudMatrixEvent == null) {
            GoogleCloudTestingToSMTRunnerEventsConvertor.$$$reportNull$$$0(8);
        }
        this.myTestsRootNode.setScheduledActive();
        for (GoogleCloudTestProxy googleCloudTestProxy : this.myTestsRootNode.getChildren()) {
            googleCloudTestProxy.setScheduledActive();
        }
    }

    @Override
    public void onConfigurationStopped(final @NotNull TestConfigurationStoppedEvent configurationStoppedEvent) {
        if (configurationStoppedEvent == null) {
            GoogleCloudTestingToSMTRunnerEventsConvertor.$$$reportNull$$$0(9);
        }
        this.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                String configurationName = configurationStoppedEvent.getName();
                for (GoogleCloudTestProxy googleCloudTestProxy : GoogleCloudTestingToSMTRunnerEventsConvertor.this.myTestsRootNode.getChildren()) {
                    if (!googleCloudTestProxy.getName().equals(configurationName)) continue;
                    List<GoogleCloudTestProxy> suiteTests = googleCloudTestProxy.getAllTests();
                    suiteTests.remove((Object)googleCloudTestProxy);
                    for (GoogleCloudTestProxy suiteTest : suiteTests) {
                        GoogleCloudTestingToSMTRunnerEventsConvertor.this.stopTest(suiteTest, configurationStoppedEvent.getStopReason());
                    }
                    GoogleCloudTestingToSMTRunnerEventsConvertor.this.stopTest(googleCloudTestProxy, configurationStoppedEvent.getStopReason());
                    googleCloudTestProxy.setDuration(configurationStoppedEvent.getTestDuration());
                    return;
                }
                throw new IllegalStateException("Could not find configuration: " + configurationName);
            }
        });
    }

    @Override
    public void onConfigurationStarted(final @NotNull TestConfigurationStartedEvent configurationStartedEvent) {
        if (configurationStartedEvent == null) {
            GoogleCloudTestingToSMTRunnerEventsConvertor.$$$reportNull$$$0(10);
        }
        this.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                String configurationName = configurationStartedEvent.getName();
                GoogleCloudTestProxy newConfiguration = GoogleCloudTestingToSMTRunnerEventsConvertor.this.findOrCreateChildNode(GoogleCloudTestingToSMTRunnerEventsConvertor.this.myTestsRootNode, configurationName, false);
                if (GoogleCloudTestingToSMTRunnerEventsConvertor.this.myLocator != null) {
                    newConfiguration.setLocator(GoogleCloudTestingToSMTRunnerEventsConvertor.this.myLocator);
                }
                newConfiguration.setStarted();
                GoogleCloudTestingToSMTRunnerEventsConvertor.this.fireOnSuiteStarted(newConfiguration);
                if (!GoogleCloudTestingToSMTRunnerEventsConvertor.this.myTestsRootNode.isInProgress()) {
                    GoogleCloudTestingToSMTRunnerEventsConvertor.this.myTestsRootNode.setStarted();
                    GoogleCloudTestingToSMTRunnerEventsConvertor.this.fireOnTestingStarted(false);
                }
            }
        });
    }

    @Override
    public void onConfigurationProgress(final @NotNull TestConfigurationProgressEvent configurationProgressEvent) {
        if (configurationProgressEvent == null) {
            GoogleCloudTestingToSMTRunnerEventsConvertor.$$$reportNull$$$0(11);
        }
        this.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                String configurationName = configurationProgressEvent.getName();
                String progressText = configurationProgressEvent.getText();
                GoogleCloudTestProxy configurationProxy = (GoogleCloudTestProxy)((Object)Iterables.find(GoogleCloudTestingToSMTRunnerEventsConvertor.this.myTestsRootNode.getChildren(), (Predicate)GoogleCloudTestingToSMTRunnerEventsConvertor.this.getNodeNamed(configurationName), null));
                if (configurationProxy == null) {
                    throw new IllegalStateException("Could not report progress for non-existing configuration: " + configurationName);
                }
                configurationProxy.addStdOutput(progressText, ProcessOutputTypes.STDOUT, true);
            }
        });
    }

    @Override
    public void onConfigurationScheduled(final @NotNull TestConfigurationScheduledEvent configurationScheduledEvent) {
        if (configurationScheduledEvent == null) {
            GoogleCloudTestingToSMTRunnerEventsConvertor.$$$reportNull$$$0(12);
        }
        this.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                String configurationName = configurationScheduledEvent.getName();
                String locationUrl = configurationScheduledEvent.getLocationUrl();
                GoogleCloudTestProxy newConfiguration = new GoogleCloudTestProxy(configurationName, true, locationUrl);
                if (GoogleCloudTestingToSMTRunnerEventsConvertor.this.myLocator != null) {
                    newConfiguration.setLocator(GoogleCloudTestingToSMTRunnerEventsConvertor.this.myLocator);
                }
                GoogleCloudTestingToSMTRunnerEventsConvertor.this.myTestsRootNode.addChild(newConfiguration);
                newConfiguration.setScheduled();
                GoogleCloudTestingToSMTRunnerEventsConvertor.this.fireOnSuiteStarted(newConfiguration);
            }
        });
    }

    private void stopTest(GoogleCloudTestProxy test, CloudTestingUtils.ConfigurationStopReason stopReason) {
        switch (stopReason) {
            case FINISHED: {
                test.setFinished();
                break;
            }
            case INFRASTRUCTURE_FAILURE: {
                test.setInfrastructureFailed();
                break;
            }
            case TRIGGERING_ERROR: {
                test.setTriggeringError();
                break;
            }
            case TIMED_OUT: {
                test.setTimeout();
            }
        }
        this.fireOnTestFinished(test);
    }

    @Override
    public void onTestFinished(final @NotNull GoogleCloudTestFinishedEvent testFinishedEvent) {
        if (testFinishedEvent == null) {
            GoogleCloudTestingToSMTRunnerEventsConvertor.$$$reportNull$$$0(13);
        }
        this.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                String configuration = testFinishedEvent.getConfiguration();
                String className = testFinishedEvent.getClassName();
                String testName = testFinishedEvent.getName();
                long duration = testFinishedEvent.getDuration() == null ? -1L : testFinishedEvent.getDuration();
                String fullTestName = GoogleCloudTestingToSMTRunnerEventsConvertor.this.getFullTestName(configuration, className, testName);
                GoogleCloudTestProxy testProxy = GoogleCloudTestingToSMTRunnerEventsConvertor.this.getProxyByFullTestName(fullTestName);
                if (testProxy == null) {
                    GoogleCloudTestingToSMTRunnerEventsConvertor.this.logProblem("Test wasn't started! TestFinished event: name = {" + testName + "}. " + GoogleCloudTestingToSMTRunnerEventsConvertor.this.cannotFindFullTestNameMsg(fullTestName));
                    return;
                }
                GoogleCloudTestingToSMTRunnerEventsConvertor.this.lastUpdatedTest = testProxy;
                testProxy.setDuration(duration);
                testProxy.setFinished();
                GoogleCloudTestingToSMTRunnerEventsConvertor.this.myRunningTestsFullNameToProxy.remove(fullTestName);
                GoogleCloudTestingToSMTRunnerEventsConvertor.this.fireOnTestFinished(testProxy);
            }
        });
    }

    @Override
    public void onSuiteFinished(@NotNull TestSuiteFinishedEvent suiteFinishedEvent) {
        if (suiteFinishedEvent == null) {
            GoogleCloudTestingToSMTRunnerEventsConvertor.$$$reportNull$$$0(14);
        }
        this.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                throw new RuntimeException("Unsupported event 'onSuiteFinished'");
            }
        });
    }

    @Override
    public void onConfigurationFinished(@NotNull TestConfigurationFinishedEvent configurationFinishedEvent) {
        if (configurationFinishedEvent == null) {
            GoogleCloudTestingToSMTRunnerEventsConvertor.$$$reportNull$$$0(15);
        }
        this.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                throw new RuntimeException("Unsupported event 'onConfigurationFinished'");
            }
        });
    }

    @Override
    public void onUncapturedOutput(final @NotNull String text, final Key outputType) {
        if (text == null) {
            GoogleCloudTestingToSMTRunnerEventsConvertor.$$$reportNull$$$0(16);
        }
        this.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                GoogleCloudTestProxy currentProxy = GoogleCloudTestingToSMTRunnerEventsConvertor.this.findCurrentTestOrSuite();
                if (ProcessOutputTypes.STDERR.equals((Object)outputType)) {
                    currentProxy.addStdErr(text, true);
                } else if (ProcessOutputTypes.SYSTEM.equals((Object)outputType)) {
                    currentProxy.addSystemOutput(text);
                } else {
                    currentProxy.addStdOutput(text, outputType, true);
                }
            }
        });
    }

    @Override
    public void onError(final @NotNull String localizedMessage, final @Nullable String stackTrace, final boolean isCritical) {
        if (localizedMessage == null) {
            GoogleCloudTestingToSMTRunnerEventsConvertor.$$$reportNull$$$0(17);
        }
        this.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                GoogleCloudTestProxy currentProxy = GoogleCloudTestingToSMTRunnerEventsConvertor.this.findCurrentTestOrSuite();
                currentProxy.addError(localizedMessage, stackTrace, isCritical);
            }
        });
    }

    @Override
    public void onCustomProgressTestsCategory(final @Nullable String categoryName, final int testCount) {
        this.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                GoogleCloudTestingToSMTRunnerEventsConvertor.this.fireOnCustomProgressTestsCategory(categoryName, testCount);
            }
        });
    }

    @Override
    public void onCustomProgressTestStarted() {
        this.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                GoogleCloudTestingToSMTRunnerEventsConvertor.this.fireOnCustomProgressTestStarted();
            }
        });
    }

    @Override
    public void onCustomProgressTestFailed() {
        this.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                GoogleCloudTestingToSMTRunnerEventsConvertor.this.fireOnCustomProgressTestFailed();
            }
        });
    }

    @Override
    public void onTestFailure(final @NotNull GoogleCloudTestFailedEvent testFailedEvent) {
        if (testFailedEvent == null) {
            GoogleCloudTestingToSMTRunnerEventsConvertor.$$$reportNull$$$0(18);
        }
        this.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                String configuration = testFailedEvent.getConfiguration();
                String className = testFailedEvent.getClassName();
                String testName = (String)ObjectUtils.assertNotNull((Object)testFailedEvent.getName());
                String localizedMessage = testFailedEvent.getLocalizedFailureMessage();
                String stackTrace = testFailedEvent.getStacktrace();
                boolean isTestError = testFailedEvent.isTestError();
                String comparisionFailureActualText = testFailedEvent.getComparisonFailureActualText();
                String comparisionFailureExpectedText = testFailedEvent.getComparisonFailureExpectedText();
                boolean inDebugMode = GoogleCloudTestResultsConnectionUtil.isInDebugMode();
                String fullTestName = GoogleCloudTestingToSMTRunnerEventsConvertor.this.getFullTestName(configuration, className, testName);
                GoogleCloudTestProxy testProxy = GoogleCloudTestingToSMTRunnerEventsConvertor.this.getProxyByFullTestName(fullTestName);
                if (testProxy == null) {
                    GoogleCloudTestingToSMTRunnerEventsConvertor.this.logProblem("Test wasn't started! TestFailure event: name = {" + testName + "}, message = {" + localizedMessage + "}, stackTrace = {" + stackTrace + "}. " + GoogleCloudTestingToSMTRunnerEventsConvertor.this.cannotFindFullTestNameMsg(fullTestName));
                    if (inDebugMode) {
                        return;
                    }
                    GoogleCloudTestingToSMTRunnerEventsConvertor.this.onTestStarted(new GoogleCloudTestStartedEvent(testName, null, configuration, className));
                    testProxy = GoogleCloudTestingToSMTRunnerEventsConvertor.this.getProxyByFullTestName(fullTestName);
                }
                if (testProxy == null) {
                    return;
                }
                GoogleCloudTestingToSMTRunnerEventsConvertor.this.lastUpdatedTest = testProxy;
                if (comparisionFailureActualText != null && comparisionFailureExpectedText != null) {
                    if (GoogleCloudTestingToSMTRunnerEventsConvertor.this.myFailedTestsSet.contains((Object)testProxy)) {
                        GoogleCloudTestingToSMTRunnerEventsConvertor.this.logProblem("Duplicate failure for test [" + fullTestName + "]: msg = " + localizedMessage + ", stacktrace = " + stackTrace);
                        if (inDebugMode) {
                            return;
                        }
                    }
                    testProxy.setTestComparisonFailed(localizedMessage, stackTrace, comparisionFailureActualText, comparisionFailureExpectedText);
                } else if (comparisionFailureActualText == null && comparisionFailureExpectedText == null) {
                    testProxy.setTestFailed(localizedMessage, stackTrace, isTestError);
                } else {
                    GoogleCloudTestingToSMTRunnerEventsConvertor.this.logProblem("Comparison failure actual and expected texts should be both null or not null.\nExpected:\n" + comparisionFailureExpectedText + "\nActual:\n" + comparisionFailureActualText);
                }
                GoogleCloudTestingToSMTRunnerEventsConvertor.this.myFailedTestsSet.add(testProxy);
                GoogleCloudTestingToSMTRunnerEventsConvertor.this.fireOnTestFailed(testProxy);
            }
        });
    }

    @Override
    public void onTestIgnored(final @NotNull GoogleCloudTestIgnoredEvent testIgnoredEvent) {
        if (testIgnoredEvent == null) {
            GoogleCloudTestingToSMTRunnerEventsConvertor.$$$reportNull$$$0(19);
        }
        this.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                String configuration = testIgnoredEvent.getConfiguration();
                String className = testIgnoredEvent.getClassName();
                String testName = (String)ObjectUtils.assertNotNull((Object)testIgnoredEvent.getName());
                String ignoreComment = testIgnoredEvent.getIgnoreComment();
                if (StringUtil.isEmpty((String)ignoreComment)) {
                    ignoreComment = SMTestsRunnerBundle.message((String)"sm.test.runner.states.test.is.ignored", (Object[])new Object[0]);
                }
                String stackTrace = testIgnoredEvent.getStacktrace();
                String fullTestName = GoogleCloudTestingToSMTRunnerEventsConvertor.this.getFullTestName(configuration, className, testName);
                GoogleCloudTestProxy testProxy = GoogleCloudTestingToSMTRunnerEventsConvertor.this.getProxyByFullTestName(fullTestName);
                if (testProxy == null) {
                    boolean debugMode = GoogleCloudTestResultsConnectionUtil.isInDebugMode();
                    GoogleCloudTestingToSMTRunnerEventsConvertor.this.logProblem("Test wasn't started! TestIgnored event: name = {" + testName + "}, message = {" + ignoreComment + "}. " + GoogleCloudTestingToSMTRunnerEventsConvertor.this.cannotFindFullTestNameMsg(fullTestName));
                    if (debugMode) {
                        return;
                    }
                    GoogleCloudTestingToSMTRunnerEventsConvertor.this.onTestStarted(new GoogleCloudTestStartedEvent(testName, null, configuration, className));
                    testProxy = GoogleCloudTestingToSMTRunnerEventsConvertor.this.getProxyByFullTestName(fullTestName);
                }
                if (testProxy == null) {
                    return;
                }
                GoogleCloudTestingToSMTRunnerEventsConvertor.this.lastUpdatedTest = testProxy;
                testProxy.setTestIgnored(ignoreComment, stackTrace);
                GoogleCloudTestingToSMTRunnerEventsConvertor.this.fireOnTestIgnored(testProxy);
            }
        });
    }

    @Override
    public void onTestOutput(final @NotNull GoogleCloudTestOutputEvent testOutputEvent) {
        if (testOutputEvent == null) {
            GoogleCloudTestingToSMTRunnerEventsConvertor.$$$reportNull$$$0(20);
        }
        this.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                String configuration = testOutputEvent.getConfiguration();
                String className = testOutputEvent.getClassName();
                String testName = testOutputEvent.getName();
                String text = testOutputEvent.getText();
                boolean stdOut = testOutputEvent.getOutputType() == ProcessOutputTypes.STDOUT;
                String fullTestName = GoogleCloudTestingToSMTRunnerEventsConvertor.this.getFullTestName(configuration, className, testName);
                GoogleCloudTestProxy testProxy = GoogleCloudTestingToSMTRunnerEventsConvertor.this.getProxyByFullTestName(fullTestName);
                if (testProxy == null) {
                    GoogleCloudTestingToSMTRunnerEventsConvertor.this.logProblem("Test wasn't started! TestOutput event: name = {" + testName + "}, isStdOut = " + stdOut + ", text = {" + text + "}. " + GoogleCloudTestingToSMTRunnerEventsConvertor.this.cannotFindFullTestNameMsg(fullTestName));
                    return;
                }
                GoogleCloudTestingToSMTRunnerEventsConvertor.this.lastUpdatedTest = testProxy;
                if (stdOut) {
                    testProxy.addStdOutput(text, ProcessOutputTypes.STDOUT, true);
                } else {
                    testProxy.addStdErr(text, true);
                }
            }
        });
    }

    @Override
    public void onTestsCountInSuite(final int count) {
        this.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                GoogleCloudTestingToSMTRunnerEventsConvertor.this.fireOnTestsCountInSuite(count);
            }
        });
    }

    protected int getRunningTestsQuantity() {
        return this.myRunningTestsFullNameToProxy.size();
    }

    protected Set<AbstractTestProxy> getFailedTestsSet() {
        return Collections.unmodifiableSet(this.myFailedTestsSet);
    }

    @Nullable
    protected GoogleCloudTestProxy getProxyByFullTestName(String fullTestName) {
        return this.myRunningTestsFullNameToProxy.get(fullTestName);
    }

    private String cannotFindFullTestNameMsg(String fullTestName) {
        return "Cant find running test for [" + fullTestName + "]. Current running tests: {" + this.dumpRunningTestsNames() + "}";
    }

    private StringBuilder dumpRunningTestsNames() {
        Set<String> names = this.myRunningTestsFullNameToProxy.keySet();
        StringBuilder namesDump = new StringBuilder();
        for (String name : names) {
            namesDump.append('[').append(name).append(']').append(',');
        }
        return namesDump;
    }

    private void fireOnTestingStarted(boolean printTestingStartedTime) {
        for (GoogleCloudTestEventsListener listener : this.myEventsListeners) {
            listener.onTestingStarted(this.myTestsRootNode, printTestingStartedTime);
        }
    }

    private void fireOnTestingFinished() {
        for (GoogleCloudTestEventsListener listener : this.myEventsListeners) {
            listener.onTestingFinished(this.myTestsRootNode);
        }
    }

    private void fireOnTestsCountInSuite(int count) {
        for (GoogleCloudTestEventsListener listener : this.myEventsListeners) {
            listener.onTestsCountInSuite(count);
        }
    }

    private void fireOnTestStarted(GoogleCloudTestProxy test) {
        for (GoogleCloudTestEventsListener listener : this.myEventsListeners) {
            listener.onTestStarted(test);
        }
    }

    private void fireOnTestFinished(GoogleCloudTestProxy test) {
        for (GoogleCloudTestEventsListener listener : this.myEventsListeners) {
            listener.onTestFinished(test);
        }
    }

    private void fireOnTestFailed(GoogleCloudTestProxy test) {
        for (GoogleCloudTestEventsListener listener : this.myEventsListeners) {
            listener.onTestFailed(test);
        }
    }

    private void fireOnTestIgnored(GoogleCloudTestProxy test) {
        for (GoogleCloudTestEventsListener listener : this.myEventsListeners) {
            listener.onTestIgnored(test);
        }
    }

    private void fireOnSuiteStarted(GoogleCloudTestProxy suite) {
        for (GoogleCloudTestEventsListener listener : this.myEventsListeners) {
            listener.onSuiteStarted(suite);
        }
    }

    private void fireOnSuiteFinished(GoogleCloudTestProxy suite) {
        for (GoogleCloudTestEventsListener listener : this.myEventsListeners) {
            listener.onSuiteFinished(suite);
        }
    }

    private void fireOnCustomProgressTestsCategory(@Nullable String categoryName, int testCount) {
        for (GoogleCloudTestEventsListener listener : this.myEventsListeners) {
            listener.onCustomProgressTestsCategory(categoryName, testCount);
        }
    }

    private void fireOnCustomProgressTestStarted() {
        for (GoogleCloudTestEventsListener listener : this.myEventsListeners) {
            listener.onCustomProgressTestStarted();
        }
    }

    private void fireOnCustomProgressTestFailed() {
        for (GoogleCloudTestEventsListener listener : this.myEventsListeners) {
            listener.onCustomProgressTestFailed();
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                Application application;
                GoogleCloudTestingToSMTRunnerEventsConvertor.this.myEventsListeners.clear();
                if (!(GoogleCloudTestingToSMTRunnerEventsConvertor.this.myRunningTestsFullNameToProxy.isEmpty() || (application = ApplicationManager.getApplication()).isHeadlessEnvironment() || application.isUnitTestMode())) {
                    GoogleCloudTestingToSMTRunnerEventsConvertor.this.logProblem("Not all events were processed! " + GoogleCloudTestingToSMTRunnerEventsConvertor.this.dumpRunningTestsNames());
                }
                GoogleCloudTestingToSMTRunnerEventsConvertor.this.myRunningTestsFullNameToProxy.clear();
            }
        });
    }

    private GoogleCloudTestProxy findCurrentTestOrSuite() {
        if (this.lastUpdatedTest != null) {
            return this.lastUpdatedTest;
        }
        return this.myTestsRootNode;
    }

    public static String getTFrameworkPrefix(String testFrameworkName) {
        return "[" + testFrameworkName + "]: ";
    }

    private void logProblem(String msg) {
        GoogleCloudTestingToSMTRunnerEventsConvertor.logProblem(LOG, msg, this.myTestFrameworkName);
    }

    public static void logProblem(Logger log, String msg, String testFrameworkName) {
        GoogleCloudTestingToSMTRunnerEventsConvertor.logProblem(log, msg, GoogleCloudTestResultsConnectionUtil.isInDebugMode(), testFrameworkName);
    }

    public static void logProblem(Logger log, String msg, boolean throwError, String testFrameworkName) {
        String text = GoogleCloudTestingToSMTRunnerEventsConvertor.getTFrameworkPrefix(testFrameworkName) + msg;
        if (throwError) {
            log.error(text);
        } else {
            log.warn(text);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testsRootNode";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testFrameworkName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "customLocator";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "printerProvider";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testStartedEvent";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suiteStartedEvent";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "setTestRunIdEvent";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "setActiveCloudMatrixEvent";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationStoppedEvent";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationStartedEvent";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationProgressEvent";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationScheduledEvent";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testFinishedEvent";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suiteFinishedEvent";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationFinishedEvent";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localizedMessage";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testFailedEvent";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testIgnoredEvent";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testOutputEvent";
                break;
            }
        }
        objectArray2[1] = "com/google/gct/testing/results/GoogleCloudTestingToSMTRunnerEventsConvertor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "setLocator";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "addEventsListener";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "setPrinterProvider";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "onTestStarted";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "onSuiteStarted";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "onSetTestRunId";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "onSetActiveCloudMatrix";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "onConfigurationStopped";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "onConfigurationStarted";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "onConfigurationProgress";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "onConfigurationScheduled";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "onTestFinished";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "onSuiteFinished";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "onConfigurationFinished";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "onUncapturedOutput";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "onError";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "onTestFailure";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "onTestIgnored";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "onTestOutput";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

