/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.testing.results;

import com.google.gct.testing.CloudTestingUtils;
import com.google.gct.testing.results.GoogleCloudTestEventsProcessor;
import com.google.gct.testing.results.GoogleCloudTestingProcessOutputConsumer;
import com.google.gct.testing.results.events.GoogleCloudTestFailedEvent;
import com.google.gct.testing.results.events.GoogleCloudTestFinishedEvent;
import com.google.gct.testing.results.events.GoogleCloudTestIgnoredEvent;
import com.google.gct.testing.results.events.GoogleCloudTestOutputEvent;
import com.google.gct.testing.results.events.GoogleCloudTestStartedEvent;
import com.google.gct.testing.results.events.SetActiveCloudMatrixEvent;
import com.google.gct.testing.results.events.SetTestRunIdEvent;
import com.google.gct.testing.results.events.TestConfigurationFinishedEvent;
import com.google.gct.testing.results.events.TestConfigurationProgressEvent;
import com.google.gct.testing.results.events.TestConfigurationScheduledEvent;
import com.google.gct.testing.results.events.TestConfigurationStartedEvent;
import com.google.gct.testing.results.events.TestConfigurationStoppedEvent;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.sm.runner.GeneralToSMTRunnerEventsConvertor;
import com.intellij.execution.testframework.sm.runner.OutputLineSplitter;
import com.intellij.execution.testframework.sm.runner.events.TestSuiteFinishedEvent;
import com.intellij.execution.testframework.sm.runner.events.TestSuiteStartedEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import java.text.ParseException;
import java.util.Map;
import jetbrains.buildServer.messages.serviceMessages.BaseTestMessage;
import jetbrains.buildServer.messages.serviceMessages.BuildNumber;
import jetbrains.buildServer.messages.serviceMessages.BuildStatisticValue;
import jetbrains.buildServer.messages.serviceMessages.BuildStatus;
import jetbrains.buildServer.messages.serviceMessages.DefaultServiceMessageVisitor;
import jetbrains.buildServer.messages.serviceMessages.Message;
import jetbrains.buildServer.messages.serviceMessages.ProgressFinish;
import jetbrains.buildServer.messages.serviceMessages.ProgressMessage;
import jetbrains.buildServer.messages.serviceMessages.ProgressStart;
import jetbrains.buildServer.messages.serviceMessages.PublishArtifacts;
import jetbrains.buildServer.messages.serviceMessages.ServiceMessage;
import jetbrains.buildServer.messages.serviceMessages.ServiceMessageVisitor;
import jetbrains.buildServer.messages.serviceMessages.TestFailed;
import jetbrains.buildServer.messages.serviceMessages.TestFinished;
import jetbrains.buildServer.messages.serviceMessages.TestIgnored;
import jetbrains.buildServer.messages.serviceMessages.TestStarted;
import jetbrains.buildServer.messages.serviceMessages.TestStdErr;
import jetbrains.buildServer.messages.serviceMessages.TestStdOut;
import jetbrains.buildServer.messages.serviceMessages.TestSuiteFinished;
import jetbrains.buildServer.messages.serviceMessages.TestSuiteStarted;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OutputToGoogleCloudTestEventsConverter
implements GoogleCloudTestingProcessOutputConsumer {
    private static final Logger LOG = Logger.getInstance((String)OutputToGoogleCloudTestEventsConverter.class.getName());
    private GoogleCloudTestEventsProcessor myProcessor;
    private final MyServiceMessageVisitor myServiceMessageVisitor;
    private final String myTestFrameworkName;
    private final OutputLineSplitter mySplitter;
    private boolean myPendingLineBreakFlag;

    public OutputToGoogleCloudTestEventsConverter(@NotNull String testFrameworkName, @NotNull TestConsoleProperties consoleProperties) {
        if (testFrameworkName == null) {
            OutputToGoogleCloudTestEventsConverter.$$$reportNull$$$0(0);
        }
        if (consoleProperties == null) {
            OutputToGoogleCloudTestEventsConverter.$$$reportNull$$$0(1);
        }
        this.myTestFrameworkName = testFrameworkName;
        this.myServiceMessageVisitor = new MyServiceMessageVisitor();
        this.mySplitter = new OutputLineSplitter(consoleProperties.isEditable()){

            protected void onLineAvailable(@NotNull String text, @NotNull Key outputType, boolean tcLikeFakeOutput) {
                if (text == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (outputType == null) {
                    1.$$$reportNull$$$0(1);
                }
                OutputToGoogleCloudTestEventsConverter.this.processConsistentText(text, outputType, tcLikeFakeOutput);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "text";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "outputType";
                        break;
                    }
                }
                objectArray[1] = "com/google/gct/testing/results/OutputToGoogleCloudTestEventsConverter$1";
                objectArray[2] = "onLineAvailable";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @Override
    public void setProcessor(@Nullable GoogleCloudTestEventsProcessor processor) {
        this.myProcessor = processor;
    }

    public void dispose() {
        this.setProcessor(null);
    }

    @Override
    public void process(String text, Key outputType) {
        this.mySplitter.process(text, outputType);
    }

    @Override
    public void flushBufferBeforeTerminating() {
        this.mySplitter.flush();
        if (this.myPendingLineBreakFlag) {
            this.fireOnUncapturedLineBreak();
        }
    }

    private void fireOnUncapturedLineBreak() {
        this.fireOnUncapturedOutput("\n", ProcessOutputTypes.STDOUT);
    }

    private void processConsistentText(String text, Key outputType, boolean tcLikeFakeOutput) {
        try {
            if (!this.processServiceMessages(text, outputType, (ServiceMessageVisitor)this.myServiceMessageVisitor)) {
                if (this.myPendingLineBreakFlag) {
                    this.fireOnUncapturedLineBreak();
                    this.myPendingLineBreakFlag = false;
                }
                String outputToProcess = text;
                if (tcLikeFakeOutput && text.endsWith("\n")) {
                    this.myPendingLineBreakFlag = true;
                    outputToProcess = outputToProcess.substring(0, outputToProcess.length() - 1);
                }
                this.fireOnUncapturedOutput(outputToProcess, outputType);
            } else {
                this.myPendingLineBreakFlag = false;
            }
        }
        catch (ParseException e) {
            LOG.error(GeneralToSMTRunnerEventsConvertor.getTFrameworkPrefix((String)this.myTestFrameworkName) + "Error parsing text: [" + text + "]", (Throwable)e);
        }
    }

    protected boolean processServiceMessages(String text, Key outputType, ServiceMessageVisitor visitor) throws ParseException {
        ServiceMessage message = ServiceMessage.parse((String)text.trim());
        if (message != null) {
            message.visit(visitor);
        }
        return message != null;
    }

    private void fireOnTestStarted(@NotNull GoogleCloudTestStartedEvent testStartedEvent) {
        GoogleCloudTestEventsProcessor processor;
        if (testStartedEvent == null) {
            OutputToGoogleCloudTestEventsConverter.$$$reportNull$$$0(2);
        }
        if ((processor = this.myProcessor) != null) {
            processor.onTestStarted(testStartedEvent);
        }
    }

    private void fireOnTestFailure(@NotNull GoogleCloudTestFailedEvent testFailedEvent) {
        if (testFailedEvent == null) {
            OutputToGoogleCloudTestEventsConverter.$$$reportNull$$$0(3);
        }
        this.assertNotNull(testFailedEvent.getLocalizedFailureMessage());
        GoogleCloudTestEventsProcessor processor = this.myProcessor;
        if (processor != null) {
            processor.onTestFailure(testFailedEvent);
        }
    }

    private void fireOnTestIgnored(@NotNull GoogleCloudTestIgnoredEvent testIgnoredEvent) {
        GoogleCloudTestEventsProcessor processor;
        if (testIgnoredEvent == null) {
            OutputToGoogleCloudTestEventsConverter.$$$reportNull$$$0(4);
        }
        if ((processor = this.myProcessor) != null) {
            processor.onTestIgnored(testIgnoredEvent);
        }
    }

    private void fireOnTestFinished(@NotNull GoogleCloudTestFinishedEvent testFinishedEvent) {
        GoogleCloudTestEventsProcessor processor;
        if (testFinishedEvent == null) {
            OutputToGoogleCloudTestEventsConverter.$$$reportNull$$$0(5);
        }
        if ((processor = this.myProcessor) != null) {
            processor.onTestFinished(testFinishedEvent);
        }
    }

    private void fireOnCustomProgressTestsCategory(String categoryName, int testsCount) {
        this.assertNotNull(categoryName);
        GoogleCloudTestEventsProcessor processor = this.myProcessor;
        if (processor != null) {
            boolean disableCustomMode = StringUtil.isEmpty((String)categoryName);
            processor.onCustomProgressTestsCategory(disableCustomMode ? null : categoryName, disableCustomMode ? 0 : testsCount);
        }
    }

    private void fireOnCustomProgressTestStarted() {
        GoogleCloudTestEventsProcessor processor = this.myProcessor;
        if (processor != null) {
            processor.onCustomProgressTestStarted();
        }
    }

    private void fireOnCustomProgressTestFailed() {
        GoogleCloudTestEventsProcessor processor = this.myProcessor;
        if (processor != null) {
            processor.onCustomProgressTestFailed();
        }
    }

    private void fireOnTestFrameworkAttached() {
        GoogleCloudTestEventsProcessor processor = this.myProcessor;
        if (processor != null) {
            processor.onTestsReporterAttached();
        }
    }

    private void fireOnTestOutput(@NotNull GoogleCloudTestOutputEvent testOutputEvent) {
        GoogleCloudTestEventsProcessor processor;
        if (testOutputEvent == null) {
            OutputToGoogleCloudTestEventsConverter.$$$reportNull$$$0(6);
        }
        if ((processor = this.myProcessor) != null) {
            processor.onTestOutput(testOutputEvent);
        }
    }

    private void fireOnUncapturedOutput(String text, Key outputType) {
        this.assertNotNull(text);
        if (StringUtil.isEmpty((String)text)) {
            return;
        }
        GoogleCloudTestEventsProcessor processor = this.myProcessor;
        if (processor != null) {
            processor.onUncapturedOutput(text, outputType);
        }
    }

    private void fireOnTestsCountInSuite(int count) {
        GoogleCloudTestEventsProcessor processor = this.myProcessor;
        if (processor != null) {
            processor.onTestsCountInSuite(count);
        }
    }

    private void fireOnSuiteStarted(@NotNull TestSuiteStartedEvent suiteStartedEvent) {
        GoogleCloudTestEventsProcessor processor;
        if (suiteStartedEvent == null) {
            OutputToGoogleCloudTestEventsConverter.$$$reportNull$$$0(7);
        }
        if ((processor = this.myProcessor) != null) {
            processor.onSuiteStarted(suiteStartedEvent);
        }
    }

    private void fireOnSetTestRunId(@NotNull SetTestRunIdEvent setTestRunIdEvent) {
        GoogleCloudTestEventsProcessor processor;
        if (setTestRunIdEvent == null) {
            OutputToGoogleCloudTestEventsConverter.$$$reportNull$$$0(8);
        }
        if ((processor = this.myProcessor) != null) {
            processor.onSetTestRunId(setTestRunIdEvent);
        }
    }

    private void fireOnSetActiveCloudMatrix(@NotNull SetActiveCloudMatrixEvent setActiveCloudMatrixEvent) {
        GoogleCloudTestEventsProcessor processor;
        if (setActiveCloudMatrixEvent == null) {
            OutputToGoogleCloudTestEventsConverter.$$$reportNull$$$0(9);
        }
        if ((processor = this.myProcessor) != null) {
            processor.onSetActiveCloudMatrix(setActiveCloudMatrixEvent);
        }
    }

    private void fireOnConfigurationStopped(@NotNull TestConfigurationStoppedEvent configurationStoppedEvent) {
        GoogleCloudTestEventsProcessor processor;
        if (configurationStoppedEvent == null) {
            OutputToGoogleCloudTestEventsConverter.$$$reportNull$$$0(10);
        }
        if ((processor = this.myProcessor) != null) {
            processor.onConfigurationStopped(configurationStoppedEvent);
        }
    }

    private void fireOnConfigurationStarted(@NotNull TestConfigurationStartedEvent configurationStartedEvent) {
        GoogleCloudTestEventsProcessor processor;
        if (configurationStartedEvent == null) {
            OutputToGoogleCloudTestEventsConverter.$$$reportNull$$$0(11);
        }
        if ((processor = this.myProcessor) != null) {
            processor.onConfigurationStarted(configurationStartedEvent);
        }
    }

    private void fireOnConfigurationProgress(@NotNull TestConfigurationProgressEvent configurationProgressEvent) {
        GoogleCloudTestEventsProcessor processor;
        if (configurationProgressEvent == null) {
            OutputToGoogleCloudTestEventsConverter.$$$reportNull$$$0(12);
        }
        if ((processor = this.myProcessor) != null) {
            processor.onConfigurationProgress(configurationProgressEvent);
        }
    }

    private void fireOnConfigurationScheduled(@NotNull TestConfigurationScheduledEvent configurationScheduledEvent) {
        GoogleCloudTestEventsProcessor processor;
        if (configurationScheduledEvent == null) {
            OutputToGoogleCloudTestEventsConverter.$$$reportNull$$$0(13);
        }
        if ((processor = this.myProcessor) != null) {
            processor.onConfigurationScheduled(configurationScheduledEvent);
        }
    }

    private void fireOnConfigurationFinished(@NotNull TestConfigurationFinishedEvent configurationFinishedEvent) {
        GoogleCloudTestEventsProcessor processor;
        if (configurationFinishedEvent == null) {
            OutputToGoogleCloudTestEventsConverter.$$$reportNull$$$0(14);
        }
        if ((processor = this.myProcessor) != null) {
            processor.onConfigurationFinished(configurationFinishedEvent);
        }
    }

    private void fireOnSuiteFinished(@NotNull TestSuiteFinishedEvent suiteFinishedEvent) {
        GoogleCloudTestEventsProcessor processor;
        if (suiteFinishedEvent == null) {
            OutputToGoogleCloudTestEventsConverter.$$$reportNull$$$0(15);
        }
        if ((processor = this.myProcessor) != null) {
            processor.onSuiteFinished(suiteFinishedEvent);
        }
    }

    protected void fireOnErrorMsg(String localizedMessage, @Nullable String stackTrace, boolean isCritical) {
        this.assertNotNull(localizedMessage);
        GoogleCloudTestEventsProcessor processor = this.myProcessor;
        if (processor != null) {
            processor.onError(localizedMessage, stackTrace, isCritical);
        }
    }

    private void assertNotNull(String s) {
        if (s == null) {
            LOG.error(GeneralToSMTRunnerEventsConvertor.getTFrameworkPrefix((String)this.myTestFrameworkName) + " @NotNull value is expected.");
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testFrameworkName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleProperties";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testStartedEvent";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testFailedEvent";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testIgnoredEvent";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testFinishedEvent";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testOutputEvent";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suiteStartedEvent";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "setTestRunIdEvent";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "setActiveCloudMatrixEvent";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationStoppedEvent";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationStartedEvent";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationProgressEvent";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationScheduledEvent";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationFinishedEvent";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suiteFinishedEvent";
                break;
            }
        }
        objectArray2[1] = "com/google/gct/testing/results/OutputToGoogleCloudTestEventsConverter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "fireOnTestStarted";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "fireOnTestFailure";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "fireOnTestIgnored";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "fireOnTestFinished";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "fireOnTestOutput";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "fireOnSuiteStarted";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "fireOnSetTestRunId";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "fireOnSetActiveCloudMatrix";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "fireOnConfigurationStopped";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "fireOnConfigurationStarted";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "fireOnConfigurationProgress";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "fireOnConfigurationScheduled";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "fireOnConfigurationFinished";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "fireOnSuiteFinished";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class MyServiceMessageVisitor
    extends DefaultServiceMessageVisitor {
        @NonNls
        public static final String KEY_TESTS_COUNT = "testCount";
        @NonNls
        private static final String ATTR_KEY_TEST_ERROR = "error";
        @NonNls
        private static final String ATTR_KEY_TEST_COUNT = "count";
        @NonNls
        private static final String ATTR_KEY_TEST_DURATION = "duration";
        @NonNls
        private static final String ATTR_KEY_LOCATION_URL = "locationHint";
        @NonNls
        private static final String ATTR_KEY_LOCATION_URL_OLD = "location";
        @NonNls
        private static final String ATTR_KEY_STACKTRACE_DETAILS = "details";
        @NonNls
        private static final String ATTR_KEY_DIAGNOSTIC = "diagnosticInfo";
        @NonNls
        private static final String MESSAGE = "message";
        @NonNls
        private static final String TEST_REPORTER_ATTACHED = "enteredTheMatrix";
        @NonNls
        private static final String ATTR_KEY_STATUS = "status";
        @NonNls
        private static final String ATTR_VALUE_STATUS_ERROR = "ERROR";
        @NonNls
        private static final String ATTR_VALUE_STATUS_WARNING = "WARNING";
        @NonNls
        private static final String ATTR_KEY_TEXT = "text";
        @NonNls
        private static final String ATTR_KEY_ERROR_DETAILS = "errorDetails";
        @NonNls
        public static final String CUSTOM_STATUS = "customProgressStatus";
        @NonNls
        private static final String ATTR_KEY_TEST_TYPE = "type";
        @NonNls
        private static final String ATTR_KEY_TESTS_CATEGORY = "testsCategory";
        @NonNls
        private static final String ATTR_VAL_TEST_STARTED = "testStarted";
        @NonNls
        private static final String ATTR_VAL_TEST_FAILED = "testFailed";

        private MyServiceMessageVisitor() {
        }

        public void visitTestSuiteStarted(@NotNull TestSuiteStarted suiteStarted) {
            if (suiteStarted == null) {
                MyServiceMessageVisitor.$$$reportNull$$$0(0);
            }
            String locationUrl = this.fetchTestLocation(suiteStarted);
            TestSuiteStartedEvent suiteStartedEvent = new TestSuiteStartedEvent(suiteStarted, locationUrl);
            OutputToGoogleCloudTestEventsConverter.this.fireOnSuiteStarted(suiteStartedEvent);
        }

        @Nullable
        private String fetchTestLocation(TestSuiteStarted suiteStarted) {
            Map attrs = suiteStarted.getAttributes();
            String location = (String)attrs.get(ATTR_KEY_LOCATION_URL);
            if (location == null) {
                String oldLocation = (String)attrs.get(ATTR_KEY_LOCATION_URL_OLD);
                if (oldLocation != null) {
                    LOG.error(GeneralToSMTRunnerEventsConvertor.getTFrameworkPrefix((String)OutputToGoogleCloudTestEventsConverter.this.myTestFrameworkName) + "Test Runner API was changed for TeamCity 5.0 compatibility. Please use 'locationHint' attribute instead of 'location'.");
                    return oldLocation;
                }
                return null;
            }
            return location;
        }

        public void visitTestSuiteFinished(@NotNull TestSuiteFinished suiteFinished) {
            if (suiteFinished == null) {
                MyServiceMessageVisitor.$$$reportNull$$$0(1);
            }
            TestSuiteFinishedEvent finishedEvent = new TestSuiteFinishedEvent(suiteFinished);
            OutputToGoogleCloudTestEventsConverter.this.fireOnSuiteFinished(finishedEvent);
        }

        public void visitTestStarted(@NotNull TestStarted testStarted) {
            if (testStarted == null) {
                MyServiceMessageVisitor.$$$reportNull$$$0(2);
            }
            String locationUrl = (String)testStarted.getAttributes().get(ATTR_KEY_LOCATION_URL);
            GoogleCloudTestStartedEvent testStartedEvent = new GoogleCloudTestStartedEvent(testStarted, locationUrl);
            OutputToGoogleCloudTestEventsConverter.this.fireOnTestStarted(testStartedEvent);
        }

        public void visitTestFinished(@NotNull TestFinished testFinished) {
            if (testFinished == null) {
                MyServiceMessageVisitor.$$$reportNull$$$0(3);
            }
            String durationStr = (String)testFinished.getAttributes().get(ATTR_KEY_TEST_DURATION);
            long duration = 0L;
            if (!StringUtil.isEmptyOrSpaces((String)durationStr)) {
                duration = this.convertToLong(durationStr, (ServiceMessage)testFinished);
            }
            GoogleCloudTestFinishedEvent testFinishedEvent = new GoogleCloudTestFinishedEvent(testFinished, duration);
            OutputToGoogleCloudTestEventsConverter.this.fireOnTestFinished(testFinishedEvent);
        }

        public void visitTestIgnored(@NotNull TestIgnored testIgnored) {
            if (testIgnored == null) {
                MyServiceMessageVisitor.$$$reportNull$$$0(4);
            }
            String stacktrace = (String)testIgnored.getAttributes().get(ATTR_KEY_STACKTRACE_DETAILS);
            OutputToGoogleCloudTestEventsConverter.this.fireOnTestIgnored(new GoogleCloudTestIgnoredEvent(testIgnored, stacktrace));
        }

        public void visitTestStdOut(@NotNull TestStdOut testStdOut) {
            if (testStdOut == null) {
                MyServiceMessageVisitor.$$$reportNull$$$0(5);
            }
            OutputToGoogleCloudTestEventsConverter.this.fireOnTestOutput(new GoogleCloudTestOutputEvent((BaseTestMessage)testStdOut, testStdOut.getStdOut(), ProcessOutputTypes.STDOUT, (String)testStdOut.getAttributes().get("configuration"), (String)testStdOut.getAttributes().get("className")));
        }

        public void visitTestStdErr(@NotNull TestStdErr testStdErr) {
            if (testStdErr == null) {
                MyServiceMessageVisitor.$$$reportNull$$$0(6);
            }
            OutputToGoogleCloudTestEventsConverter.this.fireOnTestOutput(new GoogleCloudTestOutputEvent((BaseTestMessage)testStdErr, testStdErr.getStdErr(), ProcessOutputTypes.STDERR, (String)testStdErr.getAttributes().get("configuration"), (String)testStdErr.getAttributes().get("className")));
        }

        public void visitTestFailed(@NotNull TestFailed testFailed) {
            if (testFailed == null) {
                MyServiceMessageVisitor.$$$reportNull$$$0(7);
            }
            boolean testError = testFailed.getAttributes().get(ATTR_KEY_TEST_ERROR) != null;
            GoogleCloudTestFailedEvent testFailedEvent = new GoogleCloudTestFailedEvent(testFailed, testError);
            OutputToGoogleCloudTestEventsConverter.this.fireOnTestFailure(testFailedEvent);
        }

        public void visitPublishArtifacts(@NotNull PublishArtifacts publishArtifacts) {
            if (publishArtifacts == null) {
                MyServiceMessageVisitor.$$$reportNull$$$0(8);
            }
        }

        public void visitProgressMessage(@NotNull ProgressMessage progressMessage) {
            if (progressMessage == null) {
                MyServiceMessageVisitor.$$$reportNull$$$0(9);
            }
        }

        public void visitProgressStart(@NotNull ProgressStart progressStart) {
            if (progressStart == null) {
                MyServiceMessageVisitor.$$$reportNull$$$0(10);
            }
        }

        public void visitProgressFinish(@NotNull ProgressFinish progressFinish) {
            if (progressFinish == null) {
                MyServiceMessageVisitor.$$$reportNull$$$0(11);
            }
        }

        public void visitBuildStatus(@NotNull BuildStatus buildStatus) {
            if (buildStatus == null) {
                MyServiceMessageVisitor.$$$reportNull$$$0(12);
            }
        }

        public void visitBuildNumber(@NotNull BuildNumber buildNumber) {
            if (buildNumber == null) {
                MyServiceMessageVisitor.$$$reportNull$$$0(13);
            }
        }

        public void visitBuildStatisticValue(@NotNull BuildStatisticValue buildStatsValue) {
            if (buildStatsValue == null) {
                MyServiceMessageVisitor.$$$reportNull$$$0(14);
            }
        }

        public void visitMessageWithStatus(@NotNull Message msg) {
            Map msgAttrs;
            String text;
            if (msg == null) {
                MyServiceMessageVisitor.$$$reportNull$$$0(15);
            }
            if (!StringUtil.isEmpty((String)(text = (String)(msgAttrs = msg.getAttributes()).get(ATTR_KEY_TEXT)))) {
                String status = (String)msgAttrs.get(ATTR_KEY_STATUS);
                if (status.equals(ATTR_VALUE_STATUS_ERROR)) {
                    String stackTrace = (String)msgAttrs.get(ATTR_KEY_ERROR_DETAILS);
                    OutputToGoogleCloudTestEventsConverter.this.fireOnErrorMsg(text, stackTrace, true);
                } else if (status.equals(ATTR_VALUE_STATUS_WARNING)) {
                    String stackTrace = (String)msgAttrs.get(ATTR_KEY_ERROR_DETAILS);
                    OutputToGoogleCloudTestEventsConverter.this.fireOnErrorMsg(text, stackTrace, false);
                } else {
                    OutputToGoogleCloudTestEventsConverter.this.fireOnUncapturedOutput(text, ProcessOutputTypes.STDOUT);
                }
            }
        }

        public void visitServiceMessage(@NotNull ServiceMessage msg) {
            String name;
            if (msg == null) {
                MyServiceMessageVisitor.$$$reportNull$$$0(16);
            }
            if (KEY_TESTS_COUNT.equals(name = msg.getMessageName())) {
                this.processTestCountInSuite(msg);
            } else if (CUSTOM_STATUS.equals(name)) {
                this.processCustomStatus(msg);
            } else if (MESSAGE.equals(name)) {
                Map msgAttrs = msg.getAttributes();
                String text = (String)msgAttrs.get(ATTR_KEY_TEXT);
                if (!StringUtil.isEmpty((String)text)) {
                    OutputToGoogleCloudTestEventsConverter.this.fireOnUncapturedOutput(text, ProcessOutputTypes.STDOUT);
                }
            } else if (TEST_REPORTER_ATTACHED.equals(name)) {
                OutputToGoogleCloudTestEventsConverter.this.fireOnTestFrameworkAttached();
            } else {
                this.handleCustomMessages(msg);
            }
        }

        private void handleCustomMessages(@NotNull ServiceMessage message) {
            String messageName;
            if (message == null) {
                MyServiceMessageVisitor.$$$reportNull$$$0(17);
            }
            if ((messageName = message.getMessageName()).equals("setTestRunId")) {
                SetTestRunIdEvent setTestRunIdEvent = new SetTestRunIdEvent((String)message.getAttributes().get("testRunId"));
                OutputToGoogleCloudTestEventsConverter.this.fireOnSetTestRunId(setTestRunIdEvent);
            } else if (messageName.equals("setActiveCloudMatrix")) {
                OutputToGoogleCloudTestEventsConverter.this.fireOnSetActiveCloudMatrix(new SetActiveCloudMatrixEvent());
            } else {
                String configurationName = (String)message.getAttributes().get("name");
                if (messageName.equals("testConfigurationStopped")) {
                    CloudTestingUtils.ConfigurationStopReason stopReason = CloudTestingUtils.ConfigurationStopReason.valueOf((String)message.getAttributes().get("stopReason"));
                    long testDuration = Long.valueOf((String)message.getAttributes().get("testDuration"));
                    TestConfigurationStoppedEvent configurationStoppedEvent = new TestConfigurationStoppedEvent(configurationName, stopReason, testDuration);
                    OutputToGoogleCloudTestEventsConverter.this.fireOnConfigurationStopped(configurationStoppedEvent);
                } else if (messageName.equals("testConfigurationProgress")) {
                    TestConfigurationProgressEvent configurationProgressEvent = new TestConfigurationProgressEvent(configurationName, (String)message.getAttributes().get(ATTR_KEY_TEXT));
                    OutputToGoogleCloudTestEventsConverter.this.fireOnConfigurationProgress(configurationProgressEvent);
                } else if (messageName.equals("testConfigurationScheduled")) {
                    TestConfigurationScheduledEvent configurationScheduledEvent = new TestConfigurationScheduledEvent(configurationName);
                    OutputToGoogleCloudTestEventsConverter.this.fireOnConfigurationScheduled(configurationScheduledEvent);
                } else if (messageName.equals("testConfigurationStarted")) {
                    TestConfigurationStartedEvent configurationStartedEvent = new TestConfigurationStartedEvent(configurationName);
                    OutputToGoogleCloudTestEventsConverter.this.fireOnConfigurationStarted(configurationStartedEvent);
                } else if (messageName.equals("testConfigurationFinished")) {
                    TestConfigurationFinishedEvent configurationFinishedEvent = new TestConfigurationFinishedEvent(configurationName);
                    OutputToGoogleCloudTestEventsConverter.this.fireOnConfigurationFinished(configurationFinishedEvent);
                } else {
                    GeneralToSMTRunnerEventsConvertor.logProblem((Logger)LOG, (String)("Unexpected service message:" + messageName), (String)OutputToGoogleCloudTestEventsConverter.this.myTestFrameworkName);
                }
            }
        }

        private void processTestCountInSuite(ServiceMessage msg) {
            String countStr = (String)msg.getAttributes().get(ATTR_KEY_TEST_COUNT);
            OutputToGoogleCloudTestEventsConverter.this.fireOnTestsCountInSuite(this.convertToInt(countStr, msg));
        }

        private int convertToInt(String countStr, ServiceMessage msg) {
            int count = 0;
            try {
                count = Integer.parseInt(countStr);
            }
            catch (NumberFormatException ex) {
                String diagnosticInfo = (String)msg.getAttributes().get(ATTR_KEY_DIAGNOSTIC);
                LOG.error(GeneralToSMTRunnerEventsConvertor.getTFrameworkPrefix((String)OutputToGoogleCloudTestEventsConverter.this.myTestFrameworkName) + "Parse integer error." + (diagnosticInfo == null ? "" : " " + diagnosticInfo), (Throwable)ex);
            }
            return count;
        }

        private long convertToLong(String countStr, @NotNull ServiceMessage msg) {
            if (msg == null) {
                MyServiceMessageVisitor.$$$reportNull$$$0(18);
            }
            long count = 0L;
            try {
                count = Long.parseLong(countStr);
            }
            catch (NumberFormatException ex) {
                String diagnosticInfo = (String)msg.getAttributes().get(ATTR_KEY_DIAGNOSTIC);
                LOG.error(GeneralToSMTRunnerEventsConvertor.getTFrameworkPrefix((String)OutputToGoogleCloudTestEventsConverter.this.myTestFrameworkName) + "Parse long error." + (diagnosticInfo == null ? "" : " " + diagnosticInfo), (Throwable)ex);
            }
            return count;
        }

        private void processCustomStatus(ServiceMessage msg) {
            Map attrs = msg.getAttributes();
            String msgType = (String)attrs.get(ATTR_KEY_TEST_TYPE);
            if (msgType != null) {
                if (msgType.equals(ATTR_VAL_TEST_STARTED)) {
                    OutputToGoogleCloudTestEventsConverter.this.fireOnCustomProgressTestStarted();
                } else if (msgType.equals(ATTR_VAL_TEST_FAILED)) {
                    OutputToGoogleCloudTestEventsConverter.this.fireOnCustomProgressTestFailed();
                }
                return;
            }
            String testsCategory = (String)attrs.get(ATTR_KEY_TESTS_CATEGORY);
            if (testsCategory != null) {
                String countStr = (String)msg.getAttributes().get(ATTR_KEY_TEST_COUNT);
                OutputToGoogleCloudTestEventsConverter.this.fireOnCustomProgressTestsCategory(testsCategory, this.convertToInt(countStr, msg));
                return;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "suiteStarted";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "suiteFinished";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = ATTR_VAL_TEST_STARTED;
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "testFinished";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "testIgnored";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "testStdOut";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "testStdErr";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = ATTR_VAL_TEST_FAILED;
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "publishArtifacts";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "progressMessage";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "progressStart";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "progressFinish";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "buildStatus";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "buildNumber";
                    break;
                }
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "buildStatsValue";
                    break;
                }
                case 15: 
                case 16: 
                case 18: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "msg";
                    break;
                }
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = MESSAGE;
                    break;
                }
            }
            objectArray2[1] = "com/google/gct/testing/results/OutputToGoogleCloudTestEventsConverter$MyServiceMessageVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitTestSuiteStarted";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitTestSuiteFinished";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitTestStarted";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitTestFinished";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitTestIgnored";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitTestStdOut";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitTestStdErr";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitTestFailed";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPublishArtifacts";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitProgressMessage";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitProgressStart";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitProgressFinish";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitBuildStatus";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitBuildNumber";
                    break;
                }
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitBuildStatisticValue";
                    break;
                }
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitMessageWithStatus";
                    break;
                }
                case 16: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitServiceMessage";
                    break;
                }
                case 17: {
                    objectArray = objectArray2;
                    objectArray2[2] = "handleCustomMessages";
                    break;
                }
                case 18: {
                    objectArray = objectArray2;
                    objectArray2[2] = "convertToLong";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

