/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.android;

import com.android.ide.common.blame.Message;
import com.android.ide.common.blame.SourceFilePosition;
import com.android.ide.common.blame.SourcePosition;
import com.android.ide.common.blame.parser.util.OutputLineReader;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.lang.reflect.Field;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.kapt3.diagnostic.KaptError;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=2, d1={"\u0000<\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\u001a\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\fH\u0002\u001a\u0018\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0001H\u0002\u001a\u0010\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0001H\u0002\u001a\u0010\u0010\u0013\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u001a$\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\f\u001a\u0014\u0010\u0018\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\u001a\f\u0010\u0019\u001a\u00020\u001a*\u00020\u0001H\u0002\u001a\f\u0010\u001b\u001a\u00020\b*\u00020\u0001H\u0002\u001a\u0014\u0010\u001c\u001a\u00020\u001a*\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u0001H\u0002\u001a\f\u0010\u001e\u001a\u00020\b*\u00020\u0001H\u0002\u001a\u0014\u0010\u001f\u001a\u00020\u0001*\u00020\u00012\u0006\u0010 \u001a\u00020\u001aH\u0002\u001a\u0014\u0010!\u001a\u00020\u0001*\u00020\u00012\u0006\u0010 \u001a\u00020\u001aH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0002\u001a\n \u0004*\u0004\u0018\u00010\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0006\u001a\n \u0004*\u0004\u0018\u00010\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"COLON", "", "JAVAC_POSITION_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "KAPT_ERROR_WHILE_ANNOTATION_PROCESSING_MARKER_TEXT", "KOTLIN_POSITION_PATTERN", "addMessage", "", "message", "Lcom/android/ide/common/blame/Message;", "messages", "", "createMessage", "messageKind", "Lcom/android/ide/common/blame/Message$Kind;", "text", "getMessageKind", "kind", "isKaptErrorWhileAnnotationProcessing", "parse", "lineText", "reader", "Lcom/android/ide/common/blame/parser/util/OutputLineReader;", "amendNextLinesIfNeeded", "colon", "", "isNextMessage", "skipDriveOnWin", "line", "startsWithSeverityPrefix", "substringAfterAndTrim", "index", "substringBeforeAndTrim", "idea-android-output-parser"})
public final class KotlinOutputParserHelperKt {
    private static final String COLON = ":";
    private static final Pattern KOTLIN_POSITION_PATTERN;
    private static final Pattern JAVAC_POSITION_PATTERN;
    private static final String KAPT_ERROR_WHILE_ANNOTATION_PROCESSING_MARKER_TEXT;

    public static final boolean parse(@NotNull String lineText, @NotNull OutputLineReader reader, @NotNull List<Message> messages) {
        Intrinsics.checkParameterIsNotNull((Object)lineText, (String)"lineText");
        Intrinsics.checkParameterIsNotNull((Object)reader, (String)"reader");
        Intrinsics.checkParameterIsNotNull(messages, (String)"messages");
        int colonIndex1 = KotlinOutputParserHelperKt.colon(lineText);
        if (colonIndex1 < 0) {
            return false;
        }
        String severity = KotlinOutputParserHelperKt.substringBeforeAndTrim(lineText, colonIndex1);
        if (!KotlinOutputParserHelperKt.startsWithSeverityPrefix(severity)) {
            return false;
        }
        String lineWoSeverity = KotlinOutputParserHelperKt.substringAfterAndTrim(lineText, colonIndex1);
        int colonIndex2 = KotlinOutputParserHelperKt.skipDriveOnWin(KotlinOutputParserHelperKt.colon(lineWoSeverity), lineWoSeverity);
        if (colonIndex2 >= 0) {
            String string;
            String path = KotlinOutputParserHelperKt.substringBeforeAndTrim(lineWoSeverity, colonIndex2);
            File file = new File(path);
            String string2 = string = FilesKt.getExtension((File)file);
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.toLowerCase();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
            String fileExtension = string3;
            if (!file.isFile() || Intrinsics.areEqual((Object)fileExtension, (Object)"kt") ^ true && Intrinsics.areEqual((Object)fileExtension, (Object)"java") ^ true) {
                return KotlinOutputParserHelperKt.addMessage(KotlinOutputParserHelperKt.createMessage(KotlinOutputParserHelperKt.getMessageKind(severity), KotlinOutputParserHelperKt.amendNextLinesIfNeeded(lineWoSeverity, reader)), messages);
            }
            String lineWoPath = KotlinOutputParserHelperKt.substringAfterAndTrim(lineWoSeverity, colonIndex2);
            int colonIndex3 = KotlinOutputParserHelperKt.colon(lineWoPath);
            if (colonIndex3 >= 0) {
                String position = KotlinOutputParserHelperKt.substringBeforeAndTrim(lineWoPath, colonIndex3);
                Matcher matcher = KOTLIN_POSITION_PATTERN.matcher(position);
                Matcher it = matcher;
                Matcher matcher2 = it.matches() ? matcher : null;
                if (matcher2 == null) {
                    matcher2 = JAVAC_POSITION_PATTERN.matcher(position);
                }
                Matcher matcher3 = matcher2;
                String message = KotlinOutputParserHelperKt.amendNextLinesIfNeeded(KotlinOutputParserHelperKt.substringAfterAndTrim(lineWoPath, colonIndex3), reader);
                if (matcher3.matches()) {
                    int column;
                    int n;
                    Integer line;
                    Integer n2;
                    String string4 = matcher3.group(1);
                    if (string4 != null) {
                        String $i$a$1$takeIf = string4;
                        n2 = Integer.parseInt($i$a$1$takeIf);
                    } else {
                        n2 = line = null;
                    }
                    if (matcher3.groupCount() >= 2) {
                        String string5 = matcher3.group(2);
                        if (string5 != null) {
                            String string6 = string5;
                            n = Integer.parseInt(string6);
                        } else {
                            n = 1;
                        }
                    } else {
                        n = column = 1;
                    }
                    if (line != null) {
                        SourceFilePosition position2 = new SourceFilePosition(file, new SourcePosition(line.intValue(), column, column));
                        String string7 = message;
                        Message.Kind kind = KotlinOutputParserHelperKt.getMessageKind(severity);
                        String string8 = string7;
                        if (string8 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                        }
                        String string9 = ((Object)StringsKt.trim((CharSequence)string8)).toString();
                        SourceFilePosition[] sourceFilePositionArray = new SourceFilePosition[]{};
                        SourceFilePosition sourceFilePosition = position2;
                        String string10 = string9;
                        Message.Kind kind2 = kind;
                        return KotlinOutputParserHelperKt.addMessage(new Message(kind2, string10, sourceFilePosition, sourceFilePositionArray), messages);
                    }
                }
                return KotlinOutputParserHelperKt.addMessage(KotlinOutputParserHelperKt.createMessage(KotlinOutputParserHelperKt.getMessageKind(severity), message), messages);
            }
            return KotlinOutputParserHelperKt.addMessage(KotlinOutputParserHelperKt.createMessage(KotlinOutputParserHelperKt.getMessageKind(severity), KotlinOutputParserHelperKt.amendNextLinesIfNeeded(lineWoSeverity, reader)), messages);
        }
        return false;
    }

    private static final String amendNextLinesIfNeeded(@NotNull String $receiver, OutputLineReader reader) {
        String nextLine = reader.readLine();
        StringBuilder builder = new StringBuilder($receiver);
        while (nextLine != null && !KotlinOutputParserHelperKt.isNextMessage(nextLine)) {
            builder.append("\n").append(nextLine);
            if (!reader.hasNextLine()) break;
            nextLine = reader.readLine();
        }
        if (nextLine != null) {
            Field field;
            try {
                field = reader.getClass().getDeclaredField("myPosition");
            }
            catch (Throwable e) {
                field = null;
            }
            Field positionField = field;
            if (positionField != null) {
                positionField.setAccessible(true);
                positionField.setInt(reader, positionField.getInt(reader) - 1);
            }
        }
        String string = builder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"builder.toString()");
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isNextMessage(@NotNull String $receiver) {
        int colonIndex1 = StringsKt.indexOf$default((CharSequence)$receiver, (String)COLON, (int)0, (boolean)false, (int)6, null);
        if (colonIndex1 == 0) return true;
        if (colonIndex1 >= 0) {
            String string = $receiver;
            int n = 0;
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(n, colonIndex1);
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            if (KotlinOutputParserHelperKt.startsWithSeverityPrefix(string3)) return true;
        }
        if (StringUtil.containsIgnoreCase((String)$receiver, (String)"FAILURE")) return true;
        if (!StringUtil.containsIgnoreCase((String)$receiver, (String)"FAILED")) return false;
        return true;
    }

    private static final boolean startsWithSeverityPrefix(@NotNull String $receiver) {
        return KotlinOutputParserHelperKt.getMessageKind($receiver) != Message.Kind.UNKNOWN;
    }

    private static final Message.Kind getMessageKind(String kind) {
        Message.Kind kind2;
        switch (kind) {
            case "e": {
                kind2 = Message.Kind.ERROR;
                break;
            }
            case "w": {
                kind2 = Message.Kind.WARNING;
                break;
            }
            case "i": {
                kind2 = Message.Kind.INFO;
                break;
            }
            case "v": {
                kind2 = Message.Kind.SIMPLE;
                break;
            }
            default: {
                kind2 = Message.Kind.UNKNOWN;
            }
        }
        return kind2;
    }

    private static final String substringAfterAndTrim(@NotNull String $receiver, int index) {
        String string = $receiver;
        int n = index + 1;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(n);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
        String string4 = string = string3;
        if (string4 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        return ((Object)StringsKt.trim((CharSequence)string4)).toString();
    }

    private static final String substringBeforeAndTrim(@NotNull String $receiver, int index) {
        String string = $receiver;
        int n = 0;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(n, index);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String string4 = string = string3;
        if (string4 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        return ((Object)StringsKt.trim((CharSequence)string4)).toString();
    }

    private static final int colon(@NotNull String $receiver) {
        return StringsKt.indexOf$default((CharSequence)$receiver, (String)COLON, (int)0, (boolean)false, (int)6, null);
    }

    private static final int skipDriveOnWin(int $receiver, String line) {
        return $receiver == 1 ? StringsKt.indexOf$default((CharSequence)line, (String)COLON, (int)($receiver + 1), (boolean)false, (int)4, null) : $receiver;
    }

    private static final boolean isKaptErrorWhileAnnotationProcessing(Message message) {
        if (message.getKind() != Message.Kind.ERROR) {
            return false;
        }
        if (Intrinsics.areEqual((Object)((SourceFilePosition)CollectionsKt.singleOrNull((List)message.getSourceFilePositions())), (Object)SourceFilePosition.UNKNOWN) ^ true) {
            return false;
        }
        String messageText = message.getText();
        String string = IllegalStateException.class.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"IllegalStateException::class.java.name");
        return StringsKt.startsWith$default((String)messageText, (String)string, (boolean)false, (int)2, null) && StringsKt.contains$default((CharSequence)messageText, (CharSequence)KAPT_ERROR_WHILE_ANNOTATION_PROCESSING_MARKER_TEXT, (boolean)false, (int)2, null);
    }

    private static final boolean addMessage(Message message, List<Message> messages) {
        if (KotlinOutputParserHelperKt.isKaptErrorWhileAnnotationProcessing(message)) {
            return true;
        }
        boolean duplicatesPrevious = false;
        int messageCount = messages.size();
        if (messageCount > 0) {
            Message lastMessage = messages.get(messageCount - 1);
            duplicatesPrevious = Intrinsics.areEqual((Object)lastMessage, (Object)message);
        }
        if (!duplicatesPrevious) {
            messages.add(message);
        }
        return true;
    }

    private static final Message createMessage(Message.Kind messageKind, String text) {
        String string = text;
        Message.Kind kind = messageKind;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        String string3 = ((Object)StringsKt.trim((CharSequence)string2)).toString();
        Optional optional = Optional.absent();
        Intrinsics.checkExpressionValueIsNotNull((Object)optional, (String)"Optional.absent<String>()");
        ImmutableList immutableList = ImmutableList.of();
        Intrinsics.checkExpressionValueIsNotNull((Object)immutableList, (String)"ImmutableList.of()");
        ImmutableList immutableList2 = immutableList;
        Optional optional2 = optional;
        String string4 = text;
        String string5 = string3;
        Message.Kind kind2 = kind;
        return new Message(kind2, string5, string4, optional2, immutableList2);
    }

    static {
        COLON = COLON;
        KOTLIN_POSITION_PATTERN = Pattern.compile("\\(([0-9]*), ([0-9]*)\\)");
        JAVAC_POSITION_PATTERN = Pattern.compile("([0-9]+)");
        KAPT_ERROR_WHILE_ANNOTATION_PROCESSING_MARKER_TEXT = KaptError.class.getCanonicalName() + ": " + KaptError.Kind.ERROR_RAISED.getMessage();
    }
}

