/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.testrecorder.codegen;

import com.google.common.base.Strings;
import com.google.gct.testrecorder.util.ClassHelper;
import com.google.gct.testrecorder.util.StringHelper;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;

public class MatcherBuilder {
    private final Project myProject;
    private final boolean myIsKotlinTestClass;
    private int myMatcherCount = 0;
    private final StringBuilder myMatchers = new StringBuilder();

    public MatcherBuilder(Project project, boolean isKotlinTestClass) {
        this.myProject = project;
        this.myIsKotlinTestClass = isKotlinTestClass;
    }

    public void addMatcher(Kind kind, String matchedString, boolean shouldBox, boolean isAssertionMatcher) {
        if (!Strings.isNullOrEmpty((String)matchedString)) {
            if (kind == Kind.ClassName && !isAssertionMatcher) {
                matchedString = ClassHelper.getInternalName(this.myProject, matchedString);
            }
            if (this.myMatcherCount > 0) {
                this.myMatchers.append(", ");
            }
            if (kind == Kind.ClassName && isAssertionMatcher) {
                if (this.myIsKotlinTestClass) {
                    this.myMatchers.append("IsInstanceOf.instanceOf(").append(matchedString).append("::class.java)");
                } else {
                    this.myMatchers.append("IsInstanceOf.<View>instanceOf(").append(matchedString).append(".class)");
                }
            } else {
                this.myMatchers.append("with").append(kind.name()).append(kind == Kind.ClassName ? this.getClassNameMatcher() : "(").append(shouldBox ? StringHelper.boxString(matchedString) : matchedString).append(kind == Kind.ClassName ? "))" : ")");
            }
            ++this.myMatcherCount;
        }
    }

    @NotNull
    private String getClassNameMatcher() {
        String string = this.myIsKotlinTestClass ? "(`is`(" : "(is(";
        if (string == null) {
            MatcherBuilder.$$$reportNull$$$0(0);
        }
        return string;
    }

    public int getMatcherCount() {
        return this.myMatcherCount;
    }

    public String getMatchers() {
        return this.myMatchers.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/gct/testrecorder/codegen/MatcherBuilder", "getClassNameMatcher"));
    }

    public static enum Kind {
        Id,
        Text,
        ContentDescription,
        ClassName;

    }
}

