/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.testrecorder.debugger;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.CollectingOutputReceiver;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.tools.idea.run.AndroidSessionInfo;
import com.android.tools.idea.run.ApkProviderUtil;
import com.android.tools.idea.run.activity.ActivityLocatorUtils;
import com.android.tools.idea.run.activity.DefaultActivityLocator;
import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gct.testrecorder.debugger.BreakpointCommand;
import com.google.gct.testrecorder.debugger.BreakpointDescriptor;
import com.google.gct.testrecorder.run.TestRecorderRunConfigurationProxy;
import com.google.gct.testrecorder.settings.TestRecorderSettings;
import com.google.gct.testrecorder.ui.RecordingDialog;
import com.intellij.debugger.DebugEnvironment;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.DefaultDebugEnvironment;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebugProcessListener;
import com.intellij.debugger.engine.JavaDebugProcess;
import com.intellij.debugger.engine.RemoteDebugProcessHandler;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.impl.DebuggerManagerListener;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RemoteConnection;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiClass;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugProcessStarter;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.swing.SwingUtilities;
import org.jetbrains.android.dom.manifest.Activity;
import org.jetbrains.android.dom.manifest.ActivityAlias;
import org.jetbrains.android.dom.manifest.Application;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.annotations.NotNull;

public class SessionInitializer
implements Runnable {
    private static final Logger LOGGER = Logger.getInstance(SessionInitializer.class);
    private final Set<BreakpointDescriptor> myBreakpointDescriptors = Sets.newHashSet();
    private final Set<BreakpointCommand> myBreakpointCommands = Sets.newHashSet();
    private final AndroidFacet myFacet;
    private final Project myProject;
    private final ExecutionEnvironment myEnvironment;
    private final TestRecorderRunConfigurationProxy myTestRecorderConfigurationProxy;
    private final int myConfigurationId;
    private final boolean myIsRecordingTest;
    private IDevice myDevice;
    private String myPackageName;
    private volatile DebuggerSession myDebuggerSession;
    private volatile DebuggerManagerListener myDebuggerManagerListener;
    private volatile RecordingDialog myRecordingDialog;
    private volatile boolean myFailedToStart;

    public SessionInitializer(AndroidFacet facet, ExecutionEnvironment environment, TestRecorderRunConfigurationProxy testRecorderConfigurationProxy, int configurationId, boolean isRecordingTest) {
        this.myFacet = facet;
        this.myProject = this.myFacet.getModule().getProject();
        this.myEnvironment = environment;
        this.myTestRecorderConfigurationProxy = testRecorderConfigurationProxy;
        this.myConfigurationId = configurationId;
        this.myIsRecordingTest = isRecordingTest;
        this.myBreakpointDescriptors.add(new BreakpointDescriptor("VIEW_CLICKED", "android.view.View$PerformClick", "run", "()V", false));
        this.myBreakpointDescriptors.add(new BreakpointDescriptor("VIEW_LONG_CLICKED", "android.view.View", "performLongClick", "()Z", false));
        this.myBreakpointDescriptors.add(new BreakpointDescriptor("LIST_ITEM_CLICKED", "android.widget.AbsListView", "performItemClick", "(Landroid/view/View;IJ)Z", false));
        this.myBreakpointDescriptors.add(new BreakpointDescriptor("VIEW_TEXT_CHANGED", "android.widget.TextView$ChangeWatcher", "beforeTextChanged", "(Ljava/lang/CharSequence;III)V", true));
        this.myBreakpointDescriptors.add(new BreakpointDescriptor("VIEW_TEXT_CHANGED", "android.widget.TextView$ChangeWatcher", "onTextChanged", "(Ljava/lang/CharSequence;III)V", false));
        this.myBreakpointDescriptors.add(new BreakpointDescriptor("PRESSED_BACK", "android.view.inputmethod.InputMethodManager", "invokeFinishedInputEventCallback", "(Landroid/view/inputmethod/InputMethodManager$PendingEvent;Z)V", false));
        this.myBreakpointDescriptors.add(new BreakpointDescriptor("PRESSED_EDITOR_ACTION", "android.widget.TextView", "onEditorAction", "(I)V", false));
        this.myBreakpointDescriptors.add(new BreakpointDescriptor("VIEW_SWIPED", "android.support.v4.view.ViewPager", "smoothScrollTo", "(III)V", false));
        this.myBreakpointDescriptors.add(new BreakpointDescriptor("DELAYED_MESSAGE_POSTED", "android.os.Handler", "postDelayed", "(Ljava/lang/Runnable;J)Z", false));
        this.myBreakpointDescriptors.add(new BreakpointDescriptor("WINDOW_CONTENT_CHANGED", "android.view.ViewRootImpl$SendWindowContentChangedAccessibilityEvent", "run", "()V", false));
        this.myBreakpointDescriptors.add(new BreakpointDescriptor("LAZY_CLASSES_LOADER", "android.os.Handler", "dispatchMessage", "(Landroid/os/Message;)V", false));
        this.myBreakpointDescriptors.add(new BreakpointDescriptor("PERMISSIONS_REQUEST", "android.app.Activity", "requestPermissions", "([Ljava/lang/String;I)V", false));
    }

    @Override
    public void run() {
        this.myDebuggerManagerListener = new DebuggerManagerListener(){

            public void sessionCreated(DebuggerSession session) {
                SessionInitializer.this.myDebuggerSession = session;
                SessionInitializer.this.myDebuggerSession.getProcess().addDebugProcessListener(SessionInitializer.this.createDebugProcessListener());
            }

            public void sessionDetached(DebuggerSession session) {
                if (SessionInitializer.this.myDebuggerSession == session) {
                    DebuggerManagerEx.getInstanceEx((Project)SessionInitializer.this.myProject).removeDebuggerManagerListener(SessionInitializer.this.myDebuggerManagerListener);
                }
            }
        };
        DebuggerManagerEx.getInstanceEx((Project)this.myProject).addDebuggerManagerListener(this.myDebuggerManagerListener);
        try {
            this.assignDevice();
        }
        catch (Exception e) {
            this.myFailedToStart = true;
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    Messages.showErrorDialog((Project)SessionInitializer.this.myProject, (String)e.getMessage(), (String)"Test Recorder startup failure");
                }
            });
            this.stopTestRecorder();
        }
    }

    @NotNull
    private DebugProcessListener createDebugProcessListener() {
        DebugProcessListener debugProcessListener = new DebugProcessListener(){

            public void processAttached(DebugProcess process) {
                if (SessionInitializer.this.myFailedToStart) {
                    SessionInitializer.this.stopDebugger();
                    return;
                }
                AndroidSessionInfo sessionInfo = (AndroidSessionInfo)process.getProcessHandler().getUserData(AndroidSessionInfo.KEY);
                if (sessionInfo != null && sessionInfo.getRunConfigurationId() != SessionInitializer.this.myConfigurationId) {
                    DebuggerManagerEx.getInstanceEx((Project)SessionInitializer.this.myProject).removeDebuggerManagerListener(SessionInitializer.this.myDebuggerManagerListener);
                    return;
                }
                ApplicationManager.getApplication().runReadAction(new Runnable(){

                    @Override
                    public void run() {
                        for (XDebugSession debugSession : XDebuggerManager.getInstance((Project)SessionInitializer.this.myProject).getDebugSessions()) {
                            debugSession.setBreakpointMuted(true);
                        }
                    }
                });
                SessionInitializer.this.scheduleBreakpointCommands();
                if (SessionInitializer.this.myRecordingDialog == null) {
                    final String launchedActivityName = SessionInitializer.this.detectLaunchedActivityName();
                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SessionInitializer.this.myRecordingDialog = new RecordingDialog(SessionInitializer.this.myFacet, SessionInitializer.this.myDevice, SessionInitializer.this.myPackageName, launchedActivityName, SessionInitializer.this.myIsRecordingTest);
                            SessionInitializer.this.myRecordingDialog.setDebuggerSession(SessionInitializer.this.myDebuggerSession);
                            for (BreakpointCommand breakpointCommand : SessionInitializer.this.myBreakpointCommands) {
                                breakpointCommand.setEventListener(SessionInitializer.this.myRecordingDialog);
                            }
                            SessionInitializer.this.myRecordingDialog.show();
                            SessionInitializer.this.stopTestRecorder();
                        }
                    });
                } else {
                    SessionInitializer.this.myRecordingDialog.setDebuggerSession(SessionInitializer.this.myDebuggerSession);
                    for (BreakpointCommand breakpointCommand : SessionInitializer.this.myBreakpointCommands) {
                        breakpointCommand.setEventListener(SessionInitializer.this.myRecordingDialog);
                    }
                }
            }

            public void processDetached(DebugProcess process, boolean closedByUser) {
                if (SessionInitializer.this.myRecordingDialog != null && SessionInitializer.this.myRecordingDialog.isShowing()) {
                    SessionInitializer.this.promptToRestartDebugging();
                }
            }
        };
        if (debugProcessListener == null) {
            SessionInitializer.$$$reportNull$$$0(0);
        }
        return debugProcessListener;
    }

    @NotNull
    private String detectLaunchedActivityName() {
        if (!Strings.isNullOrEmpty((String)this.myTestRecorderConfigurationProxy.getLaunchActivityClass())) {
            String string = this.myTestRecorderConfigurationProxy.getLaunchActivityClass();
            if (string == null) {
                SessionInitializer.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = (String)DumbService.getInstance((Project)this.myProject).runReadActionInSmartMode((Computable)new Computable<String>(){

            public String compute() {
                String activityName = "unknownPackage.unknownActivity";
                try {
                    activityName = new DefaultActivityLocator(SessionInitializer.this.myFacet).getQualifiedActivityName(SessionInitializer.this.myDevice);
                }
                catch (Exception e) {
                    return activityName;
                }
                if (SessionInitializer.this.myFacet.getManifest() == null || SessionInitializer.this.myFacet.getManifest().getApplication() == null) {
                    return activityName;
                }
                Application application = SessionInitializer.this.myFacet.getManifest().getApplication();
                for (Activity activity : application.getActivities()) {
                    if (!activityName.equals(ActivityLocatorUtils.getQualifiedName((Activity)activity))) continue;
                    return activityName;
                }
                for (ActivityAlias activityAlias : application.getActivityAliases()) {
                    String qualifiedName;
                    if (!activityName.equals(ActivityLocatorUtils.getQualifiedName((ActivityAlias)activityAlias))) continue;
                    PsiClass psiClass = (PsiClass)activityAlias.getTargetActivity().getValue();
                    if (psiClass != null && (qualifiedName = psiClass.getQualifiedName()) != null) {
                        return qualifiedName;
                    }
                    return activityName;
                }
                return activityName;
            }
        });
        if (string == null) {
            SessionInitializer.$$$reportNull$$$0(2);
        }
        return string;
    }

    private void promptToRestartDebugging() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                String message = "Test Recorder stopped recording your actions because it has detached from the device VM.\nPlease fix the connection and click Resume to continue.";
                while (message != null) {
                    SessionInitializer.this.myDebuggerSession = null;
                    if (SessionInitializer.this.myRecordingDialog != null) {
                        SessionInitializer.this.myRecordingDialog.setDebuggerSession(null);
                    }
                    int userChoice = Messages.showDialog((Project)SessionInitializer.this.myProject, (String)message, (String)"Test Recorder has detached from the device VM", (String[])new String[]{"Stop", "Resume"}, (int)1, null);
                    message = null;
                    if (userChoice == 0) continue;
                    try {
                        SessionInitializer.this.restartDebugging();
                    }
                    catch (Exception e) {
                        message = "Could not reattach the debugger: " + e.getMessage();
                    }
                }
            }
        });
    }

    private void restartDebugging() throws ExecutionException {
        this.reconnectToDevice();
        String debugPort = Integer.toString(this.myDevice.getClient(this.myPackageName).getDebuggerListenPort());
        RemoteConnection connection = new RemoteConnection(true, "localhost", debugPort, false);
        RunProfileState state = new RunProfileState(){

            public ExecutionResult execute(Executor executor, @NotNull ProgramRunner runner) throws ExecutionException {
                if (runner == null) {
                    6.$$$reportNull$$$0(0);
                }
                return new DefaultExecutionResult();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runner", "com/google/gct/testrecorder/debugger/SessionInitializer$6", "execute"));
            }
        };
        final RemoteDebugProcessHandler processHandler = new RemoteDebugProcessHandler(this.myProject);
        DefaultDebugEnvironment debugEnvironment = new DefaultDebugEnvironment(this.myEnvironment, state, connection, false){

            public ExecutionResult createExecutionResult() throws ExecutionException {
                return new DefaultExecutionResult(null, (ProcessHandler)processHandler);
            }
        };
        DebuggerManagerEx.getInstanceEx((Project)this.myProject).attachVirtualMachine((DebugEnvironment)debugEnvironment);
        if (this.myDebuggerSession == null) {
            throw new RuntimeException("Could not attach the virtual machine!");
        }
        XDebuggerManager.getInstance((Project)this.myProject).startSession(this.myEnvironment, new XDebugProcessStarter(){

            @NotNull
            public XDebugProcess start(@NotNull XDebugSession session) {
                if (session == null) {
                    8.$$$reportNull$$$0(0);
                }
                JavaDebugProcess javaDebugProcess = JavaDebugProcess.create((XDebugSession)session, (DebuggerSession)SessionInitializer.this.myDebuggerSession);
                if (javaDebugProcess == null) {
                    8.$$$reportNull$$$0(1);
                }
                return javaDebugProcess;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "session";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/google/gct/testrecorder/debugger/SessionInitializer$8";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/google/gct/testrecorder/debugger/SessionInitializer$8";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "start";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "start";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
        processHandler.startNotify();
    }

    private void scheduleBreakpointCommands() {
        this.myBreakpointCommands.clear();
        DebugProcessImpl debugProcess = this.myDebuggerSession.getProcess();
        for (BreakpointDescriptor breakpointDescriptor : this.myBreakpointDescriptors) {
            BreakpointCommand breakpointCommand = new BreakpointCommand(debugProcess, breakpointDescriptor);
            this.myBreakpointCommands.add(breakpointCommand);
            debugProcess.getManagerThread().schedule((DebuggerCommandImpl)breakpointCommand);
        }
    }

    private void stopTestRecorder() {
        this.stopDebugger();
        if (this.myDevice != null && TestRecorderSettings.getInstance().CLEAN_AFTER_FINISH) {
            try {
                this.myDevice.executeShellCommand("pm clear " + this.myPackageName, (IShellOutputReceiver)new CollectingOutputReceiver(), 5L, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                LOGGER.warn("Exception stopping the app", (Throwable)e);
            }
        }
    }

    private void stopDebugger() {
        DebuggerManagerEx.getInstanceEx((Project)this.myProject).removeDebuggerManagerListener(this.myDebuggerManagerListener);
        if (TestRecorderSettings.getInstance().STOP_APP_AFTER_RECORDING) {
            XDebugSession xDebugSession;
            if (this.myDebuggerSession != null && (xDebugSession = this.myDebuggerSession.getXDebugSession()) != null) {
                xDebugSession.stop();
            }
        } else {
            for (BreakpointCommand breakpointCommand : this.myBreakpointCommands) {
                breakpointCommand.disable();
            }
        }
    }

    private void assignDevice() {
        List<ListenableFuture<IDevice>> listenableFutures = this.myTestRecorderConfigurationProxy.getDeviceFutures(this.myEnvironment);
        if (listenableFutures == null || listenableFutures.size() != 1) {
            throw new RuntimeException("Test Recorder should be launched on a single device!");
        }
        try {
            this.myDevice = (IDevice)listenableFutures.get(0).get();
        }
        catch (Exception e) {
            throw new RuntimeException("Exception while waiting for the device to become ready ", e);
        }
        if (this.myDevice.getVersion().getApiLevel() < 19) {
            throw new RuntimeException("Test Recorder supports devices and emulators running Android API level 19 (Android 4.4 Kit Kat) and higher.");
        }
        try {
            this.myPackageName = ApkProviderUtil.computePackageName((AndroidFacet)this.myFacet);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not compute package name!");
        }
    }

    private void reconnectToDevice() {
        AndroidDebugBridge debugBridge = AndroidSdkUtils.getDebugBridge((Project)this.myProject);
        if (debugBridge == null) {
            throw new RuntimeException("Could not obtain the debug bridge!");
        }
        for (IDevice device : debugBridge.getDevices()) {
            if (!this.myDevice.getSerialNumber().equals(device.getSerialNumber())) continue;
            this.myDevice = device;
            return;
        }
        throw new RuntimeException("Could not find the original device to reconnect to!");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/google/gct/testrecorder/debugger/SessionInitializer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createDebugProcessListener";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "detectLaunchedActivityName";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

