/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.gradle.model;

import com.android.builder.model.NativeArtifact;
import com.android.builder.model.NativeFile;
import com.android.builder.model.NativeFolder;
import com.android.ide.common.gradle.model.IdeModel;
import com.android.ide.common.gradle.model.IdeNativeFile;
import com.android.ide.common.gradle.model.IdeNativeFolder;
import com.android.ide.common.gradle.model.ModelCache;
import com.android.ide.common.gradle.model.UnusedModelMethodException;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.Collection;
import java.util.Objects;

public final class IdeNativeArtifact
extends IdeModel
implements NativeArtifact {
    private final String myName;
    private final String myToolChain;
    private final String myGroupName;
    private final Collection<NativeFolder> mySourceFolders;
    private final Collection<NativeFile> mySourceFiles;
    private final Collection<File> myExportedHeaders;
    private final File myOutputFile;
    private final String myAbi;
    private final String myTargetName;
    private final int myHashCode;

    public IdeNativeArtifact(NativeArtifact artifact, ModelCache modelCache) {
        super(artifact, modelCache);
        this.myName = artifact.getName();
        this.myToolChain = artifact.getToolChain();
        this.myGroupName = artifact.getGroupName();
        this.mySourceFolders = IdeNativeArtifact.copy(artifact.getSourceFolders(), modelCache, (K folder) -> new IdeNativeFolder((NativeFolder)folder, modelCache));
        this.mySourceFiles = IdeNativeArtifact.copy(artifact.getSourceFiles(), modelCache, (K file) -> new IdeNativeFile((NativeFile)file, modelCache));
        this.myExportedHeaders = ImmutableList.copyOf((Collection)artifact.getExportedHeaders());
        this.myAbi = IdeNativeArtifact.copyNewProperty(() -> ((NativeArtifact)artifact).getAbi(), null);
        this.myTargetName = IdeNativeArtifact.copyNewProperty(() -> ((NativeArtifact)artifact).getTargetName(), null);
        this.myOutputFile = artifact.getOutputFile();
        this.myHashCode = this.calculateHashCode();
    }

    public String getName() {
        return this.myName;
    }

    public String getToolChain() {
        return this.myToolChain;
    }

    public String getGroupName() {
        return this.myGroupName;
    }

    public String getAssembleTaskName() {
        throw new UnusedModelMethodException("getAssembleTaskName");
    }

    public Collection<NativeFolder> getSourceFolders() {
        return this.mySourceFolders;
    }

    public Collection<NativeFile> getSourceFiles() {
        return this.mySourceFiles;
    }

    public Collection<File> getExportedHeaders() {
        return this.myExportedHeaders;
    }

    public String getAbi() {
        if (this.myAbi != null) {
            return this.myAbi;
        }
        throw new UnsupportedOperationException("Unsupported method: NativeArtifact.getAbi()");
    }

    public String getTargetName() {
        if (this.myTargetName != null) {
            return this.myTargetName;
        }
        throw new UnsupportedOperationException("Unsupported method: NativeArtifact.getTargetName()");
    }

    public File getOutputFile() {
        return this.myOutputFile;
    }

    public Collection<File> getRuntimeFiles() {
        throw new UnusedModelMethodException("getRuntimeFiles");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IdeNativeArtifact)) {
            return false;
        }
        IdeNativeArtifact artifact = (IdeNativeArtifact)o;
        return Objects.equals(this.myName, artifact.myName) && Objects.equals(this.myToolChain, artifact.myToolChain) && Objects.equals(this.myGroupName, artifact.myGroupName) && Objects.equals(this.mySourceFolders, artifact.mySourceFolders) && Objects.equals(this.mySourceFiles, artifact.mySourceFiles) && Objects.equals(this.myExportedHeaders, artifact.myExportedHeaders) && Objects.equals(this.myAbi, artifact.myAbi) && Objects.equals(this.myTargetName, artifact.myTargetName) && Objects.equals(this.myOutputFile, artifact.myOutputFile);
    }

    public int hashCode() {
        return this.myHashCode;
    }

    private int calculateHashCode() {
        return Objects.hash(this.myName, this.myToolChain, this.myGroupName, this.mySourceFolders, this.mySourceFiles, this.myExportedHeaders, this.myAbi, this.myTargetName, this.myOutputFile);
    }

    public String toString() {
        return "IdeNativeArtifact{myName='" + this.myName + '\'' + ", myToolChain='" + this.myToolChain + '\'' + ", myGroupName='" + this.myGroupName + '\'' + ", mySourceFolders=" + this.mySourceFolders + ", mySourceFiles=" + this.mySourceFiles + ", myExportedHeaders=" + this.myExportedHeaders + ", myAbi='" + this.myAbi + '\'' + ", myTargetName='" + this.myTargetName + '\'' + ", myOutputFile=" + this.myOutputFile + "}";
    }
}

