/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.gradle.model;

import com.android.builder.model.NativeSettings;
import com.android.ide.common.gradle.model.IdeModel;
import com.android.ide.common.gradle.model.ModelCache;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public final class IdeNativeSettings
extends IdeModel
implements NativeSettings {
    private final String myName;
    private final List<String> myCompilerFlags;
    private final int myHashCode;

    public IdeNativeSettings(NativeSettings settings, ModelCache modelCache) {
        super(settings, modelCache);
        this.myName = settings.getName();
        List compilerFlags = settings.getCompilerFlags();
        this.myCompilerFlags = compilerFlags != null && !compilerFlags.isEmpty() ? ImmutableList.copyOf((Collection)compilerFlags) : Collections.emptyList();
        this.myHashCode = this.calculateHashCode();
    }

    public String getName() {
        return this.myName;
    }

    public List<String> getCompilerFlags() {
        return this.myCompilerFlags;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IdeNativeSettings)) {
            return false;
        }
        IdeNativeSettings settings = (IdeNativeSettings)o;
        return Objects.equals(this.myName, settings.myName) && Objects.equals(this.myCompilerFlags, settings.myCompilerFlags);
    }

    public int hashCode() {
        return this.myHashCode;
    }

    private int calculateHashCode() {
        return Objects.hash(this.myName, this.myCompilerFlags);
    }

    public String toString() {
        return "IdeNativeSettings{myName='" + this.myName + '\'' + ", myCompilerFlags=" + this.myCompilerFlags + "}";
    }
}

