/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.repository;

import com.android.ide.common.repository.GoogleMavenRepository;
import com.android.ide.common.repository.GoogleMavenRepositoryKt;
import com.android.ide.common.repository.GradleCoordinate;
import com.android.ide.common.repository.GradleVersion;
import com.android.ide.common.repository.NetworkCache;
import com.google.common.collect.Maps;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kxml2.io.KXmlParser;
import org.xmlpull.v1.XmlPullParserException;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\b&\u0018\u0000 #2\u00020\u0001:\u0003\"#$B'\b\u0007\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u001a\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\nH\u0002J\"\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0010\b\u0002\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u0015J*\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u000e\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u00152\b\b\u0002\u0010\u0017\u001a\u00020\u0018J:\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\n2\u0016\b\u0002\u0010\u0014\u001a\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u00192\b\b\u0002\u0010\u0017\u001a\u00020\u0018J2\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\n2\u000e\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u00152\b\b\u0002\u0010\u0017\u001a\u00020\u0018J\u0018\u0010\u001a\u001a\u0012\u0012\u0004\u0012\u00020\n\u0012\b\u0012\u00060\u000bR\u00020\u00000\tH\u0002J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\nH\u0014J(\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001c2\u0016\u0010!\u001a\u0012\u0012\u0004\u0012\u00020\n\u0012\b\u0012\u00060\u000bR\u00020\u00000\tH\u0002R \u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\b\u0012\u00060\u000bR\u00020\u0000\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/android/ide/common/repository/GoogleMavenRepository;", "Lcom/android/ide/common/repository/NetworkCache;", "cacheDir", "Ljava/io/File;", "networkTimeoutMs", "", "cacheExpiryHours", "(Ljava/io/File;II)V", "packageMap", "", "", "Lcom/android/ide/common/repository/GoogleMavenRepository$PackageInfo;", "findArtifact", "Lcom/android/ide/common/repository/GoogleMavenRepository$ArtifactInfo;", "groupId", "artifactId", "findVersion", "Lcom/android/ide/common/repository/GradleVersion;", "dependency", "Lcom/android/ide/common/repository/GradleCoordinate;", "filter", "Ljava/util/function/Predicate;", "predicate", "allowPreview", "", "Lkotlin/Function1;", "getPackageMap", "readDefaultData", "Ljava/io/InputStream;", "relative", "readMasterIndex", "", "stream", "map", "ArtifactInfo", "Companion", "PackageInfo", "android.sdktools.sdk-common"})
public abstract class GoogleMavenRepository
extends NetworkCache {
    private Map<String, PackageInfo> packageMap;
    @NotNull
    public static final String MAVEN_GOOGLE_CACHE_DIR_KEY = "maven.google";
    public static final Companion Companion = new Companion(null);

    @Nullable
    public final GradleVersion findVersion(@NotNull GradleCoordinate dependency, @Nullable Predicate<GradleVersion> filter2) {
        Intrinsics.checkParameterIsNotNull((Object)dependency, (String)"dependency");
        return this.findVersion(dependency, filter2, dependency.isPreview());
    }

    @Nullable
    public static /* bridge */ /* synthetic */ GradleVersion findVersion$default(GoogleMavenRepository googleMavenRepository, GradleCoordinate gradleCoordinate, Predicate predicate, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: findVersion");
        }
        if ((n & 2) != 0) {
            predicate = null;
        }
        return googleMavenRepository.findVersion(gradleCoordinate, predicate);
    }

    @Nullable
    public final GradleVersion findVersion(@NotNull GradleCoordinate dependency, @Nullable Predicate<GradleVersion> predicate, boolean allowPreview) {
        Function1 function1;
        Intrinsics.checkParameterIsNotNull((Object)dependency, (String)"dependency");
        String string = dependency.getGroupId();
        if (string == null) {
            return null;
        }
        String groupId = string;
        String string2 = dependency.getArtifactId();
        if (string2 == null) {
            return null;
        }
        String artifactId = string2;
        if (dependency.acceptsGreaterRevisions()) {
            String string3 = dependency.getRevision();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"dependency.revision");
            String prefix = StringsKt.trimEnd((String)string3, (char[])new char[]{'+'});
            function1 = predicate != null ? (Function1)new Function1<GradleVersion, Boolean>(predicate, prefix){
                final /* synthetic */ Predicate $predicate;
                final /* synthetic */ String $prefix;

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final boolean invoke(@NotNull GradleVersion v) {
                    Intrinsics.checkParameterIsNotNull((Object)v, (String)"v");
                    if (!this.$predicate.test(v)) return false;
                    String string = v.toString();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"v.toString()");
                    if (!StringsKt.startsWith$default((String)string, (String)this.$prefix, (boolean)false, (int)2, null)) return false;
                    return true;
                }
                {
                    this.$predicate = predicate;
                    this.$prefix = string;
                    super(1);
                }
            } : (Function1)new Function1<GradleVersion, Boolean>(prefix){
                final /* synthetic */ String $prefix;

                public final boolean invoke(@NotNull GradleVersion v) {
                    Intrinsics.checkParameterIsNotNull((Object)v, (String)"v");
                    String string = v.toString();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"v.toString()");
                    return StringsKt.startsWith$default((String)string, (String)this.$prefix, (boolean)false, (int)2, null);
                }
                {
                    this.$prefix = string;
                    super(1);
                }
            };
        } else {
            function1 = predicate != null ? (Function1)new Function1<GradleVersion, Boolean>(predicate){
                final /* synthetic */ Predicate $predicate;

                public final boolean invoke(@NotNull GradleVersion v) {
                    Intrinsics.checkParameterIsNotNull((Object)v, (String)"v");
                    return this.$predicate.test(v);
                }
                {
                    this.$predicate = predicate;
                    super(1);
                }
            } : null;
        }
        Function1 filter2 = function1;
        String string4 = groupId;
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"groupId");
        String string5 = artifactId;
        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"artifactId");
        return this.findVersion(string4, string5, (Function1<? super GradleVersion, Boolean>)filter2, allowPreview);
    }

    @Nullable
    public static /* bridge */ /* synthetic */ GradleVersion findVersion$default(GoogleMavenRepository googleMavenRepository, GradleCoordinate gradleCoordinate, Predicate predicate, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: findVersion");
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        return googleMavenRepository.findVersion(gradleCoordinate, predicate, bl);
    }

    @Nullable
    public final GradleVersion findVersion(@NotNull String groupId, @NotNull String artifactId, @Nullable Predicate<GradleVersion> filter2, boolean allowPreview) {
        Intrinsics.checkParameterIsNotNull((Object)groupId, (String)"groupId");
        Intrinsics.checkParameterIsNotNull((Object)artifactId, (String)"artifactId");
        return this.findVersion(groupId, artifactId, (Function1<? super GradleVersion, Boolean>)((Function1)new Function1<GradleVersion, Boolean>(filter2){
            final /* synthetic */ Predicate $filter;

            public final boolean invoke(@NotNull GradleVersion it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                Predicate predicate = this.$filter;
                return predicate == null || predicate.test(it);
            }
            {
                this.$filter = predicate;
                super(1);
            }
        }), allowPreview);
    }

    @Nullable
    public static /* bridge */ /* synthetic */ GradleVersion findVersion$default(GoogleMavenRepository googleMavenRepository, String string, String string2, Predicate predicate, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: findVersion");
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        return googleMavenRepository.findVersion(string, string2, predicate, bl);
    }

    @Nullable
    public final GradleVersion findVersion(@NotNull String groupId, @NotNull String artifactId, @Nullable Function1<? super GradleVersion, Boolean> filter2, boolean allowPreview) {
        Intrinsics.checkParameterIsNotNull((Object)groupId, (String)"groupId");
        Intrinsics.checkParameterIsNotNull((Object)artifactId, (String)"artifactId");
        ArtifactInfo artifactInfo = this.findArtifact(groupId, artifactId);
        if (artifactInfo == null) {
            return null;
        }
        ArtifactInfo artifactInfo2 = artifactInfo;
        return artifactInfo2.findVersion(filter2, allowPreview);
    }

    @Nullable
    public static /* bridge */ /* synthetic */ GradleVersion findVersion$default(GoogleMavenRepository googleMavenRepository, String string, String string2, Function1 function1, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: findVersion");
        }
        if ((n & 4) != 0) {
            function1 = null;
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        return googleMavenRepository.findVersion(string, string2, (Function1<? super GradleVersion, Boolean>)function1, bl);
    }

    private final ArtifactInfo findArtifact(String groupId, String artifactId) {
        PackageInfo packageInfo = this.getPackageMap().get(groupId);
        if (packageInfo == null) {
            return null;
        }
        PackageInfo packageInfo2 = packageInfo;
        return packageInfo2.findArtifact(artifactId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Map<String, PackageInfo> getPackageMap() {
        if (this.packageMap == null) {
            HashMap map = Maps.newHashMapWithExpectedSize((int)28);
            InputStream inputStream = this.findData("master-index.xml");
            if (inputStream != null) {
                Closeable closeable = inputStream;
                Throwable throwable = null;
                try {
                    InputStream it = (InputStream)closeable;
                    HashMap hashMap = map;
                    Intrinsics.checkExpressionValueIsNotNull((Object)hashMap, (String)"map");
                    this.readMasterIndex(it, hashMap);
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            this.packageMap = map;
        }
        Map<String, PackageInfo> map = this.packageMap;
        if (map == null) {
            Intrinsics.throwNpe();
        }
        return map;
    }

    @Override
    @Nullable
    protected InputStream readDefaultData(@NotNull String relative) {
        Intrinsics.checkParameterIsNotNull((Object)relative, (String)"relative");
        return GoogleMavenRepository.class.getResourceAsStream("/versions-offline/" + relative);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void readMasterIndex(InputStream stream, Map<String, PackageInfo> map) {
        try {
            Closeable closeable = stream;
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)closeable;
                KXmlParser parser = new KXmlParser();
                parser.setInput(it, "UTF-8");
                while (parser.next() != 1) {
                    int eventType = parser.getEventType();
                    if (eventType == 3) {
                        String tag;
                        String string = tag = parser.getName();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"tag");
                        PackageInfo packageInfo = new PackageInfo(string);
                        Map<String, PackageInfo> map2 = map;
                        String string2 = tag;
                        PackageInfo packageInfo2 = packageInfo;
                        map2.put(string2, packageInfo2);
                        continue;
                    }
                    if (eventType == 2) continue;
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (IOException e) {
            this.error(e, null);
        }
        catch (XmlPullParserException e) {
            this.error(e, null);
        }
    }

    @JvmOverloads
    public GoogleMavenRepository(@Nullable File cacheDir, int networkTimeoutMs, int cacheExpiryHours) {
        super(GoogleMavenRepositoryKt.GMAVEN_BASE_URL, MAVEN_GOOGLE_CACHE_DIR_KEY, cacheDir, networkTimeoutMs, cacheExpiryHours);
    }

    @JvmOverloads
    public /* synthetic */ GoogleMavenRepository(File file, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 1) != 0) {
            file = null;
        }
        if ((n3 & 2) != 0) {
            n = 3000;
        }
        if ((n3 & 4) != 0) {
            n2 = (int)TimeUnit.DAYS.toHours(7L);
        }
        this(file, n, n2);
    }

    @JvmOverloads
    public GoogleMavenRepository(@Nullable File cacheDir, int networkTimeoutMs) {
        this(cacheDir, networkTimeoutMs, 0, 4, null);
    }

    @JvmOverloads
    public GoogleMavenRepository(@Nullable File cacheDir) {
        this(cacheDir, 0, 0, 6, null);
    }

    @JvmOverloads
    public GoogleMavenRepository() {
        this(null, 0, 0, 7, null);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J(\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0014\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\r\u0018\u00010\u00122\b\b\u0002\u0010\u0013\u001a\u00020\rJ\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0017"}, d2={"Lcom/android/ide/common/repository/GoogleMavenRepository$ArtifactInfo;", "", "id", "", "versions", "(Ljava/lang/String;Ljava/lang/String;)V", "getId", "()Ljava/lang/String;", "getVersions", "component1", "component2", "copy", "equals", "", "other", "findVersion", "Lcom/android/ide/common/repository/GradleVersion;", "filter", "Lkotlin/Function1;", "allowPreview", "hashCode", "", "toString", "android.sdktools.sdk-common"})
    private static final class ArtifactInfo {
        @NotNull
        private final String id;
        @NotNull
        private final String versions;

        @Nullable
        public final GradleVersion findVersion(@Nullable Function1<? super GradleVersion, Boolean> filter2, boolean allowPreview) {
            return (GradleVersion)SequencesKt.max((Sequence)SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)SequencesKt.filterNotNull((Sequence)SequencesKt.map((Sequence)StringsKt.splitToSequence$default((CharSequence)this.versions, (String[])new String[]{","}, (boolean)false, (int)0, (int)6, null), (Function1)findVersion.1.INSTANCE)), (Function1)((Function1)new Function1<GradleVersion, Boolean>(filter2){
                final /* synthetic */ Function1 $filter;

                public final boolean invoke(@NotNull GradleVersion it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    return this.$filter == null || (Boolean)this.$filter.invoke((Object)it) != false;
                }
                {
                    this.$filter = function1;
                    super(1);
                }
            })), (Function1)((Function1)new Function1<GradleVersion, Boolean>(allowPreview){
                final /* synthetic */ boolean $allowPreview;

                public final boolean invoke(@NotNull GradleVersion it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    return this.$allowPreview || !it.isPreview();
                }
                {
                    this.$allowPreview = bl;
                    super(1);
                }
            })));
        }

        @Nullable
        public static /* bridge */ /* synthetic */ GradleVersion findVersion$default(ArtifactInfo artifactInfo, Function1 function1, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = false;
            }
            return artifactInfo.findVersion((Function1<? super GradleVersion, Boolean>)function1, bl);
        }

        @NotNull
        public final String getId() {
            return this.id;
        }

        @NotNull
        public final String getVersions() {
            return this.versions;
        }

        public ArtifactInfo(@NotNull String id, @NotNull String versions) {
            Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
            Intrinsics.checkParameterIsNotNull((Object)versions, (String)"versions");
            this.id = id;
            this.versions = versions;
        }

        @NotNull
        public final String component1() {
            return this.id;
        }

        @NotNull
        public final String component2() {
            return this.versions;
        }

        @NotNull
        public final ArtifactInfo copy(@NotNull String id, @NotNull String versions) {
            Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
            Intrinsics.checkParameterIsNotNull((Object)versions, (String)"versions");
            return new ArtifactInfo(id, versions);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ ArtifactInfo copy$default(ArtifactInfo artifactInfo, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = artifactInfo.id;
            }
            if ((n & 2) != 0) {
                string2 = artifactInfo.versions;
            }
            return artifactInfo.copy(string, string2);
        }

        public String toString() {
            return "ArtifactInfo(id=" + this.id + ", versions=" + this.versions + ")";
        }

        public int hashCode() {
            String string = this.id;
            String string2 = this.versions;
            return (string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ArtifactInfo)) break block3;
                    ArtifactInfo artifactInfo = (ArtifactInfo)object;
                    if (!Intrinsics.areEqual((Object)this.id, (Object)artifactInfo.id) || !Intrinsics.areEqual((Object)this.versions, (Object)artifactInfo.versions)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000f\u001a\u00020\u0003J\u001c\u0010\u0010\u001a\u00020\u00112\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00070\u0013H\u0002J$\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00162\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00070\u0013H\u0002R'\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00070\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0017"}, d2={"Lcom/android/ide/common/repository/GoogleMavenRepository$PackageInfo;", "", "pkg", "", "(Lcom/android/ide/common/repository/GoogleMavenRepository;Ljava/lang/String;)V", "artifacts", "", "Lcom/android/ide/common/repository/GoogleMavenRepository$ArtifactInfo;", "getArtifacts", "()Ljava/util/Map;", "artifacts$delegate", "Lkotlin/Lazy;", "getPkg", "()Ljava/lang/String;", "findArtifact", "id", "initializeIndex", "", "map", "", "readGroupData", "stream", "Ljava/io/InputStream;", "android.sdktools.sdk-common"})
    private final class PackageInfo {
        static final /* synthetic */ KProperty[] $$delegatedProperties;
        private final Lazy artifacts$delegate;
        @NotNull
        private final String pkg;

        static {
            $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(PackageInfo.class), "artifacts", "getArtifacts()Ljava/util/Map;"))};
        }

        private final Map<String, ArtifactInfo> getArtifacts() {
            Lazy lazy = this.artifacts$delegate;
            PackageInfo packageInfo = this;
            KProperty kProperty = $$delegatedProperties[0];
            return (Map)lazy.getValue();
        }

        @Nullable
        public final ArtifactInfo findArtifact(@NotNull String id) {
            Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
            return this.getArtifacts().get(id);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void initializeIndex(Map<String, ArtifactInfo> map) {
            InputStream stream;
            InputStream inputStream = stream = GoogleMavenRepository.this.findData("" + StringsKt.replace$default((String)this.pkg, (char)'.', (char)'/', (boolean)false, (int)4, null) + "/group-index.xml");
            if (inputStream != null) {
                Closeable closeable = inputStream;
                Throwable throwable = null;
                try {
                    InputStream it = (InputStream)closeable;
                    this.readGroupData(stream, map);
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void readGroupData(InputStream stream, Map<String, ArtifactInfo> map) {
            try {
                Closeable closeable = stream;
                Throwable throwable = null;
                try {
                    InputStream it = (InputStream)closeable;
                    KXmlParser parser = new KXmlParser();
                    parser.setInput(it, "UTF-8");
                    while (parser.next() != 1) {
                        int eventType = parser.getEventType();
                        if (eventType != 2) continue;
                        String artifactId = parser.getName();
                        String versions = parser.getAttributeValue(null, "versions");
                        if (versions == null) continue;
                        String string = artifactId;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"artifactId");
                        ArtifactInfo artifactInfo = new ArtifactInfo(string, versions);
                        Map<String, ArtifactInfo> map2 = map;
                        String string2 = artifactId;
                        ArtifactInfo artifactInfo2 = artifactInfo;
                        map2.put(string2, artifactInfo2);
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            catch (Exception e) {
                GoogleMavenRepository.this.error(e, null);
            }
        }

        @NotNull
        public final String getPkg() {
            return this.pkg;
        }

        public PackageInfo(String pkg) {
            Intrinsics.checkParameterIsNotNull((Object)pkg, (String)"pkg");
            this.pkg = pkg;
            this.artifacts$delegate = LazyKt.lazy((Function0)((Function0)new Function0<HashMap<String, ArtifactInfo>>(this){
                final /* synthetic */ PackageInfo this$0;

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final HashMap<String, ArtifactInfo> invoke() {
                    void var1_1;
                    HashMap<K, V> map = new HashMap<K, V>();
                    PackageInfo.access$initializeIndex(this.this$0, map);
                    return var1_1;
                }
                {
                    this.this$0 = packageInfo;
                    super(0);
                }
            }));
        }

        public static final /* synthetic */ void access$initializeIndex(PackageInfo $this, @NotNull Map map) {
            $this.initializeIndex(map);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/android/ide/common/repository/GoogleMavenRepository$Companion;", "", "()V", "MAVEN_GOOGLE_CACHE_DIR_KEY", "", "android.sdktools.sdk-common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

