/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.vectordrawable;

class PathBuilder {
    private StringBuilder mPathData = new StringBuilder();

    PathBuilder() {
    }

    private static String booleanToString(boolean flag) {
        return flag ? "1" : "0";
    }

    public PathBuilder absoluteMoveTo(float x, float y) {
        this.mPathData.append("M").append(x).append(",").append(y);
        return this;
    }

    public PathBuilder relativeMoveTo(float x, float y) {
        this.mPathData.append("m").append(x).append(",").append(y);
        return this;
    }

    public PathBuilder absoluteLineTo(float x, float y) {
        this.mPathData.append("L").append(x).append(",").append(y);
        return this;
    }

    public PathBuilder relativeLineTo(float x, float y) {
        this.mPathData.append("l").append(x).append(",").append(y);
        return this;
    }

    public PathBuilder absoluteVerticalTo(float v) {
        this.mPathData.append("V").append(v);
        return this;
    }

    public PathBuilder relativeVerticalTo(float v) {
        this.mPathData.append("v").append(v);
        return this;
    }

    public PathBuilder absoluteHorizontalTo(float h) {
        this.mPathData.append("H").append(h);
        return this;
    }

    public PathBuilder relativeHorizontalTo(float h) {
        this.mPathData.append("h").append(h);
        return this;
    }

    public PathBuilder absoluteArcTo(float rx, float ry, boolean rotation, boolean largeArc, boolean sweep, float x, float y) {
        this.mPathData.append("A").append(rx).append(",").append(ry).append(",").append(PathBuilder.booleanToString(rotation)).append(",").append(PathBuilder.booleanToString(largeArc)).append(",").append(PathBuilder.booleanToString(sweep)).append(",").append(x).append(",").append(y);
        return this;
    }

    public PathBuilder relativeArcTo(float rx, float ry, boolean rotation, boolean largeArc, boolean sweep, float x, float y) {
        this.mPathData.append("a").append(rx).append(",").append(ry).append(",").append(PathBuilder.booleanToString(rotation)).append(",").append(PathBuilder.booleanToString(largeArc)).append(",").append(PathBuilder.booleanToString(sweep)).append(",").append(x).append(",").append(y);
        return this;
    }

    public PathBuilder absoluteClose() {
        this.mPathData.append("Z");
        return this;
    }

    public PathBuilder relativeClose() {
        this.mPathData.append("z");
        return this;
    }

    public String toString() {
        return this.mPathData.toString();
    }
}

