/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.vectordrawable;

import com.android.ide.common.vectordrawable.SvgGroupNode;
import com.android.ide.common.vectordrawable.SvgNode;
import com.android.ide.common.vectordrawable.SvgTree;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Node;

public class SvgClipPathNode
extends SvgGroupNode {
    private final ArrayList<SvgNode> mAffectedNodes = new ArrayList();

    public SvgClipPathNode(SvgTree svgTree, Node docNode, String name) {
        super(svgTree, docNode, name);
    }

    @Override
    @NotNull
    public SvgClipPathNode deepCopy() {
        SvgClipPathNode newInstance = new SvgClipPathNode(this.getTree(), this.getDocumentNode(), this.getName());
        newInstance.copyFrom(this);
        SvgClipPathNode svgClipPathNode = newInstance;
        if (svgClipPathNode == null) {
            SvgClipPathNode.$$$reportNull$$$0(0);
        }
        return svgClipPathNode;
    }

    protected void copyFrom(SvgClipPathNode from) {
        super.copyFrom(from);
        for (SvgNode node : from.mAffectedNodes) {
            this.addAffectedNode(node);
        }
    }

    @Override
    public void addChild(SvgNode child) {
        this.mChildren.add(child);
        child.fillEmptyAttributes(this.mVdAttributesMap);
    }

    public void addAffectedNode(SvgNode child) {
        this.mAffectedNodes.add(child);
        child.fillEmptyAttributes(this.mVdAttributesMap);
    }

    @Override
    public void flatten(@NotNull AffineTransform transform) {
        if (transform == null) {
            SvgClipPathNode.$$$reportNull$$$0(1);
        }
        for (SvgNode n : this.mChildren) {
            this.mStackedTransform.setTransform(transform);
            this.mStackedTransform.concatenate(this.mLocalTransform);
            n.flatten(this.mStackedTransform);
        }
        this.mStackedTransform.setTransform(transform);
        this.mStackedTransform.concatenate(this.mLocalTransform);
        if (this.mVdAttributesMap.containsKey("stroke-width") && (this.mStackedTransform.getType() & 6) != 0) {
            this.getTree().logErrorLine("Scaling of the stroke width is ignored", this.getDocumentNode(), SvgTree.SvgLogLevel.WARNING);
        }
    }

    @Override
    public void transformIfNeeded(@NotNull AffineTransform rootTransform) {
        if (rootTransform == null) {
            SvgClipPathNode.$$$reportNull$$$0(2);
        }
        for (SvgNode p : this.mChildren) {
            p.transformIfNeeded(rootTransform);
        }
    }

    @Override
    public void writeXML(OutputStreamWriter writer, boolean inClipPath, String indent) throws IOException {
        writer.write(indent);
        writer.write("<group>");
        writer.write(System.lineSeparator());
        writer.write(indent);
        writer.write("  ");
        writer.write("<clip-path android:pathData=\"");
        for (SvgNode node : this.mChildren) {
            node.writeXML(writer, true, indent + "  ");
        }
        writer.write("\"/>");
        writer.write(System.lineSeparator());
        for (SvgNode node : this.mAffectedNodes) {
            node.writeXML(writer, false, indent + "  ");
        }
        writer.write(indent);
        writer.write("</group>");
        writer.write(System.lineSeparator());
    }

    public void setClipPathNodeAttributes() {
        for (SvgNode n : this.mAffectedNodes) {
            this.mLocalTransform.concatenate(n.mLocalTransform);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/ide/common/vectordrawable/SvgClipPathNode";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transform";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootTransform";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "deepCopy";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/ide/common/vectordrawable/SvgClipPathNode";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "flatten";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "transformIfNeeded";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

