/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.vectordrawable;

import com.android.ide.common.vectordrawable.SvgNode;
import com.android.ide.common.vectordrawable.SvgTree;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Node;

class SvgGroupNode
extends SvgNode {
    private static final Logger logger = Logger.getLogger(SvgGroupNode.class.getSimpleName());
    protected final ArrayList<SvgNode> mChildren = new ArrayList();

    public SvgGroupNode(SvgTree svgTree, Node docNode, String name) {
        super(svgTree, docNode, name);
    }

    @Override
    public SvgGroupNode deepCopy() {
        SvgGroupNode newInstance = new SvgGroupNode(this.getTree(), this.getDocumentNode(), this.getName());
        newInstance.copyFrom(this);
        return newInstance;
    }

    protected void copyFrom(SvgGroupNode from) {
        super.copyFrom(from);
        for (SvgNode child : from.mChildren) {
            this.addChild(child.deepCopy());
        }
    }

    public void addChild(SvgNode child) {
        this.mChildren.add(child);
        child.fillEmptyAttributes(this.mVdAttributesMap);
    }

    public void removeChild(SvgNode child) {
        this.mChildren.remove(child);
    }

    @Override
    public void dumpNode(String indent) {
        logger.log(Level.FINE, indent + "current group is :" + this.getName());
        for (SvgNode node : this.mChildren) {
            node.dumpNode(indent + "  ");
        }
    }

    public SvgGroupNode findParent(SvgNode node) {
        for (SvgNode n : this.mChildren) {
            SvgGroupNode parent;
            if (n == node) {
                return this;
            }
            if (!n.isGroupNode() || (parent = ((SvgGroupNode)n).findParent(node)) == null) continue;
            return parent;
        }
        return null;
    }

    @Override
    public boolean isGroupNode() {
        return true;
    }

    @Override
    public void transformIfNeeded(@NotNull AffineTransform rootTransform) {
        if (rootTransform == null) {
            SvgGroupNode.$$$reportNull$$$0(0);
        }
        for (SvgNode p : this.mChildren) {
            p.transformIfNeeded(rootTransform);
        }
    }

    @Override
    public void flatten(@NotNull AffineTransform transform) {
        if (transform == null) {
            SvgGroupNode.$$$reportNull$$$0(1);
        }
        for (SvgNode n : this.mChildren) {
            this.mStackedTransform.setTransform(transform);
            this.mStackedTransform.concatenate(this.mLocalTransform);
            n.flatten(this.mStackedTransform);
        }
    }

    @Override
    public void writeXML(OutputStreamWriter writer, boolean inClipPath, String indent) throws IOException {
        for (SvgNode node : this.mChildren) {
            node.writeXML(writer, inClipPath, indent);
        }
    }

    @Override
    public void fillPresentationAttributes(@NotNull String name, @NotNull String value) {
        if (name == null) {
            SvgGroupNode.$$$reportNull$$$0(2);
        }
        if (value == null) {
            SvgGroupNode.$$$reportNull$$$0(3);
        }
        super.fillPresentationAttributes(name, value);
        for (SvgNode n : this.mChildren) {
            if (n.mVdAttributesMap.containsKey(name)) continue;
            n.fillPresentationAttributes(name, value);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootTransform";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transform";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        objectArray2[1] = "com/android/ide/common/vectordrawable/SvgGroupNode";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "transformIfNeeded";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "flatten";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "fillPresentationAttributes";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

