/*
 * Decompiled with CFR 0.152.
 */
package com.android.java.model.builder;

import com.android.java.model.JavaLibrary;
import com.android.java.model.JavaProject;
import com.android.java.model.SourceSet;
import com.android.java.model.impl.JavaLibraryImpl;
import com.android.java.model.impl.JavaProjectImpl;
import com.android.java.model.impl.SourceSetImpl;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.LenientConfiguration;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.ResolvedConfiguration;
import org.gradle.api.artifacts.SelfResolvingDependency;
import org.gradle.api.artifacts.UnresolvedDependency;
import org.gradle.api.artifacts.component.BuildIdentifier;
import org.gradle.api.artifacts.component.ComponentArtifactIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.initialization.IncludedBuild;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.specs.Specs;
import org.gradle.api.tasks.SourceSetOutput;
import org.gradle.tooling.provider.model.ToolingModelBuilder;
import org.gradle.util.VersionNumber;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\u0005H\u0016R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/android/java/model/builder/JavaModelBuilder;", "Lorg/gradle/tooling/provider/model/ToolingModelBuilder;", "()V", "buildMapping", "", "", "buildAll", "", "modelName", "project", "Lorg/gradle/api/Project;", "canBuild", "", "Companion", "android.sdktools.java-lib-model-builder"})
public final class JavaModelBuilder
implements ToolingModelBuilder {
    private Map<String, String> buildMapping;
    private static final String UNRESOLVED_DEPENDENCY_PREFIX = "unresolved dependency - ";
    private static final String LOCAL_JAR_DISPLAY_NAME = "local jar - ";
    private static final String CURRENT_BUILD_NAME = "__current_build__";
    public static final Companion Companion = new Companion(null);

    public boolean canBuild(@NotNull String modelName) {
        Intrinsics.checkParameterIsNotNull((Object)modelName, (String)"modelName");
        return Intrinsics.areEqual((Object)modelName, (Object)JavaProject.class.getName());
    }

    @Nullable
    public Object buildAll(@NotNull String modelName, @NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)modelName, (String)"modelName");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        if (!project.getPlugins().hasPlugin(JavaPlugin.class)) {
            return null;
        }
        if (this.buildMapping.isEmpty() && JavaModelBuilder.Companion.isCompositeBuildSupported(project)) {
            Gradle gradle = project.getGradle();
            Intrinsics.checkExpressionValueIsNotNull((Object)gradle, (String)"project.gradle");
            this.buildMapping = JavaModelBuilder.Companion.computeBuildMapping(gradle);
        }
        JavaPluginConvention javaPlugin = (JavaPluginConvention)project.getConvention().findPlugin(JavaPluginConvention.class);
        ArrayList<SourceSet> sourceSets = new ArrayList<SourceSet>();
        JavaPluginConvention javaPluginConvention = javaPlugin;
        if (javaPluginConvention == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)javaPluginConvention, (String)"javaPlugin!!");
        Iterator iterator = javaPluginConvention.getSourceSets().iterator();
        while (iterator.hasNext()) {
            org.gradle.api.tasks.SourceSet sourceSet;
            org.gradle.api.tasks.SourceSet sourceSet2 = sourceSet = (org.gradle.api.tasks.SourceSet)iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)sourceSet2, (String)"sourceSet");
            sourceSets.add(JavaModelBuilder.Companion.createSourceSets(project, sourceSet2, this.buildMapping));
        }
        String string = project.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"project.name");
        Collection collection = sourceSets;
        String string2 = javaPlugin.getSourceCompatibility().toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"javaPlugin.sourceCompatibility.toString()");
        return new JavaProjectImpl(string, collection, string2);
    }

    public JavaModelBuilder() {
        JavaModelBuilder javaModelBuilder = this;
        HashMap hashMap = new HashMap();
        javaModelBuilder.buildMapping = hashMap;
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002J,\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\bH\u0002J,\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u00192\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\bH\u0002J2\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u00042\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\bH\u0002J\u001a\u0010\u001e\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001f\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010 \u001a\u00020\f2\u0006\u0010!\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020\u0004H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/android/java/model/builder/JavaModelBuilder$Companion;", "", "()V", "CURRENT_BUILD_NAME", "", "LOCAL_JAR_DISPLAY_NAME", "UNRESOLVED_DEPENDENCY_PREFIX", "computeBuildMapping", "", "gradle", "Lorg/gradle/api/invocation/Gradle;", "contains", "", "directory", "Ljava/io/File;", "file", "createSourceSets", "Lcom/android/java/model/SourceSet;", "project", "Lorg/gradle/api/Project;", "sourceSet", "Lorg/gradle/api/tasks/SourceSet;", "buildMapping", "getBuildId", "artifact", "Lorg/gradle/api/artifacts/ResolvedArtifact;", "getLibrariesForConfiguration", "", "Lcom/android/java/model/JavaLibrary;", "configurationName", "getProjectPath", "isCompositeBuildSupported", "isGradleAtLeast", "gradleVersion", "expectedVersion", "android.sdktools.java-lib-model-builder"})
    public static final class Companion {
        private final Map<String, String> computeBuildMapping(Gradle gradle) {
            HashMap buildMapping = new HashMap();
            Project project = gradle.getRootProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"gradle.rootProject");
            File file = project.getProjectDir();
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"gradle.rootProject.projectDir");
            String currentBuildPath = file.getAbsolutePath();
            Map map = buildMapping;
            Object object = JavaModelBuilder.CURRENT_BUILD_NAME;
            String string = currentBuildPath;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"currentBuildPath");
            Object object2 = string;
            map.put(object, object2);
            Gradle rootGradleProject = gradle;
            while (true) {
                Gradle gradle2 = rootGradleProject;
                if (gradle2 == null) {
                    Intrinsics.throwNpe();
                }
                if (gradle2.getParent() == null) break;
                rootGradleProject = rootGradleProject.getParent();
            }
            if (rootGradleProject != gradle) {
                object = buildMapping;
                Project project2 = rootGradleProject.getRootProject();
                Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"rootGradleProject.rootProject");
                String string2 = project2.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"rootGradleProject.rootProject.name");
                object2 = string2;
                Project project3 = rootGradleProject.getRootProject();
                Intrinsics.checkExpressionValueIsNotNull((Object)project3, (String)"rootGradleProject.rootProject");
                File file2 = project3.getProjectDir();
                Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"rootGradleProject.rootProject.projectDir");
                String string3 = file2.getAbsolutePath();
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"rootGradleProject.rootPr\u2026t.projectDir.absolutePath");
                String string4 = string3;
                object.put(object2, string4);
            }
            object2 = rootGradleProject.getIncludedBuilds().iterator();
            while (object2.hasNext()) {
                String string5;
                String string6;
                IncludedBuild includedBuild;
                IncludedBuild includedBuild2 = includedBuild = (IncludedBuild)object2.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)includedBuild2, (String)"includedBuild");
                File file3 = includedBuild2.getProjectDir();
                Intrinsics.checkExpressionValueIsNotNull((Object)file3, (String)"includedBuild.projectDir");
                String includedBuildPath = file3.getAbsolutePath();
                if (!(Intrinsics.areEqual((Object)includedBuildPath, (Object)currentBuildPath) ^ true)) continue;
                Map map2 = buildMapping;
                Intrinsics.checkExpressionValueIsNotNull((Object)includedBuild.getName(), (String)"includedBuild.name");
                Intrinsics.checkExpressionValueIsNotNull((Object)includedBuildPath, (String)"includedBuildPath");
                map2.put(string6, string5);
            }
            return buildMapping;
        }

        private final SourceSet createSourceSets(Project project, org.gradle.api.tasks.SourceSet sourceSet, Map<String, String> buildMapping) {
            String string;
            Gradle gradle = project.getGradle();
            Intrinsics.checkExpressionValueIsNotNull((Object)gradle, (String)"project.gradle");
            String string2 = gradle.getGradleVersion();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"project.gradle.gradleVersion");
            if (this.isGradleAtLeast(string2, "2.12")) {
                String string3 = sourceSet.getCompileClasspathConfigurationName();
                string = string3;
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"sourceSet.compileClasspathConfigurationName");
            } else {
                String string4 = sourceSet.getCompileConfigurationName();
                string = string4;
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"sourceSet.compileConfigurationName");
            }
            String compileConfigurationName = string;
            String string5 = sourceSet.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"sourceSet.name");
            SourceDirectorySet sourceDirectorySet = sourceSet.getAllJava();
            Intrinsics.checkExpressionValueIsNotNull((Object)sourceDirectorySet, (String)"sourceSet.allJava");
            Set set = sourceDirectorySet.getSrcDirs();
            Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"sourceSet.allJava.srcDirs");
            Collection collection = set;
            SourceDirectorySet sourceDirectorySet2 = sourceSet.getResources();
            Intrinsics.checkExpressionValueIsNotNull((Object)sourceDirectorySet2, (String)"sourceSet.resources");
            Set set2 = sourceDirectorySet2.getSrcDirs();
            Intrinsics.checkExpressionValueIsNotNull((Object)set2, (String)"sourceSet.resources.srcDirs");
            Collection collection2 = set2;
            SourceSetOutput sourceSetOutput = sourceSet.getOutput();
            Intrinsics.checkExpressionValueIsNotNull((Object)sourceSetOutput, (String)"sourceSet.output");
            File file = sourceSetOutput.getClassesDir();
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"sourceSet.output.classesDir");
            SourceSetOutput sourceSetOutput2 = sourceSet.getOutput();
            Intrinsics.checkExpressionValueIsNotNull((Object)sourceSetOutput2, (String)"sourceSet.output");
            File file2 = sourceSetOutput2.getResourcesDir();
            Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"sourceSet.output.resourcesDir");
            return new SourceSetImpl(string5, collection, collection2, file, file2, this.getLibrariesForConfiguration(project, compileConfigurationName, buildMapping));
        }

        public final boolean isGradleAtLeast(@NotNull String gradleVersion, @NotNull String expectedVersion) {
            Intrinsics.checkParameterIsNotNull((Object)gradleVersion, (String)"gradleVersion");
            Intrinsics.checkParameterIsNotNull((Object)expectedVersion, (String)"expectedVersion");
            VersionNumber currentVersion = VersionNumber.parse((String)gradleVersion);
            VersionNumber givenVersion = VersionNumber.parse((String)expectedVersion);
            return currentVersion.compareTo(givenVersion) >= 0;
        }

        /*
         * WARNING - void declaration
         */
        private final Collection<JavaLibrary> getLibrariesForConfiguration(Project project, String configurationName, Map<String, String> buildMapping) {
            String string;
            Object object;
            String string2;
            Object object2;
            JavaLibraryImpl javaLibraryImpl;
            String string3;
            Object object3;
            CharSequence projectPath;
            UnresolvedDependency artifact;
            ArrayList<JavaLibraryImpl> arrayList;
            Configuration configuration = project.getConfigurations().getAt(configurationName);
            ArrayList<JavaLibraryImpl> javaLibraries = new ArrayList<JavaLibraryImpl>();
            Configuration configuration2 = configuration;
            Intrinsics.checkExpressionValueIsNotNull((Object)configuration2, (String)"configuration");
            ResolvedConfiguration resolvedConfiguration = configuration2.getResolvedConfiguration();
            Intrinsics.checkExpressionValueIsNotNull((Object)resolvedConfiguration, (String)"configuration.resolvedConfiguration");
            LenientConfiguration lenientConfiguration = resolvedConfiguration.getLenientConfiguration();
            Set set = lenientConfiguration.getArtifacts(Specs.satisfyAll());
            Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"lenientConfiguration.get\u2026facts(Specs.satisfyAll())");
            Iterable $receiver$iv = set;
            for (Object item$iv : $receiver$iv) {
                JavaLibraryImpl javaLibraryImpl2;
                ResolvedArtifact resolvedArtifact = (ResolvedArtifact)item$iv;
                arrayList = javaLibraries;
                void v3 = artifact;
                Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"artifact");
                projectPath = Companion.getProjectPath(project, (ResolvedArtifact)v3);
                String buildId = projectPath == null ? null : Companion.getBuildId(project, (ResolvedArtifact)artifact, buildMapping);
                Intrinsics.checkExpressionValueIsNotNull((Object)artifact.getName(), (String)"artifact.name");
                object3 = buildId;
                string3 = projectPath;
                JavaLibraryImpl javaLibraryImpl3 = javaLibraryImpl2;
                javaLibraryImpl = javaLibraryImpl2;
                String string4 = object2;
                if (string4 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)string4.intern(), (String)"(this as java.lang.String).intern()");
                javaLibraryImpl3(string3, (String)object3, string2, artifact.getFile());
                object = javaLibraryImpl;
                arrayList.add((JavaLibraryImpl)object);
            }
            LenientConfiguration lenientConfiguration2 = lenientConfiguration;
            Intrinsics.checkExpressionValueIsNotNull((Object)lenientConfiguration2, (String)"lenientConfiguration");
            Set set2 = lenientConfiguration2.getUnresolvedModuleDependencies();
            Intrinsics.checkExpressionValueIsNotNull((Object)set2, (String)"lenientConfiguration.unresolvedModuleDependencies");
            $receiver$iv = set2;
            for (Object item$iv : $receiver$iv) {
                String string5;
                JavaLibraryImpl javaLibraryImpl4;
                void unresolvedDependency;
                artifact = (UnresolvedDependency)item$iv;
                arrayList = javaLibraries;
                StringBuilder stringBuilder = new StringBuilder().append(JavaModelBuilder.UNRESOLVED_DEPENDENCY_PREFIX);
                void v9 = unresolvedDependency;
                Intrinsics.checkExpressionValueIsNotNull((Object)v9, (String)"unresolvedDependency");
                projectPath = v9.getSelector().toString();
                string = ":";
                object2 = stringBuilder;
                object3 = new Regex(string);
                string = object3;
                string3 = " ";
                object3 = string.replace(projectPath, string3);
                String unresolvedName = ((StringBuilder)object2).append((String)object3).toString();
                projectPath = unresolvedName;
                javaLibraryImpl = null;
                string2 = null;
                object3 = javaLibraryImpl4;
                object2 = javaLibraryImpl4;
                CharSequence charSequence = projectPath;
                if (charSequence == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)((String)charSequence).intern(), (String)"(this as java.lang.String).intern()");
                ((JavaLibraryImpl)object3)(string2, (String)((Object)javaLibraryImpl), string5, new File(unresolvedName));
                object = object2;
                arrayList.add((JavaLibraryImpl)object);
            }
            for (Dependency dependency : configuration.getAllDependencies()) {
                if (!(dependency instanceof SelfResolvingDependency) || dependency instanceof ProjectDependency) continue;
                for (File file : ((SelfResolvingDependency)dependency).resolve()) {
                    String string6;
                    JavaLibraryImpl javaLibraryImpl5;
                    String localJarName;
                    StringBuilder stringBuilder = new StringBuilder().append(JavaModelBuilder.LOCAL_JAR_DISPLAY_NAME);
                    File file2 = file;
                    Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"file");
                    string = localJarName = stringBuilder.append(file2.getName()).toString();
                    String string7 = null;
                    String string8 = null;
                    JavaLibraryImpl javaLibraryImpl6 = javaLibraryImpl5;
                    object = javaLibraryImpl5;
                    arrayList = javaLibraries;
                    String string9 = string;
                    if (string9 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)string9.intern(), (String)"(this as java.lang.String).intern()");
                    javaLibraryImpl6(string8, string7, string6, file);
                    arrayList.add((JavaLibraryImpl)object);
                }
            }
            return javaLibraries;
        }

        private final String getProjectPath(Project project, ResolvedArtifact artifact) {
            Gradle gradle = project.getGradle();
            Intrinsics.checkExpressionValueIsNotNull((Object)gradle, (String)"project.gradle");
            String string = gradle.getGradleVersion();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"project.gradle.gradleVersion");
            if (this.isGradleAtLeast(string, "2.6")) {
                ComponentArtifactIdentifier componentArtifactIdentifier = artifact.getId();
                Intrinsics.checkExpressionValueIsNotNull((Object)componentArtifactIdentifier, (String)"artifact.id");
                ComponentIdentifier id = componentArtifactIdentifier.getComponentIdentifier();
                if (id instanceof ProjectComponentIdentifier) {
                    String string2;
                    String string3 = ((ProjectComponentIdentifier)id).getProjectPath();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"id.projectPath");
                    String string4 = string2 = string3;
                    if (string4 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string5 = string4.intern();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.String).intern()");
                    return string5;
                }
            } else {
                String string6;
                Object object;
                Object v11;
                block8: {
                    Project project2 = project.getRootProject();
                    Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project.rootProject");
                    Set set = project2.getAllprojects();
                    Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"project.rootProject.allprojects");
                    Iterable $receiver$iv = set;
                    for (Object element$iv : $receiver$iv) {
                        Project it;
                        Project project3 = it = (Project)element$iv;
                        Intrinsics.checkExpressionValueIsNotNull((Object)project3, (String)"it");
                        File file = project3.getBuildDir();
                        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"it.buildDir");
                        File file2 = artifact.getFile();
                        Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"artifact.file");
                        if (!Companion.contains(file, file2)) continue;
                        v11 = element$iv;
                        break block8;
                    }
                    v11 = null;
                }
                if ((object = (Project)v11) != null && (object = object.getPath()) != null) {
                    Object object2;
                    Object object3 = object2 = object;
                    if (object3 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string7 = ((String)object3).intern();
                    string6 = string7;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"(this as java.lang.String).intern()");
                } else {
                    string6 = null;
                }
                return string6;
            }
            return null;
        }

        private final boolean isCompositeBuildSupported(Project project) {
            Gradle gradle = project.getGradle();
            Intrinsics.checkExpressionValueIsNotNull((Object)gradle, (String)"project.gradle");
            String string = gradle.getGradleVersion();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"project.gradle.gradleVersion");
            return this.isGradleAtLeast(string, "3.1");
        }

        private final String getBuildId(Project project, ResolvedArtifact artifact, Map<String, String> buildMapping) {
            if (this.isCompositeBuildSupported(project)) {
                ComponentArtifactIdentifier componentArtifactIdentifier = artifact.getId();
                Intrinsics.checkExpressionValueIsNotNull((Object)componentArtifactIdentifier, (String)"artifact.id");
                ComponentIdentifier id = componentArtifactIdentifier.getComponentIdentifier();
                if (id instanceof ProjectComponentIdentifier) {
                    BuildIdentifier identifier;
                    BuildIdentifier buildIdentifier = identifier = ((ProjectComponentIdentifier)id).getBuild();
                    Intrinsics.checkExpressionValueIsNotNull((Object)buildIdentifier, (String)"identifier");
                    String string = buildMapping.get(buildIdentifier.isCurrentBuild() ? JavaModelBuilder.CURRENT_BUILD_NAME : identifier.getName());
                    if (string == null) {
                        Intrinsics.throwNpe();
                    }
                    return string;
                }
            }
            File file = project.getProjectDir();
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"project.projectDir");
            String string = file.getAbsolutePath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"project.projectDir.absolutePath");
            return string;
        }

        private final boolean contains(File directory, File file) {
            try {
                Intrinsics.checkExpressionValueIsNotNull((Object)file.getCanonicalFile(), (String)"file.canonicalFile");
                File canonicalDirectory = directory.getCanonicalFile();
                for (File canonicalFile = (v257400).getParentFile(); canonicalFile != null; canonicalFile = canonicalFile.getParentFile()) {
                    if (!Intrinsics.areEqual((Object)canonicalFile, (Object)canonicalDirectory)) continue;
                    return true;
                }
            }
            catch (IOException ex) {
                return false;
            }
            return false;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

