/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutinspector.model;

import com.android.ddmlib.ChunkHandler;
import com.android.ddmlib.Client;
import com.android.ddmlib.ClientData;
import com.android.ddmlib.HandleViewDebug;
import com.android.layoutinspector.LayoutInspectorCaptureOptions;
import com.android.layoutinspector.ProtocolVersion;
import com.android.layoutinspector.model.ViewNode;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00172\u00020\u0001:\u0003\u0016\u0017\u0018B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J \u0010\u0013\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u00038F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\t\u00a8\u0006\u0019"}, d2={"Lcom/android/layoutinspector/model/ClientWindow;", "", "title", "", "client", "Lcom/android/ddmlib/Client;", "(Ljava/lang/String;Lcom/android/ddmlib/Client;)V", "displayName", "getDisplayName", "()Ljava/lang/String;", "getTitle", "loadViewImage", "", "node", "Lcom/android/layoutinspector/model/ViewNode;", "timeout", "", "unit", "Ljava/util/concurrent/TimeUnit;", "loadWindowData", "options", "Lcom/android/layoutinspector/LayoutInspectorCaptureOptions;", "CaptureByteArrayHandler", "Companion", "ListViewRootsHandler", "android.sdktools.layoutinspector"})
public final class ClientWindow {
    @NotNull
    private final String title;
    private final Client client;
    public static final Companion Companion = new Companion(null);

    @Nullable
    public final String getDisplayName() {
        Collection $receiver$iv;
        ClientData clientData = this.client.getClientData();
        Intrinsics.checkExpressionValueIsNotNull((Object)clientData, (String)"client.clientData");
        String appName = clientData.getClientDescription();
        Collection collection = $receiver$iv = (Collection)StringsKt.split$default((CharSequence)this.title, (String[])new String[]{"/"}, (boolean)false, (int)0, (int)6, null);
        if (collection == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        Collection thisCollection$iv = collection;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        ArrayList parts = CollectionsKt.arrayListOf((Object[])Arrays.copyOf(stringArray, stringArray.length));
        parts.remove("");
        parts.remove(appName);
        return parts.isEmpty() ? appName : (String)parts.get(parts.size() > 2 ? 1 : 0);
    }

    @Nullable
    public final byte[] loadWindowData(@NotNull LayoutInspectorCaptureOptions options, long timeout, @NotNull TimeUnit unit) {
        Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
        Intrinsics.checkParameterIsNotNull((Object)((Object)unit), (String)"unit");
        CaptureByteArrayHandler handler = new CaptureByteArrayHandler(HandleViewDebug.CHUNK_VURT);
        try {
            HandleViewDebug.dumpViewHierarchy(this.client, this.title, false, true, Intrinsics.areEqual((Object)((Object)options.getVersion()), (Object)((Object)ProtocolVersion.Version2)), handler);
        }
        catch (IOException e) {
            return null;
        }
        return handler.getData(timeout, unit);
    }

    @Nullable
    public final byte[] loadViewImage(@NotNull ViewNode node, long timeout, @NotNull TimeUnit unit) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull((Object)((Object)unit), (String)"unit");
        CaptureByteArrayHandler handler = new CaptureByteArrayHandler(HandleViewDebug.CHUNK_VUOP);
        try {
            HandleViewDebug.captureView(this.client, this.title, node.toString(), handler);
        }
        catch (IOException e) {
            return null;
        }
        return handler.getData(timeout, unit);
    }

    @NotNull
    public final String getTitle() {
        return this.title;
    }

    public ClientWindow(@NotNull String title, @NotNull Client client) {
        Intrinsics.checkParameterIsNotNull((Object)title, (String)"title");
        Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
        this.title = title;
        this.client = client;
    }

    @JvmStatic
    @Nullable
    public static final List<ClientWindow> getAll(@NotNull Client client, long timeout, @NotNull TimeUnit unit) throws IOException {
        return Companion.getAll(client, timeout, unit);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0014R2\u0010\u0003\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005 \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/android/layoutinspector/model/ClientWindow$ListViewRootsHandler;", "Lcom/android/ddmlib/HandleViewDebug$ViewDumpHandler;", "()V", "myViewRoots", "Ljava/util/concurrent/CopyOnWriteArrayList;", "", "kotlin.jvm.PlatformType", "getWindows", "", "Lcom/android/layoutinspector/model/ClientWindow;", "c", "Lcom/android/ddmlib/Client;", "timeout", "", "unit", "Ljava/util/concurrent/TimeUnit;", "handleViewDebugResult", "", "data", "Ljava/nio/ByteBuffer;", "android.sdktools.layoutinspector"})
    private static final class ListViewRootsHandler
    extends HandleViewDebug.ViewDumpHandler {
        private final CopyOnWriteArrayList<String> myViewRoots = Lists.newCopyOnWriteArrayList();

        /*
         * WARNING - void declaration
         */
        @Override
        protected void handleViewDebugResult(@NotNull ByteBuffer data) {
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            int nWindows = data.getInt();
            int n = 0;
            int n2 = nWindows;
            while (n < n2) {
                void i;
                int len = data.getInt();
                this.myViewRoots.add(ChunkHandler.getString(data, len));
                ++i;
            }
        }

        @NotNull
        public final List<ClientWindow> getWindows(@NotNull Client c, long timeout, @NotNull TimeUnit unit) throws IOException {
            Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
            Intrinsics.checkParameterIsNotNull((Object)((Object)unit), (String)"unit");
            HandleViewDebug.listViewRoots(c, this);
            this.waitForResult(timeout, unit);
            ArrayList windows = Lists.newArrayList();
            Iterator<String> iterator = this.myViewRoots.iterator();
            while (iterator.hasNext()) {
                String root;
                String string = root = iterator.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"root");
                windows.add(new ClientWindow(string, c));
            }
            ArrayList arrayList = windows;
            Intrinsics.checkExpressionValueIsNotNull((Object)arrayList, (String)"windows");
            return arrayList;
        }

        public ListViewRootsHandler() {
            super(HandleViewDebug.CHUNK_VULW);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/android/layoutinspector/model/ClientWindow$CaptureByteArrayHandler;", "Lcom/android/ddmlib/HandleViewDebug$ViewDumpHandler;", "type", "", "(I)V", "mData", "Ljava/util/concurrent/atomic/AtomicReference;", "", "getData", "timeout", "", "unit", "Ljava/util/concurrent/TimeUnit;", "handleViewDebugResult", "", "data", "Ljava/nio/ByteBuffer;", "android.sdktools.layoutinspector"})
    private static final class CaptureByteArrayHandler
    extends HandleViewDebug.ViewDumpHandler {
        private final AtomicReference<byte[]> mData = new AtomicReference();

        @Override
        protected void handleViewDebugResult(@NotNull ByteBuffer data) {
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            byte[] b = new byte[data.remaining()];
            data.get(b);
            this.mData.set(b);
        }

        @Nullable
        public final byte[] getData(long timeout, @NotNull TimeUnit unit) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)unit), (String)"unit");
            this.waitForResult(timeout, unit);
            return this.mData.get();
        }

        public CaptureByteArrayHandler(int type) {
            super(type);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007\u00a8\u0006\f"}, d2={"Lcom/android/layoutinspector/model/ClientWindow$Companion;", "", "()V", "getAll", "", "Lcom/android/layoutinspector/model/ClientWindow;", "client", "Lcom/android/ddmlib/Client;", "timeout", "", "unit", "Ljava/util/concurrent/TimeUnit;", "android.sdktools.layoutinspector"})
    public static final class Companion {
        @JvmStatic
        @Nullable
        public final List<ClientWindow> getAll(@NotNull Client client, long timeout, @NotNull TimeUnit unit) throws IOException {
            Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
            Intrinsics.checkParameterIsNotNull((Object)((Object)unit), (String)"unit");
            ClientData cd = client.getClientData();
            return cd.hasFeature("view-hierarchy") ? new ListViewRootsHandler().getWindows(client, timeout, unit) : null;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

