/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutinspector.parser;

import com.android.layoutinspector.LayoutInspectorCaptureOptions;
import com.android.layoutinspector.model.LayoutFileData;
import com.android.layoutinspector.model.ViewNode;
import com.android.layoutinspector.parser.ViewNodeParser;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.nio.file.Files;
import javax.imageio.ImageIO;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0007\u00a8\u0006\n"}, d2={"Lcom/android/layoutinspector/parser/LayoutFileDataParser;", "", "()V", "parseFromBytes", "Lcom/android/layoutinspector/model/LayoutFileData;", "bytes", "", "parseFromFile", "file", "Ljava/io/File;", "android.sdktools.layoutinspector"})
public final class LayoutFileDataParser {
    public static final LayoutFileDataParser INSTANCE;

    @JvmStatic
    @NotNull
    public static final LayoutFileData parseFromFile(@NotNull File file) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        byte[] byArray = Files.readAllBytes(file.toPath());
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"Files.readAllBytes(file.toPath())");
        return LayoutFileDataParser.parseFromBytes(byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    @NotNull
    public static final LayoutFileData parseFromBytes(@NotNull byte[] bytes) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)bytes, (String)"bytes");
        ViewNode node = null;
        LayoutInspectorCaptureOptions options = new LayoutInspectorCaptureOptions();
        byte[] previewBytes = new byte[]{};
        Closeable closeable = new ObjectInputStream(new ByteArrayInputStream(bytes));
        Throwable throwable = null;
        try {
            ObjectInputStream input = (ObjectInputStream)closeable;
            String string = input.readUTF();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"input.readUTF()");
            options.parse(string);
            byte[] nodeBytes = new byte[input.readInt()];
            input.readFully(nodeBytes);
            node = ViewNodeParser.parse(nodeBytes, options.getVersion());
            if (node == null) {
                throw (Throwable)new IOException("Error parsing view node");
            }
            previewBytes = new byte[input.readInt()];
            input.readFully(previewBytes);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        BufferedImage bufferedImage = ImageIO.read(new ByteArrayInputStream(previewBytes));
        return new LayoutFileData(bufferedImage, node, options);
    }

    private LayoutFileDataParser() {
    }

    static {
        LayoutFileDataParser layoutFileDataParser;
        INSTANCE = layoutFileDataParser = new LayoutFileDataParser();
    }
}

