/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutinspector.parser;

import com.android.layoutinspector.ProtocolVersion;
import com.android.layoutinspector.model.ViewNode;
import com.android.layoutinspector.model.ViewProperty;
import com.android.layoutinspector.parser.DisplayInfoFactory;
import com.android.layoutinspector.parser.ViewNodeParser$WhenMappings;
import com.android.layoutinspector.parser.ViewNodeV2Parser;
import com.android.layoutinspector.parser.ViewPropertyParser;
import com.google.common.base.Charsets;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u001c\u0010\u000b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000fH\u0007J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00042\u0006\u0010\f\u001a\u00020\rH\u0002J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00042\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u0012"}, d2={"Lcom/android/layoutinspector/parser/ViewNodeParser;", "", "()V", "createViewNode", "Lcom/android/layoutinspector/model/ViewNode;", "parent", "data", "", "loadProperties", "", "node", "parse", "bytes", "", "version", "Lcom/android/layoutinspector/ProtocolVersion;", "parseV1ViewNode", "parseV2ViewNode", "android.sdktools.layoutinspector"})
public final class ViewNodeParser {
    public static final ViewNodeParser INSTANCE;

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final ViewNode parse(@NotNull byte[] bytes, @NotNull ProtocolVersion version) throws IOException, StringIndexOutOfBoundsException {
        ViewNode viewNode;
        Intrinsics.checkParameterIsNotNull((Object)bytes, (String)"bytes");
        Intrinsics.checkParameterIsNotNull((Object)((Object)version), (String)"version");
        switch (ViewNodeParser$WhenMappings.$EnumSwitchMapping$0[version.ordinal()]) {
            case 1: {
                viewNode = INSTANCE.parseV1ViewNode(bytes);
                break;
            }
            case 2: {
                viewNode = INSTANCE.parseV2ViewNode(bytes);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return viewNode;
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static /* bridge */ /* synthetic */ ViewNode parse$default(byte[] byArray, ProtocolVersion protocolVersion, int n, Object object) throws IOException, StringIndexOutOfBoundsException {
        if ((n & 2) != 0) {
            protocolVersion = ProtocolVersion.Version1;
        }
        return ViewNodeParser.parse(byArray, protocolVersion);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final ViewNode parse(@NotNull byte[] bytes) throws IOException, StringIndexOutOfBoundsException {
        return ViewNodeParser.parse$default(bytes, null, 2, null);
    }

    private final ViewNode parseV2ViewNode(byte[] bytes) {
        return new ViewNodeV2Parser().parse(bytes);
    }

    /*
     * WARNING - void declaration
     */
    private final ViewNode parseV1ViewNode(byte[] bytes) {
        ViewNode root;
        block10: {
            String line;
            root = null;
            ViewNode lastNode = null;
            int lastWhitespaceCount = Integer.MIN_VALUE;
            Stack<ViewNode> stack = new Stack<ViewNode>();
            BufferedReader input = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(bytes), Charsets.UTF_8));
            Iterator iterator = input.lines().iterator();
            while (iterator.hasNext() && !StringsKt.equals((String)"DONE.", (String)(line = (String)iterator.next()), (boolean)true)) {
                void $receiver$iv;
                int whitespaceCount = 0;
                while (line.charAt(whitespaceCount) == ' ') {
                    ++whitespaceCount;
                }
                if (lastWhitespaceCount < whitespaceCount) {
                    stack.push(lastNode);
                } else if (!stack.isEmpty()) {
                    int count = lastWhitespaceCount - whitespaceCount;
                    int n = 0;
                    int n2 = count;
                    while (n < n2) {
                        void i;
                        stack.pop();
                        ++i;
                    }
                }
                lastWhitespaceCount = whitespaceCount;
                ViewNode parent = null;
                if (!stack.isEmpty()) {
                    parent = (ViewNode)stack.peek();
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)line, (String)"line");
                ViewNode viewNode = parent;
                ViewNodeParser viewNodeParser = this;
                CharSequence $receiver$iv$iv = (CharSequence)$receiver$iv;
                int startIndex$iv$iv = 0;
                int endIndex$iv$iv = $receiver$iv$iv.length() - 1;
                boolean startFound$iv$iv = false;
                while (startIndex$iv$iv <= endIndex$iv$iv) {
                    boolean match$iv$iv;
                    int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                    char it = $receiver$iv$iv.charAt(index$iv$iv);
                    boolean bl = match$iv$iv = it <= ' ';
                    if (!startFound$iv$iv) {
                        if (!match$iv$iv) {
                            startFound$iv$iv = true;
                            continue;
                        }
                        ++startIndex$iv$iv;
                        continue;
                    }
                    if (!match$iv$iv) break;
                    --endIndex$iv$iv;
                }
                String string = ((Object)$receiver$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
                lastNode = viewNodeParser.createViewNode(viewNode, string);
                if (root != null) continue;
                root = lastNode;
            }
            ViewNode viewNode = root;
            if (viewNode == null) break block10;
            viewNode.updateNodeDrawn(true);
        }
        return root;
    }

    /*
     * WARNING - void declaration
     */
    private final ViewNode createViewNode(ViewNode parent, String data) {
        ViewNode node;
        block10: {
            ViewNode viewNode;
            String data2 = data;
            int delimIndex = StringsKt.indexOf$default((CharSequence)data2, (char)'@', (int)0, (boolean)false, (int)6, null);
            if (delimIndex < 0) {
                throw (Throwable)new IllegalArgumentException("Invalid format for ViewNode, missing @: " + data2);
            }
            String string = data2;
            int n = 0;
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(n, delimIndex);
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String name = string3;
            string = data2;
            n = delimIndex + 1;
            String string4 = string;
            if (string4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.substring(n);
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.String).substring(startIndex)");
            data2 = string5;
            delimIndex = StringsKt.indexOf$default((CharSequence)data2, (char)' ', (int)0, (boolean)false, (int)6, null);
            String string6 = data2;
            int n2 = 0;
            String string7 = string6;
            if (string7 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string8 = string7.substring(n2, delimIndex);
            Intrinsics.checkExpressionValueIsNotNull((Object)string8, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String hash = string8;
            node = new ViewNode(parent, name, hash);
            node.setIndex(parent == null ? 0 : parent.getChildren().size());
            if (data2.length() > delimIndex + 1) {
                void $receiver$iv;
                String string9;
                String string10 = data2;
                int n3 = delimIndex + 1;
                ViewNode viewNode2 = node;
                ViewNodeParser viewNodeParser = this;
                String string11 = string10;
                if (string11 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string12 = string11.substring(n3);
                Intrinsics.checkExpressionValueIsNotNull((Object)string12, (String)"(this as java.lang.String).substring(startIndex)");
                string10 = string9 = string12;
                CharSequence $receiver$iv$iv = (CharSequence)$receiver$iv;
                int startIndex$iv$iv = 0;
                int endIndex$iv$iv = $receiver$iv$iv.length() - 1;
                boolean startFound$iv$iv = false;
                while (startIndex$iv$iv <= endIndex$iv$iv) {
                    boolean match$iv$iv;
                    int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                    char it = $receiver$iv$iv.charAt(index$iv$iv);
                    boolean bl = match$iv$iv = it <= ' ';
                    if (!startFound$iv$iv) {
                        if (!match$iv$iv) {
                            startFound$iv$iv = true;
                            continue;
                        }
                        ++startIndex$iv$iv;
                        continue;
                    }
                    if (!match$iv$iv) break;
                    --endIndex$iv$iv;
                }
                string9 = ((Object)$receiver$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
                viewNodeParser.loadProperties(viewNode2, string9);
                ViewProperty viewProperty = node.getProperty("mID", "id");
                if (viewProperty == null) {
                    Intrinsics.throwNpe();
                }
                node.setId(viewProperty.getValue());
            }
            node.setDisplayInfo(DisplayInfoFactory.INSTANCE.createDisplayInfoFromNode(node));
            ViewNode viewNode3 = parent;
            if (viewNode3 == null) break block10;
            ViewNode it = viewNode = viewNode3;
            it.getChildren().add(node);
        }
        return node;
    }

    private final void loadProperties(ViewNode node, String data) {
        boolean stop;
        int start = 0;
        do {
            String value;
            String fullName;
            String string;
            int index = StringsKt.indexOf$default((CharSequence)data, (char)'=', (int)start, (boolean)false, (int)4, null);
            String string2 = string = data;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)string2.substring(start, index), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            int index2 = StringsKt.indexOf$default((CharSequence)data, (char)',', (int)(index + 1), (boolean)false, (int)4, null);
            String string3 = data;
            int n = index + 1;
            String string4 = string3;
            if (string4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.substring(n, index2);
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            int length = Integer.parseInt(string5);
            start = index2 + 1 + length;
            String string6 = data;
            int n2 = index2 + 1;
            int n3 = index2 + 1 + length;
            String string7 = string6;
            if (string7 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)string7.substring(n2, n3), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            ViewProperty property = ViewPropertyParser.INSTANCE.parse(fullName, value);
            node.getProperties().add(property);
            Map<String, ViewProperty> map = node.getNamedProperties();
            String string8 = property.getFullName();
            ViewProperty viewProperty = property;
            map.put(string8, viewProperty);
            node.addPropertyToGroup(property);
            boolean bl = stop = start >= data.length();
            if (stop) continue;
            ++start;
        } while (!stop);
        CollectionsKt.sort(node.getProperties());
    }

    private ViewNodeParser() {
    }

    static {
        ViewNodeParser viewNodeParser;
        INSTANCE = viewNodeParser = new ViewNodeParser();
    }
}

