/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ir.client;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.CollectingOutputReceiver;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.SyncException;
import com.android.ddmlib.TimeoutException;
import com.android.tools.ir.client.AppState;
import com.android.tools.ir.client.ApplicationPatchUtil;
import com.android.tools.ir.client.Communicator;
import com.android.tools.ir.client.InstantRunArtifact;
import com.android.tools.ir.client.InstantRunArtifactType;
import com.android.tools.ir.client.InstantRunBuildInfo;
import com.android.tools.ir.client.InstantRunPushFailedException;
import com.android.tools.ir.client.ServiceCommunicator;
import com.android.tools.ir.client.UpdateMode;
import com.android.tools.ir.runtime.ApplicationPatch;
import com.android.tools.ir.runtime.Paths;
import com.android.utils.ILogger;
import com.android.utils.NullLogger;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;

public class InstantRunClient {
    private static final int DEFAULT_LOCAL_PORT = 46622;
    private final String mPackageName;
    private final ILogger mLogger;
    private final long mToken;
    private final ServiceCommunicator mAppService;
    public static final int TRANSFER_MODE_HOTSWAP = 3;
    public static final int TRANSFER_MODE_RESOURCES = 4;

    public InstantRunClient(String packageName, ILogger logger, long token) {
        this(packageName, logger, token, 46622);
    }

    @VisibleForTesting
    public InstantRunClient(String packageName, ILogger logger, long token, int port) {
        this.mAppService = new ServiceCommunicator(packageName, logger, port);
        this.mPackageName = packageName;
        this.mLogger = logger;
        this.mToken = token;
    }

    private static File createTempFile(String prefix, String suffix) throws IOException {
        File file = File.createTempFile(prefix, suffix);
        file.deleteOnExit();
        return file;
    }

    public AppState getAppState(IDevice device) throws IOException {
        return this.mAppService.talkToService(device, new Communicator<AppState>(){

            @Override
            public AppState communicate(DataInputStream input, DataOutputStream output) throws IOException {
                output.writeInt(2);
                boolean foreground = input.readBoolean();
                InstantRunClient.this.mLogger.info("Ping sent and replied successfully, application seems to be running. Foreground=" + foreground, new Object[0]);
                return foreground ? AppState.FOREGROUND : AppState.BACKGROUND;
            }
        });
    }

    public void showToast(IDevice device, final String message2) throws IOException {
        this.mAppService.talkToService(device, new Communicator<Boolean>(){

            @Override
            public Boolean communicate(DataInputStream input, DataOutputStream output) throws IOException {
                output.writeInt(6);
                output.writeUTF(message2);
                return false;
            }
        });
    }

    public void restartActivity(IDevice device) throws IOException {
        AppState appState = this.getAppState(device);
        if (appState == AppState.FOREGROUND || appState == AppState.BACKGROUND) {
            this.mAppService.talkToService(device, new Communicator<Void>(){

                @Override
                public Void communicate(DataInputStream input, DataOutputStream output) throws IOException {
                    output.writeInt(5);
                    InstantRunClient.this.writeToken(output);
                    return null;
                }
            });
        }
    }

    public UpdateMode pushPatches(IDevice device, InstantRunBuildInfo buildInfo, UpdateMode updateMode, boolean isRestartActivity, boolean isShowToastEnabled) throws InstantRunPushFailedException, IOException {
        boolean needRestart;
        boolean appRunning;
        boolean appInForeground;
        if (!buildInfo.canHotswap()) {
            updateMode = updateMode.combine(UpdateMode.COLD_SWAP);
        }
        ArrayList files = Lists.newArrayList();
        try {
            AppState appState = this.getAppState(device);
            appInForeground = appState == AppState.FOREGROUND;
            appRunning = appState == AppState.FOREGROUND || appState == AppState.BACKGROUND;
        }
        catch (IOException e) {
            appRunning = false;
            appInForeground = false;
        }
        List<InstantRunArtifact> artifacts = buildInfo.getArtifacts();
        this.mLogger.info("Artifacts from build-info.xml: " + Joiner.on((String)"-").join(artifacts), new Object[0]);
        block11: for (InstantRunArtifact artifact : artifacts) {
            InstantRunArtifactType type = artifact.type;
            Object file = artifact.file;
            switch (type) {
                case MAIN: {
                    assert (false) : artifact;
                    continue block11;
                }
                case SPLIT_MAIN: {
                    continue block11;
                }
                case SPLIT: {
                    continue block11;
                }
                case RESOURCES: {
                    updateMode = updateMode.combine(UpdateMode.WARM_SWAP);
                    files.add(FileTransfer.createResourceFile((File)file));
                    continue block11;
                }
                case RELOAD_DEX: {
                    if (appInForeground) {
                        files.add(FileTransfer.createHotswapPatch((File)file));
                        continue block11;
                    }
                    if (buildInfo.hasOneOf(InstantRunArtifactType.SPLIT)) continue block11;
                    throw new InstantRunPushFailedException("Can't apply hot swap patch: app is no longer running");
                }
            }
            assert (false) : artifact;
        }
        if (appRunning) {
            ArrayList<ApplicationPatch> changes = new ArrayList<ApplicationPatch>(files.size());
            for (Object file : files) {
                try {
                    changes.add(((FileTransfer)file).getPatch());
                }
                catch (IOException e) {
                    throw new InstantRunPushFailedException("Could not read file " + file);
                }
            }
            updateMode = this.pushPatches(device, buildInfo.getTimeStamp(), changes, updateMode, isRestartActivity, isShowToastEnabled);
            needRestart = false;
            if (!appInForeground || !buildInfo.canHotswap()) {
                this.stopApp(device, false);
                needRestart = true;
            }
        } else {
            return UpdateMode.COLD_SWAP;
        }
        this.logFilesPushed(files, needRestart);
        if (needRestart) {
            return UpdateMode.COLD_SWAP;
        }
        return updateMode;
    }

    public UpdateMode pushPatches(IDevice device, String buildId, final List<ApplicationPatch> changes, UpdateMode updateMode, boolean isRestartActivity, final boolean isShowToastEnabled) throws IOException {
        if (changes.isEmpty() || updateMode == UpdateMode.NO_CHANGES) {
            this.transferLocalIdToDeviceId(device, buildId);
            return UpdateMode.NO_CHANGES;
        }
        if (updateMode == UpdateMode.HOT_SWAP && isRestartActivity) {
            updateMode = updateMode.combine(UpdateMode.WARM_SWAP);
        }
        final UpdateMode updateMode1 = updateMode;
        this.mAppService.talkToService(device, new Communicator<Boolean>(){

            @Override
            public Boolean communicate(DataInputStream input, DataOutputStream output) throws IOException {
                output.writeInt(1);
                InstantRunClient.this.writeToken(output);
                ApplicationPatchUtil.write(output, changes, updateMode1);
                output.writeBoolean(isShowToastEnabled);
                input.readBoolean();
                return false;
            }

            @Override
            int getTimeout() {
                return 8000;
            }
        });
        this.transferLocalIdToDeviceId(device, buildId);
        return updateMode;
    }

    public void transferLocalIdToDeviceId(IDevice device, String buildId) {
        InstantRunClient.transferBuildIdToDevice(device, buildId, this.mPackageName, this.mLogger);
    }

    public static void transferBuildIdToDevice(IDevice device, String buildId, String pkgName, ILogger logger) {
        if (logger == null) {
            logger = new NullLogger();
        }
        long unused = 0L;
        InstantRunClient client = new InstantRunClient(pkgName, logger, 0L);
        client.transferBuildIdToDevice(device, buildId);
    }

    private void transferBuildIdToDevice(IDevice device, String buildId) {
        try {
            String remoteIdFile = Paths.getDeviceIdFolder(this.mPackageName);
            File local = File.createTempFile("build-id", "txt");
            local.deleteOnExit();
            Files.write((CharSequence)buildId, (File)local, (Charset)Charsets.UTF_8);
            device.pushFile(local.getPath(), remoteIdFile);
        }
        catch (IOException ioe) {
            this.mLogger.warning("Couldn't write build id file: %s", new Object[]{ioe});
        }
        catch (AdbCommandRejectedException | SyncException | TimeoutException e) {
            this.mLogger.warning("%s", new Object[]{Throwables.getStackTraceAsString((Throwable)e)});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDeviceBuildTimestamp(IDevice device, String packageName, ILogger logger) {
        block9: {
            String string;
            String remoteIdFile2 = Paths.getDeviceIdFolder(packageName);
            File localIdFile = InstantRunClient.createTempFile("build-id", "txt");
            try {
                device.pullFile(remoteIdFile2, localIdFile.getPath());
                string = Files.toString((File)localIdFile, (Charset)Charsets.UTF_8).trim();
                localIdFile.delete();
            }
            catch (SyncException ignore) {
                String string2;
                try {
                    string2 = null;
                    localIdFile.delete();
                }
                catch (Throwable throwable) {
                    try {
                        localIdFile.delete();
                        throw throwable;
                    }
                    catch (IOException remoteIdFile2) {
                        break block9;
                    }
                    catch (AdbCommandRejectedException | TimeoutException e) {
                        logger.warning("%s", new Object[]{Throwables.getStackTraceAsString((Throwable)e)});
                    }
                }
                return string2;
            }
            return string;
        }
        return null;
    }

    private void writeToken(DataOutputStream output) throws IOException {
        output.writeLong(this.mToken);
    }

    public void stopApp(IDevice device, boolean sendChangeBroadcast) throws InstantRunPushFailedException {
        try {
            this.runCommand(device, "am force-stop " + this.mPackageName);
        }
        catch (Throwable t) {
            throw new InstantRunPushFailedException("Exception while stopping app: " + t);
        }
        if (sendChangeBroadcast) {
            try {
                this.runCommand(device, "am broadcast -a android.intent.action.PACKAGE_CHANGED -p " + this.mPackageName);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private boolean runCommand(IDevice device, String cmd) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        String output = InstantRunClient.getCommandOutput(device, cmd).trim();
        if (!output.isEmpty()) {
            this.mLogger.warning("Unexpected shell output for " + cmd + ": " + output, new Object[0]);
            return false;
        }
        return true;
    }

    private static String getCommandOutput(IDevice device, String cmd) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        CollectingOutputReceiver receiver = new CollectingOutputReceiver();
        device.executeShellCommand(cmd, receiver);
        return receiver.getOutput();
    }

    private void logFilesPushed(List<FileTransfer> files, boolean needRestart) {
        StringBuilder sb = new StringBuilder("Pushing files: ");
        if (needRestart) {
            sb.append("(needs restart) ");
        }
        sb.append('[');
        String separator = "";
        for (FileTransfer file : files) {
            sb.append(separator);
            sb.append(file.source.getName());
            sb.append(" as ");
            sb.append(file.name);
            separator = ", ";
        }
        sb.append(']');
        this.mLogger.info(sb.toString(), new Object[0]);
    }

    public static class FileTransfer {
        public final int mode;
        public final File source;
        public final String name;

        public FileTransfer(int mode, File source, String name) {
            this.mode = mode;
            this.source = source;
            this.name = name;
        }

        public static FileTransfer createResourceFile(File source) {
            return new FileTransfer(4, source, "resources.ap_");
        }

        public static FileTransfer createHotswapPatch(File source) {
            return new FileTransfer(3, source, "classes.dex.3");
        }

        public ApplicationPatch getPatch() throws IOException {
            String path2;
            byte[] bytes = Files.toByteArray((File)this.source);
            switch (this.mode) {
                case 3: 
                case 4: {
                    path2 = this.name;
                    break;
                }
                default: {
                    throw new IllegalArgumentException(Integer.toString(this.mode));
                }
            }
            return new ApplicationPatch(path2, bytes);
        }

        public String toString() {
            return this.source + " as " + this.name + " with mode " + this.mode;
        }
    }
}

