/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiMethod;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u00012\u00020\u0002:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005H\u0016J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/lint/checks/AddJavascriptInterfaceDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "getApplicableMethodNames", "", "", "visitMethod", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "node", "Lorg/jetbrains/uast/UCallExpression;", "method", "Lcom/intellij/psi/PsiMethod;", "Companion", "android.sdktools.lint-checks"})
public final class AddJavascriptInterfaceDetector
extends Detector
implements SourceCodeScanner {
    @JvmField
    @NotNull
    public static final Issue ISSUE;
    @NotNull
    public static final String WEB_VIEW = "android.webkit.WebView";
    @NotNull
    public static final String ADD_JAVASCRIPT_INTERFACE = "addJavascriptInterface";
    public static final Companion Companion;

    @Override
    @Nullable
    public List<String> getApplicableMethodNames() {
        return CollectionsKt.listOf((Object)ADD_JAVASCRIPT_INTERFACE);
    }

    @Override
    public void visitMethod(@NotNull JavaContext context2, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
        if (context2.getMainProject().getMinSdk() >= 17) {
            return;
        }
        JavaEvaluator evaluator = context2.getEvaluator();
        if (!evaluator.methodMatches(method, WEB_VIEW, true, "java.lang.Object", "java.lang.String")) {
            return;
        }
        String message2 = "`WebView.addJavascriptInterface` should not be called with minSdkVersion < 17 for security reasons: JavaScript can use reflection to manipulate application";
        JavaContext.report$default(context2, ISSUE, (UElement)node, context2.getNameLocation((UElement)node), message2, null, 16, null);
    }

    static {
        Companion = new Companion(null);
        boolean bl = false;
        Implementation implementation = new Implementation(AddJavascriptInterfaceDetector.class, Scope.JAVA_FILE_SCOPE);
        Severity severity = Severity.WARNING;
        int n = 9;
        Category category = Category.SECURITY;
        String string = "https://labs.mwrinfosecurity.com/blog/2013/09/24/webview-addjavascriptinterface-remote-code-execution/";
        ISSUE = Issue.Companion.create$default(Issue.Companion, "AddJavascriptInterface", "addJavascriptInterface Called", "\n            For applications built for API levels below 17, `WebView#addJavascriptInterface` presents a \\\n            security hazard as JavaScript on the target web page has the ability to use reflection to access \\\n            the injected object's public fields and thus manipulate the host application in unintended ways.\n            ", implementation, string, category, n, severity, bl, 256, null);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/android/tools/lint/checks/AddJavascriptInterfaceDetector$Companion;", "", "()V", "ADD_JAVASCRIPT_INTERFACE", "", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "WEB_VIEW", "android.sdktools.lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

