/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.sdklib.AndroidVersion;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ConstantEvaluator;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.google.common.collect.Sets;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.UQualifiedReferenceExpression;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00172\u00020\u00012\u00020\u0002:\u0001\u0017B\u0005\u00a2\u0006\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J0\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\u0013H\u0016J \u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016\u00a8\u0006\u0018"}, d2={"Lcom/android/tools/lint/checks/CipherGetInstanceDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "checkProvider", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "call", "Lorg/jetbrains/uast/UCallExpression;", "node", "Lorg/jetbrains/uast/UElement;", "provider", "", "checkTransformation", "transformation", "includeValue", "", "getApplicableMethodNames", "", "visitMethod", "method", "Lcom/intellij/psi/PsiMethod;", "Companion", "android.sdktools.lint-checks"})
public final class CipherGetInstanceDetector
extends Detector
implements SourceCodeScanner {
    @JvmField
    @NotNull
    public static final Issue ISSUE;
    @JvmField
    @NotNull
    public static final Issue DEPRECATED_PROVIDER;
    private static final String JAVAX_CRYPTO_CIPHER = "javax.crypto.Cipher";
    private static final String GET_INSTANCE = "getInstance";
    private static final HashSet<String> ALGORITHM_ONLY;
    public static final Companion Companion;

    @Override
    @Nullable
    public List<String> getApplicableMethodNames() {
        return CollectionsKt.listOf((Object)GET_INSTANCE);
    }

    @Override
    public void visitMethod(@NotNull JavaContext context2, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        UExpression expression;
        Object transformation;
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
        if (!context2.getEvaluator().isMemberInSubClassOf((PsiMember)method, JAVAX_CRYPTO_CIPHER, false)) {
            return;
        }
        List arguments = node.getValueArguments();
        Collection collection = arguments;
        if (!collection.isEmpty() && (transformation = ConstantEvaluator.evaluate(context2, (UElement)(expression = (UExpression)arguments.get(0)))) instanceof String) {
            this.checkTransformation(context2, node, (UElement)expression, (String)transformation, !(expression instanceof ULiteralExpression));
        }
        if (arguments.size() == 2) {
            UExpression selector;
            expression = (UExpression)arguments.get(1);
            Object provider = ConstantEvaluator.evaluate(context2, (UElement)expression);
            if (provider instanceof String) {
                this.checkProvider(context2, node, (UElement)expression, (String)provider);
            } else if (expression instanceof UQualifiedReferenceExpression && (selector = ((UQualifiedReferenceExpression)expression).getSelector()) instanceof UCallExpression) {
                Object nestedProvider;
                List args;
                PsiMethod getProvider;
                PsiMethod psiMethod = getProvider = ((UCallExpression)selector).resolve();
                if (Intrinsics.areEqual((Object)(psiMethod != null ? psiMethod.getName() : null), (Object)"getProvider") && (args = ((UCallExpression)selector).getValueArguments()).size() == 1 && (nestedProvider = ConstantEvaluator.evaluate(context2, (UElement)args.get(0))) instanceof String) {
                    this.checkProvider(context2, node, (UElement)expression, (String)nestedProvider);
                }
            }
        }
    }

    private final void checkTransformation(JavaContext context2, UCallExpression call, UElement node, String transformation, boolean includeValue) {
        if (CipherGetInstanceDetector.Companion.getALGORITHM_ONLY().contains(transformation)) {
            String message2 = "`Cipher.getInstance` should not be called without setting the encryption mode and padding";
            JavaContext.report$default(context2, ISSUE, (UElement)call, context2.getLocation(node), message2, null, 16, null);
        } else if ((StringsKt.contains$default((CharSequence)transformation, (CharSequence)"/ECB/", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)transformation, (String)"/ECB", (boolean)false, (int)2, null)) && !StringsKt.startsWith$default((String)transformation, (String)"RSA/", (boolean)false, (int)2, null)) {
            String message3 = "ECB encryption mode should not be used";
            if (includeValue) {
                message3 = message3 + " (was \"" + transformation + "\")";
            }
            JavaContext.report$default(context2, ISSUE, (UElement)call, context2.getLocation(node), message3, null, 16, null);
        }
    }

    private final void checkProvider(JavaContext context2, UCallExpression call, UElement node, String provider) {
        if (Intrinsics.areEqual((Object)provider, (Object)"BC")) {
            StringBuilder stringBuilder = new StringBuilder();
            AndroidVersion androidVersion = context2.getMainProject().getTargetSdkVersion();
            Intrinsics.checkExpressionValueIsNotNull((Object)androidVersion, (String)"context.mainProject.targetSdkVersion");
            String message2 = stringBuilder.append(androidVersion.getFeatureLevel() >= 28 ? "The `BC` provider is deprecated and as of Android P this method will throw a `NoSuchAlgorithmException`." : "The `BC` provider is deprecated and when `targetSdkVersion` is moved to `P` this method will throw a `NoSuchAlgorithmException`.").append(" To fix ").append("this you should stop specifying a provider and use the default ").append("implementation").toString();
            JavaContext.report$default(context2, ISSUE, (UElement)call, context2.getLocation(node), message2, null, 16, null);
        }
    }

    static {
        Companion = new Companion(null);
        ISSUE = Issue.Companion.create("GetInstance", "Cipher.getInstance with ECB", "\n                `Cipher#getInstance` should not be called with ECB as the cipher mode or \\\n                without setting the cipher mode because the default mode on android is \\\n                ECB, which is insecure.", Category.SECURITY, 9, Severity.WARNING, new Implementation(CipherGetInstanceDetector.class, Scope.JAVA_FILE_SCOPE));
        boolean bl = false;
        Implementation implementation = new Implementation(CipherGetInstanceDetector.class, Scope.JAVA_FILE_SCOPE);
        Severity severity = Severity.WARNING;
        int n = 9;
        Category category = Category.SECURITY;
        String string = "https://android-developers.googleblog.com/2018/03/cryptography-changes-in-android-p.html";
        DEPRECATED_PROVIDER = Issue.Companion.create$default(Issue.Companion, "DeprecatedProvider", "Using BC Provider", "\n            The `BC` provider has been deprecated and will not be provided when `targetSdkVersion` is P or higher.\n            ", implementation, string, category, n, severity, bl, 256, null);
        ALGORITHM_ONLY = Sets.newHashSet((Object[])new String[]{"AES", "DES", "DESede"});
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R8\u0010\u0003\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005 \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0010\u0010\t\u001a\u00020\n8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00020\n8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/android/tools/lint/checks/CipherGetInstanceDetector$Companion;", "", "()V", "ALGORITHM_ONLY", "Ljava/util/HashSet;", "", "kotlin.jvm.PlatformType", "getALGORITHM_ONLY", "()Ljava/util/HashSet;", "DEPRECATED_PROVIDER", "Lcom/android/tools/lint/detector/api/Issue;", "GET_INSTANCE", "ISSUE", "JAVAX_CRYPTO_CIPHER", "android.sdktools.lint-checks"})
    public static final class Companion {
        private final HashSet<String> getALGORITHM_ONLY() {
            return ALGORITHM_ONLY;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

