/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.DataFlowAnalyzer;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.google.common.collect.Lists;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.uast.UBinaryExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UDoWhileExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UIdentifier;
import org.jetbrains.uast.UIfExpression;
import org.jetbrains.uast.ULambdaExpression;
import org.jetbrains.uast.ULocalVariable;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UPolyadicExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UResolvable;
import org.jetbrains.uast.UReturnExpression;
import org.jetbrains.uast.UUnaryExpression;
import org.jetbrains.uast.UVariable;
import org.jetbrains.uast.UWhileExpression;
import org.jetbrains.uast.UastCallKind;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.util.UastExpressionUtils;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

public class CleanupDetector
extends Detector
implements SourceCodeScanner {
    private static final Implementation IMPLEMENTATION = new Implementation(CleanupDetector.class, Scope.JAVA_FILE_SCOPE);
    public static final Issue RECYCLE_RESOURCE = Issue.create("Recycle", "Missing `recycle()` calls", "Many resources, such as TypedArrays, VelocityTrackers, etc., should be recycled (with a `recycle()` call) after use. This lint check looks for missing `recycle()` calls.", Category.PERFORMANCE, 7, Severity.WARNING, IMPLEMENTATION);
    public static final Issue COMMIT_FRAGMENT = Issue.create("CommitTransaction", "Missing `commit()` calls", "After creating a `FragmentTransaction`, you typically need to commit it as well", Category.CORRECTNESS, 7, Severity.WARNING, IMPLEMENTATION);
    public static final Issue SHARED_PREF = Issue.create("CommitPrefEdits", "Missing `commit()` on `SharedPreference` editor", "After calling `edit()` on a `SharedPreference`, you must call `commit()` or `apply()` on the editor to save the results.", Category.CORRECTNESS, 6, Severity.WARNING, new Implementation(CleanupDetector.class, Scope.JAVA_FILE_SCOPE));
    public static final Issue APPLY_SHARED_PREF = Issue.create("ApplySharedPref", "Use `apply()` on `SharedPreferences`", "Consider using `apply()` instead of `commit` on shared preferences. Whereas `commit` blocks and writes its data to persistent storage immediately, `apply` will handle it in the background.", Category.CORRECTNESS, 6, Severity.WARNING, new Implementation(CleanupDetector.class, Scope.JAVA_FILE_SCOPE));
    private static final String RECYCLE = "recycle";
    private static final String RELEASE = "release";
    private static final String OBTAIN = "obtain";
    private static final String SHOW = "show";
    private static final String ACQUIRE_CPC = "acquireContentProviderClient";
    private static final String OBTAIN_NO_HISTORY = "obtainNoHistory";
    private static final String OBTAIN_ATTRIBUTES = "obtainAttributes";
    private static final String OBTAIN_TYPED_ARRAY = "obtainTypedArray";
    private static final String OBTAIN_STYLED_ATTRIBUTES = "obtainStyledAttributes";
    private static final String BEGIN_TRANSACTION = "beginTransaction";
    private static final String COMMIT = "commit";
    private static final String COMMIT_NOW = "commitNow";
    private static final String APPLY = "apply";
    private static final String COMMIT_ALLOWING_LOSS = "commitAllowingStateLoss";
    private static final String COMMIT_NOW_ALLOWING_LOSS = "commitNowAllowingStateLoss";
    private static final String QUERY = "query";
    private static final String RAW_QUERY = "rawQuery";
    private static final String QUERY_WITH_FACTORY = "queryWithFactory";
    private static final String RAW_QUERY_WITH_FACTORY = "rawQueryWithFactory";
    private static final String CLOSE = "close";
    private static final String EDIT = "edit";
    public static final String MOTION_EVENT_CLS = "android.view.MotionEvent";
    private static final String PARCEL_CLS = "android.os.Parcel";
    private static final String VELOCITY_TRACKER_CLS = "android.view.VelocityTracker";
    private static final String DIALOG_FRAGMENT = "android.app.DialogFragment";
    private static final String DIALOG_V4_FRAGMENT = "android.support.v4.app.DialogFragment";
    private static final String FRAGMENT_MANAGER_CLS = "android.app.FragmentManager";
    private static final String FRAGMENT_MANAGER_V4_CLS = "android.support.v4.app.FragmentManager";
    private static final String FRAGMENT_TRANSACTION_CLS = "android.app.FragmentTransaction";
    private static final String FRAGMENT_TRANSACTION_V4_CLS = "android.support.v4.app.FragmentTransaction";
    public static final String SURFACE_CLS = "android.view.Surface";
    public static final String SURFACE_TEXTURE_CLS = "android.graphics.SurfaceTexture";
    public static final String CONTENT_PROVIDER_CLIENT_CLS = "android.content.ContentProviderClient";
    public static final String CONTENT_RESOLVER_CLS = "android.content.ContentResolver";
    public static final String SQLITE_DATABASE_CLS = "android.database.sqlite.SQLiteDatabase";
    public static final String CURSOR_CLS = "android.database.Cursor";
    public static final String ANDROID_CONTENT_SHARED_PREFERENCES = "android.content.SharedPreferences";
    private static final String ANDROID_CONTENT_SHARED_PREFERENCES_EDITOR = "android.content.SharedPreferences.Editor";
    private static final boolean USE_NEW_DATA_FLOW_ANALYZER = true;

    @Override
    public List<String> getApplicableMethodNames() {
        return Arrays.asList(BEGIN_TRANSACTION, OBTAIN, OBTAIN_NO_HISTORY, OBTAIN_STYLED_ATTRIBUTES, OBTAIN_ATTRIBUTES, OBTAIN_TYPED_ARRAY, ACQUIRE_CPC, QUERY, RAW_QUERY, QUERY_WITH_FACTORY, RAW_QUERY_WITH_FACTORY, EDIT);
    }

    @Override
    public List<String> getApplicableConstructorTypes() {
        return Arrays.asList(SURFACE_TEXTURE_CLS, SURFACE_CLS);
    }

    @Override
    public void visitMethod(JavaContext context2, UCallExpression call, PsiMethod method) {
        String name = method.getName();
        if (BEGIN_TRANSACTION.equals(name)) {
            CleanupDetector.checkTransactionCommits(context2, call, method);
        } else if (EDIT.equals(name)) {
            this.checkEditorApplied(context2, call, method);
        } else {
            CleanupDetector.checkResourceRecycled(context2, call, method);
        }
    }

    @Override
    public void visitConstructor(JavaContext context2, UCallExpression node, PsiMethod constructor) {
        String type;
        PsiClass containingClass = constructor.getContainingClass();
        if (containingClass != null && (type = containingClass.getQualifiedName()) != null) {
            CleanupDetector.checkRecycled(context2, node, type, RELEASE);
        }
    }

    private static void checkResourceRecycled(JavaContext context2, UCallExpression node, PsiMethod method) {
        String name = method.getName();
        PsiClass containingClass = method.getContainingClass();
        if (containingClass == null) {
            return;
        }
        JavaEvaluator evaluator = context2.getEvaluator();
        if ((OBTAIN.equals(name) || OBTAIN_NO_HISTORY.equals(name)) && evaluator.extendsClass(containingClass, MOTION_EVENT_CLS, false)) {
            CleanupDetector.checkRecycled(context2, node, MOTION_EVENT_CLS, RECYCLE);
        } else if (OBTAIN.equals(name) && evaluator.extendsClass(containingClass, PARCEL_CLS, false)) {
            CleanupDetector.checkRecycled(context2, node, PARCEL_CLS, RECYCLE);
        } else if (OBTAIN.equals(name) && evaluator.extendsClass(containingClass, VELOCITY_TRACKER_CLS, false)) {
            CleanupDetector.checkRecycled(context2, node, VELOCITY_TRACKER_CLS, RECYCLE);
        } else if ((OBTAIN_STYLED_ATTRIBUTES.equals(name) || OBTAIN_ATTRIBUTES.equals(name) || OBTAIN_TYPED_ARRAY.equals(name)) && (evaluator.extendsClass(containingClass, "android.content.Context", false) || evaluator.extendsClass(containingClass, "android.content.res.Resources", false))) {
            PsiClass cls;
            PsiType returnType = method.getReturnType();
            if (returnType instanceof PsiClassType && (cls = ((PsiClassType)returnType).resolve()) != null && "android.content.res.TypedArray".equals(cls.getQualifiedName())) {
                CleanupDetector.checkRecycled(context2, node, "android.content.res.TypedArray", RECYCLE);
            }
        } else if (ACQUIRE_CPC.equals(name) && evaluator.extendsClass(containingClass, CONTENT_RESOLVER_CLS, false)) {
            CleanupDetector.checkRecycled(context2, node, CONTENT_PROVIDER_CLIENT_CLS, RELEASE);
        } else if ((QUERY.equals(name) || RAW_QUERY.equals(name) || QUERY_WITH_FACTORY.equals(name) || RAW_QUERY_WITH_FACTORY.equals(name)) && (evaluator.extendsClass(containingClass, SQLITE_DATABASE_CLS, false) || evaluator.extendsClass(containingClass, CONTENT_RESOLVER_CLS, false) || evaluator.extendsClass(containingClass, "android.content.ContentProvider", false) || evaluator.extendsClass(containingClass, CONTENT_PROVIDER_CLIENT_CLS, false))) {
            for (UCallExpression curr = node; curr != null; curr = curr.getUastParent()) {
                PsiElement psi = curr.getPsi();
                if (psi == null) continue;
                if (PsiTreeUtil.getParentOfType((PsiElement)psi, PsiResourceVariable.class) == null) break;
                return;
            }
            CleanupDetector.checkRecycled(context2, node, CURSOR_CLS, CLOSE);
        }
    }

    private static void checkRecycled(final JavaContext context2, UCallExpression node, final String recycleType, final String recycleName) {
        UMethod method = (UMethod)UastUtils.getParentOfType((UElement)node, UMethod.class, (boolean)true);
        if (method == null) {
            return;
        }
        final AtomicBoolean recycled = new AtomicBoolean(false);
        final AtomicBoolean escapes = new AtomicBoolean(false);
        DataFlowAnalyzer visitor = new DataFlowAnalyzer(Collections.singleton(node), Collections.emptyList()){

            @Override
            public void receiver(UCallExpression call) {
                if (this.isCleanup(call)) {
                    recycled.set(true);
                }
                super.receiver(call);
            }

            private boolean isCleanup(UCallExpression call) {
                String methodName = Lint.getMethodName(call);
                if ("use".equals(methodName) && CleanupDetector.CLOSE.equals(recycleName)) {
                    PsiElement resolved;
                    UExpression operand = call.getReceiver();
                    if (this.getInstances().contains(operand)) {
                        return true;
                    }
                    if (operand instanceof UResolvable && (resolved = ((UResolvable)operand).resolve()) != null && this.getReferences().contains(resolved)) {
                        return true;
                    }
                }
                if (!recycleName.equals(methodName)) {
                    return false;
                }
                PsiMethod method = call.resolve();
                if (method != null) {
                    PsiClass containingClass = method.getContainingClass();
                    return context2.getEvaluator().extendsClass(containingClass, recycleType, false);
                }
                return false;
            }

            @Override
            public void field(UElement field) {
                escapes.set(true);
            }

            @Override
            public void argument(UCallExpression call, UElement reference) {
                PsiMethod resolved;
                if (recycleType.equals(CleanupDetector.SURFACE_TEXTURE_CLS) && UastExpressionUtils.isConstructorCall((UElement)call) && (resolved = call.resolve()) != null && context2.getEvaluator().isMemberInClass((PsiMember)resolved, CleanupDetector.SURFACE_CLS)) {
                    return;
                }
                if (CleanupDetector.OBTAIN.equals(Lint.getMethodName(call))) {
                    PsiMethod method = call.resolve();
                    if (context2.getEvaluator().isMemberInClass((PsiMember)method, CleanupDetector.MOTION_EVENT_CLS)) {
                        return;
                    }
                }
                escapes.set(true);
            }

            @Override
            public void returns(UReturnExpression expression) {
                escapes.set(true);
            }
        };
        method.accept((UastVisitor)visitor);
        if (!recycled.get() && !escapes.get()) {
            String className = recycleType.substring(recycleType.lastIndexOf(46) + 1);
            String message2 = RECYCLE.equals(recycleName) ? String.format("This `%1$s` should be recycled after use with `#recycle()`", className) : String.format("This `%1$s` should be freed up after use with `#%2$s()`", className, recycleName);
            UIdentifier locationNode = node.getMethodIdentifier();
            if (locationNode == null) {
                locationNode = node;
            }
            Location location = context2.getLocation((UElement)locationNode);
            context2.report(RECYCLE_RESOURCE, (UElement)node, location, message2);
        }
    }

    private static void checkRecycledOld(JavaContext context2, UCallExpression node, final String recycleType, final String recycleName) {
        PsiVariable boundVariable = CleanupDetector.getVariableElement(node);
        if (boundVariable == null) {
            return;
        }
        UMethod method = (UMethod)UastUtils.getParentOfType((UElement)node, UMethod.class, (boolean)true);
        if (method == null) {
            return;
        }
        FinishVisitor visitor = new FinishVisitor(context2, boundVariable){

            @Override
            protected boolean isCleanupCall(UCallExpression call) {
                PsiElement resolved;
                UExpression operand;
                String methodName = Lint.getMethodName(call);
                if ("use".equals(methodName) && CleanupDetector.CLOSE.equals(recycleName) && (operand = call.getReceiver()) instanceof UResolvable && (resolved = ((UResolvable)operand).resolve()) != null && this.mVariables.contains(resolved)) {
                    return true;
                }
                if (!recycleName.equals(methodName)) {
                    return false;
                }
                PsiMethod method = call.resolve();
                if (method != null) {
                    PsiElement resolved2;
                    UExpression operand2;
                    PsiClass containingClass = method.getContainingClass();
                    if (this.mContext.getEvaluator().extendsClass(containingClass, recycleType, false) && (operand2 = call.getReceiver()) instanceof UResolvable && (resolved2 = ((UResolvable)operand2).resolve()) != null && this.mVariables.contains(resolved2)) {
                        return true;
                    }
                }
                return false;
            }
        };
        method.accept((UastVisitor)visitor);
        if (visitor.isCleanedUp() || visitor.variableEscapes()) {
            return;
        }
        String className = recycleType.substring(recycleType.lastIndexOf(46) + 1);
        String message2 = RECYCLE.equals(recycleName) ? String.format("This `%1$s` should be recycled after use with `#recycle()`", className) : String.format("This `%1$s` should be freed up after use with `#%2$s()`", className, recycleName);
        UIdentifier locationNode = node.getMethodIdentifier();
        if (locationNode == null) {
            locationNode = node;
        }
        Location location = context2.getLocation((UElement)locationNode);
        context2.report(RECYCLE_RESOURCE, (UElement)node, location, message2);
    }

    private static void checkTransactionCommits(JavaContext context2, UCallExpression node, PsiMethod calledMethod) {
        if (CleanupDetector.isBeginTransaction(context2, calledMethod)) {
            PsiVariable boundVariable = CleanupDetector.getVariableElement(node, true, true);
            if (CleanupDetector.isCommittedInChainedCalls(context2, node)) {
                return;
            }
            if (boundVariable != null) {
                UMethod method = (UMethod)UastUtils.getParentOfType((UElement)node, UMethod.class, (boolean)true);
                if (method == null) {
                    return;
                }
                FinishVisitor commitVisitor = new FinishVisitor(context2, boundVariable){

                    @Override
                    protected boolean isCleanupCall(UCallExpression call) {
                        UExpression first;
                        PsiElement resolved;
                        List arguments;
                        if (CleanupDetector.isTransactionCommitMethodCall(this.mContext, call)) {
                            List chain = UastUtils.getQualifiedChain((UExpression)UastUtils.getOutermostQualified((UExpression)call));
                            if (chain.isEmpty()) {
                                return false;
                            }
                            UExpression operand = (UExpression)chain.get(0);
                            if (operand != null) {
                                PsiElement resolved2 = UastUtils.tryResolve((UElement)operand);
                                if (resolved2 != null && this.mVariables.contains(resolved2)) {
                                    return true;
                                }
                                if (resolved2 instanceof PsiMethod && operand instanceof UCallExpression && CleanupDetector.isCommittedInChainedCalls(this.mContext, (UCallExpression)operand)) {
                                    while (operand instanceof UCallExpression) {
                                        operand = ((UCallExpression)operand).getReceiver();
                                    }
                                    if (operand instanceof UResolvable && (resolved2 = ((UResolvable)operand).resolve()) != null && this.mVariables.contains(resolved2)) {
                                        return true;
                                    }
                                }
                            }
                        } else if (CleanupDetector.isShowFragmentMethodCall(this.mContext, call) && (arguments = call.getValueArguments()).size() == 2 && (resolved = UastUtils.tryResolve((UElement)(first = (UExpression)arguments.get(0)))) != null && this.mVariables.contains(resolved)) {
                            return true;
                        }
                        return false;
                    }
                };
                method.accept((UastVisitor)commitVisitor);
                if (commitVisitor.isCleanedUp() || commitVisitor.variableEscapes()) {
                    return;
                }
            }
            String message2 = "This transaction should be completed with a `commit()` call";
            context2.report(COMMIT_FRAGMENT, (UElement)node, context2.getNameLocation((UElement)node), message2);
        }
    }

    private static boolean isCommittedInChainedCalls(JavaContext context2, UCallExpression node) {
        CommitCallChecker checker = (c, call) -> CleanupDetector.isTransactionCommitMethodCall(c, call) || CleanupDetector.isShowFragmentMethodCall(c, call);
        return CleanupDetector.isCommittedInChainedCalls(context2, node, checker);
    }

    private static boolean isTransactionCommitMethodCall(JavaContext context2, UCallExpression call) {
        String methodName = Lint.getMethodName(call);
        return (COMMIT.equals(methodName) || COMMIT_ALLOWING_LOSS.equals(methodName) || COMMIT_NOW_ALLOWING_LOSS.equals(methodName) || COMMIT_NOW.equals(methodName)) && CleanupDetector.isMethodOnFragmentClass(context2, call, FRAGMENT_TRANSACTION_CLS, FRAGMENT_TRANSACTION_V4_CLS, true);
    }

    private static boolean isShowFragmentMethodCall(JavaContext context2, UCallExpression call) {
        String methodName = Lint.getMethodName(call);
        return SHOW.equals(methodName) && CleanupDetector.isMethodOnFragmentClass(context2, call, DIALOG_FRAGMENT, DIALOG_V4_FRAGMENT, true);
    }

    private static boolean isMethodOnFragmentClass(JavaContext context2, UCallExpression call, String fragmentClass, String v4FragmentClass, boolean returnForUnresolved) {
        PsiMethod method = call.resolve();
        if (method != null) {
            PsiClass containingClass = method.getContainingClass();
            JavaEvaluator evaluator = context2.getEvaluator();
            return evaluator.extendsClass(containingClass, fragmentClass, false) || evaluator.extendsClass(containingClass, v4FragmentClass, false);
        }
        return returnForUnresolved;
    }

    private void checkEditorApplied(JavaContext context2, UCallExpression node, PsiMethod calledMethod) {
        if (CleanupDetector.isSharedEditorCreation(context2, calledMethod)) {
            if (!node.getValueArguments().isEmpty()) {
                return;
            }
            PsiVariable boundVariable = CleanupDetector.getVariableElement(node, true, true);
            if (CleanupDetector.isEditorCommittedInChainedCalls(context2, node)) {
                return;
            }
            if (boundVariable != null) {
                UMethod method = (UMethod)UastUtils.getParentOfType((UElement)node, UMethod.class, (boolean)true);
                if (method == null) {
                    return;
                }
                FinishVisitor commitVisitor = new FinishVisitor(context2, boundVariable){

                    @Override
                    protected boolean isCleanupCall(UCallExpression call) {
                        if (CleanupDetector.isEditorApplyMethodCall(this.mContext, call) || CleanupDetector.isEditorCommitMethodCall(this.mContext, call)) {
                            List chain = UastUtils.getQualifiedChain((UExpression)UastUtils.getOutermostQualified((UExpression)call));
                            if (chain.isEmpty()) {
                                return false;
                            }
                            UExpression operand = (UExpression)chain.get(0);
                            if (operand != null) {
                                PsiElement resolved = UastUtils.tryResolve((UElement)operand);
                                if (resolved != null && this.mVariables.contains(resolved)) {
                                    return true;
                                }
                                if (resolved instanceof PsiMethod && operand instanceof UCallExpression && CleanupDetector.isEditorCommittedInChainedCalls(this.mContext, (UCallExpression)operand)) {
                                    while (operand instanceof UCallExpression) {
                                        operand = ((UCallExpression)operand).getReceiver();
                                    }
                                    if (operand instanceof UResolvable && (resolved = ((UResolvable)operand).resolve()) != null && this.mVariables.contains(resolved)) {
                                        return true;
                                    }
                                }
                            }
                        }
                        return false;
                    }
                };
                method.accept((UastVisitor)commitVisitor);
                if (commitVisitor.isCleanedUp() || commitVisitor.variableEscapes()) {
                    return;
                }
            } else if (UastUtils.getParentOfType((UElement)node, UReturnExpression.class) != null) {
                return;
            }
            String message2 = "`SharedPreferences.edit()` without a corresponding `commit()` or `apply()` call";
            context2.report(SHARED_PREF, (UElement)node, context2.getLocation((UElement)node), message2);
        }
    }

    private static boolean isSharedEditorCreation(JavaContext context2, PsiMethod method) {
        String methodName = method.getName();
        if (EDIT.equals(methodName)) {
            PsiClass containingClass = method.getContainingClass();
            JavaEvaluator evaluator = context2.getEvaluator();
            return containingClass != null && evaluator.implementsInterface(containingClass, ANDROID_CONTENT_SHARED_PREFERENCES, false) && evaluator.typeMatches(method.getReturnType(), ANDROID_CONTENT_SHARED_PREFERENCES_EDITOR);
        }
        return false;
    }

    private static boolean isEditorCommittedInChainedCalls(JavaContext context2, UCallExpression node) {
        CommitCallChecker checker = (c, call) -> CleanupDetector.isEditorCommitMethodCall(c, call) || CleanupDetector.isEditorApplyMethodCall(c, call);
        return CleanupDetector.isCommittedInChainedCalls(context2, node, checker);
    }

    private static boolean isCommittedInChainedCalls(JavaContext context2, UCallExpression node, CommitCallChecker checker) {
        String methodName;
        UCallExpression parentCall;
        UExpression lastExpression;
        List chain = UastUtils.getQualifiedChain((UExpression)UastUtils.getOutermostQualified((UExpression)node));
        if (!chain.isEmpty() && (lastExpression = (UExpression)chain.get(chain.size() - 1)) instanceof UCallExpression) {
            UCallExpression call = (UCallExpression)lastExpression;
            if (checker.isCommitCall(context2, call)) {
                return true;
            }
            if (CommitCallVisitor.lastArgCallsCommit(context2, call, checker)) {
                return true;
            }
        }
        if ((parentCall = (UCallExpression)UastUtils.getParentOfType((UElement)node, UCallExpression.class, (boolean)true)) != null && "with".equals(methodName = Lint.getMethodName(parentCall))) {
            List args = parentCall.getValueArguments();
            return args.size() == 2 && CommitCallVisitor.lastArgCallsCommit(context2, parentCall, checker);
        }
        return false;
    }

    private static boolean isEditorCommitMethodCall(JavaContext context2, UCallExpression call) {
        String methodName = Lint.getMethodName(call);
        if (COMMIT.equals(methodName)) {
            PsiMethod method = call.resolve();
            if (method != null) {
                PsiClass containingClass = method.getContainingClass();
                JavaEvaluator evaluator = context2.getEvaluator();
                if (evaluator.extendsClass(containingClass, ANDROID_CONTENT_SHARED_PREFERENCES_EDITOR, false)) {
                    CleanupDetector.suggestApplyIfApplicable(context2, call);
                    return true;
                }
            } else if (call.getValueArgumentCount() == 0) {
                return true;
            }
        }
        return false;
    }

    private static boolean isEditorApplyMethodCall(JavaContext context2, UCallExpression call) {
        String methodName = Lint.getMethodName(call);
        if (APPLY.equals(methodName)) {
            PsiMethod method = call.resolve();
            if (method != null) {
                PsiClass containingClass = method.getContainingClass();
                JavaEvaluator evaluator = context2.getEvaluator();
                return evaluator.extendsClass(containingClass, ANDROID_CONTENT_SHARED_PREFERENCES_EDITOR, false);
            }
            if (call.getValueArgumentCount() == 0) {
                return true;
            }
        }
        return false;
    }

    private static void suggestApplyIfApplicable(JavaContext context2, UCallExpression node) {
        if (context2.getProject().getMinSdkVersion().getApiLevel() >= 9) {
            UExpression condition;
            UCallExpression qualifiedNode = node;
            UElement parent = Lint.skipParentheses(node.getUastParent());
            while (parent instanceof UReferenceExpression) {
                qualifiedNode = parent;
                parent = Lint.skipParentheses(parent.getUastParent());
            }
            boolean returnValueIgnored = true;
            if (parent instanceof UCallExpression || parent instanceof UVariable || parent instanceof UPolyadicExpression || parent instanceof UUnaryExpression || parent instanceof UReturnExpression) {
                returnValueIgnored = false;
            } else if (parent instanceof UIfExpression) {
                condition = ((UIfExpression)parent).getCondition();
                returnValueIgnored = !condition.equals(qualifiedNode);
            } else if (parent instanceof UWhileExpression) {
                condition = ((UWhileExpression)parent).getCondition();
                returnValueIgnored = !condition.equals(qualifiedNode);
            } else if (parent instanceof UDoWhileExpression) {
                condition = ((UDoWhileExpression)parent).getCondition();
                boolean bl = returnValueIgnored = !condition.equals(qualifiedNode);
            }
            if (returnValueIgnored) {
                String message2 = "Consider using `apply()` instead; `commit` writes its data to persistent storage immediately, whereas `apply` will handle it in the background";
                Location location = context2.getLocation((UElement)node);
                LintFix fix = LintFix.create().name("Replace commit() with apply()").replace().pattern("(commit)\\s*\\(").with(APPLY).build();
                context2.report(APPLY_SHARED_PREF, (UElement)node, location, message2, fix);
            }
        }
    }

    public static PsiVariable getVariableElement(UCallExpression rhs) {
        return CleanupDetector.getVariableElement(rhs, false, false);
    }

    public static PsiVariable getVariableElement(UCallExpression rhs, boolean allowChainedCalls, boolean allowFields) {
        return DataFlowAnalyzer.Companion.getVariableElement(rhs, allowChainedCalls, allowFields);
    }

    private static boolean isBeginTransaction(JavaContext context2, PsiMethod method) {
        String methodName = method.getName();
        if (BEGIN_TRANSACTION.equals(methodName)) {
            PsiClass containingClass = method.getContainingClass();
            JavaEvaluator evaluator = context2.getEvaluator();
            if (evaluator.extendsClass(containingClass, FRAGMENT_MANAGER_CLS, false) || evaluator.extendsClass(containingClass, FRAGMENT_MANAGER_V4_CLS, false)) {
                return true;
            }
        }
        return false;
    }

    private static class CommitCallVisitor
    extends AbstractUastVisitor {
        private JavaContext context;
        private boolean found;
        private CommitCallChecker checker;

        public CommitCallVisitor(JavaContext context2, CommitCallChecker checker) {
            this.context = context2;
            this.checker = checker;
        }

        public boolean visitCallExpression(UCallExpression node) {
            if (this.checker.isCommitCall(this.context, node)) {
                this.found = true;
            }
            return super.visitCallExpression(node);
        }

        public boolean isFound() {
            return this.found;
        }

        private static boolean callsCommit(JavaContext context2, UElement node, CommitCallChecker checker) {
            CommitCallVisitor visitor = new CommitCallVisitor(context2, checker);
            node.accept((UastVisitor)visitor);
            return visitor.isFound();
        }

        private static boolean lastArgCallsCommit(JavaContext context2, UCallExpression methodInvocation, CommitCallChecker checker) {
            UExpression last;
            List args = methodInvocation.getValueArguments();
            if (!args.isEmpty() && (last = (UExpression)args.get(args.size() - 1)) instanceof ULambdaExpression) {
                UExpression body = ((ULambdaExpression)last).getBody();
                return CommitCallVisitor.callsCommit(context2, (UElement)body, checker);
            }
            return false;
        }
    }

    private static interface CommitCallChecker {
        public boolean isCommitCall(JavaContext var1, UCallExpression var2);
    }

    private static abstract class FinishVisitor
    extends AbstractUastVisitor {
        protected final JavaContext mContext;
        protected final List<PsiVariable> mVariables;
        private final PsiVariable mOriginalVariableNode;
        private boolean mContainsCleanup;
        private boolean mEscapes;

        public FinishVisitor(JavaContext context2, PsiVariable variableNode) {
            this.mContext = context2;
            this.mOriginalVariableNode = variableNode;
            this.mVariables = Lists.newArrayList((Object[])new PsiVariable[]{variableNode});
        }

        public boolean isCleanedUp() {
            return this.mContainsCleanup;
        }

        public boolean variableEscapes() {
            return this.mEscapes;
        }

        public boolean visitElement(UElement node) {
            return this.mContainsCleanup || super.visitElement(node);
        }

        protected abstract boolean isCleanupCall(UCallExpression var1);

        public boolean visitCallExpression(UCallExpression node) {
            if (node.getKind() == UastCallKind.METHOD_CALL) {
                this.visitMethodCallExpression(node);
            }
            return super.visitCallExpression(node);
        }

        private void visitMethodCallExpression(UCallExpression call) {
            if (this.mContainsCleanup) {
                return;
            }
            if (!this.mEscapes) {
                for (UExpression expression : call.getValueArguments()) {
                    PsiElement resolved;
                    if (!(expression instanceof UResolvable) || (resolved = ((UResolvable)expression).resolve()) == null || !this.mVariables.contains(resolved)) continue;
                    boolean wasEscaped = this.mEscapes;
                    this.mEscapes = true;
                    if (!CleanupDetector.OBTAIN.equals(Lint.getMethodName(call))) continue;
                    PsiMethod method = call.resolve();
                    if (!this.mContext.getEvaluator().isMemberInClass((PsiMember)method, CleanupDetector.MOTION_EVENT_CLS)) continue;
                    this.mEscapes = wasEscaped;
                }
            }
            if (this.isCleanupCall(call)) {
                this.mContainsCleanup = true;
            }
        }

        public boolean visitVariable(UVariable variable) {
            PsiElement resolved;
            UExpression initializer;
            if (variable instanceof ULocalVariable && (initializer = variable.getUastInitializer()) instanceof UResolvable && (resolved = ((UResolvable)initializer).resolve()) != null && this.mVariables.contains(resolved)) {
                this.mVariables.add(variable.getPsi());
            }
            return super.visitVariable(variable);
        }

        public boolean visitBinaryExpression(UBinaryExpression expression) {
            PsiElement lhs;
            PsiElement resolved;
            if (!UastExpressionUtils.isAssignment((UElement)expression)) {
                return super.visitBinaryExpression(expression);
            }
            boolean clearLhs = false;
            UExpression rhs = expression.getRightOperand();
            if (rhs instanceof UResolvable && (resolved = ((UResolvable)rhs).resolve()) != null && this.mVariables.contains(resolved)) {
                clearLhs = false;
                PsiElement lhs2 = UastUtils.tryResolve((UElement)expression.getLeftOperand());
                if (lhs2 instanceof PsiLocalVariable) {
                    this.mVariables.add((PsiVariable)((PsiLocalVariable)lhs2));
                } else if (lhs2 instanceof PsiField) {
                    this.mEscapes = true;
                }
            }
            if (clearLhs && (lhs = UastUtils.tryResolve((UElement)expression.getLeftOperand())) != null && !lhs.equals(this.mOriginalVariableNode) && this.mVariables.contains(lhs)) {
                this.mVariables.remove(lhs);
            }
            return super.visitBinaryExpression(expression);
        }

        public boolean visitReturnExpression(UReturnExpression node) {
            PsiElement resolved;
            UExpression returnValue = node.getReturnExpression();
            if (returnValue instanceof UResolvable && (resolved = ((UResolvable)returnValue).resolve()) != null && this.mVariables.contains(resolved)) {
                this.mEscapes = true;
            }
            return super.visitReturnExpression(node);
        }
    }
}

