/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.builder.model.AndroidLibrary;
import com.android.builder.model.Dependencies;
import com.android.builder.model.MavenCoordinates;
import com.android.builder.model.Variant;
import com.android.ide.common.fonts.FontDetail;
import com.android.ide.common.fonts.FontFamily;
import com.android.ide.common.fonts.FontLoader;
import com.android.ide.common.fonts.FontProvider;
import com.android.ide.common.fonts.MutableFontDetail;
import com.android.ide.common.fonts.QueryParser;
import com.android.ide.common.repository.GradleCoordinate;
import com.android.resources.ResourceFolderType;
import com.android.sdklib.AndroidVersion;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.utils.XmlUtils;
import com.google.common.base.Joiner;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class FontDetector
extends ResourceXmlDetector {
    public static final int FUTURE_API_VERSION_WHERE_DOWNLOADABLE_FONTS_WORK_IN_FRAMEWORK = 0x7FFFFFFE;
    private static final Implementation IMPLEMENTATION = new Implementation(FontDetector.class, Scope.RESOURCE_FILE_SCOPE);
    public static final Issue FONT_VALIDATION_WARNING = Issue.create("FontValidationWarning", "Validation of font files", "Look for problems in various font files.", Category.CORRECTNESS, 9, Severity.WARNING, IMPLEMENTATION).addMoreInfo("https://developer.android.com/guide/topics/text/downloadable-fonts.html");
    public static final Issue FONT_VALIDATION_ERROR = Issue.create("FontValidationError", "Validation of font files", "Look for problems in various font files.", Category.CORRECTNESS, 8, Severity.ERROR, IMPLEMENTATION).addMoreInfo("https://developer.android.com/guide/topics/text/downloadable-fonts.html");
    public static final GradleCoordinate MIN_APPSUPPORT_VERSION = new GradleCoordinate("com.android.support", "appcompat-v7", "26.0.0");
    private FontLoader mFontLoader;

    @Override
    public boolean appliesTo(ResourceFolderType folderType) {
        return folderType == ResourceFolderType.FONT;
    }

    @Override
    public Collection<String> getApplicableElements() {
        return Arrays.asList("font-family", "font");
    }

    @Override
    public void beforeCheckRootProject(Context context2) {
        if (this.mFontLoader == null) {
            this.mFontLoader = FontLoader.getInstance((File)context2.getClient().getSdkHome());
        }
    }

    @Override
    public void visitElement(XmlContext context2, Element element) {
        boolean downloadableFontFile;
        Attr authority = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "fontProviderAuthority");
        Attr query = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "fontProviderQuery");
        Attr androidPackage = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "fontProviderPackage");
        Attr certs = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "fontProviderCerts");
        Attr appAuthority = element.getAttributeNodeNS("http://schemas.android.com/apk/res-auto", "fontProviderAuthority");
        Attr appQuery = element.getAttributeNodeNS("http://schemas.android.com/apk/res-auto", "fontProviderQuery");
        Attr appPackage = element.getAttributeNodeNS("http://schemas.android.com/apk/res-auto", "fontProviderPackage");
        Attr appCerts = element.getAttributeNodeNS("http://schemas.android.com/apk/res-auto", "fontProviderCerts");
        Attr firstAndroidAttribute = Lint.coalesce(authority, query, androidPackage, certs);
        Attr firstAppAttribute = Lint.coalesce(appAuthority, appQuery, appPackage, appCerts);
        List<String> missingAndroidAttributes = FontDetector.findMissingAttributes(authority, query, androidPackage, certs);
        List<String> missingAppAttributes = FontDetector.findMissingAttributes(appAuthority, appQuery, appPackage, appCerts);
        Element fontTag = XmlUtils.getFirstSubTagByName((Node)element, (String)"font");
        AndroidVersion minSdk = context2.getMainProject().getMinSdkVersion();
        boolean bl = downloadableFontFile = Lint.coalesce(firstAndroidAttribute, firstAppAttribute) != null;
        if (downloadableFontFile) {
            FontDetector.checkSupportLibraryVersion(context2, element);
            if (FontDetector.reportMisplacedFontTag(context2, fontTag)) {
                return;
            }
            if (minSdk.getApiLevel() >= 0x7FFFFFFE) {
                FontDetector.reportUnexpectedAttributeNamespace(context2, firstAppAttribute, "android");
            } else {
                FontDetector.reportUnexpectedAttributeNamespace(context2, firstAndroidAttribute, "app");
            }
            FontProvider provider = this.reportUnknownProvider(context2, authority, appAuthority);
            if (provider != null) {
                FontDetector.reportUnknownPackage(context2, androidPackage, appPackage, provider);
                this.reportQueryProblem(context2, query, appQuery, provider);
            }
            if (minSdk.getFeatureLevel() > 27) {
                this.reportMissingAppAttribute(context2, firstAndroidAttribute, missingAndroidAttributes, "http://schemas.android.com/apk/res/android", "android", provider);
            } else {
                this.reportMissingAppAttribute(context2, firstAppAttribute, missingAppAttributes, "http://schemas.android.com/apk/res-auto", "app", provider);
            }
        }
    }

    private static List<String> findMissingAttributes(Attr authority, Attr query, Attr packageName, Attr certs) {
        if (authority != null && query != null && packageName != null && certs != null) {
            return Collections.emptyList();
        }
        ArrayList<String> missing = new ArrayList<String>();
        if (authority == null) {
            missing.add("fontProviderAuthority");
        }
        if (query == null) {
            missing.add("fontProviderQuery");
        }
        if (packageName == null) {
            missing.add("fontProviderPackage");
        }
        if (certs == null) {
            missing.add("fontProviderCerts");
        }
        return missing;
    }

    private static void checkSupportLibraryVersion(XmlContext context2, Element element) {
        Variant variant = context2.getMainProject().getCurrentVariant();
        if (variant == null) {
            return;
        }
        Dependencies dependencies = variant.getMainArtifact().getDependencies();
        for (AndroidLibrary library : dependencies.getLibraries()) {
            GradleCoordinate version;
            MavenCoordinates rc = library.getResolvedCoordinates();
            if (!"com.android.support".equals(rc.getGroupId()) || !"appcompat-v7".equals(rc.getArtifactId()) || GradleCoordinate.COMPARE_PLUS_LOWER.compare(version = new GradleCoordinate("com.android.support", "appcompat-v7", rc.getVersion()), MIN_APPSUPPORT_VERSION) >= 0) continue;
            String message2 = "Using version " + version.getRevision() + " of the " + "appcompat-v7" + " library. Required version for using downloadable fonts: " + MIN_APPSUPPORT_VERSION.getRevision() + " or higher.";
            LintFix fix = LintFix.create().data("appcompat-v7");
            FontDetector.reportError(context2, element, message2, context2.getNameLocation(element), fix);
        }
    }

    private static boolean reportMisplacedFontTag(XmlContext context2, Element fontTag) {
        if (fontTag == null) {
            return false;
        }
        LintFix fix = LintFix.create().replace().with("").range(context2.getLocation(fontTag)).build();
        FontDetector.reportError(context2, fontTag, "A downloadable font cannot have a `<font>` sub tag", context2.getElementLocation(fontTag), fix);
        return true;
    }

    private static void reportUnexpectedAttributeNamespace(XmlContext context2, Attr first, String namespace) {
        if (first != null) {
            AndroidVersion minSdk = context2.getMainProject().getMinSdkVersion();
            String message2 = String.format("For `minSdkVersion`=%1$d only `%2$s:` attributes should be used", minSdk.getApiLevel(), namespace);
            LintFix fix = LintFix.create().unset(first.getNamespaceURI(), first.getLocalName()).build();
            FontDetector.reportWarning(context2, first, message2, context2.getLocation(first), fix);
        }
    }

    private void reportMissingAppAttribute(XmlContext context2, Attr firstFontAttribute, List<String> missingAttributes, String namespaceUri, String namespacePrefix, FontProvider provider) {
        if (firstFontAttribute != null && !missingAttributes.isEmpty()) {
            String message2 = String.format("Missing required %1$s: %2$s:%3$s", StringUtil.pluralize((String)"attribute", (int)missingAttributes.size()), namespacePrefix, Joiner.on((String)(", " + namespacePrefix + ":")).join(missingAttributes));
            LintFix fix = this.makeMissingAttributeFix(missingAttributes, namespaceUri, provider);
            Element element = firstFontAttribute.getOwnerElement();
            FontDetector.reportError(context2, element, message2, context2.getElementLocation(element), fix);
        }
    }

    private LintFix makeMissingAttributeFix(List<String> missingAttributes, String namespaceUri, FontProvider provider) {
        if (provider == null) {
            provider = this.mFontLoader.findOnlyKnownProvider();
        }
        LintFix.GroupBuilder fix = this.fix().composite();
        for (String missingAttribute : missingAttributes) {
            String value = FontDetector.generateNewValue(missingAttribute, provider);
            if (value == null) {
                fix.add(this.fix().set().todo(namespaceUri, missingAttribute).build());
                continue;
            }
            fix.add(this.fix().set(namespaceUri, missingAttribute, value).build());
        }
        return fix.build();
    }

    private static String generateNewValue(String missingAttribute, FontProvider provider) {
        if (provider == null) {
            return null;
        }
        switch (missingAttribute) {
            case "fontProviderAuthority": {
                return provider.getAuthority();
            }
            case "fontProviderPackage": {
                return provider.getPackageName();
            }
            case "fontProviderCerts": {
                return "@array/" + provider.getCertificateResourceName();
            }
        }
        return null;
    }

    private FontProvider reportUnknownProvider(XmlContext context2, Attr attrAuthority, Attr attrAppAuthority) {
        String authority = attrAuthority != null ? attrAuthority.getValue() : null;
        String appAuthority = attrAppAuthority != null ? attrAppAuthority.getValue() : null;
        FontProvider provider = null;
        if (authority != null) {
            provider = this.reportUnknownProvider(context2, attrAuthority, authority);
        } else if (appAuthority != null) {
            provider = this.reportUnknownProvider(context2, attrAppAuthority, appAuthority);
        }
        return provider;
    }

    private FontProvider reportUnknownProvider(XmlContext context2, Attr attrAuthority, String authority) {
        FontProvider provider = this.mFontLoader.findProvider(authority);
        if (provider != null) {
            return provider;
        }
        LintFix fix = null;
        FontProvider onlyKnownProvider = this.mFontLoader.findOnlyKnownProvider();
        if (onlyKnownProvider != null) {
            fix = this.fix().name("Replace with " + onlyKnownProvider.getAuthority()).replace().text(authority).with(onlyKnownProvider.getAuthority()).build();
        }
        FontDetector.reportError(context2, attrAuthority, "Unknown font provider authority", context2.getValueLocation(attrAuthority), fix);
        return null;
    }

    private static void reportUnknownPackage(XmlContext context2, Attr attrAndroidPackage, Attr attrAppPackage, FontProvider provider) {
        String appPackage;
        String androidPackage = attrAndroidPackage != null ? attrAndroidPackage.getValue() : null;
        String string = appPackage = attrAppPackage != null ? attrAppPackage.getValue() : null;
        if (androidPackage != null && !androidPackage.equals(provider.getPackageName())) {
            FontDetector.reportUnknownPackage(context2, attrAndroidPackage, androidPackage, provider);
        } else if (appPackage != null && !appPackage.equals(provider.getPackageName())) {
            FontDetector.reportUnknownPackage(context2, attrAppPackage, appPackage, provider);
        }
    }

    private static void reportUnknownPackage(XmlContext context2, Attr attrPackage, String packageName, FontProvider provider) {
        if (provider.getPackageName().equals(packageName)) {
            return;
        }
        LintFix fix = LintFix.create().name("Replace with " + provider.getPackageName()).replace().text(packageName).with(provider.getPackageName()).build();
        FontDetector.reportError(context2, attrPackage, "Unexpected font provider package", context2.getValueLocation(attrPackage), fix);
    }

    private void reportQueryProblem(XmlContext context2, Attr androidQueryAttr, Attr appQueryAttr, FontProvider provider) {
        String appQuery;
        String androidQuery = androidQueryAttr != null ? androidQueryAttr.getValue() : null;
        String string = appQuery = appQueryAttr != null ? appQueryAttr.getValue() : null;
        if (androidQuery != null) {
            this.reportQueryProblem(context2, androidQueryAttr, androidQuery, provider);
        } else if (appQuery != null) {
            this.reportQueryProblem(context2, appQueryAttr, appQuery, provider);
        }
    }

    private void reportQueryProblem(XmlContext context2, Attr queryAttr, String query, FontProvider provider) {
        if (query.isEmpty()) {
            LintFix fix = this.fix().set().todo(queryAttr.getNamespaceURI(), queryAttr.getLocalName()).build();
            FontDetector.reportError(context2, queryAttr, "Missing provider query", context2.getLocation(queryAttr), fix);
            return;
        }
        try {
            QueryParser.DownloadableParseResult result = QueryParser.parseDownloadableFont((String)provider.getAuthority(), (String)XmlUtils.fromXmlAttributeValue((String)query));
            if (!this.mFontLoader.fontsLoaded()) {
                return;
            }
            for (String fontName : result.getFonts().keySet()) {
                FontFamily family = this.mFontLoader.findFont(provider, fontName);
                if (family == null) {
                    FontDetector.reportError(context2, queryAttr, "Unknown font: " + fontName, context2.getValueLocation(queryAttr), null);
                    continue;
                }
                for (MutableFontDetail detail : result.getFonts().get((Object)fontName)) {
                    FontDetail best = detail.findBestMatch((Collection)family.getFonts());
                    if (best == null || detail.match(best) == 0) continue;
                    LintFix fix = null;
                    if (result.getFonts().size() == 1) {
                        String better = best.generateQuery(detail.getExact());
                        fix = this.fix().name("Replace with closest font: " + better).set(queryAttr.getNamespaceURI(), queryAttr.getLocalName(), better).build();
                    }
                    if (detail.getExact()) {
                        FontDetector.reportError(context2, queryAttr, "No exact match found for: " + fontName, context2.getValueLocation(queryAttr), fix);
                        continue;
                    }
                    FontDetector.reportWarning(context2, queryAttr, "No exact match found for: " + fontName, context2.getValueLocation(queryAttr), fix);
                }
            }
        }
        catch (QueryParser.FontQueryParserError ex) {
            FontDetector.reportError(context2, queryAttr, ex.getMessage(), context2.getValueLocation(queryAttr), null);
        }
    }

    private static void reportError(XmlContext context2, Node node, String message2, Location location, LintFix fix) {
        if (!context2.isEnabled(FONT_VALIDATION_ERROR)) {
            return;
        }
        context2.report(FONT_VALIDATION_ERROR, node, location, message2, fix);
    }

    private static void reportWarning(XmlContext context2, Node node, String message2, Location location, LintFix fix) {
        if (!context2.isEnabled(FONT_VALIDATION_WARNING)) {
            return;
        }
        context2.report(FONT_VALIDATION_WARNING, node, location, message2, fix);
    }
}

