/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import java.util.Collections;
import java.util.List;
import org.jetbrains.uast.UClass;

public class ItemDecoratorDetector
extends Detector
implements SourceCodeScanner {
    public static final Issue ISSUE = Issue.create("DuplicateDivider", "Unnecessary Divider Copy", "Older versions of the RecyclerView library did not include a divider decorator, but one was provided as a sample in the support demos. This divider class has been widely copy/pasted into various projects.\n\nIn recent versions of the support library, the divider decorator is now included, so you can replace custom copies with the \"built-in\" version, `android.support.v7.widget.DividerItemDecoration`.", Category.PERFORMANCE, 4, Severity.WARNING, new Implementation(ItemDecoratorDetector.class, Scope.JAVA_FILE_SCOPE));

    @Override
    public List<String> applicableSuperClasses() {
        return Collections.singletonList("android.support.v7.widget.RecyclerView.ItemDecoration");
    }

    @Override
    public void visitClass(JavaContext context2, UClass declaration) {
        String name = declaration.getName();
        if (name == null || !name.equals("DividerItemDecoration")) {
            return;
        }
        if (declaration.findFieldByName("HORIZONTAL_LIST", false) == null || declaration.findFieldByName("VERTICAL_LIST", false) == null) {
            return;
        }
        String qualifiedName = declaration.getQualifiedName();
        if ("android.support.v7.widget.DividerItemDecoration".equals(qualifiedName)) {
            return;
        }
        Location location = context2.getNameLocation(declaration);
        context2.report(ISSUE, declaration, location, "Replace with `android.support.v7.widget.DividerItemDecoration`?");
    }
}

