/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.ide.common.resources.AbstractResourceRepository;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.util.PathString;
import com.android.resources.ResourceType;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.ResourceReference;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LayoutDetector;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.utils.CharSequenceReader;
import com.android.utils.CharSequences;
import com.android.utils.Pair;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.psi.PsiMethod;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UastLiteralUtils;
import org.kxml2.io.KXmlParser;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.xmlpull.v1.XmlPullParserException;

public class LayoutInflationDetector
extends LayoutDetector
implements SourceCodeScanner {
    private static final Implementation IMPLEMENTATION = new Implementation(LayoutInflationDetector.class, Scope.JAVA_AND_RESOURCE_FILES, Scope.JAVA_FILE_SCOPE);
    public static final Issue ISSUE = Issue.create("InflateParams", "Layout Inflation without a Parent", "When inflating a layout, avoid passing in null as the parent view, since otherwise any layout parameters on the root of the inflated layout will be ignored.", Category.CORRECTNESS, 5, Severity.WARNING, IMPLEMENTATION).addMoreInfo("http://www.doubleencore.com/2013/05/layout-inflation-as-intended");
    private static final String ERROR_MESSAGE = "Avoid passing `null` as the view root (needed to resolve layout parameters on the inflated layout's root element)";
    private Set<String> mLayoutsWithRootLayoutParams;
    private List<Pair<String, Location>> mPendingErrors;

    @Override
    public void afterCheckRootProject(Context context2) {
        if (this.mPendingErrors != null) {
            for (Pair<String, Location> pair : this.mPendingErrors) {
                String inflatedLayout = (String)pair.getFirst();
                if (this.mLayoutsWithRootLayoutParams == null || !this.mLayoutsWithRootLayoutParams.contains(inflatedLayout)) continue;
                Location location = (Location)pair.getSecond();
                context2.report(ISSUE, location, ERROR_MESSAGE);
            }
        }
    }

    @Override
    public void visitDocument(XmlContext context2, Document document) {
        Element root = document.getDocumentElement();
        if (root != null) {
            NamedNodeMap attributes = root.getAttributes();
            int n = attributes.getLength();
            for (int i = 0; i < n; ++i) {
                Attr attribute = (Attr)attributes.item(i);
                if (attribute.getLocalName() == null || !attribute.getLocalName().startsWith("layout_")) continue;
                if (this.mLayoutsWithRootLayoutParams == null) {
                    this.mLayoutsWithRootLayoutParams = Sets.newHashSetWithExpectedSize((int)20);
                }
                this.mLayoutsWithRootLayoutParams.add(Lint.getBaseName(context2.file.getName()));
                break;
            }
        }
    }

    @Override
    public List<String> getApplicableMethodNames() {
        return Collections.singletonList("inflate");
    }

    @Override
    public void visitMethod(JavaContext context2, UCallExpression call, PsiMethod method) {
        assert (method.getName().equals("inflate"));
        if (call.getReceiver() == null) {
            return;
        }
        List arguments = call.getValueArguments();
        if (arguments.size() < 2) {
            return;
        }
        UExpression second = (UExpression)arguments.get(1);
        if (!UastLiteralUtils.isNullLiteral((UElement)second)) {
            return;
        }
        UExpression first = (UExpression)arguments.get(0);
        ResourceReference reference = ResourceReference.get((UElement)first);
        if (reference == null) {
            return;
        }
        String layoutName = reference.getName();
        if (context2.getScope().contains((Object)Scope.RESOURCE_FILE)) {
            if (!context2.getDriver().isSuppressed(context2, ISSUE, (UElement)call)) {
                if (this.mPendingErrors == null) {
                    this.mPendingErrors = Lists.newArrayList();
                }
                Location location = context2.getLocation((UElement)second);
                this.mPendingErrors.add((Pair<String, Location>)Pair.of((Object)layoutName, (Object)location));
            }
        } else if (LayoutInflationDetector.hasLayoutParams(context2, layoutName)) {
            context2.report(ISSUE, (UElement)call, context2.getLocation((UElement)second), ERROR_MESSAGE);
        }
    }

    private static boolean hasLayoutParams(JavaContext context2, String name) {
        LintClient client = context2.getClient();
        if (!client.supportsProjectResources()) {
            return true;
        }
        Project project = context2.getProject();
        AbstractResourceRepository resources = client.getResourceRepository(project, true, false);
        if (resources == null) {
            return true;
        }
        List items = resources.getResourceItem(ResourceType.LAYOUT, name);
        if (items == null || items.isEmpty()) {
            return false;
        }
        for (ResourceItem item : items) {
            PathString source = item.getSource();
            if (source == null) {
                return true;
            }
            File file = source.toFile();
            if (file == null) {
                return true;
            }
            if (!file.exists()) continue;
            try {
                CharSequence s = client.readFile(file);
                CharSequenceReader reader = CharSequences.getReader((CharSequence)s, (boolean)true);
                if (!LayoutInflationDetector.hasLayoutParams((Reader)reader)) continue;
                return true;
            }
            catch (Exception e) {
                context2.log(e, "Could not read/parse inflated layout", new Object[0]);
                return true;
            }
        }
        return false;
    }

    static boolean hasLayoutParams(Reader reader) throws XmlPullParserException, IOException {
        int event;
        KXmlParser parser = new KXmlParser();
        parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
        parser.setInput(reader);
        do {
            if ((event = parser.next()) != 2) continue;
            for (int i = 0; i < parser.getAttributeCount(); ++i) {
                String prefix;
                if (!parser.getAttributeName(i).startsWith("layout_") || (prefix = parser.getAttributePrefix(i)) == null || prefix.isEmpty() || !"http://schemas.android.com/apk/res/android".equals(parser.getNamespace(prefix))) continue;
                return true;
            }
            return false;
        } while (event != 1);
        return false;
    }
}

