/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.StringFormatDetector;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ConstantEvaluator;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameterList;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.UThrowExpression;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u00142\u00020\u00012\u00020\u0002:\u0001\u0014B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\"\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0001\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000bH\u0002J\u0010\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000fH\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000bH\u0002J \u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/lint/checks/LocaleDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "checkFormat", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "method", "Lcom/intellij/psi/PsiMethod;", "call", "Lorg/jetbrains/uast/UCallExpression;", "checkLocaleGetDefault", "node", "getApplicableMethodNames", "", "", "isLoggingParameter", "", "visitMethod", "Companion", "android.sdktools.lint-checks"})
public final class LocaleDetector
extends Detector
implements SourceCodeScanner {
    private static final Implementation IMPLEMENTATION;
    @NotNull
    public static final String GET_DEFAULT = "getDefault";
    @JvmField
    @NotNull
    public static final Issue STRING_LOCALE;
    @JvmField
    @NotNull
    public static final Issue FINAL_LOCALE;
    public static final Companion Companion;

    @Override
    @Nullable
    public List<String> getApplicableMethodNames() {
        return LintClient.Companion.isStudio() ? Arrays.asList("format", GET_DEFAULT) : Arrays.asList("toLowerCase", "toUpperCase", "format", GET_DEFAULT);
    }

    @Override
    public void visitMethod(@NotNull JavaContext context2, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
        if (Intrinsics.areEqual((Object)method.getName(), (Object)GET_DEFAULT)) {
            if (context2.getEvaluator().isMemberInClass((PsiMember)method, "java.util.Locale")) {
                this.checkLocaleGetDefault(context2, method, node);
            }
            return;
        }
        if (context2.getEvaluator().isMemberInClass((PsiMember)method, "java.lang.String")) {
            if (Intrinsics.areEqual((Object)method.getName(), (Object)"format")) {
                this.checkFormat(context2, method, node);
            } else {
                PsiParameterList psiParameterList = method.getParameterList();
                Intrinsics.checkExpressionValueIsNotNull((Object)psiParameterList, (String)"method.parameterList");
                if (psiParameterList.getParametersCount() == 0) {
                    Location location = context2.getNameLocation((UElement)node);
                    StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                    String string = "Implicitly using the default locale is a common source of bugs: Use `%1$s(Locale)` instead. For strings meant to be internal use `Locale.ROOT`, otherwise `Locale.getDefault()`.";
                    Object[] objectArray = new Object[]{method.getName()};
                    String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
                    String message2 = string2;
                    JavaContext.report$default(context2, STRING_LOCALE, (UElement)node, location, message2, null, 16, null);
                }
            }
        }
    }

    private final void checkFormat(JavaContext context2, PsiMethod method, UCallExpression call) {
        PsiParameterList psiParameterList = method.getParameterList();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiParameterList, (String)"method.parameterList");
        if (psiParameterList.getParametersCount() == 0 || !context2.getEvaluator().parameterHasType(method, 0, "java.lang.String")) {
            return;
        }
        List expressions = call.getValueArguments();
        if (expressions.isEmpty()) {
            return;
        }
        UExpression first = (UExpression)expressions.get(0);
        Object object = ConstantEvaluator.evaluate(context2, (UElement)first);
        if (!(object instanceof String)) {
            object = null;
        }
        String string = (String)object;
        if (string == null) {
            return;
        }
        String value = string;
        if (StringFormatDetector.isLocaleSpecific(value)) {
            if (this.isLoggingParameter(context2, call)) {
                return;
            }
            if (UastUtils.getParentOfType((UElement)((UElement)call), UThrowExpression.class, (boolean)true) != null) {
                return;
            }
            Location location = Intrinsics.areEqual((Object)"format", (Object)Lint.getMethodName(call)) ? context2.getCallLocation(call, true, true) : context2.getCallLocation(call, false, true);
            String message2 = "Implicitly using the default locale is a common source of bugs: Use `String.format(Locale, ...)` instead";
            JavaContext.report$default(context2, STRING_LOCALE, (UElement)call, location, message2, null, 16, null);
        }
    }

    private final void checkLocaleGetDefault(JavaContext context2, PsiMethod method, UCallExpression node) {
        UField uField = (UField)UastUtils.getParentOfType((UElement)((UElement)node), UField.class, (boolean)true);
        if (uField == null) {
            return;
        }
        UField field = uField;
        JavaEvaluator evaluator = context2.getEvaluator();
        if (evaluator.isStatic((PsiModifierListOwner)field) && evaluator.isFinal((PsiModifierListOwner)field)) {
            JavaContext.report$default(context2, FINAL_LOCALE, (UElement)node, context2.getLocation((UElement)node), "Assigning `Locale.getDefault()` to a final static field is suspicious; this code will not work correctly if the user changes locale while the app is running", null, 16, null);
        }
    }

    private final boolean isLoggingParameter(JavaContext context2, UCallExpression node) {
        String name;
        UCallExpression parentCall = (UCallExpression)UastUtils.getParentOfType((UElement)((UElement)node), UCallExpression.class, (boolean)true);
        if (parentCall != null && (name = Lint.getMethodName(parentCall)) != null && name.length() == 1) {
            PsiMethod method = parentCall.resolve();
            return context2.getEvaluator().isMemberInClass((PsiMember)method, "android.util.Log");
        }
        return false;
    }

    static {
        Companion = new Companion(null);
        IMPLEMENTATION = new Implementation(LocaleDetector.class, Scope.JAVA_FILE_SCOPE);
        boolean bl = false;
        Implementation implementation = LocaleDetector.Companion.getIMPLEMENTATION();
        Severity severity = Severity.WARNING;
        int n = 6;
        Category category = Category.CORRECTNESS;
        String string = "http://developer.android.com/reference/java/util/Locale.html#default_locale";
        STRING_LOCALE = Issue.Companion.create$default(Issue.Companion, "DefaultLocale", "Implied default locale in case conversion", "\n                Calling `String#toLowerCase()` or `#toUpperCase()` **without specifying an \\\n                explicit locale** is a common source of bugs. The reason for that is that \\\n                those methods will use the current locale on the user's device, and even \\\n                though the code appears to work correctly when you are developing the app, \\\n                it will fail in some locales. For example, in the Turkish locale, the \\\n                uppercase replacement for `i` is **not** `I`.\n\n                If you want the methods to just perform ASCII replacement, for example to \\\n                convert an enum name, call `String#toUpperCase(Locale.US)` instead. If you \\\n                really want to use the current locale, call \\\n                `String#toUpperCase(Locale.getDefault())` instead.\n                ", implementation, string, category, n, severity, bl, 256, null);
        FINAL_LOCALE = Issue.Companion.create("ConstantLocale", "Constant Locale", "\n                Assigning `Locale.getDefault()` to a constant is suspicious, because \\\n                the locale can change while the app is running.", Category.I18N, 6, Severity.WARNING, LocaleDetector.Companion.getIMPLEMENTATION());
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0010\u0010\u000b\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/android/tools/lint/checks/LocaleDetector$Companion;", "", "()V", "FINAL_LOCALE", "Lcom/android/tools/lint/detector/api/Issue;", "GET_DEFAULT", "", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "getIMPLEMENTATION", "()Lcom/android/tools/lint/detector/api/Implementation;", "STRING_LOCALE", "android.sdktools.lint-checks"})
    public static final class Companion {
        private final Implementation getIMPLEMENTATION() {
            return IMPLEMENTATION;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

