/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;

public class MathDetector
extends Detector
implements SourceCodeScanner {
    public static final Issue ISSUE = Issue.create("FloatMath", "Using `FloatMath` instead of `Math`", "In older versions of Android, using `android.util.FloatMath` was recommended for performance reasons when operating on floats. However, on modern hardware doubles are just as fast as float (though they take more memory), and in recent versions of Android, `FloatMath` is actually slower than using `java.lang.Math` due to the way the JIT optimizes `java.lang.Math`. Therefore, you should use `Math` instead of `FloatMath` if you are only targeting Froyo and above.", Category.PERFORMANCE, 3, Severity.WARNING, new Implementation(MathDetector.class, Scope.JAVA_FILE_SCOPE)).addMoreInfo("http://developer.android.com/guide/practices/design/performance.html#avoidfloat");

    @Override
    public List<String> getApplicableMethodNames() {
        return Arrays.asList("sin", "cos", "ceil", "sqrt", "floor");
    }

    @Override
    public void visitMethod(JavaContext context2, UCallExpression call, PsiMethod method) {
        if (context2.getEvaluator().isMemberInClass((PsiMember)method, "android.util.FloatMath") && context2.getProject().getMinSdk() >= 8) {
            String message2 = String.format("Use `java.lang.Math#%1$s` instead of `android.util.FloatMath#%1$s()` since it is faster as of API 8", method.getName());
            Location location = context2.getCallLocation(call, true, false);
            context2.report(ISSUE, (UElement)call, location, message2);
        }
    }
}

