/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.resources.AbstractResourceRepository;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.util.PathString;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceUrl;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LayoutDetector;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class NegativeMarginDetector
extends LayoutDetector {
    private static final Implementation IMPLEMENTATION = new Implementation(NegativeMarginDetector.class, Scope.RESOURCE_FILE_SCOPE);
    public static final Issue ISSUE = Issue.create("NegativeMargin", "Negative Margins", "Margin values should be positive. Negative values are generally a sign that you are making assumptions about views surrounding the current one, or may be tempted to turn off child clipping to allow a view to escape its parent. Turning off child clipping to do this not only leads to poor graphical performance, it also results in wrong touch event handling since touch events are based strictly on a chain of parent-rect hit tests. Finally, making assumptions about the size of strings can lead to localization problems.", Category.USABILITY, 4, Severity.WARNING, IMPLEMENTATION).setEnabledByDefault(false);
    private HashMap<String, Location.Handle> mDimenUsage;

    @Override
    public boolean appliesTo(ResourceFolderType folderType) {
        return folderType == ResourceFolderType.LAYOUT || folderType == ResourceFolderType.VALUES;
    }

    @Override
    public Collection<String> getApplicableAttributes() {
        return Arrays.asList("layout_margin", "layout_marginLeft", "layout_marginTop", "layout_marginRight", "layout_marginBottom", "layout_marginStart", "layout_marginEnd");
    }

    @Override
    public Collection<String> getApplicableElements() {
        return Arrays.asList("dimen", "style");
    }

    @Override
    public void visitAttribute(XmlContext context2, Attr attribute) {
        String value = attribute.getValue();
        this.checkMarginValue(context2, value, attribute, null);
    }

    @Override
    public void visitElement(XmlContext context2, Element element) {
        block7: {
            String tag;
            block6: {
                Location.Handle handle;
                if (context2.getResourceFolderType() != ResourceFolderType.VALUES) {
                    return;
                }
                tag = element.getTagName();
                if (!"dimen".equals(tag)) break block6;
                NodeList itemNodes = element.getChildNodes();
                String name = element.getAttribute("name");
                Location.Handle handle2 = handle = this.mDimenUsage != null ? this.mDimenUsage.get(name) : null;
                if (handle == null) break block7;
                int nodeCount = itemNodes.getLength();
                for (int j = 0; j < nodeCount; ++j) {
                    Node item = itemNodes.item(j);
                    if (item.getNodeType() != 3) continue;
                    String text = item.getNodeValue().trim();
                    this.checkMarginValue(context2, text, null, handle);
                }
                break block7;
            }
            assert ("style".equals(tag)) : tag;
            NodeList itemNodes = element.getChildNodes();
            int nodeCount = itemNodes.getLength();
            for (int j = 0; j < nodeCount; ++j) {
                Element itemElement;
                String name;
                Node item = itemNodes.item(j);
                if (item.getNodeType() != 1 || !"item".equals(item.getNodeName()) || !(name = (itemElement = (Element)item).getAttribute("name")).startsWith("android:") || !name.startsWith("layout_margin", "android:".length())) continue;
                NodeList childNodes = item.getChildNodes();
                int n = childNodes.getLength();
                for (int i = 0; i < n; ++i) {
                    Node child = childNodes.item(i);
                    if (child.getNodeType() != 3) {
                        return;
                    }
                    this.checkMarginValue(context2, child.getNodeValue(), child, null);
                }
            }
        }
    }

    private static boolean isNegativeDimension(String value) {
        return value.trim().startsWith("-");
    }

    private void checkMarginValue(XmlContext context2, String value, Node scope, Location.Handle handle) {
        if (NegativeMarginDetector.isNegativeDimension(value)) {
            String message2 = "Margin values should not be negative";
            if (scope != null) {
                context2.report(ISSUE, scope, context2.getLocation(scope), message2);
            } else {
                assert (handle != null);
                context2.report(ISSUE, handle.resolve(), message2);
            }
        } else if (value.startsWith("@dimen/") && scope != null) {
            ResourceUrl url = ResourceUrl.parse((String)value);
            if (url == null) {
                return;
            }
            if (context2.getClient().supportsProjectResources()) {
                List items;
                Project project;
                LintClient client = context2.getClient();
                AbstractResourceRepository resources = client.getResourceRepository(project = context2.getProject(), true, true);
                if (resources != null && (items = resources.getResourceItem(url.type, url.name)) != null) {
                    for (ResourceItem item : items) {
                        String dimenValue;
                        ResourceValue resourceValue = item.getResourceValue();
                        if (resourceValue == null || (dimenValue = resourceValue.getValue()) == null || !NegativeMarginDetector.isNegativeDimension(dimenValue)) continue;
                        PathString sourceFile = item.getSource();
                        assert (sourceFile != null);
                        String message3 = String.format("Margin values should not be negative (`%1$s` is defined as `%2$s` in `%3$s`", value, dimenValue, Lint.getFileNameWithParent(client, sourceFile));
                        context2.report(ISSUE, scope, context2.getLocation(scope), message3);
                        break;
                    }
                }
            } else if (!context2.getDriver().isSuppressed(context2, ISSUE, scope)) {
                if (this.mDimenUsage == null) {
                    this.mDimenUsage = new HashMap();
                }
                this.mDimenUsage.put(url.name, context2.createLocationHandle(scope));
            }
        }
    }
}

