/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.SecurityDetector;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.tools.lint.detector.api.XmlScanner;
import com.android.utils.XmlUtils;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.uast.UClass;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PreferenceActivityDetector
extends Detector
implements XmlScanner,
SourceCodeScanner {
    public static final Implementation IMPLEMENTATION = new Implementation(PreferenceActivityDetector.class, EnumSet.of(Scope.MANIFEST, Scope.JAVA_FILE), Scope.MANIFEST_SCOPE, Scope.JAVA_FILE_SCOPE);
    public static final Issue ISSUE = Issue.create("ExportedPreferenceActivity", "PreferenceActivity should not be exported", "Fragment injection gives anyone who can send your PreferenceActivity an intent the ability to load any fragment, with any arguments, in your process.", Category.SECURITY, 8, Severity.WARNING, IMPLEMENTATION).addMoreInfo("http://securityintelligence.com/new-vulnerability-android-framework-fragment-injection");
    private static final String PREFERENCE_ACTIVITY = "android.preference.PreferenceActivity";
    private static final String IS_VALID_FRAGMENT = "isValidFragment";
    private final Map<String, Location.Handle> mExportedActivities = new HashMap<String, Location.Handle>();

    @Override
    public Collection<String> getApplicableElements() {
        return Collections.singletonList("activity");
    }

    @Override
    public void visitElement(XmlContext context2, Element element) {
        if (SecurityDetector.getExported(element)) {
            String fqcn = Lint.resolveManifestName(element);
            if (fqcn.equals(PREFERENCE_ACTIVITY) && !context2.getDriver().isSuppressed(context2, ISSUE, element)) {
                String message2 = "`PreferenceActivity` should not be exported";
                context2.report(ISSUE, element, context2.getLocation(element), message2);
            }
            this.mExportedActivities.put(fqcn, context2.createLocationHandle(element));
        }
    }

    @Override
    public List<String> applicableSuperClasses() {
        return Collections.singletonList(PREFERENCE_ACTIVITY);
    }

    @Override
    public void visitClass(JavaContext context2, UClass declaration) {
        if (!context2.getProject().getReportIssues()) {
            return;
        }
        JavaEvaluator evaluator = context2.getEvaluator();
        String className = declaration.getQualifiedName();
        if (evaluator.extendsClass((PsiClass)declaration, PREFERENCE_ACTIVITY, false) && this.isExported(context2, className)) {
            Location location;
            if (context2.getMainProject().getTargetSdk() >= 19 && PreferenceActivityDetector.overridesIsValidFragment(evaluator, (PsiClass)declaration)) {
                return;
            }
            String message2 = String.format("`PreferenceActivity` subclass `%1$s` should not be exported", className);
            if (context2.getScope().contains((Object)Scope.MANIFEST)) {
                location = this.mExportedActivities.get(className).resolve();
            } else {
                location = context2.getNameLocation(declaration);
                message2 = message2 + " in the manifest";
            }
            context2.report(ISSUE, declaration, location, message2);
        }
    }

    private boolean isExported(JavaContext context2, String className) {
        if (className == null) {
            return false;
        }
        if (context2.getScope().contains((Object)Scope.MANIFEST)) {
            return this.mExportedActivities.containsKey(className);
        }
        Project mainProject = context2.getMainProject();
        Document mergedManifest = mainProject.getMergedManifest();
        if (mergedManifest == null || mergedManifest.getDocumentElement() == null) {
            return false;
        }
        Element application = XmlUtils.getFirstSubTagByName((Node)mergedManifest.getDocumentElement(), (String)"application");
        if (application != null) {
            for (Element element : XmlUtils.getSubTags((Node)application)) {
                String fqn;
                String name;
                if (!"activity".equals(element.getTagName()) || !className.endsWith(name = element.getAttributeNS("http://schemas.android.com/apk/res/android", "name")) || !(fqn = Lint.resolveManifestName(element)).equals(className)) continue;
                return SecurityDetector.getExported(element);
            }
        }
        return false;
    }

    private static boolean overridesIsValidFragment(JavaEvaluator evaluator, PsiClass resolvedClass) {
        for (PsiMethod method : resolvedClass.findMethodsByName(IS_VALID_FRAGMENT, false)) {
            if (!evaluator.parametersMatch(method, "java.lang.String")) continue;
            return true;
        }
        return false;
    }
}

