/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.builder.model.AndroidLibrary;
import com.android.builder.model.MavenCoordinates;
import com.android.ide.common.repository.ResourceVisibilityLookup;
import com.android.ide.common.resources.AbstractResourceRepository;
import com.android.resources.FolderTypeRelationship;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.utils.SdkUtils;
import com.android.utils.XmlUtils;
import com.google.common.collect.Lists;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiPackage;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UReferenceExpression;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PrivateResourceDetector
extends ResourceXmlDetector
implements SourceCodeScanner {
    private static final String ATTR_OVERRIDE = "override";
    private static final Implementation IMPLEMENTATION = new Implementation(PrivateResourceDetector.class, Scope.JAVA_AND_RESOURCE_FILES, Scope.JAVA_FILE_SCOPE, Scope.RESOURCE_FILE_SCOPE);
    public static final Issue ISSUE = Issue.create("PrivateResource", "Using private resources", "Private resources should not be referenced; the may not be present everywhere, and even where they are they may disappear without notice.\n\nTo fix this, copy the resource into your own project instead.", Category.CORRECTNESS, 3, Severity.WARNING, IMPLEMENTATION);
    private List<String> overriding;

    @Override
    public boolean appliesToResourceRefs() {
        return true;
    }

    @Override
    public void visitResourceReference(JavaContext context2, UElement node, ResourceType resourceType, String name, boolean isFramework) {
        if (!isFramework && PrivateResourceDetector.isPrivate(context2, resourceType, name)) {
            String pkgName;
            PsiPackage pkg;
            PsiElement resolved;
            boolean foreignPackage = false;
            if (node instanceof UReferenceExpression && (resolved = ((UReferenceExpression)node).resolve()) instanceof PsiField && (pkg = context2.getEvaluator().getPackage(resolved)) != null && !(pkgName = pkg.getQualifiedName()).equals(context2.getProject().getPackage()) && !pkgName.equals(context2.getMainProject().getPackage())) {
                foreignPackage = true;
            }
            if (!foreignPackage) {
                AbstractResourceRepository repository = context2.getClient().getResourceRepository(context2.getMainProject(), true, false);
                if (repository != null && repository.hasResourceItem(resourceType, name)) {
                    return;
                }
                if (this.overriding != null && this.overriding.contains(resourceType + ":" + name)) {
                    return;
                }
            }
            String message2 = PrivateResourceDetector.createUsageErrorMessage(context2, resourceType, name);
            context2.report(ISSUE, node, context2.getLocation(node), message2);
        }
    }

    @Override
    public Collection<String> getApplicableAttributes() {
        return ALL;
    }

    @Override
    public void visitAttribute(XmlContext context2, Attr attribute) {
        String value = attribute.getNodeValue();
        ResourceUrl url = ResourceUrl.parse((String)value);
        if (PrivateResourceDetector.isPrivate(context2, url)) {
            String message2 = PrivateResourceDetector.createUsageErrorMessage(context2, url.type, url.name);
            context2.report(ISSUE, attribute, context2.getValueLocation(attribute), message2);
        }
    }

    @Override
    public Collection<String> getApplicableElements() {
        return Arrays.asList("style", "resources", "array", "string-array", "integer-array", "plurals");
    }

    @Override
    public void visitElement(XmlContext context2, Element element) {
        if ("resources".equals(element.getTagName())) {
            for (Element item : XmlUtils.getSubTags((Node)element)) {
                ResourceType t;
                Attr nameAttribute = item.getAttributeNode("name");
                if (nameAttribute == null) continue;
                String name = SdkUtils.getResourceFieldName((String)nameAttribute.getValue());
                String type = item.getTagName();
                if (type.equals("item")) {
                    type = item.getAttribute("type");
                    if (type == null || type.isEmpty()) {
                        type = "id";
                    }
                } else if (type.equals("declare-styleable")) {
                    type = "styleable";
                } else if (type.contains("array")) {
                    type = "array";
                }
                if ((t = ResourceType.getEnum((String)type)) == null || !PrivateResourceDetector.isPrivate(context2, t, name)) continue;
                if (this.overriding == null) {
                    this.overriding = Lists.newArrayList();
                }
                this.overriding.add(type + ":" + name);
                if ("true".equals(item.getAttributeNS("http://schemas.android.com/tools", ATTR_OVERRIDE))) continue;
                String message2 = PrivateResourceDetector.createOverrideErrorMessage(context2, t, name);
                Location location = context2.getValueLocation(nameAttribute);
                context2.report(ISSUE, nameAttribute, location, message2);
            }
        } else {
            assert ("style".equals(element.getTagName()) || "array".equals(element.getTagName()) || "plurals".equals(element.getTagName()) || "integer-array".equals(element.getTagName()) || "string-array".equals(element.getTagName()));
            for (Element item : XmlUtils.getSubTags((Node)element)) {
                PrivateResourceDetector.checkChildRefs(context2, item);
            }
        }
    }

    private static boolean isPrivate(Context context2, ResourceType type, String name) {
        if (type == ResourceType.ID) {
            return false;
        }
        ResourceVisibilityLookup lookup = context2.getProject().getResourceVisibility();
        return lookup.isPrivate(type, name);
    }

    private static boolean isPrivate(Context context2, ResourceUrl url) {
        return url != null && !url.isFramework() && PrivateResourceDetector.isPrivate(context2, url.type, url.name);
    }

    private static void checkChildRefs(XmlContext context2, Element item) {
        NodeList childNodes = item.getChildNodes();
        int n = childNodes.getLength();
        block0: for (int i = 0; i < n; ++i) {
            Node child = childNodes.item(i);
            if (child.getNodeType() != 3) continue;
            String text = child.getNodeValue();
            int index = text.indexOf("?attr/");
            if (index != -1) {
                String name = text.substring(index + "?attr/".length()).trim();
                if (!PrivateResourceDetector.isPrivate(context2, ResourceType.ATTR, name)) continue;
                String message2 = PrivateResourceDetector.createUsageErrorMessage(context2, ResourceType.ATTR, name);
                context2.report(ISSUE, item, context2.getLocation(child), message2);
                continue;
            }
            int m = text.length();
            for (int j = 0; j < m; ++j) {
                char c = text.charAt(j);
                if (c == '@') {
                    ResourceUrl url = ResourceUrl.parse((String)text.trim());
                    if (!PrivateResourceDetector.isPrivate(context2, url)) continue block0;
                    String message3 = PrivateResourceDetector.createUsageErrorMessage(context2, url.type, url.name);
                    context2.report(ISSUE, item, context2.getLocation(child), message3);
                    continue block0;
                }
                if (!Character.isWhitespace(c)) continue block0;
            }
        }
    }

    @Override
    public void beforeCheckFile(Context context2) {
        String resourceName;
        File file = context2.file;
        if (!Lint.isXmlFile(file) && !SdkUtils.isBitmapFile((File)file)) {
            return;
        }
        String parentName = file.getParentFile().getName();
        int dash = parentName.indexOf(45);
        if (dash != -1 || "values".equals(parentName)) {
            return;
        }
        ResourceFolderType folderType = ResourceFolderType.getFolderType((String)parentName);
        if (folderType == null) {
            return;
        }
        List types = FolderTypeRelationship.getRelatedResourceTypes((ResourceFolderType)folderType);
        if (types.isEmpty()) {
            return;
        }
        ResourceType type = (ResourceType)types.get(0);
        if (PrivateResourceDetector.isPrivate(context2, type, resourceName = SdkUtils.getResourceFieldName((String)Lint.getBaseName(file.getName())))) {
            String message2 = PrivateResourceDetector.createOverrideErrorMessage(context2, type, resourceName);
            Location location = Location.create(file);
            context2.report(ISSUE, location, message2);
        }
    }

    private static String createOverrideErrorMessage(Context context2, ResourceType type, String name) {
        String libraryName = PrivateResourceDetector.getLibraryName(context2, type, name);
        return String.format("Overriding `@%1$s/%2$s` which is marked as private in %3$s. If deliberate, use tools:override=\"true\", otherwise pick a different name.", type, name, libraryName);
    }

    private static String createUsageErrorMessage(Context context2, ResourceType type, String name) {
        String libraryName = PrivateResourceDetector.getLibraryName(context2, type, name);
        return String.format("The resource `@%1$s/%2$s` is marked as private in %3$s", type, name, libraryName);
    }

    private static String getLibraryName(Context context2, ResourceType type, String name) {
        ResourceVisibilityLookup lookup = context2.getProject().getResourceVisibility();
        AndroidLibrary library = lookup.getPrivateIn(type, name);
        if (library != null) {
            String libraryName = library.getProject();
            if (libraryName != null) {
                return libraryName;
            }
            MavenCoordinates coordinates = library.getResolvedCoordinates();
            if (coordinates != null) {
                return coordinates.getGroupId() + ':' + coordinates.getArtifactId();
            }
        }
        return "the library";
    }
}

