/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UastLiteralUtils;

public class ReadParcelableDetector
extends Detector
implements SourceCodeScanner {
    public static final Issue ISSUE = Issue.create("ParcelClassLoader", "Default Parcel Class Loader", "The documentation for `Parcel#readParcelable(ClassLoader)` (and its variations) says that you can pass in `null` to pick up the default class loader. However, that ClassLoader is a system class loader and is not able to find classes in your own application.\n\nIf you are writing your own classes into the `Parcel` (not just SDK classes like `String` and so on), then you should supply a `ClassLoader` for your application instead; a simple way to obtain one is to just call `getClass().getClassLoader()` from your own class.", Category.CORRECTNESS, 3, Severity.WARNING, new Implementation(ReadParcelableDetector.class, Scope.JAVA_FILE_SCOPE)).addMoreInfo("http://developer.android.com/reference/android/os/Parcel.html");

    @Override
    public List<String> getApplicableMethodNames() {
        return Arrays.asList("readParcelable", "readParcelableArray", "readBundle", "readArray", "readSparseArray", "readValue", "readPersistableBundle");
    }

    @Override
    public void visitMethod(JavaContext context2, UCallExpression node, PsiMethod method) {
        UExpression parameter;
        PsiClass containingClass = method.getContainingClass();
        if (containingClass == null) {
            return;
        }
        if (!"android.os.Parcel".equals(containingClass.getQualifiedName())) {
            return;
        }
        List expressions = node.getValueArguments();
        int argumentCount = expressions.size();
        if (argumentCount == 0) {
            String message2 = String.format("Using the default class loader will not work if you are restoring your own classes. Consider using for example `%1$s(getClass().getClassLoader())` instead.", Lint.getMethodName(node));
            LintFix fix = ReadParcelableDetector.createQuickfixData(")");
            Location location = context2.getCallLocation(node, false, true);
            context2.report(ISSUE, (UElement)node, location, message2, fix);
        } else if (argumentCount == 1 && UastLiteralUtils.isNullLiteral((UElement)(parameter = (UExpression)expressions.get(0)))) {
            String message3 = "Passing null here (to use the default class loader) will not work if you are restoring your own classes. Consider using for example `getClass().getClassLoader()` instead.";
            Location location = context2.getCallLocation(node, false, true);
            LintFix fix = ReadParcelableDetector.createQuickfixData("null)");
            context2.report(ISSUE, (UElement)node, location, message3, fix);
        }
    }

    private static LintFix createQuickfixData(String parameter) {
        return LintFix.create().name("Use getClass().getClassLoader()").replace().text(parameter).with("getClass().getClassLoader())").build();
    }
}

