/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.CutPasteDetector;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiVariable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.uast.UAnonymousClass;
import org.jetbrains.uast.UBinaryExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.ULocalVariable;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.USimpleNameReferenceExpression;
import org.jetbrains.uast.UVariable;
import org.jetbrains.uast.UastBinaryOperator;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.util.UastExpressionUtils;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

public class RecyclerViewDetector
extends Detector
implements SourceCodeScanner {
    public static final Implementation IMPLEMENTATION = new Implementation(RecyclerViewDetector.class, Scope.JAVA_FILE_SCOPE);
    public static final Issue FIXED_POSITION = Issue.create("RecyclerView", "RecyclerView Problems", "`RecyclerView` will **not** call `onBindViewHolder` again when the position of the item changes in the data set unless the item itself is invalidated or the new position cannot be determined.\n\nFor this reason, you should **only** use the position parameter while acquiring the related data item inside this method, and should **not** keep a copy of it.\n\nIf you need the position of an item later on (e.g. in a click listener), use `getAdapterPosition()` which will have the updated adapter position.", Category.CORRECTNESS, 8, Severity.ERROR, IMPLEMENTATION);
    public static final Issue DATA_BINDER = Issue.create("PendingBindings", "Missing Pending Bindings", "When using a `ViewDataBinding` in a `onBindViewHolder` method, you **must** call `executePendingBindings()` before the method exits; otherwise the data binding runtime will update the UI in the next animation frame causing a delayed update and potential jumps if the item resizes.", Category.CORRECTNESS, 8, Severity.ERROR, IMPLEMENTATION);
    private static final String VIEW_ADAPTER = "android.support.v7.widget.RecyclerView.Adapter";
    private static final String ON_BIND_VIEW_HOLDER = "onBindViewHolder";

    @Override
    public List<String> applicableSuperClasses() {
        return Collections.singletonList(VIEW_ADAPTER);
    }

    @Override
    public void visitClass(JavaContext context2, UClass declaration) {
        JavaEvaluator evaluator = context2.getEvaluator();
        for (PsiMethod method : declaration.findMethodsByName(ON_BIND_VIEW_HOLDER, false)) {
            int size = evaluator.getParameterCount(method);
            if (size != 2 && size != 3) continue;
            RecyclerViewDetector.checkMethod(context2, method, (PsiClass)declaration);
        }
    }

    private static void checkMethod(JavaContext context2, PsiMethod declaration, PsiClass cls) {
        PsiParameter[] parameters = declaration.getParameterList().getParameters();
        PsiParameter viewHolder = parameters[0];
        PsiParameter parameter = parameters[1];
        ParameterEscapesVisitor visitor = new ParameterEscapesVisitor(context2, cls, parameter);
        UMethod method = context2.getUastContext().getMethod(declaration);
        method.accept((UastVisitor)visitor);
        if (visitor.variableEscapes()) {
            RecyclerViewDetector.reportError(context2, viewHolder, parameter);
        }
        List dataBinderReferences = visitor.getDataBinders();
        RecyclerViewDetector.checkDataBinders(context2, method, dataBinderReferences);
    }

    private static void reportError(JavaContext context2, PsiParameter viewHolder, PsiParameter parameter) {
        String variablePrefix = viewHolder.getName();
        if (variablePrefix == null) {
            variablePrefix = "ViewHolder";
        }
        String message2 = String.format("Do not treat position as fixed; only use immediately and call `%1$s.getAdapterPosition()` to look it up later", variablePrefix);
        context2.report(FIXED_POSITION, (PsiElement)parameter, context2.getLocation((PsiElement)parameter), message2);
    }

    private static void checkDataBinders(JavaContext context2, UMethod declaration, List<UCallExpression> references) {
        if (references != null && !references.isEmpty()) {
            ArrayList targets = Lists.newArrayList();
            ArrayList sources = Lists.newArrayList();
            for (UCallExpression ref : references) {
                if (RecyclerViewDetector.isExecutePendingBindingsCall(ref)) {
                    targets.add(ref);
                    continue;
                }
                sources.add(ref);
            }
            HashMap parentToChildren = Maps.newHashMap();
            for (UCallExpression reference : sources) {
                UExpression statement = (UExpression)UastUtils.getParentOfType((UElement)reference, UExpression.class, (boolean)true);
                if (statement == null) continue;
                parentToChildren.put(statement.getUastParent(), reference);
            }
            for (UCallExpression source : parentToChildren.values()) {
                UExpression sourceBinderReference = source.getReceiver();
                PsiField sourceDataBinder = RecyclerViewDetector.getDataBinderReference((UElement)sourceBinderReference);
                assert (sourceDataBinder != null);
                boolean reachesTarget = false;
                for (UCallExpression target : targets) {
                    if (!sourceDataBinder.equals(RecyclerViewDetector.getDataBinderReference((UElement)target.getReceiver())) || !CutPasteDetector.isReachableFrom(declaration, (UElement)source, (UElement)target)) continue;
                    reachesTarget = true;
                    break;
                }
                if (reachesTarget) continue;
                String message2 = String.format("You must call `%1$s.executePendingBindings()` before the `onBind` method exits, otherwise, the DataBinding library will update the UI in the next animation frame causing a delayed update & potential jumps if the item resizes.", sourceBinderReference.asSourceString());
                Location location = context2.getLocation((UElement)source);
                context2.report(DATA_BINDER, (UElement)source, location, message2);
            }
        }
    }

    private static boolean isExecutePendingBindingsCall(UCallExpression call) {
        return "executePendingBindings".equals(Lint.getMethodName(call));
    }

    private static PsiField getDataBinderReference(UElement element) {
        PsiField field;
        PsiElement resolved;
        if (element instanceof UReferenceExpression && (resolved = ((UReferenceExpression)element).resolve()) instanceof PsiField && "dataBinder".equals((field = (PsiField)resolved).getName())) {
            return field;
        }
        return null;
    }

    private static class ParameterEscapesVisitor
    extends AbstractUastVisitor {
        protected final JavaContext mContext;
        protected final List<PsiVariable> mVariables;
        private final PsiClass mBindClass;
        private boolean mEscapes;
        private boolean mFoundInnerClass;
        private List<UCallExpression> mDataBinders = null;

        private ParameterEscapesVisitor(JavaContext context2, PsiClass bindClass, PsiParameter variable) {
            this.mContext = context2;
            this.mVariables = Lists.newArrayList((Object[])new PsiVariable[]{variable});
            this.mBindClass = bindClass;
        }

        public boolean variableEscapes() {
            return this.mEscapes;
        }

        public boolean visitVariable(UVariable variable) {
            PsiElement resolved;
            UExpression initializer = variable.getUastInitializer();
            if (initializer instanceof UReferenceExpression && (resolved = ((UReferenceExpression)initializer).resolve()) != null && this.mVariables.contains(resolved)) {
                if (resolved instanceof ULocalVariable) {
                    this.mVariables.add((PsiVariable)variable);
                } else if (resolved instanceof PsiField) {
                    this.mEscapes = true;
                }
            }
            return super.visitVariable(variable);
        }

        public boolean visitBinaryExpression(UBinaryExpression node) {
            if (node.getOperator() instanceof UastBinaryOperator.AssignOperator) {
                PsiElement resolved;
                UExpression rhs = node.getRightOperand();
                boolean clearLhs = true;
                if (rhs instanceof UReferenceExpression && (resolved = ((UReferenceExpression)rhs).resolve()) != null && this.mVariables.contains(resolved)) {
                    clearLhs = false;
                    PsiElement resolvedLhs = UastUtils.tryResolve((UElement)node.getLeftOperand());
                    if (resolvedLhs instanceof PsiLocalVariable) {
                        PsiLocalVariable variable = (PsiLocalVariable)resolvedLhs;
                        this.mVariables.add((PsiVariable)variable);
                    } else if (resolvedLhs instanceof PsiField) {
                        this.mEscapes = true;
                    }
                }
                if (clearLhs && (resolved = UastUtils.tryResolve((UElement)node.getLeftOperand())) != null && this.mVariables.contains(resolved)) {
                    this.mVariables.remove(resolved);
                }
            }
            return super.visitBinaryExpression(node);
        }

        public boolean visitSimpleNameReferenceExpression(USimpleNameReferenceExpression node) {
            PsiClass outer;
            PsiElement resolved;
            if (this.mFoundInnerClass && (resolved = node.resolve()) != null && this.mVariables.contains(resolved) && !this.mBindClass.equals(outer = (PsiClass)UastUtils.getParentOfType((UElement)node, UClass.class, (boolean)true))) {
                this.mEscapes = true;
            }
            return super.visitSimpleNameReferenceExpression(node);
        }

        public boolean visitClass(UClass node) {
            if (node instanceof UAnonymousClass || !node.isStatic()) {
                this.mFoundInnerClass = true;
            }
            return super.visitClass(node);
        }

        private List<UCallExpression> getDataBinders() {
            return this.mDataBinders;
        }

        public boolean visitCallExpression(UCallExpression expression) {
            UExpression methodExpression;
            PsiField dataBinder;
            if (UastExpressionUtils.isMethodCall((UElement)expression) && (dataBinder = RecyclerViewDetector.getDataBinderReference((UElement)(methodExpression = expression.getReceiver()))) != null) {
                if (this.mDataBinders == null) {
                    this.mDataBinders = Lists.newArrayList();
                }
                this.mDataBinders.add(expression);
            }
            return super.visitCallExpression(expression);
        }
    }
}

