/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.ide.common.rendering.api.ResourceValue;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LayoutDetector;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TextFieldDetector
extends LayoutDetector {
    public static final Issue ISSUE = Issue.create("TextFields", "Missing `inputType`", "Providing an `inputType` attribute on a text field improves usability because depending on the data to be input, optimized keyboards can be shown to the user (such as just digits and parentheses for a phone number). \n\nThe lint detector also looks at the `id` of the view, and if the id offers a hint of the purpose of the field (for example, the `id` contains the phrase `phone` or `email`), then lint will also ensure that the `inputType` contains the corresponding type attributes.\n\nIf you really want to keep the text field generic, you can suppress this warning by setting `inputType=\"text\"`.", Category.USABILITY, 5, Severity.WARNING, new Implementation(TextFieldDetector.class, Scope.RESOURCE_FILE_SCOPE));

    @Override
    public Collection<String> getApplicableElements() {
        return Collections.singletonList("EditText");
    }

    @Override
    public void visitElement(XmlContext context2, Element element) {
        String message2;
        String style;
        Node inputTypeNode = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "inputType");
        String inputType = "";
        if (inputTypeNode != null) {
            inputType = inputTypeNode.getNodeValue();
        }
        if (inputTypeNode == null && (style = element.getAttribute("style")) != null && !style.isEmpty()) {
            LintClient client = context2.getClient();
            if (client.supportsProjectResources()) {
                Project project = context2.getMainProject();
                List<ResourceValue> styles = Lint.getStyleAttributes(project, client, style, "http://schemas.android.com/apk/res/android", "inputType");
                if (styles != null && !styles.isEmpty()) {
                    ResourceValue value = styles.get(0);
                    inputType = value.getValue();
                    inputTypeNode = element;
                }
            } else {
                return;
            }
        }
        if (inputTypeNode == null) {
            if (element.hasAttributeNS("http://schemas.android.com/apk/res/android", "inputMethod")) {
                return;
            }
            LintFix fix = this.fix().set("http://schemas.android.com/apk/res/android", "inputType", "").caretBegin().build();
            context2.report(ISSUE, (Node)element, context2.getNameLocation(element), "This text field does not specify an `inputType`", fix);
            return;
        }
        assert (inputType != null);
        Attr idNode = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "id");
        if (idNode == null) {
            return;
        }
        String id = idNode.getValue();
        if (id.isEmpty()) {
            return;
        }
        if (id.startsWith("editText")) {
            return;
        }
        if (TextFieldDetector.containsWord(id, "phone", true, true)) {
            if (!inputType.contains("phone") && element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "phoneNumber") == null) {
                message2 = String.format("The view name (`%1$s`) suggests this is a phone number, but it does not include '`phone`' in the `inputType`", id);
                TextFieldDetector.reportMismatch(context2, idNode, inputTypeNode, message2);
            }
            return;
        }
        if (TextFieldDetector.containsWord(id, "width", false, true) || TextFieldDetector.containsWord(id, "height", false, true) || TextFieldDetector.containsWord(id, "size", false, true) || TextFieldDetector.containsWord(id, "length", false, true) || TextFieldDetector.containsWord(id, "weight", false, true) || TextFieldDetector.containsWord(id, "number", false, true)) {
            if (!inputType.contains("number") && !inputType.contains("phone")) {
                message2 = String.format("The view name (`%1$s`) suggests this is a number, but it does not include a numeric `inputType` (such as '`numberSigned`')", id);
                TextFieldDetector.reportMismatch(context2, idNode, inputTypeNode, message2);
            }
            return;
        }
        if (TextFieldDetector.containsWord(id, "password", true, true)) {
            if (!inputType.contains("Password") && element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "password") == null) {
                message2 = String.format("The view name (`%1$s`) suggests this is a password, but it does not include '`textPassword`' in the `inputType`", id);
                TextFieldDetector.reportMismatch(context2, idNode, inputTypeNode, message2);
            }
            return;
        }
        if (TextFieldDetector.containsWord(id, "email", true, true)) {
            if (!inputType.contains("Email")) {
                message2 = String.format("The view name (`%1$s`) suggests this is an e-mail address, but it does not include '`textEmail`' in the `inputType`", id);
                TextFieldDetector.reportMismatch(context2, idNode, inputTypeNode, message2);
            }
            return;
        }
        if (TextFieldDetector.endsWith(id, "pin", false, true)) {
            if (!inputType.contains("numberPassword") && element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "password") == null) {
                message2 = String.format("The view name (`%1$s`) suggests this is a password, but it does not include '`numberPassword`' in the `inputType`", id);
                TextFieldDetector.reportMismatch(context2, idNode, inputTypeNode, message2);
            }
            return;
        }
        if ((TextFieldDetector.containsWord(id, "uri") || TextFieldDetector.containsWord(id, "url")) && !inputType.contains("textUri")) {
            message2 = String.format("The view name (`%1$s`) suggests this is a URI, but it does not include '`textUri`' in the `inputType`", id);
            TextFieldDetector.reportMismatch(context2, idNode, inputTypeNode, message2);
        }
        if (TextFieldDetector.containsWord(id, "date") && !inputType.contains("date")) {
            message2 = String.format("The view name (`%1$s`) suggests this is a date, but it does not include '`date`' or '`datetime`' in the `inputType`", id);
            TextFieldDetector.reportMismatch(context2, idNode, inputTypeNode, message2);
        }
    }

    private static void reportMismatch(XmlContext context2, Attr idNode, Node inputTypeNode, String message2) {
        Location location;
        if (inputTypeNode != null) {
            location = context2.getLocation(inputTypeNode);
            Location secondary = context2.getLocation(idNode);
            secondary.setMessage("id defined here");
            location.setSecondary(secondary);
        } else {
            location = context2.getLocation(idNode);
        }
        context2.report(ISSUE, idNode.getOwnerElement(), location, message2);
    }

    static boolean containsWord(String sentence, String word) {
        return TextFieldDetector.containsWord(sentence, word, false, false);
    }

    static boolean containsWord(String sentence, String word, boolean allowPrefix, boolean allowSuffix) {
        return TextFieldDetector.indexOfWord(sentence, word, allowPrefix, allowSuffix) != -1;
    }

    private static boolean endsWith(String sentence, String word, boolean allowPrefix, boolean allowSuffix) {
        int index = TextFieldDetector.indexOfWord(sentence, word, allowPrefix, allowSuffix);
        return index != -1 && index == sentence.length() - word.length();
    }

    private static int indexOfWord(String sentence, String word, boolean allowPrefix, boolean allowSuffix) {
        if (sentence.isEmpty()) {
            return -1;
        }
        int wordLength = word.length();
        if (wordLength > sentence.length()) {
            return -1;
        }
        char firstUpper = Character.toUpperCase(word.charAt(0));
        char firstLower = Character.toLowerCase(firstUpper);
        int start = 0;
        if (sentence.startsWith("@+id/")) {
            start += "@+id/".length();
        } else if (sentence.startsWith("@id/")) {
            start += "@id/".length();
        }
        int n = sentence.length();
        int m = n - (wordLength - 1);
        for (int i = start; i < m; ++i) {
            char c = sentence.charAt(i);
            if (c != firstUpper && c != firstLower || !sentence.regionMatches(true, i, word, 0, wordLength)) continue;
            if (i <= start && allowPrefix) {
                return i;
            }
            if (i == m - 1 && allowSuffix) {
                return i;
            }
            if (i > start && sentence.charAt(i - 1) != '_' && !Character.isUpperCase(c)) continue;
            if (i == m - 1) {
                return i;
            }
            char after = sentence.charAt(i + wordLength);
            if (after != '_' && !Character.isUpperCase(after)) continue;
            return i;
        }
        return -1;
    }
}

