/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.builder.model.AndroidProject;
import com.android.builder.model.Variant;
import com.android.ide.common.repository.GradleVersion;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceUrl;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import java.util.ArrayDeque;
import java.util.function.Predicate;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class VectorDetector
extends ResourceXmlDetector {
    public static final Issue ISSUE = Issue.create("VectorRaster", "Vector Image Generation", "Vector icons require API 21 or API 24 depending on used features, but when `minSdkVersion` is less than 21 or 24 and Android Gradle plugin 1.4 or higher is used, a vector drawable placed in the `drawable` folder is automatically moved to `drawable-anydpi-v21` or `drawable-anydpi-v24` and bitmap images are generated for different screen resolutions for backwards compatibility.\n\nHowever, there are some limitations to this raster image generation, and this lint check flags elements and attributes that are not fully supported. You should manually check whether the generated output is acceptable for those older devices.", Category.CORRECTNESS, 5, Severity.WARNING, new Implementation(VectorDetector.class, Scope.RESOURCE_FILE_SCOPE));

    @Override
    public boolean appliesTo(ResourceFolderType folderType) {
        return folderType == ResourceFolderType.DRAWABLE;
    }

    public static boolean isVectorGenerationSupported(Project project) {
        GradleVersion modelVersion = project.getGradleModelVersion();
        return modelVersion != null && modelVersion.isAtLeastIncludingPreviews(1, 4, 0);
    }

    public static boolean isVectorGenerationSupportedForGradient(Project project) {
        GradleVersion modelVersion = project.getGradleModelVersion();
        return modelVersion != null && modelVersion.isAtLeastIncludingPreviews(3, 1, 0);
    }

    public static boolean isVectorGenerationSupportedForFillType(Project project) {
        GradleVersion modelVersion = project.getGradleModelVersion();
        return modelVersion != null && modelVersion.isAtLeastIncludingPreviews(3, 2, 0);
    }

    @Override
    public void visitDocument(XmlContext context2, Document document) {
        boolean generationDueToGradient;
        int apiThreshold = 24;
        Project project = context2.getMainProject();
        if (project.getMinSdkVersion().getFeatureLevel() >= apiThreshold) {
            return;
        }
        if (!project.isGradleProject()) {
            return;
        }
        if (!VectorDetector.isVectorGenerationSupported(project)) {
            return;
        }
        Element root = document.getDocumentElement();
        if (root == null || !root.getTagName().equals("vector")) {
            return;
        }
        if (context2.getFolderVersion() >= apiThreshold) {
            return;
        }
        boolean bl = generationDueToGradient = VectorDetector.containsGradient(document) && VectorDetector.isVectorGenerationSupportedForGradient(project);
        if (!generationDueToGradient) {
            boolean generationDueToFillType;
            if (VectorDetector.usingSupportLibVectors(project)) {
                return;
            }
            boolean bl2 = generationDueToFillType = VectorDetector.containsFillType(document) && VectorDetector.isVectorGenerationSupportedForFillType(project);
            if (!generationDueToFillType) {
                apiThreshold = 21;
                if (project.getMinSdkVersion().getFeatureLevel() >= apiThreshold) {
                    return;
                }
                if (context2.getFolderVersion() >= apiThreshold) {
                    return;
                }
            }
        }
        VectorDetector.checkSupported(context2, root, apiThreshold);
    }

    private static boolean containsGradient(Document document) {
        return VectorDetector.findElement(document, element -> "gradient".equals(element.getTagName())) != null;
    }

    private static boolean containsFillType(Document document) {
        return VectorDetector.findElement(document, element -> element.hasAttributeNS("http://schemas.android.com/apk/res/android", "fillType")) != null;
    }

    private static Element findElement(Document document, Predicate<Element> predicate) {
        Element element;
        ArrayDeque<Element> elements = new ArrayDeque<Element>();
        elements.add(document.getDocumentElement());
        while ((element = (Element)elements.poll()) != null) {
            if (predicate.test(element)) {
                return element;
            }
            NodeList children = element.getChildNodes();
            int n = children.getLength();
            for (int i = 0; i < n; ++i) {
                Node child = children.item(i);
                if (child.getNodeType() != 1) continue;
                elements.add((Element)child);
            }
        }
        return null;
    }

    static boolean usingSupportLibVectors(Project project) {
        GradleVersion version = project.getGradleModelVersion();
        if (version == null || version.getMajor() < 2) {
            return false;
        }
        Variant currentVariant = project.getCurrentVariant();
        return currentVariant != null && Boolean.TRUE.equals(currentVariant.getMergedFlavor().getVectorDrawables().getUseSupportLibrary());
    }

    private static void checkSupported(XmlContext context2, Element element, int apiThreshold) {
        AndroidProject model;
        String tag = element.getTagName();
        if ("clip-path".equals(tag)) {
            String message2 = String.format("This tag is not supported in images generated from this vector icon for API < %d; check generated icon to make sure it looks acceptable", apiThreshold);
            context2.report(ISSUE, element, context2.getLocation(element), message2);
        } else if ("group".equals(tag) && (model = context2.getMainProject().getGradleProjectModel()) != null && model.getModelVersion().startsWith("1.4.")) {
            String message3 = "Update Gradle plugin version to 1.5+ to correctly handle `<group>` tags in generated bitmaps";
            context2.report(ISSUE, element, context2.getElementLocation(element), message3);
        }
        NamedNodeMap attributes = element.getAttributes();
        int n = attributes.getLength();
        for (int i = 0; i < n; ++i) {
            String value;
            Attr attr = (Attr)attributes.item(i);
            String name = attr.getLocalName();
            if (("autoMirrored".equals(name) || "trimPathStart".equals(name) || "trimPathEnd".equals(name) || "trimPathOffset".equals(name)) && "http://schemas.android.com/apk/res/android".equals(attr.getNamespaceURI())) {
                String message4 = String.format("This attribute is not supported in images generated from this vector icon for API < %d; check generated icon to make sure it looks acceptable", apiThreshold);
                context2.report(ISSUE, attr, context2.getNameLocation(attr), message4);
            }
            if (ResourceUrl.parse((String)(value = attr.getValue())) == null) continue;
            String message5 = String.format("Resource references will not work correctly in images generated for this vector icon for API < %d; check generated icon to make sure it looks acceptable", apiThreshold);
            context2.report(ISSUE, attr, context2.getValueLocation(attr), message5);
        }
        NodeList children = element.getChildNodes();
        int n2 = children.getLength();
        for (int i = 0; i < n2; ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1) continue;
            VectorDetector.checkSupported(context2, (Element)child, apiThreshold);
        }
    }
}

