/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.client.api.UElementHandler;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.google.common.collect.Lists;
import com.intellij.psi.PsiMethod;
import java.util.Collections;
import java.util.List;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UIfExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.USwitchExpression;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.util.UastExpressionUtils;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

public class ViewHolderDetector
extends Detector
implements SourceCodeScanner {
    private static final Implementation IMPLEMENTATION = new Implementation(ViewHolderDetector.class, Scope.JAVA_FILE_SCOPE);
    public static final Issue ISSUE = Issue.create("ViewHolder", "View Holder Candidates", "When implementing a view Adapter, you should avoid unconditionally inflating a new layout; if an available item is passed in for reuse, you should try to use that one instead. This helps make for example ListView scrolling much smoother.", Category.PERFORMANCE, 5, Severity.WARNING, IMPLEMENTATION).addMoreInfo("http://developer.android.com/training/improving-layouts/smooth-scrolling.html#ViewHolder");
    private static final String GET_VIEW = "getView";
    static final String INFLATE = "inflate";

    @Override
    public List<Class<? extends UElement>> getApplicableUastTypes() {
        return Collections.singletonList(UMethod.class);
    }

    @Override
    public UElementHandler createUastHandler(JavaContext context2) {
        return new ViewAdapterVisitor(context2);
    }

    private static class InflationVisitor
    extends AbstractUastVisitor {
        private final JavaContext context;
        private List<UCallExpression> nodes;
        private boolean haveConditional;

        public InflationVisitor(JavaContext context2) {
            this.context = context2;
        }

        public boolean visitCallExpression(UCallExpression node) {
            if (UastExpressionUtils.isMethodCall((UElement)node)) {
                this.checkMethodCall(node);
            }
            return super.visitCallExpression(node);
        }

        private void checkMethodCall(UCallExpression node) {
            String methodName;
            UExpression receiver = node.getReceiver();
            if (receiver != null && ViewHolderDetector.INFLATE.equals(methodName = Lint.getMethodName(node)) && node.getValueArgumentCount() >= 1) {
                boolean insideIf = false;
                if (UastUtils.getParentOfType((UElement)node, (boolean)true, UIfExpression.class, (Class[])new Class[]{USwitchExpression.class}) != null) {
                    insideIf = true;
                    this.haveConditional = true;
                }
                if (!insideIf) {
                    if (this.nodes == null) {
                        this.nodes = Lists.newArrayList();
                    }
                    this.nodes.add(node);
                }
            }
        }

        public void finish() {
            if (!this.haveConditional && this.nodes != null) {
                for (UCallExpression node : this.nodes) {
                    String message2 = "Unconditional layout inflation from view adapter: Should use View Holder pattern (use recycled view passed into this method as the second parameter) for smoother scrolling";
                    this.context.report(ISSUE, (UElement)node, this.context.getLocation((UElement)node), message2);
                }
            }
        }
    }

    private static class ViewAdapterVisitor
    extends UElementHandler {
        private final JavaContext context;

        public ViewAdapterVisitor(JavaContext context2) {
            this.context = context2;
        }

        @Override
        public void visitMethod(UMethod method) {
            if (ViewAdapterVisitor.isViewAdapterMethod(this.context, (PsiMethod)method)) {
                InflationVisitor visitor = new InflationVisitor(this.context);
                method.accept((UastVisitor)visitor);
                visitor.finish();
            }
        }

        private static boolean isViewAdapterMethod(JavaContext context2, PsiMethod node) {
            JavaEvaluator evaluator = context2.getEvaluator();
            return ViewHolderDetector.GET_VIEW.equals(node.getName()) && evaluator.parametersMatch(node, "int", "android.view.View", "android.view.ViewGroup");
        }
    }
}

