/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.client.api;

import com.android.ide.common.blame.SourceFile;
import com.android.ide.common.blame.SourceFilePosition;
import com.android.manifmerger.Actions;
import com.android.manifmerger.XmlNode;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.XmlParser;
import com.android.utils.Pair;
import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.UnmodifiableIterator;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 \u001a2\u00020\u0001:\u0003\u0019\u001a\u001bB%\b\u0000\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0012\u0010\t\u001a\u0004\u0018\u00010\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0002J0\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f\u0018\u00010\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002J&\u0010\u0014\u001a\u0012\u0012\u0004\u0012\u00020\u000e\u0012\u0006\b\u0001\u0012\u00020\u000f\u0018\u00010\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0013J$\u0010\u0016\u001a\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f\u0018\u00010\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000bJ&\u0010\u0017\u001a\u0012\u0012\u0004\u0012\u00020\u000e\u0012\u0006\b\u0001\u0012\u00020\u000f\u0018\u00010\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u000fR\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/android/tools/lint/client/api/BlameFile;", "", "nodes", "", "", "Lcom/android/tools/lint/client/api/BlameFile$BlameNode;", "actions", "Lcom/android/manifmerger/Actions;", "(Ljava/util/Map;Lcom/android/manifmerger/Actions;)V", "findBlameNode", "element", "Lorg/w3c/dom/Element;", "findElementOrAttribute", "Lcom/android/utils/Pair;", "Ljava/io/File;", "Lorg/w3c/dom/Node;", "client", "Lcom/android/tools/lint/client/api/LintClient;", "attribute", "Lorg/w3c/dom/Attr;", "findSourceAttribute", "attr", "findSourceElement", "findSourceNode", "node", "BlameNode", "Companion", "XmlVisitor", "android.sdktools.lint-api"})
public final class BlameFile {
    private final Map<String, BlameNode> nodes;
    private final Actions actions;
    @NotNull
    private static final BlameFile NONE;
    public static final Companion Companion;

    private final BlameNode findBlameNode(Element element) {
        String key = BlameFile.Companion.getNodeKey(element);
        BlameNode blameNode = this.nodes.get(key);
        if (blameNode == null && this.actions != null) {
            Object object;
            XmlNode.NodeKey nodeKey = XmlNode.NodeKey.fromXml((Element)element);
            ImmutableList records = this.actions.getNodeRecords(nodeKey);
            UnmodifiableIterator unmodifiableIterator = records.iterator();
            while (unmodifiableIterator.hasNext()) {
                SourceFilePosition actionLocation;
                Actions.NodeRecord record;
                Actions.NodeRecord nodeRecord = record = (Actions.NodeRecord)unmodifiableIterator.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)nodeRecord, (String)"record");
                Actions.ActionType actionType = nodeRecord.getActionType();
                if (!Intrinsics.areEqual((Object)actionType, (Object)Actions.ActionType.ADDED) && !Intrinsics.areEqual((Object)actionType, (Object)Actions.ActionType.MERGED)) continue;
                if (blameNode == null) {
                    blameNode = new BlameNode(key);
                    object = this.nodes;
                    BlameNode blameNode2 = blameNode;
                    object.put(key, blameNode2);
                }
                SourceFilePosition sourceFilePosition = actionLocation = record.getActionLocation();
                Intrinsics.checkExpressionValueIsNotNull((Object)sourceFilePosition, (String)"actionLocation");
                SourceFile sourceFile = sourceFilePosition.getFile();
                Intrinsics.checkExpressionValueIsNotNull((Object)sourceFile, (String)"actionLocation.file");
                File sourceFile2 = sourceFile.getSourceFile();
                if (sourceFile2 == null) continue;
                blameNode.setElementLocation(" from " + sourceFile2.getPath());
            }
            for (XmlNode.NodeName nodeName : this.actions.getRecordedAttributeNames(nodeKey)) {
                object = this.actions.getAttributeRecords(nodeKey, nodeName).iterator();
                while (object.hasNext()) {
                    SourceFilePosition actionLocation;
                    Actions.AttributeRecord record;
                    Actions.AttributeRecord attributeRecord = record = (Actions.AttributeRecord)object.next();
                    Intrinsics.checkExpressionValueIsNotNull((Object)attributeRecord, (String)"record");
                    Actions.ActionType actionType = attributeRecord.getActionType();
                    if (!Intrinsics.areEqual((Object)actionType, (Object)Actions.ActionType.ADDED) && !Intrinsics.areEqual((Object)actionType, (Object)Actions.ActionType.MERGED)) continue;
                    if (blameNode == null) {
                        blameNode = new BlameNode(key);
                        Map<String, BlameNode> map = this.nodes;
                        BlameNode blameNode3 = blameNode;
                        map.put(key, blameNode3);
                    }
                    SourceFilePosition sourceFilePosition = actionLocation = record.getActionLocation();
                    Intrinsics.checkExpressionValueIsNotNull((Object)sourceFilePosition, (String)"actionLocation");
                    SourceFile sourceFile = sourceFilePosition.getFile();
                    Intrinsics.checkExpressionValueIsNotNull((Object)sourceFile, (String)"actionLocation.file");
                    File sourceFile3 = sourceFile.getSourceFile();
                    if (sourceFile3 == null) continue;
                    XmlNode.NodeName nodeName2 = nodeName;
                    Intrinsics.checkExpressionValueIsNotNull((Object)nodeName2, (String)"nodeName");
                    String string = nodeName2.getLocalName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"nodeName.localName");
                    blameNode.setAttributeLocations(string, " from " + sourceFile3.getPath());
                }
            }
        }
        return blameNode;
    }

    @Nullable
    public final Pair<File, ? extends Node> findSourceNode(@NotNull LintClient client, @NotNull Node node) {
        Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Node node2 = node;
        return node2 instanceof Attr ? this.findSourceAttribute(client, (Attr)node) : (node2 instanceof Element ? this.findSourceElement(client, (Element)node) : null);
    }

    @Nullable
    public final Pair<File, Node> findSourceElement(@NotNull LintClient client, @NotNull Element element) {
        Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        Pair<File, Node> source = this.findElementOrAttribute(client, element, null);
        return source != null && source.getSecond() instanceof Element ? source : null;
    }

    @Nullable
    public final Pair<File, ? extends Node> findSourceAttribute(@NotNull LintClient client, @NotNull Attr attr) {
        Element element;
        Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
        Intrinsics.checkParameterIsNotNull((Object)attr, (String)"attr");
        Element element2 = element = attr.getOwnerElement();
        Intrinsics.checkExpressionValueIsNotNull((Object)element2, (String)"element");
        Pair<File, Node> source = this.findElementOrAttribute(client, element2, attr);
        if (source != null && source.getSecond() instanceof Attr) {
            return source;
        }
        if (source != null && source.getSecond() instanceof Element) {
            Attr sourceAttribute;
            String localName;
            String namespace;
            Attr sourceAttribute2;
            Object object = source.getSecond();
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.w3c.dom.Element");
            }
            Element sourceElement = (Element)object;
            Object object2 = attr.getPrefix() != null ? ((sourceAttribute2 = sourceElement.getAttributeNodeNS(namespace = attr.getNamespaceURI(), localName = attr.getLocalName())) != null ? Pair.of((Object)source.getFirst(), (Object)sourceAttribute2) : null) : ((sourceAttribute = sourceElement.getAttributeNode(attr.getName())) != null ? Pair.of((Object)source.getFirst(), (Object)sourceAttribute) : null);
            return object2;
        }
        return null;
    }

    private final Pair<File, Node> findElementOrAttribute(LintClient client, Element element, Attr attribute) {
        Document document;
        char c;
        int range;
        BlameNode blameNode = this.findBlameNode(element);
        if (blameNode == null) {
            return null;
        }
        BlameNode blameNode2 = blameNode;
        String location = null;
        if (attribute != null) {
            String string = attribute.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"attribute.name");
            location = blameNode2.getAttributeLocation(string);
            if (location == null) {
                String string2 = attribute.getLocalName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"attribute.localName");
                location = blameNode2.getAttributeLocation(string2);
            }
        }
        if (location == null) {
            location = blameNode2.getElementLocation();
        }
        if (location == null) {
            return null;
        }
        int index = StringsKt.indexOf$default((CharSequence)location, (String)" from ", (int)0, (boolean)false, (int)6, null);
        if (index == -1) {
            return null;
        }
        if (StringsKt.startsWith$default((String)location, (String)"[", (int)(index += " from ".length()), (boolean)false, (int)4, null)) {
            index = StringsKt.indexOf$default((CharSequence)location, (String)"] ", (int)0, (boolean)false, (int)6, null);
            if (index == -1) {
                return null;
            }
            index += 2;
        }
        for (range = location.length(); range > 0 && ((c = location.charAt(range - 1)) == ':' || c == '-' || Character.isDigit(c)); --range) {
        }
        String string = location;
        String string3 = string.substring(index, range);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String path2 = string3;
        File manifest = new File(path2);
        if (!manifest.isFile()) {
            return null;
        }
        XmlParser parser = client.getXmlParser();
        try {
            document = parser.parseXml(manifest);
            if (document == null) {
                return null;
            }
        }
        catch (Throwable ignore) {
            return null;
        }
        String targetKey = blameNode2.getKey();
        AtomicReference reference = new AtomicReference();
        XmlVisitor.Companion.accept(document, new XmlVisitor(targetKey, reference){
            final /* synthetic */ String $targetKey;
            final /* synthetic */ AtomicReference $reference;

            public boolean visitTag(@NotNull Element element, @NotNull String tag) {
                Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
                Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
                String key = com.android.tools.lint.client.api.BlameFile$Companion.access$getNodeKey(BlameFile.Companion, element);
                if (Intrinsics.areEqual((Object)this.$targetKey, (Object)key)) {
                    this.$reference.set(element);
                    return true;
                }
                return false;
            }
            {
                this.$targetKey = $captured_local_variable$0;
                this.$reference = $captured_local_variable$1;
            }
        });
        return Pair.of((Object)manifest, reference.get());
    }

    public BlameFile(@NotNull Map<String, BlameNode> nodes, @Nullable Actions actions) {
        Intrinsics.checkParameterIsNotNull(nodes, (String)"nodes");
        this.nodes = nodes;
        this.actions = actions;
    }

    static {
        BlameFile blameFile;
        Companion = new Companion(null);
        BlameFile blameFile2 = blameFile;
        BlameFile blameFile3 = blameFile;
        Map map = new LinkedHashMap();
        blameFile2(map, null);
        NONE = blameFile3;
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b&\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/lint/client/api/BlameFile$XmlVisitor;", "", "()V", "visit", "", "node", "Lorg/w3c/dom/Node;", "visitAttribute", "attribute", "Lorg/w3c/dom/Attr;", "visitTag", "element", "Lorg/w3c/dom/Element;", "tag", "", "Companion", "android.sdktools.lint-api"})
    public static abstract class XmlVisitor {
        public static final Companion Companion = new Companion(null);

        public boolean visitTag(@NotNull Element element, @NotNull String tag) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
            return false;
        }

        public boolean visitAttribute(@NotNull Attr attribute) {
            Intrinsics.checkParameterIsNotNull((Object)attribute, (String)"attribute");
            return false;
        }

        private final boolean visit(Node node) {
            if (node.getNodeType() == 1) {
                Node node2 = node;
                if (node2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.w3c.dom.Element");
                }
                Element tag = (Element)node2;
                String string = tag.getLocalName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"tag.localName");
                if (this.visitTag(tag, string)) {
                    return true;
                }
                NamedNodeMap attributes = tag.getAttributes();
                NamedNodeMap namedNodeMap = attributes;
                Intrinsics.checkExpressionValueIsNotNull((Object)namedNodeMap, (String)"attributes");
                int n = namedNodeMap.getLength();
                for (int i = 0; i < n; ++i) {
                    Node attr;
                    Node node3 = attr = attributes.item(i);
                    if (node3 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.w3c.dom.Attr");
                    }
                    if (!this.visitAttribute((Attr)node3)) continue;
                    return true;
                }
            }
            for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (!this.visit(child)) continue;
                return true;
            }
            return false;
        }

        @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lcom/android/tools/lint/client/api/BlameFile$XmlVisitor$Companion;", "", "()V", "accept", "", "node", "Lorg/w3c/dom/Node;", "visitor", "Lcom/android/tools/lint/client/api/BlameFile$XmlVisitor;", "android.sdktools.lint-api"})
        public static final class Companion {
            public final void accept(@NotNull Node node, @NotNull XmlVisitor visitor) {
                Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                Intrinsics.checkParameterIsNotNull((Object)visitor, (String)"visitor");
                visitor.visit(node);
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\r\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000e\u001a\u00020\u0003J\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0003R\"\u0010\u0005\u001a\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0007\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\b\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\n\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/lint/client/api/BlameFile$BlameNode;", "", "key", "", "(Ljava/lang/String;)V", "attributeLocations", "", "Lcom/android/utils/Pair;", "elementLocation", "getElementLocation", "()Ljava/lang/String;", "setElementLocation", "getKey", "getAttributeLocation", "name", "setAttributeLocations", "", "location", "android.sdktools.lint-api"})
    public static final class BlameNode {
        @Nullable
        private String elementLocation;
        private List<Pair<String, String>> attributeLocations;
        @NotNull
        private final String key;

        @Nullable
        public final String getElementLocation() {
            return this.elementLocation;
        }

        public final void setElementLocation(@Nullable String string) {
            this.elementLocation = string;
        }

        @Nullable
        public final String getAttributeLocation(@NotNull String name) {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            if (this.attributeLocations != null) {
                List<Pair<String, String>> list2 = this.attributeLocations;
                if (list2 == null) {
                    Intrinsics.throwNpe();
                }
                for (Pair<String, String> pair : list2) {
                    if (!Intrinsics.areEqual((Object)name, (Object)((String)pair.getFirst()))) continue;
                    return (String)pair.getSecond();
                }
            }
            return null;
        }

        public final void setAttributeLocations(@NotNull String name, @NotNull String location) {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            Intrinsics.checkParameterIsNotNull((Object)location, (String)"location");
            if (this.attributeLocations != null) {
                List<Pair<String, String>> list2 = this.attributeLocations;
                if (list2 == null) {
                    Intrinsics.throwNpe();
                }
                List<Pair<String, String>> list3 = this.attributeLocations;
                if (list3 == null) {
                    Intrinsics.throwNpe();
                }
                if (Intrinsics.areEqual((Object)name, (Object)((String)list2.get(list3.size() - 1).getFirst()))) {
                    List<Pair<String, String>> list4 = this.attributeLocations;
                    if (list4 == null) {
                        Intrinsics.throwNpe();
                    }
                    List<Pair<String, String>> list5 = this.attributeLocations;
                    if (list5 == null) {
                        Intrinsics.throwNpe();
                    }
                    list4.remove(list5.size() - 1);
                }
            } else {
                this.attributeLocations = Lists.newArrayList();
            }
            List<Pair<String, String>> list6 = this.attributeLocations;
            if (list6 == null) {
                Intrinsics.throwNpe();
            }
            Pair pair = Pair.of((Object)name, (Object)location);
            Intrinsics.checkExpressionValueIsNotNull((Object)pair, (String)"Pair.of(name, location)");
            list6.add((Pair<String, String>)pair);
        }

        @NotNull
        public final String getKey() {
            return this.key;
        }

        public BlameNode(@NotNull String key) {
            Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
            this.key = key;
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0002J\u000e\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J\u0014\u0010\u000e\u001a\u00020\u00042\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\n0\u0014R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/lint/client/api/BlameFile$Companion;", "", "()V", "NONE", "Lcom/android/tools/lint/client/api/BlameFile;", "getNONE", "()Lcom/android/tools/lint/client/api/BlameFile;", "getIndent", "", "line", "", "getNodeKey", "element", "Lorg/w3c/dom/Element;", "parse", "mergerActions", "Lcom/android/manifmerger/Actions;", "file", "Ljava/io/File;", "lines", "", "android.sdktools.lint-api"})
    public static final class Companion {
        @NotNull
        public final BlameFile getNONE() {
            return NONE;
        }

        private final String getNodeKey(Element element) {
            String string = XmlNode.NodeKey.fromXml((Element)element).toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"XmlNode.NodeKey.fromXml(element).toString()");
            return string;
        }

        @NotNull
        public final BlameFile parse(@NotNull File file) throws IOException {
            List lines;
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            List list2 = lines = Files.readLines((File)file, (Charset)Charsets.UTF_8);
            Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"lines");
            return this.parse(list2);
        }

        @NotNull
        public final BlameFile parse(@NotNull Actions mergerActions) {
            HashMap nodes;
            Intrinsics.checkParameterIsNotNull((Object)mergerActions, (String)"mergerActions");
            HashMap hashMap = nodes = Maps.newHashMapWithExpectedSize((int)80);
            Intrinsics.checkExpressionValueIsNotNull((Object)hashMap, (String)"nodes");
            return new BlameFile(hashMap, mergerActions);
        }

        @NotNull
        public final BlameFile parse(@NotNull List<String> lines) {
            Intrinsics.checkParameterIsNotNull(lines, (String)"lines");
            HashMap nodes = Maps.newHashMapWithExpectedSize((int)80);
            BlameNode last = null;
            String attributeName = null;
            for (String line : lines) {
                boolean match$iv$iv;
                char it;
                int index$iv$iv;
                boolean startFound$iv$iv;
                CharSequence $receiver$iv$iv;
                String $receiver$iv;
                int indent;
                CharSequence charSequence = line;
                if (charSequence.length() == 0 || StringsKt.startsWith$default((String)line, (String)"INJECTED ", (int)(indent = this.getIndent(line)), (boolean)false, (int)4, null)) continue;
                if (StringsKt.startsWith$default((String)line, (String)"ADDED ", (int)indent, (boolean)false, (int)4, null) || StringsKt.startsWith$default((String)line, (String)"MERGED ", (int)indent, (boolean)false, (int)4, null)) {
                    String string;
                    BlameNode blameNode;
                    if (last == null) continue;
                    if (indent > 0) {
                        boolean bl;
                        boolean bl2 = bl = attributeName != null;
                        if (_Assertions.ENABLED && !bl) {
                            String string2 = "Assertion failed";
                            throw (Throwable)((Object)new AssertionError((Object)string2));
                        }
                        if (attributeName == null) {
                            Intrinsics.throwNpe();
                        }
                        String string3 = line;
                        blameNode = last;
                        $receiver$iv$iv = $receiver$iv;
                        int startIndex$iv$iv = 0;
                        int endIndex$iv$iv = $receiver$iv$iv.length() - 1;
                        startFound$iv$iv = false;
                        while (startIndex$iv$iv <= endIndex$iv$iv) {
                            index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                            it = $receiver$iv$iv.charAt(index$iv$iv);
                            boolean bl3 = match$iv$iv = it <= ' ';
                            if (!startFound$iv$iv) {
                                if (!match$iv$iv) {
                                    startFound$iv$iv = true;
                                    continue;
                                }
                                ++startIndex$iv$iv;
                                continue;
                            }
                            if (!match$iv$iv) break;
                            --endIndex$iv$iv;
                        }
                        String string4 = ((Object)$receiver$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
                        blameNode.setAttributeLocations(string, string4);
                        continue;
                    }
                    if (last.getElementLocation() != null) continue;
                    $receiver$iv = line;
                    blameNode = last;
                    $receiver$iv$iv = $receiver$iv;
                    int startIndex$iv$iv = 0;
                    int endIndex$iv$iv = $receiver$iv$iv.length() - 1;
                    startFound$iv$iv = false;
                    while (startIndex$iv$iv <= endIndex$iv$iv) {
                        index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                        it = $receiver$iv$iv.charAt(index$iv$iv);
                        boolean bl = match$iv$iv = it <= ' ';
                        if (!startFound$iv$iv) {
                            if (!match$iv$iv) {
                                startFound$iv$iv = true;
                                continue;
                            }
                            ++startIndex$iv$iv;
                            continue;
                        }
                        if (!match$iv$iv) break;
                        --endIndex$iv$iv;
                    }
                    string = ((Object)$receiver$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
                    blameNode.setElementLocation(string);
                    continue;
                }
                if (StringsKt.startsWith$default((String)line, (String)"--", (boolean)false, (int)2, null)) continue;
                if (indent > 0) {
                    $receiver$iv = line;
                    $receiver$iv$iv = $receiver$iv;
                    int startIndex$iv$iv = 0;
                    int endIndex$iv$iv = $receiver$iv$iv.length() - 1;
                    startFound$iv$iv = false;
                    while (startIndex$iv$iv <= endIndex$iv$iv) {
                        index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                        it = $receiver$iv$iv.charAt(index$iv$iv);
                        boolean bl = match$iv$iv = it <= ' ';
                        if (!startFound$iv$iv) {
                            if (!match$iv$iv) {
                                startFound$iv$iv = true;
                                continue;
                            }
                            ++startIndex$iv$iv;
                            continue;
                        }
                        if (!match$iv$iv) break;
                        --endIndex$iv$iv;
                    }
                    attributeName = ((Object)$receiver$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
                    continue;
                }
                String $receiver$iv2 = line;
                CharSequence $receiver$iv$iv2 = $receiver$iv2;
                int startIndex$iv$iv = 0;
                int endIndex$iv$iv = $receiver$iv$iv2.length() - 1;
                boolean startFound$iv$iv2 = false;
                while (startIndex$iv$iv <= endIndex$iv$iv) {
                    boolean match$iv$iv2;
                    int index$iv$iv2 = !startFound$iv$iv2 ? startIndex$iv$iv : endIndex$iv$iv;
                    char it2 = $receiver$iv$iv2.charAt(index$iv$iv2);
                    boolean bl = match$iv$iv2 = it2 <= ' ';
                    if (!startFound$iv$iv2) {
                        if (!match$iv$iv2) {
                            startFound$iv$iv2 = true;
                            continue;
                        }
                        ++startIndex$iv$iv;
                        continue;
                    }
                    if (!match$iv$iv2) break;
                    --endIndex$iv$iv;
                }
                String key = ((Object)$receiver$iv$iv2.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
                BlameNode node = new BlameNode(key);
                HashMap hashMap = nodes;
                Intrinsics.checkExpressionValueIsNotNull((Object)hashMap, (String)"nodes");
                Map map = hashMap;
                BlameNode blameNode = node;
                map.put(key, blameNode);
                attributeName = null;
                last = node;
            }
            HashMap hashMap = nodes;
            Intrinsics.checkExpressionValueIsNotNull((Object)hashMap, (String)"nodes");
            return new BlameFile(hashMap, null);
        }

        /*
         * WARNING - void declaration
         */
        private final int getIndent(String line) {
            int n = 0;
            int n2 = line.length();
            while (n < n2) {
                void i;
                char c = line.charAt((int)i);
                if (c != '\t') {
                    return (int)i;
                }
                ++i;
            }
            return line.length();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

