/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.client.api;

import com.android.tools.lint.client.api.LintDriver;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.OtherFileScanner;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Scope;
import com.android.utils.SdkUtils;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u001e\u0010\n\u001a\u00020\u000b2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\t0\f2\u0006\u0010\r\u001a\u00020\tH\u0002J \u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0012R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u00030\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/lint/client/api/OtherFileVisitor;", "", "detectors", "", "Lcom/android/tools/lint/detector/api/Detector;", "(Ljava/util/List;)V", "files", "Ljava/util/EnumMap;", "Lcom/android/tools/lint/detector/api/Scope;", "Ljava/io/File;", "collectFiles", "", "", "file", "scan", "driver", "Lcom/android/tools/lint/client/api/LintDriver;", "project", "Lcom/android/tools/lint/detector/api/Project;", "main", "android.sdktools.lint-api"})
public final class OtherFileVisitor {
    private final EnumMap<Scope, List<File>> files;
    private final List<Detector> detectors;

    public final void scan(@NotNull LintDriver driver, @NotNull Project project, @Nullable Project main) {
        List<File> manifestFiles;
        Object object;
        Object object2;
        ArrayList<File> files;
        Object applicable;
        Intrinsics.checkParameterIsNotNull((Object)driver, (String)"driver");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        File projectFolder = project.getDir();
        EnumSet<Scope> scopes = EnumSet.noneOf(Scope.class);
        Object object4 = this.detectors.iterator();
        while (object4.hasNext()) {
            Detector detector;
            Detector detector2 = detector = object4.next();
            if (detector2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.android.tools.lint.detector.api.OtherFileScanner");
            }
            OtherFileScanner object3 = (OtherFileScanner)((Object)detector2);
            applicable = object3.getApplicableFiles();
            if (((AbstractCollection)applicable).contains((Object)Scope.OTHER)) {
                scopes = Scope.ALL;
                break;
            }
            scopes.addAll((Collection)applicable);
        }
        List<File> subset = project.getSubset();
        if (scopes.contains((Object)Scope.RESOURCE_FILE)) {
            if (subset != null && !subset.isEmpty()) {
                files = new ArrayList<File>(subset.size());
                applicable = subset.iterator();
                while (applicable.hasNext()) {
                    File file;
                    File file2 = file = applicable.next();
                    Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"file");
                    if (!SdkUtils.endsWith((CharSequence)file2.getPath(), (CharSequence)".xml") || !(Intrinsics.areEqual((Object)file.getName(), (Object)"AndroidManifest.xml") ^ true)) continue;
                    files.add(file);
                }
                if (!files.isEmpty()) {
                    Map map = this.files;
                    applicable = Scope.RESOURCE_FILE;
                    object2 = files;
                    map.put(applicable, object2);
                }
            } else {
                files = Lists.newArrayListWithExpectedSize((int)100);
                for (File file : project.getResourceFolders()) {
                    ArrayList<File> arrayList = files;
                    Intrinsics.checkExpressionValueIsNotNull(arrayList, (String)"files");
                    List list2 = arrayList;
                    File file3 = file;
                    Intrinsics.checkExpressionValueIsNotNull((Object)file3, (String)"res");
                    this.collectFiles(list2, file3);
                }
                File file = new File(projectFolder, "assets");
                if (file.exists()) {
                    ArrayList<File> arrayList = files;
                    Intrinsics.checkExpressionValueIsNotNull(arrayList, (String)"files");
                    this.collectFiles((List<File>)arrayList, file);
                }
                if (!files.isEmpty()) {
                    applicable = this.files;
                    object2 = Scope.RESOURCE_FILE;
                    object = files;
                    applicable.put(object2, object);
                }
            }
        }
        if (scopes.contains((Object)Scope.JAVA_FILE)) {
            if (subset != null && !subset.isEmpty()) {
                files = new ArrayList<File>(subset.size());
                applicable = subset.iterator();
                while (applicable.hasNext()) {
                    File file;
                    File file4 = file = applicable.next();
                    Intrinsics.checkExpressionValueIsNotNull((Object)file4, (String)"file");
                    String string = file4.getPath();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.path");
                    if (!StringsKt.endsWith$default((String)string, (String)".java", (boolean)false, (int)2, null)) {
                        String string2 = file.getPath();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"file.path");
                        if (!StringsKt.endsWith$default((String)string2, (String)".kt", (boolean)false, (int)2, null)) continue;
                    }
                    files.add(file);
                }
                if (!files.isEmpty()) {
                    Map map = this.files;
                    applicable = Scope.JAVA_FILE;
                    object2 = files;
                    map.put(applicable, object2);
                }
            } else {
                files = Lists.newArrayListWithExpectedSize((int)100);
                for (File file : project.getJavaSourceFolders()) {
                    ArrayList<File> arrayList = files;
                    Intrinsics.checkExpressionValueIsNotNull(arrayList, (String)"files");
                    List list3 = arrayList;
                    File file5 = file;
                    Intrinsics.checkExpressionValueIsNotNull((Object)file5, (String)"srcFolder");
                    this.collectFiles(list3, file5);
                }
                if (!files.isEmpty()) {
                    Map map = this.files;
                    applicable = Scope.JAVA_FILE;
                    object2 = files;
                    map.put(applicable, object2);
                }
            }
        }
        if (scopes.contains((Object)Scope.CLASS_FILE)) {
            if (subset != null && !subset.isEmpty()) {
                files = new ArrayList(subset.size());
                applicable = subset.iterator();
                while (applicable.hasNext()) {
                    File file;
                    File file6 = file = (File)applicable.next();
                    Intrinsics.checkExpressionValueIsNotNull((Object)file6, (String)"file");
                    String string = file6.getPath();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.path");
                    if (!StringsKt.endsWith$default((String)string, (String)".class", (boolean)false, (int)2, null)) continue;
                    files.add(file);
                }
                if (!files.isEmpty()) {
                    Map map = this.files;
                    applicable = Scope.CLASS_FILE;
                    object2 = files;
                    map.put(applicable, object2);
                }
            } else {
                files = Lists.newArrayListWithExpectedSize((int)100);
                for (File file : project.getJavaClassFolders()) {
                    ArrayList<File> arrayList = files;
                    Intrinsics.checkExpressionValueIsNotNull(arrayList, (String)"files");
                    List list4 = arrayList;
                    File file7 = file;
                    Intrinsics.checkExpressionValueIsNotNull((Object)file7, (String)"classFolder");
                    this.collectFiles(list4, file7);
                }
                if (!files.isEmpty()) {
                    Map map = this.files;
                    applicable = Scope.CLASS_FILE;
                    object2 = files;
                    map.put(applicable, object2);
                }
            }
        }
        if (scopes.contains((Object)Scope.MANIFEST)) {
            if (subset != null && !subset.isEmpty()) {
                files = new ArrayList(subset.size());
                applicable = subset.iterator();
                while (applicable.hasNext()) {
                    File file;
                    File file8 = file = (File)applicable.next();
                    Intrinsics.checkExpressionValueIsNotNull((Object)file8, (String)"file");
                    if (!Intrinsics.areEqual((Object)file8.getName(), (Object)"AndroidManifest.xml")) continue;
                    files.add(file);
                }
                if (!files.isEmpty()) {
                    Map map = this.files;
                    applicable = Scope.MANIFEST;
                    object2 = files;
                    map.put(applicable, object2);
                }
            } else {
                manifestFiles = project.getManifestFiles();
                Map map = this.files;
                applicable = Scope.MANIFEST;
                object2 = manifestFiles;
                map.put(applicable, object2);
            }
        }
        if (scopes.contains((Object)Scope.GRADLE_FILE)) {
            if (subset != null && !subset.isEmpty()) {
                files = new ArrayList(subset.size());
                applicable = subset.iterator();
                while (applicable.hasNext()) {
                    File file;
                    File file9 = file = (File)applicable.next();
                    Intrinsics.checkExpressionValueIsNotNull((Object)file9, (String)"file");
                    String string = file9.getName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.name");
                    if (!StringsKt.endsWith$default((String)string, (String)".gradle", (boolean)false, (int)2, null)) {
                        String string3 = file.getName();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"file.name");
                        if (!StringsKt.endsWith$default((String)string3, (String)".kts", (boolean)false, (int)2, null)) continue;
                    }
                    files.add(file);
                }
                if (!files.isEmpty()) {
                    Map map = this.files;
                    applicable = Scope.GRADLE_FILE;
                    object2 = files;
                    map.put(applicable, object2);
                }
            } else {
                manifestFiles = project.getGradleBuildScripts();
                Map map = this.files;
                applicable = Scope.GRADLE_FILE;
                object2 = manifestFiles;
                map.put(applicable, object2);
            }
        }
        if (scopes.contains((Object)Scope.PROGUARD_FILE)) {
            if (subset != null && !subset.isEmpty()) {
                files = new ArrayList(subset.size());
                applicable = subset.iterator();
                while (applicable.hasNext()) {
                    File file;
                    File file10 = file = (File)applicable.next();
                    Intrinsics.checkExpressionValueIsNotNull((Object)file10, (String)"file");
                    String string = file10.getName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.name");
                    if (!StringsKt.startsWith$default((String)string, (String)"proguard", (boolean)false, (int)2, null)) continue;
                    files.add(file);
                }
                if (!files.isEmpty()) {
                    Map map = this.files;
                    applicable = Scope.PROPERTY_FILE;
                    object2 = files;
                    map.put(applicable, object2);
                }
            } else {
                manifestFiles = project.getProguardFiles();
                Map map = this.files;
                applicable = Scope.PROGUARD_FILE;
                object2 = manifestFiles;
                map.put(applicable, object2);
            }
        }
        if (scopes.contains((Object)Scope.PROPERTY_FILE)) {
            if (subset != null && !subset.isEmpty()) {
                files = new ArrayList(subset.size());
                applicable = subset.iterator();
                while (applicable.hasNext()) {
                    File file;
                    File file11 = file = (File)applicable.next();
                    Intrinsics.checkExpressionValueIsNotNull((Object)file11, (String)"file");
                    String string = file11.getName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.name");
                    if (!StringsKt.endsWith$default((String)string, (String)".properties", (boolean)false, (int)2, null)) continue;
                    files.add(file);
                }
                if (!files.isEmpty()) {
                    Map map = this.files;
                    applicable = Scope.PROPERTY_FILE;
                    object2 = files;
                    map.put(applicable, object2);
                }
            } else {
                List<File> propertyFiles = project.getPropertyFiles();
                Map map = this.files;
                applicable = Scope.PROPERTY_FILE;
                object2 = propertyFiles;
                map.put(applicable, object2);
            }
        }
        applicable = this.files;
        Iterator iterator = applicable.entrySet().iterator();
        while (iterator.hasNext()) {
            object = object4 = iterator.next();
            Scope scope = (Scope)((Object)object.getKey());
            object = object4;
            List files2 = (List)object.getValue();
            ArrayList<Detector> applicable2 = new ArrayList<Detector>(this.detectors.size());
            Iterator<Detector> iterator2 = this.detectors.iterator();
            while (iterator2.hasNext()) {
                Detector detector;
                Detector detector3 = detector = iterator2.next();
                if (detector3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.android.tools.lint.detector.api.OtherFileScanner");
                }
                OtherFileScanner fileScanner = (OtherFileScanner)((Object)detector3);
                EnumSet<Scope> appliesTo = fileScanner.getApplicableFiles();
                if (!appliesTo.contains((Object)Scope.OTHER) && !appliesTo.contains((Object)scope)) continue;
                applicable2.add(detector);
            }
            if (applicable2.isEmpty()) continue;
            for (File file3 : files2) {
                Context context2 = new Context(driver, project, main, file3, null, 16, null);
                for (Detector detector : applicable2) {
                    detector.beforeCheckFile(context2);
                    detector.run(context2);
                    detector.afterCheckFile(context2);
                    LintDriver lintDriver = driver;
                    int n = lintDriver.getFileCount();
                    lintDriver.setFileCount(n + 1);
                }
                if (!driver.isCanceled$android_sdktools_lint_api()) continue;
                return;
            }
        }
    }

    private final void collectFiles(List<File> files, File file) {
        if (file.isDirectory()) {
            File[] children = file.listFiles();
            if (children != null) {
                int n = children.length;
                for (int i = 0; i < n; ++i) {
                    File child;
                    File file2 = child = children[i];
                    Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"child");
                    this.collectFiles(files, file2);
                }
            }
        } else {
            files.add(file);
        }
    }

    public OtherFileVisitor(@NotNull List<? extends Detector> detectors) {
        Intrinsics.checkParameterIsNotNull(detectors, (String)"detectors");
        this.detectors = detectors;
        this.files = new EnumMap(Scope.class);
    }
}

