/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.helpers;

import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.client.api.UastParser;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.UastLintUtils;
import com.android.tools.lint.helpers.DefaultJavaEvaluator;
import com.intellij.lang.Language;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiPlainTextFile;
import com.intellij.psi.impl.light.LightElement;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UFile;
import org.jetbrains.uast.UIdentifier;
import org.jetbrains.uast.UastContext;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.psi.UElementWithLocation;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\b\u0016\u0018\u0000 72\u00020\u0001:\u00017B\u0017\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\u0011\u001a\u00020\u00122\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0014J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0017H\u0016J\u0014\u0010\u0018\u001a\u0004\u0018\u00010\u00162\b\u0010\u0015\u001a\u0004\u0018\u00010\u0017H\u0002J(\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001fH\u0016J\u0012\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010#\u001a\u00020$H\u0016J\u0010\u0010%\u001a\u00020&2\u0006\u0010#\u001a\u00020$H\u0016J\u0018\u0010'\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0018\u0010'\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0015\u001a\u00020\u0017H\u0016J\u0018\u0010(\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0018\u0010(\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0015\u001a\u00020\u0017H\u0016J0\u0010)\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010*\u001a\u00020\u00162\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u00162\u0006\u0010.\u001a\u00020,H\u0016J(\u0010)\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010*\u001a\u00020\u00162\u0006\u0010+\u001a\u00020,2\u0006\u0010.\u001a\u00020,H\u0016J(\u0010)\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010*\u001a\u00020\u00172\u0006\u0010+\u001a\u00020,2\u0006\u0010.\u001a\u00020,H\u0016J0\u0010)\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010*\u001a\u00020\u00172\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u00172\u0006\u0010.\u001a\u00020,H\u0016J\u0012\u0010/\u001a\u0004\u0018\u0001002\u0006\u0010\u0015\u001a\u00020\u0017H\u0002J\u0012\u00101\u001a\u0004\u0018\u0001022\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J$\u00103\u001a\u00020\u001f2\f\u00104\u001a\b\u0012\u0004\u0012\u00020\u001b052\f\u00106\u001a\b\u0012\u0004\u0012\u00020\u001b05H\u0016R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\u0004\u0018\u00010\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u00068"}, d2={"Lcom/android/tools/lint/helpers/DefaultUastParser;", "Lcom/android/tools/lint/client/api/UastParser;", "project", "Lcom/android/tools/lint/detector/api/Project;", "p", "Lcom/intellij/openapi/project/Project;", "(Lcom/android/tools/lint/detector/api/Project;Lcom/intellij/openapi/project/Project;)V", "evaluator", "Lcom/android/tools/lint/client/api/JavaEvaluator;", "getEvaluator", "()Lcom/android/tools/lint/client/api/JavaEvaluator;", "javaEvaluator", "uContext", "Lorg/jetbrains/uast/UastContext;", "uastContext", "getUastContext", "()Lorg/jetbrains/uast/UastContext;", "createEvaluator", "Lcom/android/tools/lint/helpers/DefaultJavaEvaluator;", "createLocation", "Lcom/android/tools/lint/detector/api/Location;", "element", "Lcom/intellij/psi/PsiElement;", "Lorg/jetbrains/uast/UElement;", "findPsi", "getCallLocation", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "call", "Lorg/jetbrains/uast/UCallExpression;", "includeReceiver", "", "includeArguments", "getFile", "Ljava/io/File;", "file", "Lcom/intellij/psi/PsiFile;", "getFileContents", "", "getLocation", "getNameLocation", "getRangeLocation", "from", "fromDelta", "", "to", "toDelta", "getTextRange", "Lcom/intellij/openapi/util/TextRange;", "parse", "Lorg/jetbrains/uast/UFile;", "prepare", "contexts", "", "testContexts", "Companion", "android.sdktools.lint-api"})
public class DefaultUastParser
extends UastParser {
    private final UastContext uContext;
    private final JavaEvaluator javaEvaluator;
    @NotNull
    private final JavaEvaluator evaluator;
    @Nullable
    private final UastContext uastContext;
    private static boolean warnedAboutLargeFiles;
    public static final Companion Companion;

    @NotNull
    protected DefaultJavaEvaluator createEvaluator(@Nullable Project project, @NotNull com.intellij.openapi.project.Project p) {
        Intrinsics.checkParameterIsNotNull((Object)p, (String)"p");
        Project project2 = project;
        if (project2 == null) {
            Intrinsics.throwNpe();
        }
        return new DefaultJavaEvaluator(p, project2);
    }

    @Override
    public boolean prepare(@NotNull List<? extends JavaContext> contexts, @NotNull List<? extends JavaContext> testContexts) {
        Intrinsics.checkParameterIsNotNull(contexts, (String)"contexts");
        Intrinsics.checkParameterIsNotNull(testContexts, (String)"testContexts");
        return true;
    }

    @Override
    @NotNull
    public JavaEvaluator getEvaluator() {
        return this.evaluator;
    }

    @Override
    @Nullable
    public UFile parse(@NotNull JavaContext context2) {
        PsiFile psiFile;
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        if (context2.getUastFile() != null) {
            return context2.getUastFile();
        }
        UastContext uastContext = this.getUastContext();
        if (uastContext == null) {
            return null;
        }
        UastContext uast = uastContext;
        com.intellij.openapi.project.Project ideaProject = uast.getProject();
        if (ideaProject.isDisposed()) {
            return null;
        }
        VirtualFile virtualFile = StandardFileSystems.local().findFileByPath(context2.file.getAbsolutePath());
        if (virtualFile == null) {
            return null;
        }
        VirtualFile virtualFile2 = virtualFile;
        PsiFile psiFile2 = PsiManager.getInstance((com.intellij.openapi.project.Project)ideaProject).findFile(virtualFile2);
        if (psiFile2 == null) {
            return null;
        }
        PsiFile psiFile3 = psiFile = psiFile2;
        Intrinsics.checkExpressionValueIsNotNull((Object)psiFile3, (String)"psiFile");
        if (Intrinsics.areEqual((Object)psiFile3.getLanguage(), (Object)Language.ANY)) {
            String string = context2.file.getPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"context.file.path");
            if (StringsKt.endsWith$default((String)string, (String)".kt", (boolean)false, (int)2, null)) {
                context2.getClient().log(Severity.ERROR, null, "Could not process " + context2.getProject().getRelativePath(context2.file) + ": Kotlin not configured correctly", new Object[0]);
            }
        }
        if (psiFile instanceof PsiPlainTextFile) {
            if (!Companion.getWarnedAboutLargeFiles()) {
                Companion.setWarnedAboutLargeFiles(true);
                int max = FileUtilRt.getUserFileSizeLimit();
                long size = context2.file.length() / (long)1024;
                int sizeRoundedUp = (int)Math.pow(2.0, Math.ceil(Math.log10(size) / Math.log10(2.0) + 0.2));
                Context.report$default(context2, IssueRegistry.LINT_ERROR, Location.Companion.create(context2.file), "Source file too large for lint to process (" + size + "KB); the " + "current max size is " + max + "KB. You can increase the limit by " + "setting this system property: " + "`idea.max.intellisense.filesize=" + sizeRoundedUp + "` (or even higher)", null, 8, null);
            }
            return null;
        }
        UElement uElement = uast.convertElementWithParent((PsiElement)psiFile, UFile.class);
        if (!(uElement instanceof UFile)) {
            uElement = null;
        }
        UFile uFile = (UFile)uElement;
        if (uFile == null) {
            return null;
        }
        return uFile;
    }

    @Override
    @Nullable
    public UastContext getUastContext() {
        return this.uastContext;
    }

    @Override
    @NotNull
    public Location getLocation(@NotNull JavaContext context2, @NotNull PsiElement element) {
        CharSequence contents;
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        TextRange range = null;
        if (element instanceof PsiCompiledElement) {
            if (element instanceof LightElement) {
                range = element.getTextRange();
            }
            if (range == null || Intrinsics.areEqual((Object)TextRange.EMPTY_RANGE, (Object)range)) {
                VirtualFile virtualFile;
                PsiFile containingFile = element.getContainingFile();
                if (containingFile != null && (virtualFile = containingFile.getVirtualFile()) != null) {
                    File file = VfsUtilCore.virtualToIoFile((VirtualFile)virtualFile);
                    Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"VfsUtilCore.virtualToIoFile(virtualFile)");
                    return Location.Companion.create(file);
                }
                return Location.Companion.create(context2.file);
            }
        } else {
            range = element.getTextRange();
        }
        PsiFile containingFile = UastLintUtils.getContainingFile(context2, element);
        File file = context2.file;
        CharSequence charSequence = context2.getContents();
        if (charSequence == null) {
            charSequence = contents = (CharSequence)"";
        }
        if (containingFile != null && Intrinsics.areEqual((Object)containingFile, (Object)context2.getPsiFile()) ^ true) {
            File ioFile;
            if (context2.getDriver().getScope().size() == 1) {
                return Location.NONE;
            }
            File file2 = this.getFile(containingFile);
            if (file2 == null) {
                return Location.NONE;
            }
            file = ioFile = file2;
            contents = this.getFileContents(containingFile);
        }
        if (range == null) {
            PsiElement parent;
            if (element instanceof LightElement && (parent = element.getParent()) != null) {
                return this.getLocation(context2, parent);
            }
            return Location.Companion.create(file);
        }
        return Location.Companion.create(file, contents, range.getStartOffset(), range.getEndOffset()).setSource(element);
    }

    @Override
    @NotNull
    public Location getLocation(@NotNull JavaContext context2, @NotNull UElement element) {
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        if (element instanceof UElementWithLocation) {
            UFile uFile = UastUtils.getContainingUFile((UElement)element);
            if (uFile == null) {
                return Location.NONE;
            }
            UFile file = uFile;
            File file2 = UastUtils.getIoFile((UFile)file);
            if (file2 == null) {
                return Location.NONE;
            }
            File ioFile = file2;
            String text = file.getPsi().getText();
            Location location = Location.Companion.create(ioFile, text, ((UElementWithLocation)element).getStartOffset(), ((UElementWithLocation)element).getEndOffset());
            location.setSource(element);
            return location;
        }
        PsiElement psiElement = element.getPsi();
        if (psiElement != null) {
            return this.getLocation(context2, psiElement);
        }
        UElement parent = element.getUastParent();
        if (parent != null) {
            return this.getLocation(context2, parent);
        }
        return Location.NONE;
    }

    @Override
    @NotNull
    public Location getCallLocation(@NotNull JavaContext context2, @NotNull UCallExpression call, boolean includeReceiver, boolean includeArguments) {
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
        UExpression receiver = call.getReceiver();
        if (!includeReceiver || receiver == null) {
            if (includeArguments) {
                return this.getLocation(context2, (UElement)call);
            }
            UIdentifier methodIdentifier = call.getMethodIdentifier();
            if (methodIdentifier != null) {
                return this.getLocation(context2, (UElement)methodIdentifier);
            }
        } else {
            UIdentifier methodIdentifier;
            if (!includeArguments && (methodIdentifier = call.getMethodIdentifier()) != null) {
                return this.getRangeLocation(context2, (UElement)receiver, 0, (UElement)methodIdentifier, 0);
            }
            return this.getRangeLocation(context2, (UElement)receiver, 0, (UElement)call, 0);
        }
        return this.getLocation(context2, (UElement)call);
    }

    @Override
    @Nullable
    public File getFile(@NotNull PsiFile file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        VirtualFile virtualFile = file.getVirtualFile();
        return virtualFile != null ? VfsUtilCore.virtualToIoFile((VirtualFile)virtualFile) : null;
    }

    @Override
    @NotNull
    public CharSequence getFileContents(@NotNull PsiFile file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        String string = file.getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.text");
        return string;
    }

    @Override
    @NotNull
    public Location createLocation(@NotNull PsiElement element) {
        PsiFile containingFile;
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        TextRange range = element.getTextRange();
        PsiFile psiFile = containingFile = element.getContainingFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"containingFile");
        File file = this.getFile(psiFile);
        if (file == null) {
            return Location.NONE;
        }
        File file2 = file;
        CharSequence contents = this.getFileContents(containingFile);
        TextRange textRange = range;
        Intrinsics.checkExpressionValueIsNotNull((Object)textRange, (String)"range");
        return Location.Companion.create(file2, contents, textRange.getStartOffset(), range.getEndOffset()).setSource(element);
    }

    @Override
    @NotNull
    public Location createLocation(@NotNull UElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        if (element instanceof UElementWithLocation) {
            UFile uFile = UastUtils.getContainingUFile((UElement)element);
            if (uFile == null) {
                return Location.NONE;
            }
            UFile file = uFile;
            File file2 = UastUtils.getIoFile((UFile)file);
            if (file2 == null) {
                return Location.NONE;
            }
            File ioFile = file2;
            String text = file.getPsi().getText();
            Location location = Location.Companion.create(ioFile, text, ((UElementWithLocation)element).getStartOffset(), ((UElementWithLocation)element).getEndOffset());
            location.setSource(element);
            return location;
        }
        PsiElement psiElement = element.getPsi();
        if (psiElement != null) {
            return this.createLocation(psiElement);
        }
        UElement parent = element.getUastParent();
        if (parent != null) {
            return this.createLocation(parent);
        }
        return Location.NONE;
    }

    @Override
    @NotNull
    public Location getRangeLocation(@NotNull JavaContext context2, @NotNull PsiElement from, int fromDelta, @NotNull PsiElement to, int toDelta) {
        TextRange fromRange;
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)from, (String)"from");
        Intrinsics.checkParameterIsNotNull((Object)to, (String)"to");
        CharSequence contents = context2.getContents();
        TextRange textRange = fromRange = from.getTextRange();
        Intrinsics.checkExpressionValueIsNotNull((Object)textRange, (String)"fromRange");
        int start = Math.max(0, textRange.getStartOffset() + fromDelta);
        CharSequence charSequence = contents;
        int n = charSequence != null ? charSequence.length() : Integer.MAX_VALUE;
        TextRange textRange2 = to.getTextRange();
        Intrinsics.checkExpressionValueIsNotNull((Object)textRange2, (String)"to.textRange");
        int end = Math.min(n, textRange2.getEndOffset() + toDelta);
        if (end <= start) {
            return Location.Companion.create(context2.file, contents, start, fromRange.getEndOffset()).setSource(from);
        }
        return Location.Companion.create(context2.file, contents, start, end).setSource(from);
    }

    private final TextRange getTextRange(UElement element) {
        if (element instanceof UElementWithLocation) {
            return new TextRange(((UElementWithLocation)element).getStartOffset(), ((UElementWithLocation)element).getEndOffset());
        }
        PsiElement psiElement = element.getPsi();
        if (psiElement != null) {
            return psiElement.getTextRange();
        }
        return null;
    }

    @Override
    @NotNull
    public Location getRangeLocation(@NotNull JavaContext context2, @NotNull UElement from, int fromDelta, @NotNull UElement to, int toDelta) {
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)from, (String)"from");
        Intrinsics.checkParameterIsNotNull((Object)to, (String)"to");
        CharSequence contents = context2.getContents();
        TextRange fromRange = this.getTextRange(from);
        TextRange toRange = this.getTextRange(to);
        File file = context2.file;
        PsiElement psi = this.findPsi(from);
        if (psi != null) {
            PsiFile containingFile = psi.getContainingFile();
            contents = context2.getContents();
            if (Intrinsics.areEqual((Object)containingFile, (Object)context2.getPsiFile()) ^ true) {
                File ioFile;
                if (context2.getDriver().getScope().size() == 1) {
                    return Location.NONE;
                }
                PsiFile psiFile = containingFile;
                Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"containingFile");
                File file2 = this.getFile(psiFile);
                if (file2 == null) {
                    return Location.NONE;
                }
                file = ioFile = file2;
                contents = this.getFileContents(containingFile);
            }
        }
        if (fromRange != null && toRange != null) {
            int start = Math.max(0, fromRange.getStartOffset() + fromDelta);
            int end = Math.min(contents == null ? Integer.MAX_VALUE : contents.length(), toRange.getEndOffset() + toDelta);
            if (end <= start) {
                return Location.Companion.create(file, contents, start, fromRange.getEndOffset()).setSource(from);
            }
            return Location.Companion.create(file, contents, start, end).setSource(from);
        }
        return Location.Companion.create(file).setSource(from);
    }

    private final PsiElement findPsi(UElement element) {
        for (UElement currentElement = element; currentElement != null; currentElement = currentElement.getUastParent()) {
            PsiElement psi = currentElement.getPsi();
            if (psi == null) continue;
            return psi;
        }
        return null;
    }

    @Override
    @NotNull
    public Location getRangeLocation(@NotNull JavaContext context2, @NotNull PsiElement from, int fromDelta, int toDelta) {
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)from, (String)"from");
        TextRange textRange = from.getTextRange();
        Intrinsics.checkExpressionValueIsNotNull((Object)textRange, (String)"from.textRange");
        return this.getRangeLocation(context2, from, fromDelta, from, -(textRange.getLength() - toDelta));
    }

    @Override
    @NotNull
    public Location getRangeLocation(@NotNull JavaContext context2, @NotNull UElement from, int fromDelta, int toDelta) {
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)from, (String)"from");
        TextRange fromRange = this.getTextRange(from);
        if (fromRange != null) {
            return this.getRangeLocation(context2, from, fromDelta, from, -(fromRange.getLength() - toDelta));
        }
        return Location.Companion.create(context2.file).setSource(from);
    }

    @Override
    @NotNull
    public Location getNameLocation(@NotNull JavaContext context2, @NotNull PsiElement element) {
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        PsiElement namedElement = element;
        PsiElement nameNode = JavaContext.Companion.findNameElement(namedElement);
        if (nameNode != null) {
            namedElement = nameNode;
        }
        return this.getLocation(context2, namedElement);
    }

    @Override
    @NotNull
    public Location getNameLocation(@NotNull JavaContext context2, @NotNull UElement element) {
        PsiElement nameIdentifier;
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        UElement namedElement = element;
        UElement nameNode = JavaContext.Companion.findNameElement(namedElement);
        if (nameNode != null) {
            namedElement = nameNode;
        } else if (namedElement instanceof PsiNameIdentifierOwner && (nameIdentifier = ((PsiNameIdentifierOwner)namedElement).getNameIdentifier()) != null) {
            return this.getLocation(context2, nameIdentifier);
        }
        return this.getLocation(context2, namedElement);
    }

    public DefaultUastParser(@Nullable Project project, @NotNull com.intellij.openapi.project.Project p) {
        Intrinsics.checkParameterIsNotNull((Object)p, (String)"p");
        this.javaEvaluator = this.createEvaluator(project, p);
        this.uContext = !p.isDisposed() ? (UastContext)ServiceManager.getService((com.intellij.openapi.project.Project)p, UastContext.class) : null;
        this.evaluator = this.javaEvaluator;
        this.uastContext = this.uContext;
    }

    static {
        Companion = new Companion(null);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/android/tools/lint/helpers/DefaultUastParser$Companion;", "", "()V", "warnedAboutLargeFiles", "", "getWarnedAboutLargeFiles", "()Z", "setWarnedAboutLargeFiles", "(Z)V", "android.sdktools.lint-api"})
    public static final class Companion {
        public final boolean getWarnedAboutLargeFiles() {
            return warnedAboutLargeFiles;
        }

        public final void setWarnedAboutLargeFiles(boolean bl) {
            warnedAboutLargeFiles = bl;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

