/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.usb;

import com.android.tools.usb.Platform;
import com.android.tools.usb.UsbDevice;
import com.android.tools.usb.UsbDeviceCollector;
import com.android.tools.usb.parser.OutputParser;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007H\u0016J\u0014\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\u0004H\u0016\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/usb/UsbDeviceCollectorImpl;", "Lcom/android/tools/usb/UsbDeviceCollector;", "()V", "execute", "Ljava/util/concurrent/CompletableFuture;", "Ljava/io/InputStream;", "command", "", "getPlatform", "Lcom/android/tools/usb/Platform;", "isSupported", "", "platform", "listUsbDevices", "", "Lcom/android/tools/usb/UsbDevice;", "usb-devices"})
public final class UsbDeviceCollectorImpl
implements UsbDeviceCollector {
    @Override
    @NotNull
    public CompletableFuture<List<UsbDevice>> listUsbDevices() {
        Platform currentOS = Platform.Factory.currentOS();
        if (!currentOS.getSupported()) {
            CompletableFuture<List<UsbDevice>> completableFuture = CompletableFuture.completedFuture(Collections.emptyList());
            Intrinsics.checkExpressionValueIsNotNull(completableFuture, (String)"CompletableFuture.comple\u2026(Collections.emptyList())");
            return completableFuture;
        }
        String string = currentOS.getCommand();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        CompletionStage completionStage = this.execute(string).thenApply(new Function<T, U>(currentOS){
            final /* synthetic */ Platform $currentOS;

            @NotNull
            public final List<UsbDevice> apply(InputStream it) {
                OutputParser outputParser = this.$currentOS.parser();
                InputStream inputStream = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"it");
                return outputParser.parse(inputStream);
            }
            {
                this.$currentOS = platform;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)completionStage, (String)"execute(currentOS.comman\u2026ntOS.parser().parse(it) }");
        return completionStage;
    }

    @Override
    public boolean isSupported(@NotNull String platform) {
        Intrinsics.checkParameterIsNotNull((Object)platform, (String)"platform");
        return Platform.Factory.currentOS(platform).getSupported();
    }

    @Override
    @NotNull
    public Platform getPlatform() {
        return Platform.Factory.currentOS();
    }

    private final CompletableFuture<InputStream> execute(String command) {
        CompletableFuture<InputStream> completableFuture = CompletableFuture.supplyAsync(new Supplier<U>(command){
            final /* synthetic */ String $command;

            public final InputStream get() {
                Process process = new ProcessBuilder(StringsKt.split$default((CharSequence)this.$command, (String[])new String[]{" "}, (boolean)false, (int)0, (int)6, null)).redirectErrorStream(true).start();
                Intrinsics.checkExpressionValueIsNotNull((Object)process, (String)"ProcessBuilder(command.s\u2026ErrorStream(true).start()");
                return process.getInputStream();
            }
            {
                this.$command = string;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull(completableFuture, (String)"CompletableFuture.supply\u2026start().inputStream\n    }");
        return completableFuture;
    }
}

