/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.git4idea.http;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtilRt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.git4idea.GitExternalApp;
import org.jetbrains.git4idea.http.GitAskPassXmlRpcClient;

public class GitAskPassApp
implements GitExternalApp {
    public static void main(String[] args) {
        try {
            if (args.length < 1) {
                throw new IllegalArgumentException("No arguments specified!");
            }
            Pair<Boolean, String> arguments = GitAskPassApp.parseArguments(args[0]);
            boolean usernameNeeded = (Boolean)arguments.getFirst();
            String url = (String)arguments.getSecond();
            String token = GitAskPassApp.getNotNull("GIT_ASKPASS_HANDLER");
            int xmlRpcPort = Integer.parseInt(GitAskPassApp.getNotNull("GIT_ASKPASS_PORT"));
            String xmlRpcToken = GitAskPassApp.getNotNull("GIT_ASKPASS_TOKEN");
            GitAskPassXmlRpcClient xmlRpcClient = new GitAskPassXmlRpcClient(xmlRpcPort, xmlRpcToken);
            if (usernameNeeded) {
                String username = xmlRpcClient.askUsername(token, url);
                System.out.println(username);
            } else {
                String pass = xmlRpcClient.askPassword(token, url);
                System.out.println(pass);
            }
        }
        catch (Throwable t) {
            System.err.println(t.getMessage());
            t.printStackTrace(System.err);
        }
    }

    @NotNull
    private static String getNotNull(@NotNull String env) {
        String value;
        if (env == null) {
            GitAskPassApp.$$$reportNull$$$0(0);
        }
        if ((value = System.getenv(env)) == null) {
            throw new IllegalStateException(env + " environment variable is not defined!");
        }
        String string = value;
        if (string == null) {
            GitAskPassApp.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    private static Pair<Boolean, String> parseArguments(@NotNull String arg) {
        if (arg == null) {
            GitAskPassApp.$$$reportNull$$$0(2);
        }
        boolean username = StringUtilRt.startsWithIgnoreCase((String)arg, (String)"username");
        String[] split = arg.split(" ");
        String url = split.length > 2 ? GitAskPassApp.parseUrl(split[2]) : "";
        Pair pair = Pair.create((Object)username, (Object)url);
        if (pair == null) {
            GitAskPassApp.$$$reportNull$$$0(3);
        }
        return pair;
    }

    private static String parseUrl(@NotNull String urlArg) {
        String url;
        if (urlArg == null) {
            GitAskPassApp.$$$reportNull$$$0(4);
        }
        if ((url = urlArg).startsWith("'")) {
            url = url.substring(1);
        }
        if (url.endsWith(":")) {
            url = url.substring(0, url.length() - 1);
        }
        if (url.endsWith("'")) {
            url = url.substring(0, url.length() - 1);
        }
        return url;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/git4idea/http/GitAskPassApp";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arg";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urlArg";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/git4idea/http/GitAskPassApp";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotNull";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "parseArguments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getNotNull";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "parseArguments";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "parseUrl";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

