/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.streams.resolve;

import com.intellij.debugger.streams.resolve.ValuesOrderResolver;
import com.intellij.debugger.streams.trace.TraceElement;
import com.intellij.debugger.streams.trace.TraceInfo;
import com.intellij.debugger.streams.wrapper.TraceUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u00020\u00042\u0018\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\b0\u0006H&J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/debugger/streams/resolve/PartialReductionResolverBase;", "Lcom/intellij/debugger/streams/resolve/ValuesOrderResolver;", "()V", "buildResult", "Lcom/intellij/debugger/streams/resolve/ValuesOrderResolver$Result;", "mapping", "", "Lcom/intellij/debugger/streams/trace/TraceElement;", "", "resolve", "info", "Lcom/intellij/debugger/streams/trace/TraceInfo;", "intellij.java.debugger.streams"})
public abstract class PartialReductionResolverBase
implements ValuesOrderResolver {
    @Override
    @NotNull
    public ValuesOrderResolver.Result resolve(@NotNull TraceInfo info) {
        Intrinsics.checkParameterIsNotNull((Object)info, (String)"info");
        List<TraceElement> valuesBefore = TraceUtil.sortedByTime(info.getValuesOrderBefore().values());
        List<TraceElement> valuesAfter = TraceUtil.sortedByTime(info.getValuesOrderAfter().values());
        Map reverseMapping = new LinkedHashMap();
        int i = 0;
        for (TraceElement valueAfter : valuesAfter) {
            TraceElement traceElement;
            Object object;
            List reverseList = new ArrayList();
            while (i + 1 < valuesBefore.size()) {
                TraceElement traceElement2 = valuesBefore.get(i + 1);
                Intrinsics.checkExpressionValueIsNotNull((Object)traceElement2, (String)"valuesBefore[i + 1]");
                int n = traceElement2.getTime();
                TraceElement traceElement3 = valueAfter;
                Intrinsics.checkExpressionValueIsNotNull((Object)traceElement3, (String)"valueAfter");
                if (n >= traceElement3.getTime()) break;
                object = reverseList;
                traceElement = valuesBefore.get(i);
                object.add(traceElement);
                ++i;
            }
            object = reverseMapping;
            Intrinsics.checkExpressionValueIsNotNull((Object)valueAfter, (String)"valueAfter");
            List list2 = reverseList;
            object.put(traceElement, list2);
        }
        List<TraceElement> list3 = valuesAfter;
        Intrinsics.checkExpressionValueIsNotNull(list3, (String)"valuesAfter");
        Collection collection = list3;
        if (!collection.isEmpty()) {
            List<TraceElement> list4 = valuesBefore;
            Intrinsics.checkExpressionValueIsNotNull(list4, (String)"valuesBefore");
            collection = list4;
            if (!collection.isEmpty()) {
                Object v = reverseMapping.get(CollectionsKt.last(valuesAfter));
                if (v == null) {
                    Intrinsics.throwNpe();
                }
                collection = (List)v;
                Object object = CollectionsKt.last(valuesBefore);
                collection.add(object);
            }
        }
        return this.buildResult(reverseMapping);
    }

    @NotNull
    public abstract ValuesOrderResolver.Result buildResult(@NotNull Map<TraceElement, ? extends List<? extends TraceElement>> var1);
}

