/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.streams.resolve;

import com.intellij.debugger.streams.resolve.ValuesOrderResolver;
import com.intellij.debugger.streams.trace.TraceElement;
import com.intellij.debugger.streams.trace.TraceInfo;
import com.intellij.debugger.streams.wrapper.TraceUtil;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/debugger/streams/resolve/PrependResolver;", "Lcom/intellij/debugger/streams/resolve/ValuesOrderResolver;", "()V", "resolve", "Lcom/intellij/debugger/streams/resolve/ValuesOrderResolver$Result;", "info", "Lcom/intellij/debugger/streams/trace/TraceInfo;", "intellij.java.debugger.streams"})
public final class PrependResolver
implements ValuesOrderResolver {
    @Override
    @NotNull
    public ValuesOrderResolver.Result resolve(@NotNull TraceInfo info) {
        Intrinsics.checkParameterIsNotNull((Object)info, (String)"info");
        Map direct = new LinkedHashMap();
        Map reverse = new LinkedHashMap();
        List<TraceElement> valuesBefore = TraceUtil.sortedByTime(info.getValuesOrderBefore().values());
        List<TraceElement> valuesAfter = TraceUtil.sortedByTime(info.getValuesOrderAfter().values());
        List<TraceElement> list2 = valuesBefore;
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"valuesBefore");
        Collection collection = list2;
        if (!collection.isEmpty()) {
            int indexOfFirstItemFromSource;
            block5: {
                int n;
                TraceElement firstBefore = (TraceElement)CollectionsKt.first(valuesBefore);
                List<TraceElement> list3 = valuesAfter;
                Intrinsics.checkExpressionValueIsNotNull(list3, (String)"valuesAfter");
                List<TraceElement> $receiver$iv = list3;
                int index$iv = 0;
                Iterator<TraceElement> iterator = $receiver$iv.iterator();
                while (iterator.hasNext()) {
                    TraceElement item$iv;
                    TraceElement it;
                    TraceElement traceElement = it = (item$iv = iterator.next());
                    Intrinsics.checkExpressionValueIsNotNull((Object)traceElement, (String)"it");
                    int n2 = traceElement.getTime();
                    TraceElement traceElement2 = firstBefore;
                    Intrinsics.checkExpressionValueIsNotNull((Object)traceElement2, (String)"firstBefore");
                    if (n2 > traceElement2.getTime()) {
                        n = index$iv;
                        break block5;
                    }
                    ++index$iv;
                }
                n = indexOfFirstItemFromSource = -1;
            }
            if (indexOfFirstItemFromSource != -1) {
                for (Pair pair : CollectionsKt.zip((Iterable)valuesBefore, (Iterable)valuesAfter.subList(indexOfFirstItemFromSource, valuesAfter.size()))) {
                    TraceElement before = (TraceElement)pair.component1();
                    TraceElement after = (TraceElement)pair.component2();
                    Map map2 = direct;
                    TraceElement traceElement = before;
                    Intrinsics.checkExpressionValueIsNotNull((Object)traceElement, (String)"before");
                    TraceElement traceElement3 = traceElement;
                    Object[] objectArray = new TraceElement[1];
                    TraceElement traceElement4 = after;
                    Intrinsics.checkExpressionValueIsNotNull((Object)traceElement4, (String)"after");
                    objectArray[0] = traceElement4;
                    List list4 = CollectionsKt.mutableListOf((Object[])objectArray);
                    map2.put(traceElement3, list4);
                    map2 = reverse;
                    traceElement3 = after;
                    list4 = CollectionsKt.mutableListOf((Object[])new TraceElement[]{before});
                    map2.put(traceElement3, list4);
                }
            }
        }
        ValuesOrderResolver.Result result = ValuesOrderResolver.Result.of(direct, reverse);
        Intrinsics.checkExpressionValueIsNotNull((Object)result, (String)"ValuesOrderResolver.Result.of(direct, reverse)");
        return result;
    }
}

