/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint;

import com.android.tools.analytics.Anonymizer;
import com.android.tools.analytics.CommonMetricsData;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.lint.LintBatchAnalytics$WhenMappings;
import com.android.tools.lint.LintCliFlags;
import com.android.tools.lint.Warning;
import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.client.api.LintDriver;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Severity;
import com.android.utils.ILogger;
import com.android.utils.NullLogger;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.LintIssueId;
import com.google.wireless.android.sdk.stats.LintPerformance;
import com.google.wireless.android.sdk.stats.LintSession;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0018\u0010\u0007\u001a\u0004\u0018\u00010\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J2\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000e0\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0014\u0010\u0018\u001a\u0004\u0018\u00010\b2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0002J\u0018\u0010\u0018\u001a\u0004\u0018\u00010\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J:\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010J<\u0010\u001d\u001a\u00020\u001c2\"\u0010\u001e\u001a\u001e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000e0\u001fj\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000e` 2\u0006\u0010!\u001a\u00020\b2\u0006\u0010\"\u001a\u00020#H\u0002J\f\u0010$\u001a\u00020%*\u00020#H\u0002\u00a8\u0006&"}, d2={"Lcom/android/tools/lint/LintBatchAnalytics;", "", "()V", "computeAnalysisType", "Lcom/google/wireless/android/sdk/stats/LintSession$AnalysisType;", "flags", "Lcom/android/tools/lint/LintCliFlags;", "computeApplicationId", "", "projects", "", "Lcom/android/tools/lint/detector/api/Project;", "computeIssueData", "", "Lcom/google/wireless/android/sdk/stats/LintIssueId$Builder;", "warnings", "", "Lcom/android/tools/lint/Warning;", "registry", "Lcom/android/tools/lint/client/api/IssueRegistry;", "computePerformance", "Lcom/google/wireless/android/sdk/stats/LintPerformance;", "driver", "Lcom/android/tools/lint/client/api/LintDriver;", "computeProjectId", "projectPath", "Ljava/io/File;", "logSession", "", "recordSeverityOverride", "map", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "id", "lintSeverity", "Lcom/android/tools/lint/detector/api/Severity;", "toAnalyticsSeverity", "Lcom/google/wireless/android/sdk/stats/LintIssueId$LintSeverity;", "lint"})
public final class LintBatchAnalytics {
    public final void logSession(@NotNull IssueRegistry registry, @NotNull LintCliFlags flags, @NotNull LintDriver driver, @NotNull Collection<? extends Project> projects, @NotNull List<? extends Warning> warnings) {
        AndroidStudioEvent.Builder builder;
        LintSession.Builder builder2;
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)registry, (String)"registry");
        Intrinsics.checkParameterIsNotNull((Object)flags, (String)"flags");
        Intrinsics.checkParameterIsNotNull((Object)driver, (String)"driver");
        Intrinsics.checkParameterIsNotNull(projects, (String)"projects");
        Intrinsics.checkParameterIsNotNull(warnings, (String)"warnings");
        boolean bl2 = bl = !projects.isEmpty();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        LintSession.Builder $receiver = builder2 = LintSession.newBuilder();
        $receiver.setAnalysisType(this.computeAnalysisType(flags));
        $receiver.setProjectId(this.computeProjectId(projects));
        $receiver.setLintPerformance(this.computePerformance(driver));
        $receiver.setBaselineEnabled(driver.getBaseline() != null);
        $receiver.setIncludingGeneratedSources(driver.getCheckGeneratedSources());
        $receiver.setIncludingTestSources(driver.getCheckTestSources());
        $receiver.setIncludingDependencies(driver.getCheckDependencies());
        $receiver.setAbortOnError(flags.isSetExitCode());
        $receiver.setIgnoreWarnings(flags.isIgnoreWarnings());
        $receiver.setWarningsAsErrors(flags.isWarningsAsErrors());
        for (LintIssueId.Builder issueBuilder : this.computeIssueData(warnings, flags, registry).values()) {
            $receiver.addIssueIds(issueBuilder);
        }
        LintSession session = builder2.build();
        AndroidStudioEvent.Builder $receiver2 = builder = AndroidStudioEvent.newBuilder();
        $receiver2.setKind(AndroidStudioEvent.EventKind.LINT_SESSION);
        $receiver2.setLintSession(session);
        $receiver2.setJavaProcessStats(CommonMetricsData.getJavaProcessStats());
        $receiver2.setJvmDetails(CommonMetricsData.getJvmDetails());
        String string = this.computeApplicationId(projects);
        if (string != null) {
            String string2;
            String it = string2 = string;
            $receiver2.setRawProjectId(it);
        }
        AndroidStudioEvent.Builder event = builder;
        UsageTracker.getInstance().log(event);
    }

    private final String computeApplicationId(Collection<? extends Project> projects) {
        for (Project project : projects) {
            if (!project.isAndroidProject() || project.isLibrary()) continue;
            String string = project.getApplicationId();
            if (string == null) {
                continue;
            }
            return string;
        }
        for (Project project : projects) {
            if (!project.isAndroidProject()) continue;
            String string = project.getApplicationId();
            if (string == null) {
                continue;
            }
            return string;
        }
        return null;
    }

    private final LintSession.AnalysisType computeAnalysisType(LintCliFlags flags) {
        return flags.isFatalOnly() ? LintSession.AnalysisType.VITAL : LintSession.AnalysisType.BUILD;
    }

    private final String computeProjectId(Collection<? extends Project> projects) {
        Project project = (Project)CollectionsKt.firstOrNull((Iterable)projects);
        return this.computeProjectId(project != null ? project.getDir() : null);
    }

    private final String computeProjectId(File projectPath) {
        String string;
        if (projectPath == null) {
            return null;
        }
        try {
            string = Anonymizer.anonymizeUtf8((ILogger)((ILogger)new NullLogger()), (String)projectPath.getAbsolutePath());
        }
        catch (IOException e) {
            string = "*ANONYMIZATION_ERROR*";
        }
        return string;
    }

    private final LintPerformance computePerformance(LintDriver driver) {
        LintPerformance.Builder builder;
        LintPerformance.Builder $receiver = builder = LintPerformance.newBuilder();
        $receiver.setAnalysisTimeMs(System.currentTimeMillis() - driver.getAnalysisStartTime());
        $receiver.setFileCount((long)driver.getFileCount());
        $receiver.setModuleCount((long)driver.getModuleCount());
        $receiver.setJavaSourceCount((long)driver.getJavaFileCount());
        $receiver.setKotlinSourceCount((long)driver.getKotlinFileCount());
        $receiver.setResourceFileCount((long)driver.getResourceFileCount());
        $receiver.setTestSourceCount((long)driver.getTestSourceCount());
        LintPerformance lintPerformance = builder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)lintPerformance, (String)"LintPerformance.newBuild\u2026oLong()\n        }.build()");
        return lintPerformance;
    }

    private final void recordSeverityOverride(HashMap<String, LintIssueId.Builder> map, String id, Severity lintSeverity) {
        LintIssueId.Builder builder;
        LintIssueId.Builder builder2 = map.get(id);
        if (builder2 != null) {
            return;
        }
        LintIssueId.Builder $receiver = builder = LintIssueId.newBuilder();
        Map map2 = map;
        String string = id;
        LintIssueId.Builder builder3 = $receiver;
        Intrinsics.checkExpressionValueIsNotNull((Object)builder3, (String)"this");
        LintIssueId.Builder builder4 = builder3;
        map2.put(string, builder4);
        $receiver.setIssueId(id);
        $receiver.setCount(0L);
        $receiver.setSeverity(this.toAnalyticsSeverity(lintSeverity));
    }

    private final LintIssueId.LintSeverity toAnalyticsSeverity(@NotNull Severity $receiver) {
        LintIssueId.LintSeverity lintSeverity;
        switch (LintBatchAnalytics$WhenMappings.$EnumSwitchMapping$0[$receiver.ordinal()]) {
            case 1: {
                lintSeverity = LintIssueId.LintSeverity.FATAL_SEVERITY;
                break;
            }
            case 2: {
                lintSeverity = LintIssueId.LintSeverity.ERROR_SEVERITY;
                break;
            }
            case 3: {
                lintSeverity = LintIssueId.LintSeverity.WARNING_SEVERITY;
                break;
            }
            case 4: {
                lintSeverity = LintIssueId.LintSeverity.INFORMATIONAL_SEVERITY;
                break;
            }
            case 5: {
                lintSeverity = LintIssueId.LintSeverity.IGNORE_SEVERITY;
                break;
            }
            default: {
                lintSeverity = LintIssueId.LintSeverity.UNKNOWN_SEVERITY;
            }
        }
        return lintSeverity;
    }

    private final Map<String, LintIssueId.Builder> computeIssueData(List<? extends Warning> warnings, LintCliFlags flags, IssueRegistry registry) {
        LinkedHashMap map = new LinkedHashMap(342);
        for (Warning warning : warnings) {
            LintIssueId.Builder issueBuilder;
            Issue issue = warning.issue;
            String id = issue.getId();
            LintIssueId.Builder builder = (LintIssueId.Builder)map.get(id);
            if (builder == null) {
                LintIssueId.LintSeverity lintSeverity;
                LintIssueId.Builder builder2;
                LintIssueId.Builder builder3;
                LintBatchAnalytics lintBatchAnalytics;
                LintBatchAnalytics $receiver = lintBatchAnalytics = this;
                LintIssueId.Builder $receiver2 = builder3 = LintIssueId.newBuilder();
                Map map2 = map;
                String string = id;
                Intrinsics.checkExpressionValueIsNotNull((Object)$receiver2, (String)"this");
                map2.put(string, builder2);
                $receiver2.setIssueId(issue.getId());
                if (Intrinsics.areEqual((Object)warning.severity, (Object)issue.getDefaultSeverity())) {
                    lintSeverity = LintIssueId.LintSeverity.DEFAULT_SEVERITY;
                } else {
                    Severity severity = warning.severity;
                    Intrinsics.checkExpressionValueIsNotNull((Object)severity, (String)"warning.severity");
                    lintSeverity = $receiver.toAnalyticsSeverity(severity);
                }
                $receiver2.setSeverity(lintSeverity);
                builder = builder3;
            }
            LintIssueId.Builder builder4 = issueBuilder = builder;
            Intrinsics.checkExpressionValueIsNotNull((Object)builder4, (String)"issueBuilder");
            builder4.setCount(issueBuilder.getCount() + 1L);
        }
        Iterator<Object> iterator = flags.getSeverityOverrides().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry;
            Map.Entry entry2 = entry = (Map.Entry)iterator.next();
            String id = (String)entry2.getKey();
            entry2 = entry;
            Severity severity = (Severity)entry2.getValue();
            HashMap hashMap = map;
            String string = id;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"id");
            Severity severity2 = severity;
            Intrinsics.checkExpressionValueIsNotNull((Object)severity2, (String)"severity");
            this.recordSeverityOverride(hashMap, string, severity2);
        }
        for (String string : flags.getSuppressedIds()) {
            HashMap hashMap = map;
            String string2 = string;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"id");
            this.recordSeverityOverride(hashMap, string2, Severity.IGNORE);
        }
        for (String string : flags.getEnabledIds()) {
            HashMap hashMap = map;
            String string3 = string;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"id");
            Issue issue = registry.getIssue(string);
            if (issue == null || (issue = issue.getDefaultSeverity()) == null) {
                issue = Severity.WARNING;
            }
            this.recordSeverityOverride(hashMap, string3, (Severity)issue);
        }
        return map;
    }
}

